/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.ExponentialBackoffOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RequestRetryCondition;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.accesshelpers.ExponentialBackoffAccessHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.ObjectsUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;

public class ExponentialBackoff
implements RetryStrategy {
    private static final double JITTER_FACTOR = 0.05;
    private static final int DEFAULT_MAX_RETRIES;
    private static final Duration DEFAULT_BASE_DELAY;
    private static final Duration DEFAULT_MAX_DELAY;
    private static final ClientLogger LOGGER;
    private final int maxRetries;
    private final long baseDelayNanos;
    private final long maxDelayNanos;
    private final Predicate<RequestRetryCondition> shouldRetryCondition;

    public ExponentialBackoff() {
        this(DEFAULT_MAX_RETRIES, DEFAULT_BASE_DELAY, DEFAULT_MAX_DELAY);
    }

    public ExponentialBackoff(ExponentialBackoffOptions exponentialBackoffOptions) {
        this(ObjectsUtil.requireNonNullElse(Objects.requireNonNull(exponentialBackoffOptions, "'options' cannot be null.").getMaxRetries(), DEFAULT_MAX_RETRIES), ObjectsUtil.requireNonNullElse(Objects.requireNonNull(exponentialBackoffOptions, "'options' cannot be null.").getBaseDelay(), DEFAULT_BASE_DELAY), ObjectsUtil.requireNonNullElse(Objects.requireNonNull(exponentialBackoffOptions, "'options' cannot be null.").getMaxDelay(), DEFAULT_MAX_DELAY));
    }

    private ExponentialBackoff(ExponentialBackoffOptions exponentialBackoffOptions, Predicate<RequestRetryCondition> predicate) {
        this(ObjectsUtil.requireNonNullElse(Objects.requireNonNull(exponentialBackoffOptions, "'options' cannot be null.").getMaxRetries(), DEFAULT_MAX_RETRIES), ObjectsUtil.requireNonNullElse(Objects.requireNonNull(exponentialBackoffOptions, "'options' cannot be null.").getBaseDelay(), DEFAULT_BASE_DELAY), ObjectsUtil.requireNonNullElse(Objects.requireNonNull(exponentialBackoffOptions, "'options' cannot be null.").getMaxDelay(), DEFAULT_MAX_DELAY), predicate);
    }

    public ExponentialBackoff(int n2, Duration duration, Duration duration2) {
        this(n2, duration, duration2, null);
    }

    private ExponentialBackoff(int n2, Duration duration, Duration duration2, Predicate<RequestRetryCondition> predicate) {
        if (n2 < 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("Max retries cannot be less than 0."));
        }
        Objects.requireNonNull(duration, "'baseDelay' cannot be null.");
        Objects.requireNonNull(duration2, "'maxDelay' cannot be null.");
        if (duration.isZero() || duration.isNegative()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be negative or 0."));
        }
        if (duration.compareTo(duration2) > 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'baseDelay' cannot be greater than 'maxDelay'."));
        }
        this.maxRetries = n2;
        this.baseDelayNanos = duration.toNanos();
        this.maxDelayNanos = duration2.toNanos();
        this.shouldRetryCondition = predicate;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public Duration calculateRetryDelay(int n2) {
        long l2 = ThreadLocalRandom.current().nextLong((long)((double)this.baseDelayNanos * 0.95), (long)((double)this.baseDelayNanos * 1.05));
        return Duration.ofNanos(Math.min((1L << n2) * l2, this.maxDelayNanos));
    }

    @Override
    public boolean shouldRetryCondition(RequestRetryCondition requestRetryCondition) {
        return this.shouldRetryCondition == null ? RetryStrategy.super.shouldRetryCondition(requestRetryCondition) : this.shouldRetryCondition.test(requestRetryCondition);
    }

    static {
        DEFAULT_BASE_DELAY = Duration.ofMillis(800L);
        DEFAULT_MAX_DELAY = Duration.ofSeconds(8L);
        LOGGER = new ClientLogger(ExponentialBackoff.class);
        String string = Configuration.getGlobalConfiguration().get("AZURE_REQUEST_RETRY_COUNT");
        int n2 = 3;
        if (!CoreUtils.isNullOrEmpty(string)) {
            try {
                n2 = Integer.parseInt(string);
                if (n2 < 0) {
                    n2 = 3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.log(LogLevel.VERBOSE, () -> "AZURE_REQUEST_RETRY_COUNT was loaded but is an invalid number. Using 3 retries as the maximum.");
            }
        }
        DEFAULT_MAX_RETRIES = n2;
        ExponentialBackoffAccessHelper.setAccessor(ExponentialBackoff::new);
    }
}

