/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.AuthorizationChallengeHandler;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.okhttp3.Authenticator;
import macromedia.jdbc.sqlserver.externals.okhttp3.Challenge;
import macromedia.jdbc.sqlserver.externals.okhttp3.Interceptor;
import macromedia.jdbc.sqlserver.externals.okhttp3.Request;
import macromedia.jdbc.sqlserver.externals.okhttp3.Response;
import macromedia.jdbc.sqlserver.externals.okhttp3.Route;

public final class ProxyAuthenticator
implements Authenticator {
    private static final String VALIDATION_ERROR_TEMPLATE = "The '%s' returned in the 'Proxy-Authentication-Info' header doesn't match the value sent in the 'Proxy-Authorization' header. Sent: %s, received: %s.";
    private static final String BASIC = "basic";
    private static final String DIGEST = "digest";
    private static final String PREEMPTIVE_AUTHENTICATE = "Preemptive Authenticate";
    private static final String PROXY_METHOD = HttpMethod.CONNECT.name();
    private static final String PROXY_URI_PATH = "/";
    private static final Supplier<byte[]> NO_BODY = () -> new byte[0];
    private static final String CNONCE = "cnonce";
    private static final String NC = "nc";
    private static final ClientLogger LOGGER = new ClientLogger(ProxyAuthenticator.class);
    private final AuthorizationChallengeHandler challengeHandler;

    public ProxyAuthenticator(String string, String string2) {
        this.challengeHandler = new AuthorizationChallengeHandler(string, string2);
    }

    public Interceptor getProxyAuthenticationInfoInterceptor() {
        return new ProxyAuthenticationInfoInterceptor(this.challengeHandler);
    }

    public Request authenticate(Route route, Response response) {
        String string = this.challengeHandler.attemptToPipelineAuthorization(PROXY_METHOD, PROXY_URI_PATH, NO_BODY);
        if (!CoreUtils.isNullOrEmpty(string)) {
            return response.request().newBuilder().header("Proxy-Authorization", string).build();
        }
        if (PREEMPTIVE_AUTHENTICATE.equalsIgnoreCase(response.message())) {
            return response.request();
        }
        boolean bl2 = false;
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (Challenge challenge : response.challenges()) {
            if (BASIC.equalsIgnoreCase(challenge.scheme())) {
                bl2 = true;
                continue;
            }
            if (!DIGEST.equalsIgnoreCase(challenge.scheme())) continue;
            arrayList.add(challenge.authParams());
        }
        if (arrayList.size() > 0) {
            string = this.challengeHandler.handleDigest(PROXY_METHOD, PROXY_URI_PATH, arrayList, NO_BODY);
        }
        if (string == null && bl2) {
            string = this.challengeHandler.handleBasic();
        }
        Request.Builder builder = response.request().newBuilder();
        if (string != null) {
            builder.header("Proxy-Authorization", string);
        }
        return builder.build();
    }

    private static void validateProxyAuthenticationInfoValue(String string, Map<String, String> map, Map<String, String> map2) {
        if (map.containsKey(string)) {
            String string2 = map2.get(string);
            String string3 = map.get(string);
            if (!string3.equalsIgnoreCase(string2)) {
                throw LOGGER.logExceptionAsError(new IllegalStateException(String.format(VALIDATION_ERROR_TEMPLATE, string, string2, string3)));
            }
        }
    }

    private static class ProxyAuthenticationInfoInterceptor
    implements Interceptor {
        private final AuthorizationChallengeHandler challengeHandler;

        ProxyAuthenticationInfoInterceptor(AuthorizationChallengeHandler authorizationChallengeHandler) {
            this.challengeHandler = authorizationChallengeHandler;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Response response = chain.proceed(chain.request());
            String string = response.header("Proxy-Authentication-Info");
            if (!CoreUtils.isNullOrEmpty(string)) {
                Map<String, String> map = AuthorizationChallengeHandler.parseAuthenticationOrAuthorizationHeader(string);
                Map<String, String> map2 = AuthorizationChallengeHandler.parseAuthenticationOrAuthorizationHeader(chain.request().header("Proxy-Authorization"));
                ProxyAuthenticator.validateProxyAuthenticationInfoValue(ProxyAuthenticator.CNONCE, map, map2);
                ProxyAuthenticator.validateProxyAuthenticationInfoValue(ProxyAuthenticator.NC, map, map2);
                this.challengeHandler.consumeAuthenticationInfoHeader(map);
            }
            return response;
        }
    }
}

