/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.okhttp.implementation;

import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.okhttp3.MediaType;
import macromedia.jdbc.sqlserver.externals.okhttp3.RequestBody;
import macromedia.jdbc.sqlserver.externals.okio.BufferedSink;

public class BinaryDataRequestBody
extends RequestBody {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryDataRequestBody.class);
    private final MediaType contentType;
    private final BinaryData body;
    private final long effectiveContentLength;
    private volatile int bodySent = 0;
    private static final AtomicIntegerFieldUpdater<BinaryDataRequestBody> BODY_SENT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(BinaryDataRequestBody.class, "bodySent");

    public BinaryDataRequestBody(BinaryData binaryData, MediaType mediaType, long l2) {
        this.body = binaryData;
        this.contentType = mediaType;
        this.effectiveContentLength = l2;
    }

    public long contentLength() throws IOException {
        return this.effectiveContentLength;
    }

    public boolean isOneShot() {
        return !this.body.isReplayable();
    }

    public MediaType contentType() {
        return this.contentType;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        if (!this.body.isReplayable() && !BODY_SENT_UPDATER.compareAndSet(this, 0, 1)) {
            throw LOGGER.logThrowableAsError(new IOException("Re-attempt to send body is not supported."));
        }
        this.body.writeTo((WritableByteChannel)bufferedSink);
    }
}

