/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.spi.handler;

import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.PortInfo;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.description.impl.DescriptionUtils;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainType;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseHandlerResolver
implements HandlerResolver {
    private static Log log = LogFactory.getLog(BaseHandlerResolver.class);
    protected static final Map<String, String> protocolBindingsMap = new HashMap<String, String>(5);
    protected HandlerChainsType handlerChainsType;

    protected BaseHandlerResolver() {
    }

    protected BaseHandlerResolver(String file) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String className = this.getClass().getName();
        InputStream is = DescriptionUtils.openHandlerConfigStream((String)file, (String)className, (ClassLoader)classLoader);
        if (is == null) {
            log.warn((Object)("Unable to load handlers from file: " + file));
        } else {
            this.handlerChainsType = DescriptionUtils.loadHandlerChains((InputStream)is, (ClassLoader)classLoader);
        }
    }

    protected static boolean chainResolvesToPort(HandlerChainType hct, PortInfo portinfo) {
        List protocolBindings = hct.getProtocolBindings();
        if (protocolBindings != null) {
            boolean match = true;
            Iterator it = protocolBindings.iterator();
            while (it.hasNext()) {
                match = false;
                String protocolBinding = (String)it.next();
                protocolBinding = protocolBinding.startsWith("##") ? protocolBindingsMap.get(protocolBinding) : protocolBinding;
                if (protocolBinding == null || !protocolBinding.equals(portinfo.getBindingID())) continue;
                match = true;
                break;
            }
            if (!match) {
                return match;
            }
        }
        if (!BaseHandlerResolver.doesPatternMatch(portinfo.getPortName(), hct.getPortNamePattern())) {
            return false;
        }
        return BaseHandlerResolver.doesPatternMatch(portinfo.getServiceName(), hct.getServiceNamePattern());
    }

    protected static Class loadClass(String clazz) throws ClassNotFoundException {
        return BaseHandlerResolver.forName(clazz, true, BaseHandlerResolver.getContextClassLoader());
    }

    public static boolean doesPatternMatch(QName qName, QName pattern) {
        BaseHandlerResolver.validatePattern(pattern);
        boolean match = BaseHandlerResolver.doesPatternMatch_Official(qName, pattern);
        if (!match) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The offical matching algorithm failed.  Re-attempting with the prior algorithm");
            }
            match = BaseHandlerResolver.doesPatternMatch_Old(qName, pattern);
            if (log.isDebugEnabled()) {
                log.debug((Object)("The old matching algorithm returns " + match));
            }
        }
        return match;
    }

    private static boolean doesPatternMatch_Old(QName portInfoQName, QName pattern) {
        if (pattern == null) {
            return true;
        }
        String portInfoPrefix = portInfoQName.getNamespaceURI();
        String portInfoLocalPart = portInfoQName.getLocalPart();
        String portInfoString = portInfoPrefix == null || portInfoPrefix.equals("") ? "" : portInfoPrefix + ":";
        portInfoString = portInfoString + portInfoLocalPart;
        String patternStringPrefix = pattern.getNamespaceURI();
        String patternInfoLocalPart = pattern.getLocalPart();
        String patternString = patternStringPrefix == null || patternStringPrefix.equals("") ? "" : patternStringPrefix + ":";
        patternString = patternString + patternInfoLocalPart;
        Pattern userp = Pattern.compile(patternString.replace("*", "(\\w|\\.|-|_)*"));
        Matcher userm = userp.matcher(portInfoString);
        boolean match = userm.matches();
        if (log.isDebugEnabled()) {
            if (!match) {
                log.debug((Object)("Pattern match failed: \"" + portInfoString + "\" does not match \"" + patternString + "\""));
            } else {
                log.debug((Object)("Pattern match succeeded: \"" + portInfoString + "\" matches \"" + patternString + "\""));
            }
        }
        return match;
    }

    private static boolean doesPatternMatch_Official(QName qName, QName pattern) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("entry pattern=" + pattern + " qname=" + qName));
        }
        if (pattern == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successful Match: Pattern is null");
            }
            return true;
        }
        String patternLocalPart = pattern.getLocalPart();
        String localPart = qName.getLocalPart();
        String regEx = patternLocalPart.replace("*", "(\\w|\\.|-|_)*");
        Pattern userp = Pattern.compile(regEx);
        Matcher userm = userp.matcher(localPart);
        boolean match = userm.matches();
        if (!match) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No Match: The local name does not match the regex pattern: " + regEx));
            }
            return false;
        }
        String patternNamespace = pattern.getNamespaceURI();
        String namespace = qName.getNamespaceURI();
        if (patternNamespace.length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successful Match: The local name matches and the pattern namespace is empty.");
            }
            return true;
        }
        if (patternNamespace.equals(namespace)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successful Match: The local names and namespaces match.");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"No Match");
        }
        return false;
    }

    private static void validatePattern(QName pattern) {
        if (pattern == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The pattern qname is null.  This is accepted and interpretted as a wildcard");
            }
            return;
        }
        String patternStringPrefix = pattern.getPrefix();
        String patternInfoLocalPart = pattern.getLocalPart();
        String patternString = patternStringPrefix == null || patternStringPrefix.equals("") ? "" : patternStringPrefix + ":";
        patternString = patternString + patternInfoLocalPart;
        Pattern p = Pattern.compile("\\*|((\\w|_)(\\w|\\.|-|_)*:)?(\\w|_)(\\w|\\.|-|_)*\\*?");
        Matcher m = p.matcher(patternString);
        if (!m.matches()) {
            log.warn((Object)("Pattern defined by user is illegal:  \"" + patternString + "\" does not match regular expression in schema http://java.sun.com/xml/ns/javaee/javaee_web_services_1_2.xsd.  Pattern matching should now be considered \"best-effort.\""));
        }
    }

    private static Class forName(final String className, final boolean initialize, final ClassLoader classLoader) throws ClassNotFoundException {
        Class cl = null;
        try {
            cl = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("HandlerResolverImpl attempting to load Class: " + className));
                        }
                        return Class.forName(className, initialize, classLoader);
                    }
                    catch (Throwable e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("HandlerResolverImpl cannot load the following class Throwable Exception Occured: " + className));
                        }
                        throw new ClassNotFoundException("HandlerResolverImpl cannot load the following class Throwable Exception Occured:" + className);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw (ClassNotFoundException)e.getException();
        }
        return cl;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        try {
            cl = (ClassLoader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exception thrown from AccessController: " + e));
            }
            throw ExceptionFactory.makeWebServiceException((Throwable)e.getException());
        }
        return cl;
    }

    static {
        protocolBindingsMap.put("##SOAP11_HTTP", "http://schemas.xmlsoap.org/wsdl/soap/http");
        protocolBindingsMap.put("##SOAP11_HTTP_MTOM", "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true");
        protocolBindingsMap.put("##SOAP12_HTTP", "http://www.w3.org/2003/05/soap/bindings/HTTP/");
        protocolBindingsMap.put("##SOAP12_HTTP_MTOM", "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
        protocolBindingsMap.put("##XML_HTTP", "http://www.w3.org/2004/08/wsdl/http");
    }
}

