/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.microsoft.graph.mapper;

import coldfusion.cloud.util.ConsumerMap;
import coldfusion.cloud.util.ConsumerValidator;
import coldfusion.cloud.util.FieldTypecastUtil;
import coldfusion.cloud.util.ValidatorFiller;
import coldfusion.cloud.validator.CFBooleanValidator;
import coldfusion.cloud.validator.CFStructValidator;
import coldfusion.cloud.validator.EnumValidator;
import coldfusion.microsoft.graph.GraphServiceUtils;
import coldfusion.microsoft.graph.mapper.EmployeeOrgDataConsumer;
import coldfusion.microsoft.graph.mapper.OnPremisesExtensionAttributesConsumer;
import coldfusion.microsoft.graph.mapper.PasswordProfileConsumer;
import com.microsoft.graph.models.EmployeeOrgData;
import com.microsoft.graph.models.OnPremisesExtensionAttributes;
import com.microsoft.graph.models.PasswordProfile;
import com.microsoft.graph.models.User;
import java.util.List;
import java.util.Set;

public enum UserConsumer {
    INSTANCE;

    private final FieldTypecastUtil cast = FieldTypecastUtil.INSTANCE;
    private final ConsumerMap<User> consumerMap = new ConsumerMap();

    private UserConsumer() {
        this.consumerMap.put((Object)"aboutMe", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setAboutMe(arg_0))));
        this.consumerMap.put((Object)"accountEnabled", new ConsumerValidator((user, value) -> GraphServiceUtils.getBooleanProperty(value).ifPresent(arg_0 -> ((User)user).setAccountEnabled(arg_0)), List.of(CFBooleanValidator.INSTANCE)));
        this.consumerMap.put((Object)"ageGroup", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setAgeGroup(arg_0)), List.of(new EnumValidator(Set.of("Minor", "NotAdult", "Adult"), "ageGroup"))));
        this.consumerMap.put((Object)"birthday", new ConsumerValidator((user, value) -> GraphServiceUtils.getDateTimeProperty(value).ifPresent(arg_0 -> ((User)user).setBirthday(arg_0))));
        this.consumerMap.put((Object)"businessPhones", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringListProperty(value).ifPresent(arg_0 -> ((User)user).setBusinessPhones(arg_0))));
        this.consumerMap.put((Object)"city", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setCity(arg_0))));
        this.consumerMap.put((Object)"companyName", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setCompanyName(arg_0))));
        this.consumerMap.put((Object)"consentProvidedForMinor", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setConsentProvidedForMinor(arg_0)), List.of(new EnumValidator(Set.of("Granted", "Denied", "NotRequired"), "consentProvidedForMinor"))));
        this.consumerMap.put((Object)"country", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setCountry(arg_0))));
        this.consumerMap.put((Object)"customSecurityAttributes", new ConsumerValidator((user, value) -> GraphServiceUtils.getCustomSecurityAttributes(value).ifPresent(arg_0 -> ((User)user).setCustomSecurityAttributes(arg_0)), List.of(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"department", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setDepartment(arg_0))));
        this.consumerMap.put((Object)"displayName", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setDisplayName(arg_0))));
        this.consumerMap.put((Object)"employeeId", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setEmployeeId(arg_0))));
        this.consumerMap.put((Object)"employeeType", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setEmployeeType(arg_0))));
        this.consumerMap.put((Object)"employeeHireDate", new ConsumerValidator((user, value) -> GraphServiceUtils.getDateTimeProperty(value).ifPresent(arg_0 -> ((User)user).setEmployeeHireDate(arg_0))));
        this.consumerMap.put((Object)"employeeLeaveDateTime", new ConsumerValidator((user, value) -> GraphServiceUtils.getDateTimeProperty(value).ifPresent(arg_0 -> ((User)user).setEmployeeLeaveDateTime(arg_0))));
        this.consumerMap.put((Object)"employeeOrgData", new ConsumerValidator((user, value) -> {
            EmployeeOrgData employeeOrgData = new EmployeeOrgData();
            if (value != null) {
                ValidatorFiller.INSTANCE.fillObject((Object)employeeOrgData, this.cast.getStringStringMapProperty(value), EmployeeOrgDataConsumer.INSTANCE.getConsumerMap(), true);
                user.setEmployeeOrgData(employeeOrgData);
            }
        }, List.of(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"givenName", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setGivenName(arg_0))));
        this.consumerMap.put((Object)"interests", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringListProperty(value).ifPresent(arg_0 -> ((User)user).setInterests(arg_0))));
        this.consumerMap.put((Object)"jobTitle", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setJobTitle(arg_0))));
        this.consumerMap.put((Object)"mail", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setMail(arg_0))));
        this.consumerMap.put((Object)"mailNickname", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setMailNickname(arg_0))));
        this.consumerMap.put((Object)"mobilePhone", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setMobilePhone(arg_0))));
        this.consumerMap.put((Object)"mySite", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setMySite(arg_0))));
        this.consumerMap.put((Object)"officeLocation", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setOfficeLocation(arg_0))));
        this.consumerMap.put((Object)"onPremisesExtensionAttributes", new ConsumerValidator((user, value) -> {
            OnPremisesExtensionAttributes onPremisesExtensionAttributes = new OnPremisesExtensionAttributes();
            if (value != null) {
                ValidatorFiller.INSTANCE.fillObject((Object)onPremisesExtensionAttributes, this.cast.getStringStringMapProperty(value), OnPremisesExtensionAttributesConsumer.INSTANCE.getConsumerMap(), true);
                user.setOnPremisesExtensionAttributes(onPremisesExtensionAttributes);
            }
        }, List.of(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"onPremisesImmutableId", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setOnPremisesImmutableId(arg_0))));
        this.consumerMap.put((Object)"otherMails", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringListProperty(value).ifPresent(arg_0 -> ((User)user).setOtherMails(arg_0))));
        this.consumerMap.put((Object)"passwordPolicies", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setPasswordPolicies(arg_0)), List.of(new EnumValidator(Set.of("DisableStrongPassword", "DisablePasswordExpiration", "DisablePasswordExpiration, DisableStrongPassword"), "passwordPolicies"))));
        this.consumerMap.put((Object)"passwordProfile", new ConsumerValidator((user, value) -> {
            PasswordProfile passwordProfile = new PasswordProfile();
            if (value != null) {
                ValidatorFiller.INSTANCE.fillObject((Object)passwordProfile, this.cast.getStringObjectMapProperty(value), PasswordProfileConsumer.INSTANCE.getConsumerMap(), true);
                user.setPasswordProfile(passwordProfile);
            }
        }, List.of(CFStructValidator.INSTANCE)));
        this.consumerMap.put((Object)"pastProjects", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringListProperty(value).ifPresent(arg_0 -> ((User)user).setPastProjects(arg_0))));
        this.consumerMap.put((Object)"postalCode", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setPostalCode(arg_0))));
        this.consumerMap.put((Object)"preferredLanguage", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setPreferredLanguage(arg_0))));
        this.consumerMap.put((Object)"responsibilities", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringListProperty(value).ifPresent(arg_0 -> ((User)user).setResponsibilities(arg_0))));
        this.consumerMap.put((Object)"schools", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringListProperty(value).ifPresent(arg_0 -> ((User)user).setSchools(arg_0))));
        this.consumerMap.put((Object)"skills", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringListProperty(value).ifPresent(arg_0 -> ((User)user).setSkills(arg_0))));
        this.consumerMap.put((Object)"state", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setState(arg_0))));
        this.consumerMap.put((Object)"streetAddress", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setStreetAddress(arg_0))));
        this.consumerMap.put((Object)"surname", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setStreetAddress(arg_0))));
        this.consumerMap.put((Object)"usageLocation", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setUsageLocation(arg_0))));
        this.consumerMap.put((Object)"userPrincipalName", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setUserPrincipalName(arg_0))));
        this.consumerMap.put((Object)"userType", new ConsumerValidator((user, value) -> GraphServiceUtils.getStringProperty(value).ifPresent(arg_0 -> ((User)user).setUserType(arg_0))));
    }

    public ConsumerMap<User> getConsumerMap() {
        return this.consumerMap;
    }
}

