/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.microsoft.graph.mapper;

import coldfusion.microsoft.graph.GraphServiceUtils;
import coldfusion.microsoft.graph.mapper.AbstractResponseWriter;
import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import com.microsoft.graph.models.AssignedLicense;
import com.microsoft.graph.models.AssignedPlan;
import com.microsoft.graph.models.AutomaticRepliesSetting;
import com.microsoft.graph.models.CustomSecurityAttributeValue;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.EmployeeOrgData;
import com.microsoft.graph.models.LicenseAssignmentState;
import com.microsoft.graph.models.LocaleInfo;
import com.microsoft.graph.models.MailboxSettings;
import com.microsoft.graph.models.ObjectIdentity;
import com.microsoft.graph.models.OnPremisesExtensionAttributes;
import com.microsoft.graph.models.OnPremisesProvisioningError;
import com.microsoft.graph.models.PasswordProfile;
import com.microsoft.graph.models.ProvisionedPlan;
import com.microsoft.graph.models.ServiceProvisioningError;
import com.microsoft.graph.models.SignInActivity;
import com.microsoft.graph.models.TimeZoneBase;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.WorkingHours;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;

public class StructMapper
extends AbstractResponseWriter {
    private Struct response = new Struct();
    private final String ODATA_CONSTANT = "@odata.";

    @Override
    public Struct getObject() {
        return this.response;
    }

    public void writeStringValue(String key, String value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> {
            switch (key) {
                case "@odata.count": {
                    this.response.put((Object)"count", (Object)value);
                    break;
                }
                case "@odata.nextLink": {
                    GraphServiceUtils.parseNextLinkForSkipToken(value).ifPresent(skipToken -> this.response.put((Object)"skiptoken", skipToken));
                    break;
                }
                case "@odata.deltaLink": {
                    GraphServiceUtils.parseDeltaLinkForDeltaToken(value).ifPresent(deltaToken -> this.response.put((Object)"deltatoken", deltaToken));
                    break;
                }
                default: {
                    this.response.put((Object)key, nonNullValue);
                }
            }
        });
    }

    public void writeBooleanValue(String key, Boolean value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, nonNullValue));
    }

    public void writeByteValue(String key, Byte value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, nonNullValue));
    }

    public void writeShortValue(String key, Short value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, nonNullValue));
    }

    public void writeBigDecimalValue(String key, BigDecimal value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, nonNullValue));
    }

    public void writeIntegerValue(String key, Integer value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, nonNullValue));
    }

    public void writeFloatValue(String key, Float value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, nonNullValue));
    }

    public void writeDoubleValue(String key, Double value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, nonNullValue));
    }

    public void writeLongValue(String key, Long value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)(key.equalsIgnoreCase("@odata.count") ? "count" : key), nonNullValue));
    }

    public void writeUUIDValue(String key, UUID value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, (Object)nonNullValue.toString()));
    }

    public void writeOffsetDateTimeValue(String key, OffsetDateTime value) {
        Optional.ofNullable(value).map(aValue -> Date.from(aValue.atZoneSameInstant(ZoneId.systemDefault()).toInstant())).ifPresent(mappedValue -> this.response.put((Object)key, mappedValue));
    }

    public void writeLocalDateValue(String key, LocalDate value) {
        Optional.ofNullable(value).map(aValue -> Date.from(aValue.atStartOfDay(ZoneId.systemDefault()).toInstant())).ifPresent(mappedValue -> this.response.put((Object)key, mappedValue));
    }

    public void writeLocalTimeValue(String key, LocalTime value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, (Object)nonNullValue.toString()));
    }

    public void writePeriodAndDurationValue(String key, PeriodAndDuration value) {
    }

    public <T> void writeCollectionOfPrimitiveValues(String key, Iterable<T> values) {
        Optional.ofNullable(values).map(iterable -> {
            Array collector = new Array();
            iterable.forEach(nullableValue -> Optional.ofNullable(nullableValue).ifPresent(arg_0 -> ((Array)collector).addElement(arg_0)));
            return collector;
        }).ifPresent(anArray -> {
            if (!anArray.isEmpty()) {
                this.response.put((Object)key, anArray);
            }
        });
    }

    private Struct mapComplexObjects(Object value) {
        StructMapper complexObjectMapper = new StructMapper();
        HashMap<Class, BiConsumer<StructMapper, Object>> serializerMap = new HashMap<Class, BiConsumer<StructMapper, Object>>();
        serializerMap.put(AssignedLicense.class, (mapper, obj) -> ((AssignedLicense)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(AssignedPlan.class, (mapper, obj) -> ((AssignedPlan)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(CustomSecurityAttributeValue.class, (mapper, obj) -> ((CustomSecurityAttributeValue)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(EmployeeOrgData.class, (mapper, obj) -> ((EmployeeOrgData)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(LicenseAssignmentState.class, (mapper, obj) -> ((LicenseAssignmentState)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(MailboxSettings.class, (mapper, obj) -> ((MailboxSettings)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(AutomaticRepliesSetting.class, (mapper, obj) -> ((AutomaticRepliesSetting)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(LocaleInfo.class, (mapper, obj) -> ((LocaleInfo)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(WorkingHours.class, (mapper, obj) -> ((WorkingHours)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(TimeZoneBase.class, (mapper, obj) -> ((TimeZoneBase)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(ObjectIdentity.class, (mapper, obj) -> ((ObjectIdentity)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(PasswordProfile.class, (mapper, obj) -> ((PasswordProfile)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(ProvisionedPlan.class, (mapper, obj) -> ((ProvisionedPlan)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(ServiceProvisioningError.class, (mapper, obj) -> ((ServiceProvisioningError)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(SignInActivity.class, (mapper, obj) -> ((SignInActivity)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(OnPremisesExtensionAttributes.class, (mapper, obj) -> ((OnPremisesExtensionAttributes)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(OnPremisesProvisioningError.class, (mapper, obj) -> ((OnPremisesProvisioningError)obj).serialize((SerializationWriter)mapper));
        serializerMap.put(User.class, (mapper, obj) -> ((User)obj).serialize((SerializationWriter)mapper));
        if (serializerMap.containsKey(value.getClass())) {
            ((BiConsumer)serializerMap.get(value.getClass())).accept(complexObjectMapper, value);
        }
        return complexObjectMapper.getObject();
    }

    public <T extends Parsable> void writeCollectionOfObjectValues(String key, Iterable<T> values) {
        Optional.ofNullable(values).map(iterable -> {
            Array collector = new Array();
            iterable.forEach(nullableValue -> Optional.ofNullable(nullableValue).ifPresent(value -> {
                Struct mappedStruct = this.mapComplexObjects(value);
                if (mappedStruct.size() > 0) {
                    collector.addElement((Object)mappedStruct);
                }
            }));
            return collector;
        }).ifPresent(anArray -> {
            if (!anArray.isEmpty()) {
                this.response.put((Object)key, anArray);
            }
        });
    }

    public <T extends Enum<T>> void writeCollectionOfEnumValues(String key, Iterable<T> values) {
        Optional.ofNullable(values).map(iterable -> {
            Array collector = new Array();
            iterable.forEach(nullableValue -> Optional.ofNullable(nullableValue).ifPresent(nonNullValue -> collector.addElement((Object)nonNullValue.name())));
            return collector;
        }).ifPresent(anArray -> {
            if (!anArray.isEmpty()) {
                this.response.put((Object)key, anArray);
            }
        });
    }

    public <T extends Parsable> void writeObjectValue(String key, T value, Parsable ... additionalValuesToMerge) {
        Optional.ofNullable(value).map(this::mapComplexObjects).ifPresent(aStruct -> {
            if (aStruct.size() > 0) {
                this.response.put((Object)key, aStruct);
            } else if (value instanceof DateTimeTimeZone) {
                DateTimeTimeZone dateTimeTimeZone = (DateTimeTimeZone)value;
                LocalDateTime localDateTime = LocalDateTime.parse(dateTimeTimeZone.getDateTime(), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                ZonedDateTime providedDateTime = ZonedDateTime.of(localDateTime, ZoneId.of(dateTimeTimeZone.getTimeZone()));
                ZonedDateTime currentDateTime = providedDateTime.withZoneSameInstant(ZoneId.systemDefault());
                this.response.put((Object)key, (Object)Date.from(currentDateTime.toInstant()));
            }
        });
    }

    public <T extends Enum<T>> void writeEnumSetValue(String key, EnumSet<T> values) {
    }

    public <T extends Enum<T>> void writeEnumValue(String key, T value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, (Object)nonNullValue.name()));
    }

    public void writeNullValue(String key) {
        this.response.put((Object)key, null);
    }

    public void writeAdditionalData(Map<String, Object> value) {
        Optional.ofNullable(value).ifPresent(arg_0 -> ((Struct)this.response).putAll(arg_0));
    }

    public void writeByteArrayValue(String key, byte[] value) {
        Optional.ofNullable(value).ifPresent(nonNullValue -> this.response.put((Object)key, (Object)value));
    }

    public void setResponse(Struct response) {
        this.response = response;
    }

    @Override
    public void close() {
        super.close();
        this.setResponse(null);
    }
}

