/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.tagext.net.exchange;

import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeConnectionFactory;
import coldfusion.exchange.ExchangeLoginInfo;
import coldfusion.exchange.microsoft.graph.GraphLoginInfo;
import coldfusion.exchange.webdav.WebDAVExceptions;
import coldfusion.exchange.webdav.WebDAVLoginInfo;
import coldfusion.exchange.webservice.EWSException;
import coldfusion.exchange.webservice.EWSLoginInfo;
import coldfusion.featurerouter.EFRConstants;
import coldfusion.featurerouter.FeatureRouter;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.JSONUtils;
import coldfusion.runtime.Struct;
import coldfusion.tagext.GenericTag;
import coldfusion.tagext.net.exchange.AttachmentQuery;
import coldfusion.tagext.net.exchange.ExchangeConstants;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.tagext.net.exchange.ExchangeMailTag;
import coldfusion.tagext.validation.RequiredAttributesException;
import coldfusion.vfs.VFSFileFactory;
import jakarta.servlet.jsp.JspException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.URIException;

public abstract class ExchangeTag
extends GenericTag
implements ExchangeConstants {
    protected static final int CALENDAR_FOLDER = 1;
    protected static final int CONTACT_FOLDER = 2;
    protected static final int TASK_FOLDER = 3;
    protected static final int MAIL_FOLDER = 4;
    private static final String EXCHANGE_SERVER_VERSION = "exchangeserverversion";
    private static final String USER_PRINCIPAL_NAME = "upn";
    protected String action = null;
    protected String username = null;
    protected String mailBoxName = null;
    protected String password = null;
    protected String server = null;
    protected String protocol = "http";
    protected int port = -1;
    protected String proxyHost = null;
    protected int proxyPort = -1;
    protected String connection = null;
    protected String name = null;
    protected String notify = null;
    protected String result = null;
    protected String uid = null;
    protected String attachmentPath = null;
    protected boolean generateuniquefilenames = false;
    protected String exchangeServerLanguage = "english";
    protected boolean formBasedAuthentication = false;
    protected String exchangeApplicationName = "exchange";
    protected String formBasedAuthenticationUrl = null;
    protected String serverVersion = null;
    protected String access_token = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("name");
        }
        this.name = name;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getServer() {
        return this.server;
    }

    public String getUsername() {
        return this.username;
    }

    public String getServerVersion() {
        Map appSettings;
        ApplicationScope appScope;
        if (null == this.serverVersion && (appScope = ApplicationScopeTracker.getApplicationScope((String)FusionContext.getCurrent().getApplicationName())) != null && (appSettings = appScope.getApplicationSettingsMap()) != null) {
            return (String)appSettings.get(EXCHANGE_SERVER_VERSION);
        }
        return this.serverVersion;
    }

    public void setConnection(String connection) {
        if (connection == null || connection.trim().length() == 0) {
            ExchangeExceptions.throwInvalidConnectionException("connection", "\"\"");
        }
        this.connection = connection;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        if (protocol.equalsIgnoreCase("http")) {
            this.protocol = "http";
        } else if (protocol.equalsIgnoreCase("https")) {
            this.protocol = "https";
        } else {
            ExchangeExceptions.throwInvalidProtocolException("protocol");
        }
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getNotify() {
        return this.notify;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        if (result == null || result.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("result");
        }
        this.result = result;
    }

    public void setNotify(String notify) {
        this.notify = notify;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        if (uid == null || uid.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("uid");
        }
        this.uid = uid;
    }

    public String getAttachmentPath() {
        return this.attachmentPath;
    }

    public void setAttachmentPath(String attachmentPath) {
        if (attachmentPath == null || attachmentPath.trim().length() == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("attachmentPath");
        }
        this.attachmentPath = attachmentPath;
    }

    public void setGenerateuniquefilenames(boolean b) {
        this.generateuniquefilenames = b;
    }

    public boolean isGenerateuniquefilenames() {
        return this.generateuniquefilenames;
    }

    public String getMailBoxName() {
        return this.mailBoxName;
    }

    public void setMailBoxName(String mailBoxName) {
        this.mailBoxName = mailBoxName;
    }

    public String getExchangeServerLanguage() {
        return this.exchangeServerLanguage;
    }

    public void setExchangeServerLanguage(String language) {
        this.exchangeServerLanguage = language;
    }

    public boolean isFormBasedAuthentication() {
        return this.formBasedAuthentication;
    }

    public void setFormBasedAuthentication(boolean formBasedAuthentication) {
        this.formBasedAuthentication = formBasedAuthentication;
    }

    public String getExchangeApplicationName() {
        return this.exchangeApplicationName;
    }

    public String getFormBasedAuthenticationUrl() {
        return this.formBasedAuthenticationUrl;
    }

    public void setFormBasedAuthenticationUrl(String formBasedAuthenticationUrl) {
        this.formBasedAuthenticationUrl = formBasedAuthenticationUrl;
    }

    public void setExchangeApplicationName(String websiteName) {
        this.exchangeApplicationName = websiteName;
    }

    public void setAccess_token(String access_token) {
        this.access_token = access_token;
    }

    public String getAccess_token() {
        return this.access_token;
    }

    protected ExchangeConnection createConnection() {
        if (this.getUsername() == null && this.getAccess_token() == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "username or access_token");
        }
        if (this.getAccess_token() == null && this.getServer() == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "server");
        }
        if (this.getAccess_token() != null && this.getServerVersion() == null) {
            this.setServerVersion("online");
        }
        String version = this.getServerVersion();
        ExchangeLoginInfo loginInfo = null;
        if (null != version) {
            if (version.equalsIgnoreCase("2007")) {
                loginInfo = new WebDAVLoginInfo("2007");
            } else if (version.equalsIgnoreCase("2010")) {
                loginInfo = new EWSLoginInfo("2010");
            } else if (version.equalsIgnoreCase("2010_SP2")) {
                loginInfo = new EWSLoginInfo("2010_SP2");
            } else if (version.equalsIgnoreCase("2010_SP1")) {
                loginInfo = new EWSLoginInfo("2010_SP1");
            } else if (version.equalsIgnoreCase("2013")) {
                loginInfo = new EWSLoginInfo("2013");
            } else if (version.equalsIgnoreCase("2016")) {
                loginInfo = new EWSLoginInfo("2016");
            } else if (version.equalsIgnoreCase("2019")) {
                loginInfo = new EWSLoginInfo("2019");
            } else if (version.equalsIgnoreCase("2003")) {
                loginInfo = new WebDAVLoginInfo("2003");
            } else if (version.equalsIgnoreCase("online")) {
                loginInfo = this.setupMSGraphLogin();
            } else {
                ExchangeExceptions.throwInvalidAttributeValueException("serverversion");
            }
        } else {
            loginInfo = new WebDAVLoginInfo("2003");
        }
        loginInfo.setExchangeHost(this.getServer());
        loginInfo.setMailId(this.getUsername());
        loginInfo.setUserPassword(this.getPassword());
        loginInfo.setProtocol(this.getProtocol());
        loginInfo.setPort(this.getPort());
        loginInfo.setProxyHost(this.getProxyHost());
        loginInfo.setMailBoxName(this.getMailBoxName());
        loginInfo.setExchangeServerLanguage(this.exchangeServerLanguage);
        loginInfo.setFormBasedAuthentication(this.formBasedAuthentication);
        loginInfo.setExchangeAppName(this.exchangeApplicationName);
        loginInfo.setFormBasedAuthenticationUrl(this.formBasedAuthenticationUrl);
        if (this.getProxyPort() > 0) {
            loginInfo.setProxyPort(this.getProxyPort());
        }
        ExchangeConnection con = null;
        try {
            con = ExchangeConnectionFactory.createExchangeConnection(loginInfo);
        }
        catch (Throwable t) {
            ExchangeExceptions.throwExchangeConnectionException();
        }
        try {
            con.login();
        }
        catch (URIException ue) {
            String reason = ue.getMessage();
            if (reason.indexOf("user required") >= 0) {
                ExchangeExceptions.throwExchangeConnectionAccessDeniedException();
            }
            ExchangeExceptions.throwExchangeLoginException();
        }
        catch (HttpException he) {
            int code = he.getReasonCode();
            if (code == 401) {
                ExchangeExceptions.throwExchangeConnectionAccessDeniedException();
            } else if (code == 404) {
                ExchangeExceptions.throwExchangeWebAppNotFoundException(code, this.getServer());
            } else if (code == 403) {
                ExchangeExceptions.throwExchangeHttp403Exception(code, this.getServer());
            } else if (code == 503) {
                ExchangeExceptions.throwExchangeServiceUnavailableException(code, this.getServer());
            }
            ExchangeExceptions.throwExchangeHttpException(code);
        }
        catch (SSLHandshakeException hse) {
            ExchangeExceptions.throwExchangeSSLHandshakeException(this.getServer());
        }
        catch (ConnectException ce) {
            String msg = ce.getMessage();
            if (msg.indexOf("refused") >= 0) {
                ExchangeExceptions.throwConnectionRefusedException(this.getServer());
            } else if (msg.indexOf("timeout") >= 0) {
                ExchangeExceptions.throwConnectionTimeoutException(this.getServer());
            } else {
                ExchangeExceptions.throwConnectionException(this.getServer(), ce.getMessage());
            }
        }
        catch (UnknownHostException uhe) {
            ExchangeExceptions.throwUnknownExchangeHostException(this.getServer());
        }
        catch (EWSException ewsE) {
            throw ewsE;
        }
        catch (Throwable t) {
            if (loginInfo.getProtocol().equalsIgnoreCase("https")) {
                ExchangeExceptions.throwExchangeHttpsLoginException();
            }
            ExchangeExceptions.throwExchangeLoginException();
        }
        if (this.getConnection() != null) {
            this.pageContext.setAttribute(this.getConnection(), (Object)con);
        }
        return con;
    }

    private GraphLoginInfo setupMSGraphLogin() {
        GraphLoginInfo loginInfo = new GraphLoginInfo("online");
        loginInfo.setAccessToken(this.getAccess_token());
        if (Objects.isNull(this.server)) {
            this.setServer(loginInfo.getExchangeHost());
        }
        if (Objects.isNull(this.username)) {
            this.setUsername(this.retrieveUPNFromAccessToken(this.access_token));
        }
        this.setProtocol(loginInfo.getProtocol());
        return loginInfo;
    }

    private String retrieveUPNFromAccessToken(String accessToken) {
        String[] chunks = accessToken.split("\\.");
        Base64.Decoder decoder = Base64.getUrlDecoder();
        String jsonPayload = new String(decoder.decode(chunks[1]));
        Struct payload = (Struct)JSONUtils.deserializeJSON((Object)jsonPayload);
        return (String)payload.get(USER_PRINCIPAL_NAME);
    }

    protected void closeConnection() {
        Object tmpObj;
        String connectionName = this.getConnection();
        if (connectionName == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "connection");
        }
        if (connectionName.trim().length() == 0) {
            ExchangeExceptions.throwInvalidConnectionException("connection", connectionName);
        }
        if ((tmpObj = this.pageContext.findAttribute(connectionName)) != null && tmpObj instanceof ExchangeConnection) {
            try {
                ((ExchangeConnection)tmpObj).closeConnection();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.pageContext.removeAttribute(connectionName);
        } else {
            ExchangeExceptions.throwInvalidConnectionVariableException(this.getConnection());
        }
    }

    protected ExchangeConnection getConnection(boolean create) {
        String conVar = this.getConnection();
        if (conVar != null) {
            ExchangeConnection con;
            Object conObj = this.pageContext.findAttribute(this.getConnection());
            if (conObj == null) {
                ExchangeExceptions.throwInvalidConnectionVariableException(conVar);
            }
            if (!(conObj instanceof ExchangeConnection)) {
                ExchangeExceptions.throwInvalidConnectionException("connection", conVar);
            }
            if (!(con = (ExchangeConnection)conObj).isOpen()) {
                ExchangeExceptions.throwConnectionClosedException("connection", conVar);
            }
            return con;
        }
        if (!create) {
            return null;
        }
        return this.createConnection();
    }

    protected Boolean getBooleanAttribute(Map aMap, String key, boolean required) {
        if (!aMap.containsKey(key)) {
            if (required) {
                throw new RequiredAttributesException(this.getTagPublicName(), key);
            }
            return null;
        }
        if (!CFPage.IsBoolean(aMap.get(key))) {
            ExchangeExceptions.throwInvalidBooleanValueException(key);
        }
        return Cast._boolean(aMap.get(key)) ? Boolean.TRUE : Boolean.FALSE;
    }

    protected Integer getIntAttribute(Map aMap, String key, boolean required) {
        if (!aMap.containsKey(key)) {
            if (required) {
                throw new RequiredAttributesException(this.getTagPublicName(), key);
            }
            return null;
        }
        if (!CFPage.IsNumeric(aMap.get(key))) {
            ExchangeExceptions.throwInvalidNumericValueException(key);
        }
        return new Integer(Cast._int(aMap.get(key)));
    }

    protected Float getFloatAttribute(Map aMap, String key, boolean required) {
        if (!aMap.containsKey(key)) {
            if (required) {
                throw new RequiredAttributesException(this.getTagPublicName(), key);
            }
            return null;
        }
        if (!CFPage.IsNumeric(aMap.get(key))) {
            ExchangeExceptions.throwInvalidNumericValueException(key);
        }
        return new Float((float)Cast._double(aMap.get(key)));
    }

    protected Date getDateAttribute(Map aMap, String key, boolean required) {
        if (!aMap.containsKey(key)) {
            if (required) {
                throw new RequiredAttributesException(this.getTagPublicName(), key);
            }
            return null;
        }
        if (!CFPage.IsDate(aMap.get(key))) {
            ExchangeExceptions.throwInvalidDateValueException(key);
        }
        return Cast._Date(aMap.get(key));
    }

    protected String getStringAttribute(Map aMap, String key, boolean required) {
        if (!aMap.containsKey(key)) {
            if (required) {
                throw new RequiredAttributesException(this.getTagPublicName(), key);
            }
            return null;
        }
        return aMap.get(key).toString();
    }

    protected boolean isNotify() {
        String strValue = this.getNotify();
        if (strValue == null) {
            return true;
        }
        if (!CFPage.IsBoolean((Object)strValue)) {
            ExchangeExceptions.throwInvalidBooleanValueException("notify");
        }
        return Cast._boolean((String)strValue);
    }

    public void processException(Throwable t) throws ApplicationException {
        if (t instanceof WebDAVExceptions) {
            WebDAVExceptions we = (WebDAVExceptions)t;
            switch (we.getStatusCode()) {
                case 1: 
                case 7: {
                    ExchangeExceptions.throwInvalidAttributeValueException(we.getAttributeName());
                    break;
                }
                case 2: {
                    this.processWebDAVStatusCode(we.getWebDAVCode());
                    break;
                }
                case 5: 
                case 6: {
                    ExchangeExceptions.throwGenericExchangeActionException(String.valueOf(we.getWebDAVCode()));
                    break;
                }
                case 3: {
                    throw new RequiredAttributesException(this.getTagPublicName(), we.getAttributeName());
                }
                case 8: {
                    ExchangeExceptions.throwInvalidStartEndTimeException();
                    break;
                }
                case 4: {
                    ExchangeExceptions.throwExchangeUIDNotFoundException();
                    break;
                }
                case 11: {
                    ExchangeExceptions.throwNewUIDNotFoundException();
                }
            }
        } else {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof ConnectException) {
                ExchangeExceptions.throwExchangeConnectionException();
            } else {
                CFLogs.APPLICATION_LOG.error(t);
                ExchangeExceptions.throwGenericExchangeActionException("Unknown");
            }
        }
    }

    protected void processWebDAVStatusCode(int webDavStatusCode) throws ApplicationException {
        switch (webDavStatusCode) {
            case 401: {
                ExchangeExceptions.throwAccessDeniedException();
            }
            case 400: {
                ExchangeExceptions.throwBadRequestException();
            }
            case 403: {
                ExchangeExceptions.throwForbiddenRequestException();
            }
            case 404: {
                ExchangeExceptions.throwResourceNotFoundException();
            }
            case 407: {
                ExchangeExceptions.throwProxyAuthenticationRequiredException();
            }
            case 408: {
                ExchangeExceptions.throwRequestTimeoutException();
            }
            case 409: {
                ExchangeExceptions.throwResourceConflictException();
            }
            case 410: {
                ExchangeExceptions.throwResourceLostException();
            }
            case 413: {
                ExchangeExceptions.throwRequestEntityLargeException();
            }
            case 423: {
                ExchangeExceptions.throwResourceLockedException();
            }
            case 424: {
                ExchangeExceptions.throwExchangeRequestFailedException();
            }
            case 425: {
                ExchangeExceptions.throwInsufficientSpaceException();
            }
            case 503: {
                ExchangeExceptions.throwServiceUnavailableException();
            }
            case 507: {
                ExchangeExceptions.throwInsufficientStorageException();
            }
        }
        ExchangeExceptions.throwGenericExchangeActionException(String.valueOf(webDavStatusCode));
    }

    protected void getAttachments(int folderType) {
        String uid;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = this.getConnection(false);
        if (con == null) {
            con = this.createConnection();
            getTempConnection = true;
        }
        if ((uid = this.getUid()) == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "uid");
        }
        String name = this.getName();
        if (name == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "name");
        }
        String path = this.getAttachmentPath();
        File pathDir = null;
        if (path != null) {
            pathDir = VFSFileFactory.getFileObject((String)path);
            if (pathDir.exists() && !pathDir.isDirectory()) {
                ExchangeExceptions.throwInvalidAttachmentDirectoryException("attachmentPath", pathDir.getAbsolutePath());
            } else if (!pathDir.exists()) {
                pathDir.mkdirs();
            }
        }
        ArrayList attachments = null;
        try {
            switch (folderType) {
                case 2: {
                    attachments = con.getContactAttachments(uid, path != null);
                    break;
                }
                case 1: {
                    attachments = con.getAppointmentAttachments(uid, path != null);
                    break;
                }
                case 3: {
                    attachments = con.getTaskAttachments(uid, path != null);
                    break;
                }
                case 4: {
                    String folder = null;
                    if (this instanceof ExchangeMailTag && (folder = ((ExchangeMailTag)this).getFolder()) != null && folder.trim().length() == 0) {
                        folder = null;
                    }
                    attachments = con.getMessageAttachments(uid, path != null, folder);
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.processException(t);
        }
        String dirPath = null;
        try {
            if (pathDir != null) {
                dirPath = pathDir.getCanonicalPath();
            }
        }
        catch (IOException ie) {
            ExchangeExceptions.throwInvalidAttachmentDirectoryException("attachmentPath", path);
        }
        AttachmentQuery query = new AttachmentQuery();
        query.populate(attachments, dirPath, this.isGenerateuniquefilenames());
        this.pageContext.setAttribute(name, (Object)query);
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    protected void deleteAttachments(int folderType) {
        String uid;
        ExchangeConnection con = null;
        boolean getTempConnection = false;
        con = this.getConnection(false);
        if (con == null) {
            con = this.createConnection();
            getTempConnection = true;
        }
        if ((uid = this.getUid()) == null) {
            throw new RequiredAttributesException(this.getTagPublicName(), "uid");
        }
        Object attachments = null;
        try {
            switch (folderType) {
                case 2: {
                    con.deleteContactAttachments(uid, null);
                    break;
                }
                case 1: {
                    con.deleteAppointmentAttachments(uid, null);
                    break;
                }
                case 3: {
                    con.deleteTaskAttachments(uid, null);
                    break;
                }
                case 4: {
                    String folder = null;
                    if (this instanceof ExchangeMailTag && (folder = ((ExchangeMailTag)this).getFolder()) != null && folder.trim().length() == 0) {
                        folder = null;
                    }
                    con.deleteMessageAttachments(uid, null, folder);
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.processException(t);
        }
        if (getTempConnection) {
            con.closeConnection();
        }
    }

    protected Object[] readAttachmentFiles(String attachmentPaths) {
        if (attachmentPaths == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(attachmentPaths, File.pathSeparator);
        int numTokens = tokenizer.countTokens();
        if (numTokens == 0) {
            ExchangeExceptions.throwInvalidAttributeValueException("attachmentPath");
        }
        String[] fileNames = new String[numTokens];
        Object[] fileContents = new Object[numTokens];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String path = tokenizer.nextToken().trim();
            Object[] fileInfo = this.readAttachmentFile(path);
            fileNames[i] = (String)fileInfo[1];
            fileContents[i] = (byte[])fileInfo[0];
            ++i;
        }
        return new Object[]{fileNames, fileContents};
    }

    public void validateStruct(Map msg, HashMap validMessageAttributes, String tagName, String attribName) {
        if (msg == null || msg.size() == 0) {
            ExchangeExceptions.throwInvalidStructValueException(attribName);
        }
        Set keys = msg.keySet();
        for (String currKey : keys) {
            if (validMessageAttributes.containsKey(currKey.toUpperCase())) continue;
            ExchangeExceptions.throwInvalidAttributeKeyException(currKey, tagName);
        }
    }

    public boolean isValidAttributeKey(String attribName, HashMap validFilterAttributes) {
        return validFilterAttributes.containsKey(attribName.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] readAttachmentFile(String path) {
        InputStream inStream = null;
        try {
            File attachFile = VFSFileFactory.getFileObject((String)path);
            if (!(attachFile.exists() && attachFile.isFile() && attachFile.canRead())) {
                ExchangeExceptions.throwExchangeAttachmentIOException(path);
            }
            inStream = VFSFileFactory.getInputStream((File)attachFile);
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = inStream.read(buf)) > 0) {
                outStream.write(buf, 0, bytesRead);
            }
            byte[] fileContent = outStream.toByteArray();
            outStream.close();
            Object[] objectArray = new Object[]{fileContent, attachFile.getName()};
            return objectArray;
        }
        catch (Exception e) {
            ExchangeExceptions.throwExchangeAttachmentIOException(path);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static int castInt(Object value, String attributeName) {
        try {
            return Cast._int((Object)value);
        }
        catch (Exception e) {
            ExchangeExceptions.throwInvalidNumericValueException(attributeName);
            return -1;
        }
    }

    public static boolean castBoolean(Object value, String attributeName) {
        try {
            return Cast._boolean((Object)value);
        }
        catch (Exception e) {
            ExchangeExceptions.throwInvalidBooleanValueException(attributeName);
            return false;
        }
    }

    public static Date castDate(Object value, String attributeName) {
        try {
            return Cast._Date((Object)value);
        }
        catch (Exception e) {
            ExchangeExceptions.throwInvalidDateValueException(attributeName);
            return null;
        }
    }

    protected boolean validateImportance(String importance) {
        return importance.equalsIgnoreCase("high") || importance.equalsIgnoreCase("low") || importance.equalsIgnoreCase("normal");
    }

    protected boolean validateSensitivity(String sensitivity) {
        return sensitivity.equalsIgnoreCase("private") || sensitivity.equalsIgnoreCase("personal") || sensitivity.equalsIgnoreCase("company-confidential") || sensitivity.equalsIgnoreCase("normal");
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        return 1;
    }

    public int doEndTag() throws JspException {
        super.doEndTag();
        FeatureRouter.getInstance().allowFeature(EFRConstants.exchange_server_integration.intValue(), this.tagNameFromClass(), null);
        return 6;
    }

    public void release() {
        super.release();
        this.action = null;
        this.attachmentPath = null;
        this.connection = null;
        this.name = null;
        this.notify = null;
        this.password = null;
        this.port = -1;
        this.protocol = "http";
        this.proxyHost = null;
        this.proxyPort = -1;
        this.result = null;
        this.server = null;
        this.uid = null;
        this.username = null;
        this.mailBoxName = null;
        this.generateuniquefilenames = false;
        this.exchangeServerLanguage = "english";
        this.formBasedAuthentication = false;
        this.exchangeApplicationName = "exchange";
        this.formBasedAuthenticationUrl = null;
    }
}

