/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.webservice;

import coldfusion.exchange.AppointmentFilterInfo;
import coldfusion.exchange.ContactAddress;
import coldfusion.exchange.ContactFilterInfo;
import coldfusion.exchange.ContactOtherDetails;
import coldfusion.exchange.EffectiveRights;
import coldfusion.exchange.ExchangeAppointment;
import coldfusion.exchange.ExchangeConnection;
import coldfusion.exchange.ExchangeContact;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.ExchangeMailMeeting;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.ExchangeTask;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.exchange.FolderPermissionInfo;
import coldfusion.exchange.FolderPermissionLevel;
import coldfusion.exchange.FolderPermissionReadAccess;
import coldfusion.exchange.ManagedFolderInfo;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.PermissionScope;
import coldfusion.exchange.RecurrenceInfo;
import coldfusion.exchange.StandardUser;
import coldfusion.exchange.TaskFilterInfo;
import coldfusion.exchange.UserIdInfo;
import coldfusion.exchange.webdav.Utils;
import coldfusion.exchange.webservice.AttendeeAvailability;
import coldfusion.exchange.webservice.CFConversation;
import coldfusion.exchange.webservice.CFConversationFilter;
import coldfusion.exchange.webservice.CFTimeZone;
import coldfusion.exchange.webservice.CFUserAvailability;
import coldfusion.exchange.webservice.CalendarEvent;
import coldfusion.exchange.webservice.CalendarEventDetails;
import coldfusion.exchange.webservice.Conflict;
import coldfusion.exchange.webservice.EWSException;
import coldfusion.exchange.webservice.EWSOperationException;
import coldfusion.exchange.webservice.EmailAddress;
import coldfusion.exchange.webservice.InternetHeaders;
import coldfusion.exchange.webservice.InvalidTimezoneException;
import coldfusion.exchange.webservice.MailBoxType;
import coldfusion.exchange.webservice.Suggestion;
import coldfusion.exchange.webservice.TimeSuggestion;
import coldfusion.exchange.webservice.WorkingHours;
import coldfusion.util.DateUtils;
import coldfusion.util.RB;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.mail.Header;
import javax.mail.MessagingException;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.availability.FreeBusyViewType;
import microsoft.exchange.webservices.data.core.enumeration.availability.SuggestionQuality;
import microsoft.exchange.webservices.data.core.enumeration.property.BodyType;
import microsoft.exchange.webservices.data.core.enumeration.property.ConflictType;
import microsoft.exchange.webservices.data.core.enumeration.property.DefaultExtendedPropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.EmailAddressKey;
import microsoft.exchange.webservices.data.core.enumeration.property.Importance;
import microsoft.exchange.webservices.data.core.enumeration.property.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.core.enumeration.property.MailboxType;
import microsoft.exchange.webservices.data.core.enumeration.property.MapiPropertyType;
import microsoft.exchange.webservices.data.core.enumeration.property.MeetingResponseType;
import microsoft.exchange.webservices.data.core.enumeration.property.PhoneNumberKey;
import microsoft.exchange.webservices.data.core.enumeration.property.PhysicalAddressIndex;
import microsoft.exchange.webservices.data.core.enumeration.property.PhysicalAddressKey;
import microsoft.exchange.webservices.data.core.enumeration.property.Sensitivity;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeek;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeekIndex;
import microsoft.exchange.webservices.data.core.enumeration.property.time.Month;
import microsoft.exchange.webservices.data.core.enumeration.search.ComparisonMode;
import microsoft.exchange.webservices.data.core.enumeration.search.ContainmentMode;
import microsoft.exchange.webservices.data.core.enumeration.search.LogicalOperator;
import microsoft.exchange.webservices.data.core.enumeration.service.ConversationFlagStatus;
import microsoft.exchange.webservices.data.core.enumeration.service.TaskStatus;
import microsoft.exchange.webservices.data.core.enumeration.service.calendar.AppointmentType;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.remote.ServiceResponseException;
import microsoft.exchange.webservices.data.core.response.ServiceResponseCollection;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.Contact;
import microsoft.exchange.webservices.data.core.service.item.Conversation;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.item.MeetingCancellation;
import microsoft.exchange.webservices.data.core.service.item.MeetingMessage;
import microsoft.exchange.webservices.data.core.service.item.MeetingRequest;
import microsoft.exchange.webservices.data.core.service.item.MeetingResponse;
import microsoft.exchange.webservices.data.core.service.item.Task;
import microsoft.exchange.webservices.data.core.service.schema.AppointmentSchema;
import microsoft.exchange.webservices.data.core.service.schema.ContactSchema;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.FolderSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.core.service.schema.MeetingMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.TaskSchema;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.misc.availability.GetUserAvailabilityResults;
import microsoft.exchange.webservices.data.property.complex.Attendee;
import microsoft.exchange.webservices.data.property.complex.AttendeeCollection;
import microsoft.exchange.webservices.data.property.complex.ConversationId;
import microsoft.exchange.webservices.data.property.complex.EmailAddressCollection;
import microsoft.exchange.webservices.data.property.complex.EmailAddressDictionary;
import microsoft.exchange.webservices.data.property.complex.ExtendedProperty;
import microsoft.exchange.webservices.data.property.complex.ExtendedPropertyCollection;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.FolderPermission;
import microsoft.exchange.webservices.data.property.complex.FolderPermissionCollection;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.ItemIdCollection;
import microsoft.exchange.webservices.data.property.complex.ManagedFolderInformation;
import microsoft.exchange.webservices.data.property.complex.MessageBody;
import microsoft.exchange.webservices.data.property.complex.PhoneNumberDictionary;
import microsoft.exchange.webservices.data.property.complex.PhysicalAddressDictionary;
import microsoft.exchange.webservices.data.property.complex.PhysicalAddressEntry;
import microsoft.exchange.webservices.data.property.complex.StringList;
import microsoft.exchange.webservices.data.property.complex.UserId;
import microsoft.exchange.webservices.data.property.complex.recurrence.pattern.Recurrence;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;
import microsoft.exchange.webservices.data.property.definition.ExtendedPropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import org.apache.commons.io.IOUtils;

public class EWSUtils {
    private static final ExtendedPropertyDefinition isRecurringProperty = new ExtendedPropertyDefinition(UUID.fromString("00062002-0000-0000-C000-000000000046"), 33315, MapiPropertyType.Boolean);
    private static final ExtendedPropertyDefinition durationProperty = new ExtendedPropertyDefinition(UUID.fromString("00062002-0000-0000-C000-000000000046"), 33299, MapiPropertyType.Integer);

    public static Contact createServerContact(ExchangeService service, ExchangeContact contact) throws Exception {
        Contact newContact = new Contact(service);
        EWSUtils.setNonNullValues(newContact, contact);
        return newContact;
    }

    public static ExchangeContact createCFContact(Contact contact) throws EWSOperationException {
        ExchangeContact ct = new ExchangeContact();
        try {
            ct.setLastName(contact.getSurname());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            ct.setTimeReceived(contact.getDateTimeReceived());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            ct.setDislpayName(contact.getFileAs());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            ct.setLocation(contact.getOfficeLocation());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            ct.setFirstName(contact.getGivenName());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            PhoneNumberDictionary phoneNumbers = contact.getPhoneNumbers();
            if (phoneNumbers.contains((Object)PhoneNumberKey.BusinessFax)) {
                ct.setBusinessFax(phoneNumbers.getPhoneNumber(PhoneNumberKey.BusinessFax));
            }
            if (phoneNumbers.contains((Object)PhoneNumberKey.BusinessPhone)) {
                ct.setBusinessPhone(phoneNumbers.getPhoneNumber(PhoneNumberKey.BusinessPhone));
            }
            if (phoneNumbers.contains((Object)PhoneNumberKey.HomePhone)) {
                ct.setHomePhone(phoneNumbers.getPhoneNumber(PhoneNumberKey.HomePhone));
            }
            if (phoneNumbers.contains((Object)PhoneNumberKey.MobilePhone)) {
                ct.setMobilePhone(phoneNumbers.getPhoneNumber(PhoneNumberKey.MobilePhone));
            }
            if (phoneNumbers.contains((Object)PhoneNumberKey.OtherTelephone)) {
                ct.setOtherPhone(phoneNumbers.getPhoneNumber(PhoneNumberKey.OtherTelephone));
            }
            if (phoneNumbers.contains((Object)PhoneNumberKey.Pager)) {
                ct.setPager(phoneNumbers.getPhoneNumber(PhoneNumberKey.Pager));
            }
        }
        catch (ServiceLocalException phoneNumbers) {
            // empty catch block
        }
        PhysicalAddressEntry businessAddress = null;
        PhysicalAddressEntry homeAddress = null;
        PhysicalAddressEntry otherAddress = null;
        try {
            PhysicalAddressDictionary physicalAddresses = contact.getPhysicalAddresses();
            businessAddress = physicalAddresses.getPhysicalAddress(PhysicalAddressKey.Business);
            homeAddress = physicalAddresses.getPhysicalAddress(PhysicalAddressKey.Home);
            otherAddress = physicalAddresses.getPhysicalAddress(PhysicalAddressKey.Other);
        }
        catch (ServiceLocalException physicalAddresses) {
            // empty catch block
        }
        ct.setBusinessAddress(EWSUtils.createContactAddress(businessAddress));
        ct.setHomeAddress(EWSUtils.createContactAddress(homeAddress));
        ct.setOtherAddress(EWSUtils.createContactAddress(otherAddress));
        try {
            OutParam propertyValue = new OutParam();
            if (contact.tryGetProperty((PropertyDefinitionBase)ContactSchema.PostalAddressIndex, propertyValue)) {
                PhysicalAddressIndex postalAddressIndex = (PhysicalAddressIndex)propertyValue.getParam();
                switch (postalAddressIndex) {
                    case Business: {
                        ct.setMailingAdressType(2);
                        break;
                    }
                    case Home: {
                        ct.setMailingAdressType(1);
                        break;
                    }
                    case Other: {
                        ct.setMailingAdressType(3);
                    }
                }
            }
        }
        catch (Exception propertyValue) {
            // empty catch block
        }
        try {
            ct.setMiddleName(contact.getMiddleName());
        }
        catch (ServiceLocalException propertyValue) {
            // empty catch block
        }
        try {
            ct.setJobTitle(contact.getJobTitle());
        }
        catch (ServiceLocalException propertyValue) {
            // empty catch block
        }
        try {
            ct.setId(contact.getId().getUniqueId());
        }
        catch (ServiceLocalException propertyValue) {
            // empty catch block
        }
        try {
            ct.setCompany(contact.getCompanyName());
        }
        catch (ServiceLocalException propertyValue) {
            // empty catch block
        }
        try {
            ct.setBusinessHomePage(contact.getBusinessHomePage());
        }
        catch (ServiceLocalException propertyValue) {
            // empty catch block
        }
        try {
            ct.setLastModified(contact.getLastModifiedTime());
        }
        catch (ServiceLocalException propertyValue) {
            // empty catch block
        }
        try {
            StringList categories = contact.getCategories();
            if (null != categories && categories.getSize() > 0) {
                Iterator iterator = categories.iterator();
                StringBuilder builder = new StringBuilder();
                while (iterator.hasNext()) {
                    String category = (String)iterator.next();
                    builder.append(category);
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
                ct.setCategories(builder.toString());
            }
        }
        catch (ServiceLocalException categories) {
            // empty catch block
        }
        try {
            ct.setHasAttachment(contact.getHasAttachments());
        }
        catch (ServiceLocalException categories) {
            // empty catch block
        }
        try {
            Object bodyVal;
            String textBody = MessageBody.getStringFromMessageBody((MessageBody)contact.getBody());
            ct.setMessage(textBody);
            ct.setDescription(textBody);
            ExtendedPropertyCollection extendedProperties = contact.getExtendedProperties();
            if (extendedProperties.getCount() > 0 && null != (bodyVal = ((ExtendedProperty)extendedProperties.getPropertyAtIndex(0)).getValue())) {
                byte[] value = (byte[])bodyVal;
                String htmlBody = new String(value);
                ct.setHtmlMessage(htmlBody);
            }
        }
        catch (Exception textBody) {
            // empty catch block
        }
        ContactOtherDetails details = EWSUtils.createDetails(contact);
        ct.setDetails(details);
        try {
            EmailAddressDictionary emailAddresses = contact.getEmailAddresses();
            if (emailAddresses.contains((Object)EmailAddressKey.EmailAddress1)) {
                ct.setEMail1(emailAddresses.getEmailAddress(EmailAddressKey.EmailAddress1).getAddress());
            }
            if (emailAddresses.contains((Object)EmailAddressKey.EmailAddress2)) {
                ct.setEMail2(emailAddresses.getEmailAddress(EmailAddressKey.EmailAddress2).getAddress());
            }
            if (emailAddresses.contains((Object)EmailAddressKey.EmailAddress3)) {
                ct.setEMail3(emailAddresses.getEmailAddress(EmailAddressKey.EmailAddress3).getAddress());
            }
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        return ct;
    }

    private static ContactOtherDetails createDetails(Contact contact) {
        ContactOtherDetails details = new ContactOtherDetails();
        try {
            details.setAssistant(contact.getAssistantName());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            details.setDepartment(contact.getDepartment());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            details.setManager(contact.getManager());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            details.setNickname(contact.getNickName());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            details.setOffice(contact.getOfficeLocation());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            details.setPartner(contact.getSpouseName());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            details.setProfession(contact.getProfession());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        return details;
    }

    private static ContactAddress createContactAddress(PhysicalAddressEntry physicalAddress) {
        if (null == physicalAddress) {
            return null;
        }
        ContactAddress address = new ContactAddress();
        try {
            address.setStreet(physicalAddress.getStreet());
            address.setCity(physicalAddress.getCity());
            address.setState(physicalAddress.getState());
            address.setCountry(physicalAddress.getCountryOrRegion());
            address.setPostalCode(physicalAddress.getPostalCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return address;
    }

    public static SearchFilter createSearchFilter(ContactFilterInfo filter) throws Exception {
        SearchFilter.IsGreaterThanOrEqualTo dateFilter;
        Date date;
        ContactOtherDetails details;
        String categories;
        ContactAddress otherAddress;
        ContactAddress homeAddress;
        ContactAddress businessAddress;
        Integer mailingAdressType;
        SearchFilter.SearchFilterCollection filterCollection = new SearchFilter.SearchFilterCollection();
        String value = filter.getFirstName();
        if (null != value) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.GivenName));
        }
        if (null != (value = filter.getMiddleName())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.MiddleName));
        }
        if (null != (value = filter.getLastName())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.Surname));
        }
        if (null != (value = filter.getDislpayName())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.FileAs));
        }
        if (null != (value = filter.getBusinessFax())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessFax));
        }
        if (null != (mailingAdressType = filter.getMailingAdressType())) {
            switch (mailingAdressType) {
                case 1: {
                    filterCollection.add(EWSUtils.createComponentFilter(PhysicalAddressIndex.Home));
                    break;
                }
                case 2: {
                    filterCollection.add(EWSUtils.createComponentFilter(PhysicalAddressIndex.Business));
                    break;
                }
                case 3: {
                    filterCollection.add(EWSUtils.createComponentFilter(PhysicalAddressIndex.Other));
                }
            }
        }
        if (null != (value = filter.getJobTitle())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.JobTitle));
        }
        if (null != (value = filter.getCompany())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.CompanyName));
        }
        if (null != (value = filter.getBusinessHomePage())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessHomePage));
        }
        if (null != (value = filter.getEMail1())) {
            filterCollection.add(EWSUtils.createEMailFilter(value));
        }
        if (null != (value = filter.getEMail2())) {
            filterCollection.add(EWSUtils.createEMailFilter(value));
        }
        if (null != (value = filter.getEMail3())) {
            filterCollection.add(EWSUtils.createEMailFilter(value));
        }
        if (null != (businessAddress = filter.getBusinessAddress())) {
            value = businessAddress.getCity();
            if (null != value) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessAddressCity));
            }
            if (null != (value = businessAddress.getCountry())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessAddressCountryOrRegion));
            }
            if (null != (value = businessAddress.getPostalCode())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessAddressPostalCode));
            }
            if (null != (value = businessAddress.getState())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessAddressState));
            }
            if (null != (value = businessAddress.getStreet())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessAddressStreet));
            }
        }
        if (null != (homeAddress = filter.getHomeAddress())) {
            value = homeAddress.getCity();
            if (null != value) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.HomeAddressCity));
            }
            if (null != (value = homeAddress.getCountry())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.HomeAddressCountryOrRegion));
            }
            if (null != (value = homeAddress.getPostalCode())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.HomeAddressPostalCode));
            }
            if (null != (value = homeAddress.getState())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.HomeAddressState));
            }
            if (null != (value = homeAddress.getStreet())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.HomeAddressStreet));
            }
        }
        if (null != (otherAddress = filter.getOtherAddress())) {
            value = otherAddress.getCity();
            if (null != value) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OtherAddressCity));
            }
            if (null != (value = otherAddress.getCountry())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OtherAddressCountryOrRegion));
            }
            if (null != (value = otherAddress.getPostalCode())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OtherAddressPostalCode));
            }
            if (null != (value = otherAddress.getState())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OtherAddressState));
            }
            if (null != (value = otherAddress.getStreet())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OtherAddressStreet));
            }
        }
        if (null != (value = filter.getHomePhone())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.HomePhone));
        }
        if (null != (value = filter.getBusinessPhone())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessPhone));
        }
        if (null != (value = filter.getMobilePhone())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.MobilePhone));
        }
        if (null != (value = filter.getOtherPhone())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OtherTelephone));
        }
        if (null != (value = filter.getPager())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.Pager));
        }
        if (null != (value = filter.getPhoneNumber())) {
            SearchFilter.SearchFilterCollection phoneNumberFilter = new SearchFilter.SearchFilterCollection();
            phoneNumberFilter.setLogicalOperator(LogicalOperator.Or);
            phoneNumberFilter.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.HomePhone));
            phoneNumberFilter.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.BusinessPhone));
            phoneNumberFilter.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.MobilePhone));
            phoneNumberFilter.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OtherTelephone));
            filterCollection.add((SearchFilter)phoneNumberFilter);
        }
        if (null != (categories = filter.getCategories())) {
            filterCollection.add(EWSUtils.createCategoryFilter(categories));
        }
        if (null != (value = filter.getMessage())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.Body));
        }
        if (null != (details = filter.getDetails())) {
            value = details.getAssistant();
            if (null != value) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.AssistantName));
            }
            if (null != (value = details.getDepartment())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.Department));
            }
            if (null != (value = details.getManager())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.Manager));
            }
            if (null != (value = details.getNickname())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.NickName));
            }
            if (null != (value = details.getOffice())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.OfficeLocation));
            }
            if (null != (value = details.getPartner())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.SpouseName));
            }
            if (null != (value = details.getProfession())) {
                filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.Profession));
            }
        }
        if (null != (date = filter.getFromLastModifiedDate())) {
            dateFilter = new SearchFilter.IsGreaterThanOrEqualTo();
            dateFilter.setPropertyDefinition((PropertyDefinitionBase)ContactSchema.LastModifiedTime);
            dateFilter.setValue((Object)date);
            filterCollection.add((SearchFilter)dateFilter);
        }
        if (null != (date = filter.getToLastModifiedDate())) {
            dateFilter = new SearchFilter.IsLessThanOrEqualTo();
            dateFilter.setPropertyDefinition((PropertyDefinitionBase)ContactSchema.LastModifiedTime);
            dateFilter.setValue((Object)date);
            filterCollection.add((SearchFilter)dateFilter);
        }
        return filterCollection;
    }

    private static SearchFilter createComponentFilter(PhysicalAddressIndex value) {
        SearchFilter.IsEqualTo componentFilter = new SearchFilter.IsEqualTo();
        componentFilter.setPropertyDefinition((PropertyDefinitionBase)ContactSchema.PostalAddressIndex);
        componentFilter.setValue((Object)value);
        return componentFilter;
    }

    private static SearchFilter createEMailFilter(String value) {
        SearchFilter.SearchFilterCollection emailFilter = new SearchFilter.SearchFilterCollection();
        emailFilter.setLogicalOperator(LogicalOperator.Or);
        emailFilter.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.EmailAddress1));
        emailFilter.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.EmailAddress2));
        emailFilter.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)ContactSchema.EmailAddress3));
        return emailFilter;
    }

    private static SearchFilter createComponentFilter(String value, PropertyDefinitionBase propertyDefinition) {
        SearchFilter.ContainsSubstring componentFilter = new SearchFilter.ContainsSubstring();
        componentFilter.setPropertyDefinition(propertyDefinition);
        componentFilter.setValue(value);
        componentFilter.setComparisonMode(ComparisonMode.IgnoreCase);
        componentFilter.setContainmentMode(ContainmentMode.Substring);
        return componentFilter;
    }

    public static void setNonNullValues(Contact serverContact, ExchangeContact cfContact) throws Exception {
        String value = null;
        value = cfContact.getFirstName();
        if (value != null) {
            serverContact.setGivenName(value);
        }
        if ((value = cfContact.getMiddleName()) != null) {
            serverContact.setMiddleName(value);
        }
        if ((value = cfContact.getLastName()) != null) {
            serverContact.setSurname(value);
        }
        if ((value = cfContact.getDislpayName()) != null) {
            serverContact.setFileAs(value);
            serverContact.setSubject(value);
        }
        if ((value = cfContact.getJobTitle()) != null) {
            serverContact.setJobTitle(value);
        }
        if ((value = cfContact.getCompany()) != null) {
            serverContact.setCompanyName(value);
        }
        if ((value = cfContact.getBusinessHomePage()) != null) {
            serverContact.setBusinessHomePage(value);
        }
        if ((value = cfContact.getEMail1()) != null) {
            serverContact.getEmailAddresses().setEmailAddress(EmailAddressKey.EmailAddress1, new microsoft.exchange.webservices.data.property.complex.EmailAddress(value));
        }
        if ((value = cfContact.getEMail2()) != null) {
            serverContact.getEmailAddresses().setEmailAddress(EmailAddressKey.EmailAddress2, new microsoft.exchange.webservices.data.property.complex.EmailAddress(value));
        }
        if ((value = cfContact.getEMail3()) != null) {
            serverContact.getEmailAddresses().setEmailAddress(EmailAddressKey.EmailAddress3, new microsoft.exchange.webservices.data.property.complex.EmailAddress(value));
        }
        if ((value = cfContact.getBusinessFax()) != null) {
            serverContact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessFax, value);
        }
        if (cfContact.getMailingAdressType() != null) {
            Integer mailingAdressType = cfContact.getMailingAdressType();
            switch (mailingAdressType) {
                case 1: {
                    serverContact.setPostalAddressIndex(PhysicalAddressIndex.Home);
                    break;
                }
                case 2: {
                    serverContact.setPostalAddressIndex(PhysicalAddressIndex.Business);
                    break;
                }
                case 3: {
                    serverContact.setPostalAddressIndex(PhysicalAddressIndex.Other);
                }
            }
        }
        if (cfContact.getBusinessAddress() != null) {
            PhysicalAddressEntry businessAddress = serverContact.getPhysicalAddresses().getPhysicalAddress(PhysicalAddressKey.Business);
            if (null == businessAddress) {
                businessAddress = new PhysicalAddressEntry();
            }
            EWSUtils.setNonNullValues(businessAddress, cfContact.getBusinessAddress());
            serverContact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Business, businessAddress);
        }
        if (cfContact.getHomeAddress() != null) {
            PhysicalAddressEntry homeAddress = serverContact.getPhysicalAddresses().getPhysicalAddress(PhysicalAddressKey.Home);
            if (null == homeAddress) {
                homeAddress = new PhysicalAddressEntry();
            }
            EWSUtils.setNonNullValues(homeAddress, cfContact.getHomeAddress());
            serverContact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Home, homeAddress);
        }
        if (cfContact.getOtherAddress() != null) {
            PhysicalAddressEntry otherAddress = serverContact.getPhysicalAddresses().getPhysicalAddress(PhysicalAddressKey.Other);
            if (null == otherAddress) {
                otherAddress = new PhysicalAddressEntry();
            }
            EWSUtils.setNonNullValues(otherAddress, cfContact.getOtherAddress());
            serverContact.getPhysicalAddresses().setPhysicalAddress(PhysicalAddressKey.Other, otherAddress);
        }
        if ((value = cfContact.getBusinessPhone()) != null) {
            serverContact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.BusinessPhone, value);
        }
        if ((value = cfContact.getHomePhone()) != null) {
            serverContact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.HomePhone, value);
        }
        if ((value = cfContact.getMobilePhone()) != null) {
            serverContact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.MobilePhone, value);
        }
        if ((value = cfContact.getPager()) != null) {
            serverContact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.Pager, value);
        }
        if ((value = cfContact.getOtherPhone()) != null) {
            serverContact.getPhoneNumbers().setPhoneNumber(PhoneNumberKey.OtherTelephone, value);
        }
        if ((value = cfContact.getCategories()) != null) {
            EWSUtils.setCategories((Item)serverContact, value);
        }
        if ((value = cfContact.getDescription()) != null) {
            serverContact.setBody(MessageBody.getMessageBodyFromText((String)value));
        }
        if ((value = cfContact.getMessage()) != null) {
            serverContact.setBody(MessageBody.getMessageBodyFromText((String)value));
        }
        if ((value = cfContact.getHtmlMessage()) != null) {
            serverContact.setBody(MessageBody.getMessageBodyFromText((String)value));
        }
        if (cfContact.getDetails() != null) {
            ContactOtherDetails details = cfContact.getDetails();
            value = details.getDepartment();
            if (value != null) {
                serverContact.setDepartment(value);
            }
            if ((value = details.getAssistant()) != null) {
                serverContact.setAssistantName(value);
            }
            if ((value = details.getManager()) != null) {
                serverContact.setManager(value);
            }
            if ((value = details.getNickname()) != null) {
                serverContact.setNickName(value);
            }
            if ((value = details.getOffice()) != null) {
                serverContact.setOfficeLocation(value);
            }
            if ((value = details.getPartner()) != null) {
                serverContact.setSpouseName(value);
            }
            if ((value = details.getProfession()) != null) {
                serverContact.setProfession(value);
            }
        }
    }

    private static void setCategories(Item item, String value) throws Exception {
        String[] splits;
        StringList list = new StringList();
        for (String split : splits = Utils.splitString(value)) {
            if (null == split || split.trim().length() == 0) continue;
            list.add(split);
        }
        if (list.getSize() > 0) {
            item.setCategories(list);
        }
    }

    private static void setNonNullValues(PhysicalAddressEntry physicalAddress, ContactAddress contactAddress) throws Exception {
        String value = null;
        value = contactAddress.getCity();
        if (value != null) {
            physicalAddress.setCity(value);
        }
        if ((value = contactAddress.getCountry()) != null) {
            physicalAddress.setCountryOrRegion(value);
        }
        if ((value = contactAddress.getPostalCode()) != null) {
            physicalAddress.setPostalCode(value);
        }
        if ((value = contactAddress.getState()) != null) {
            physicalAddress.setState(value);
        }
        if ((value = contactAddress.getStreet()) != null) {
            physicalAddress.setStreet(value);
        }
    }

    public static Task createServerTask(ExchangeConnection connection, ExchangeService service, ExchangeTask task) throws Exception {
        Task newTask = new Task(service);
        EWSUtils.setNonNullValues(connection, newTask, task);
        return newTask;
    }

    public static void setNonNullValues(ExchangeConnection connection, Task newTask, ExchangeTask task) throws Exception {
        Boolean tmpBool;
        String value;
        List<String> propertiesToRemove = EWSUtils.setTaskCompleteStatus(task);
        Date tmpDate = task.getDateCompleted();
        if (tmpDate != null) {
            newTask.setCompleteDate(tmpDate);
        }
        if ((value = task.getStatus()) != null) {
            if (value.equalsIgnoreCase("Not_Started")) {
                newTask.setStatus(TaskStatus.NotStarted);
            } else if (value.equalsIgnoreCase("In_Progress")) {
                newTask.setStatus(TaskStatus.InProgress);
            } else if (value.equalsIgnoreCase("Completed")) {
                newTask.setStatus(TaskStatus.Completed);
            } else if (value.equalsIgnoreCase("Waiting")) {
                newTask.setStatus(TaskStatus.WaitingOnOthers);
            } else if (value.equalsIgnoreCase("Deferred")) {
                newTask.setStatus(TaskStatus.Deferred);
            }
        } else {
            newTask.setStatus(TaskStatus.NotStarted);
        }
        float percentComplete = task.getPercentComplete() != null ? task.getPercentComplete().floatValue() : 0.0f;
        if (percentComplete != -1.0f) {
            String percentStr = String.valueOf(percentComplete);
            char decimalSeperator = connection.getExchangeServerDecimalSeperator();
            if (decimalSeperator != '.') {
                percentStr = percentStr.replace('.', decimalSeperator);
            }
            newTask.setPercentComplete(percentStr);
        }
        if (task.getActualWork() != null) {
            newTask.setActualWork(task.getActualWork());
        } else {
            newTask.setActualWork(Integer.valueOf(0));
        }
        value = task.getSubject();
        if (value != null) {
            newTask.setSubject(value);
        }
        if ((value = task.getMessage()) != null) {
            newTask.setBody(MessageBody.getMessageBodyFromText((String)value));
        }
        if ((value = task.getBillingInfo()) != null) {
            newTask.setBillingInformation(value);
        }
        if ((value = task.getCompanies()) != null) {
            String[] splits;
            StringList list = new StringList();
            for (String split : splits = Utils.splitString(value)) {
                if (null == split || split.trim().length() == 0) continue;
                list.add(split);
            }
            if (list.getSize() > 0) {
                newTask.setCompanies(list);
            }
        }
        if ((value = task.getMileage()) != null) {
            newTask.setMileage(value);
        }
        if ((value = task.getTeamTask()) != null) {
            // empty if block
        }
        if ((value = task.getCategories()) != null) {
            EWSUtils.setCategories((Item)newTask, value);
        }
        if (task.getTotalWork() != null) {
            newTask.setTotalWork(task.getTotalWork());
        } else {
            newTask.setTotalWork(Integer.valueOf(0));
        }
        tmpDate = task.getDueDate();
        if (tmpDate != null) {
            newTask.setDueDate(tmpDate);
        }
        if ((tmpDate = task.getReminderDate()) != null) {
            newTask.setReminderDueBy(tmpDate);
            newTask.setIsReminderSet(Boolean.valueOf(true));
        }
        if ((tmpDate = task.getStartDate()) != null) {
            newTask.setStartDate(tmpDate);
        }
        if ((tmpBool = task.getIsRecurring()) != null) {
            // empty if block
        }
        if ((tmpBool = task.getTaskComplete()) != null) {
            newTask.setStatus(TaskStatus.Completed);
        }
        if (null != task.getPriority()) {
            switch (task.getPriority()) {
                case 0: {
                    newTask.setImportance(Importance.Low);
                    break;
                }
                case 1: {
                    newTask.setImportance(Importance.Normal);
                    break;
                }
                case 2: {
                    newTask.setImportance(Importance.High);
                    break;
                }
                default: {
                    newTask.setImportance(Importance.Normal);
                }
            }
        }
        if ((tmpBool = task.getIsReminderSet()) != null) {
            newTask.setIsReminderSet(tmpBool);
        }
        for (String property : propertiesToRemove) {
            if (!"datecompleted".equals(property)) continue;
            newTask.setCompleteDate(null);
        }
    }

    private static List<String> setTaskCompleteStatus(ExchangeTask task) {
        int status = ExchangeTask.statusStringToInt(task.getStatus());
        float percentComplete = -1.0f;
        Date dateCompleted = task.getDateCompleted();
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        if (status == 2) {
            percentComplete = 100.0f;
            task.setPercentComplete(100.0f);
            if (dateCompleted != null) {
                propertiesToRemove.add("datecompleted");
            }
        } else if (status != 0 && status != 2) {
            propertiesToRemove.add("datecompleted");
            if (percentComplete == 100.0f) {
                percentComplete = 0.0f;
            }
            dateCompleted = null;
        } else if (task.getPercentComplete() != null) {
            percentComplete = task.getPercentComplete().floatValue();
            propertiesToRemove.add("datecompleted");
            dateCompleted = null;
            if (percentComplete >= 100.0f) {
                status = 2;
                percentComplete = 100.0f;
            } else if (percentComplete == 0.0f) {
                status = 0;
            } else if (status == 0 || status == 2) {
                status = 1;
            }
        } else if (dateCompleted != null) {
            status = 2;
            percentComplete = 100.0f;
        }
        if (percentComplete != -1.0f) {
            task.setPercentComplete(percentComplete);
        }
        if (status != -1) {
            task.setStatus(ExchangeTask.statusIntToString(String.valueOf(status)));
        }
        task.setDateCompleted(dateCompleted);
        if (dateCompleted != null && task.getIsReminderSet() != null && task.getIsReminderSet().booleanValue()) {
            task.setIsReminderSet(Boolean.FALSE);
        }
        return propertiesToRemove;
    }

    public static ExchangeTask createCFTask(ExchangeConnection connection, Task task) {
        int i;
        ExchangeTask cfTask = new ExchangeTask();
        try {
            TaskStatus status = task.getStatus();
            switch (status) {
                case NotStarted: {
                    cfTask.setStatus("Not_Started");
                    break;
                }
                case Completed: {
                    cfTask.setStatus("Completed");
                    break;
                }
                case Deferred: {
                    cfTask.setStatus("Deferred");
                    break;
                }
                case InProgress: {
                    cfTask.setStatus("In_Progress");
                    break;
                }
                case WaitingOnOthers: {
                    cfTask.setStatus("Waiting");
                    break;
                }
                default: {
                    cfTask.setStatus("Invalid");
                    break;
                }
            }
        }
        catch (ServiceLocalException status) {
            // empty catch block
        }
        try {
            cfTask.setStartDate(task.getStartDate());
        }
        catch (ServiceLocalException status) {
            // empty catch block
        }
        try {
            cfTask.setDueDate(task.getDueDate());
        }
        catch (ServiceLocalException status) {
            // empty catch block
        }
        try {
            cfTask.setReminderDate(task.getReminderDueBy());
        }
        catch (ServiceLocalException status) {
            // empty catch block
        }
        try {
            cfTask.setDateCompleted(task.getCompleteDate());
        }
        catch (ServiceLocalException status) {
            // empty catch block
        }
        try {
            cfTask.setMileage(task.getMileage());
        }
        catch (ServiceLocalException status) {
            // empty catch block
        }
        try {
            cfTask.setTimeReceived(task.getDateTimeReceived());
        }
        catch (ServiceLocalException status) {
            // empty catch block
        }
        try {
            StringList companies = task.getCompanies();
            StringBuilder builder = new StringBuilder();
            if (null != companies) {
                int size = companies.getSize();
                for (i = 0; i < size; ++i) {
                    if (i != 0) {
                        builder.append(",");
                    }
                    builder.append(companies.getString(i));
                }
            }
            cfTask.setCompanies(builder.toString());
        }
        catch (ServiceLocalException companies) {
            // empty catch block
        }
        try {
            cfTask.setBillingInfo(task.getBillingInformation());
        }
        catch (ServiceLocalException companies) {
            // empty catch block
        }
        try {
            float percentComplete;
            String percent = String.valueOf(task.getPercentComplete());
            char decimalSeperator = connection.getExchangeServerDecimalSeperator();
            if (decimalSeperator != '.') {
                percent = percent.replace(decimalSeperator, '.');
            }
            if ((percentComplete = Float.parseFloat(percent)) >= 0.0f && percentComplete <= 1.0f) {
                percentComplete *= 100.0f;
            }
            cfTask.setPercentComplete(percentComplete);
        }
        catch (ServiceLocalException percent) {
            // empty catch block
        }
        try {
            StringList categories = task.getCategories();
            StringBuilder builder = new StringBuilder();
            if (null != categories) {
                int size = categories.getSize();
                for (i = 0; i < size; ++i) {
                    if (i != 0) {
                        builder.append(",");
                    }
                    builder.append(categories.getString(i));
                }
            }
            cfTask.setCategories(builder.toString());
        }
        catch (ServiceLocalException categories) {
            // empty catch block
        }
        try {
            Boolean isTeamTask = task.getIsTeamTask();
            if (null != isTeamTask) {
                cfTask.setTeamTask(Boolean.toString(isTeamTask));
            }
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            cfTask.setActualWork(task.getActualWork());
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            cfTask.setTotalWork(task.getTotalWork());
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            cfTask.setTaskComplete(task.getIsComplete());
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            cfTask.setIsRecurring(task.getIsRecurring());
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            cfTask.setIsReminderSet(task.getIsReminderSet());
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            cfTask.setId(task.getId().getUniqueId());
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            cfTask.setSubject(task.getSubject());
        }
        catch (ServiceLocalException isTeamTask) {
            // empty catch block
        }
        try {
            MessageBody body = task.getBody();
            switch (body.getBodyType()) {
                case Text: {
                    cfTask.setMessage(MessageBody.getStringFromMessageBody((MessageBody)body));
                    break;
                }
                case HTML: {
                    cfTask.setHtmlMessage(MessageBody.getStringFromMessageBody((MessageBody)body));
                    cfTask.setMessage(MessageBody.getStringFromMessageBody((MessageBody)body));
                }
            }
        }
        catch (Exception body) {
            // empty catch block
        }
        try {
            Importance importance = task.getImportance();
            if (null != importance) {
                switch (importance) {
                    case High: {
                        cfTask.setPriority(2);
                        break;
                    }
                    case Low: {
                        cfTask.setPriority(0);
                        break;
                    }
                    case Normal: {
                        cfTask.setPriority(1);
                        break;
                    }
                    default: {
                        cfTask.setPriority(-1);
                    }
                }
            }
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            cfTask.setHasAttachment(task.getHasAttachments());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            cfTask.setLastModified(task.getLastModifiedTime());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        return cfTask;
    }

    public static SearchFilter createSearchFilter(TaskFilterInfo filter) {
        String categories;
        Date toLastModifiedDate;
        Date fromLastModifiedDate;
        Integer priority;
        Integer totalWork;
        Integer percentComplete;
        String value;
        Integer actualWork;
        Date toStartDate;
        Date fromStartDate;
        Date toReminderDate;
        Date toDueDate;
        Date fromDueDate;
        Date toDateCompleted;
        SearchFilter.SearchFilterCollection filterCollection = new SearchFilter.SearchFilterCollection();
        Date fromDateCompleted = filter.getFromDateCompleted();
        if (null != fromDateCompleted) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(fromDateCompleted, (PropertyDefinitionBase)TaskSchema.CompleteDate));
        }
        if (null != (toDateCompleted = filter.getToDateCompleted())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(toDateCompleted, (PropertyDefinitionBase)TaskSchema.CompleteDate));
        }
        if (null != (fromDueDate = filter.getFromDueDate())) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(fromDueDate, (PropertyDefinitionBase)TaskSchema.DueDate));
        }
        if (null != (toDueDate = filter.getToDueDate())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(toDueDate, (PropertyDefinitionBase)TaskSchema.DueDate));
        }
        boolean isRemainderSet = false;
        Date fromRemainderDate = filter.getFromReminderDate();
        if (null != fromRemainderDate) {
            ExtendedPropertyDefinition reminderDateProperty = new ExtendedPropertyDefinition(UUID.fromString("00062008-0000-0000-C000-000000000046"), 34050, MapiPropertyType.SystemTime);
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(fromRemainderDate, (PropertyDefinitionBase)reminderDateProperty));
            isRemainderSet = true;
        }
        if (null != (toReminderDate = filter.getToReminderDate())) {
            ExtendedPropertyDefinition reminderDateProperty = new ExtendedPropertyDefinition(UUID.fromString("00062008-0000-0000-C000-000000000046"), 34050, MapiPropertyType.SystemTime);
            filterCollection.add(EWSUtils.createLessThanEqFilter(toReminderDate, (PropertyDefinitionBase)reminderDateProperty));
            isRemainderSet = true;
        }
        if (isRemainderSet) {
            filterCollection.add(EWSUtils.createComponentFilter(isRemainderSet, (PropertyDefinitionBase)TaskSchema.IsReminderSet));
        }
        if (null != (fromStartDate = filter.getFromStartDate())) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(fromStartDate, (PropertyDefinitionBase)TaskSchema.StartDate));
        }
        if (null != (toStartDate = filter.getToStartDate())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(toStartDate, (PropertyDefinitionBase)TaskSchema.StartDate));
        }
        if (null != (actualWork = filter.getActualWork())) {
            filterCollection.add(EWSUtils.createComponentFilter(actualWork, (PropertyDefinitionBase)TaskSchema.ActualWork));
        }
        if (null != (value = filter.getBillingInfo())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)TaskSchema.BillingInformation));
        }
        if (null != (value = filter.getCompanies())) {
            filterCollection.add(EWSUtils.createCompaniesFilter(value));
        }
        if (null != (value = filter.getMileage())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)TaskSchema.Mileage));
        }
        if (null != (percentComplete = filter.getPercentComplete())) {
            filterCollection.add(EWSUtils.createComponentFilter(String.valueOf(percentComplete), (PropertyDefinitionBase)TaskSchema.PercentComplete));
        }
        if (null != (value = filter.getStatus())) {
            if (value.equalsIgnoreCase("Not_Started")) {
                filterCollection.add(EWSUtils.createComponentFilter((short)0));
            } else if (value.equalsIgnoreCase("In_Progress")) {
                filterCollection.add(EWSUtils.createComponentFilter((short)1));
            } else if (value.equalsIgnoreCase("Completed")) {
                filterCollection.add(EWSUtils.createComponentFilter((short)2));
            } else if (value.equalsIgnoreCase("Waiting")) {
                filterCollection.add(EWSUtils.createComponentFilter((short)3));
            } else if (value.equalsIgnoreCase("Deferred")) {
                filterCollection.add(EWSUtils.createComponentFilter((short)4));
            }
        }
        if (null != (totalWork = filter.getTotalWork())) {
            filterCollection.add(EWSUtils.createComponentFilter(totalWork, (PropertyDefinitionBase)TaskSchema.TotalWork));
        }
        if (null != (value = filter.getSubject())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)TaskSchema.Subject));
        }
        if (null != (value = filter.getMessage())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)TaskSchema.Body));
        }
        if (null != (priority = filter.getPriority())) {
            switch (priority) {
                case 0: {
                    filterCollection.add(EWSUtils.createComponentFilter(Importance.Low));
                    break;
                }
                case 1: {
                    filterCollection.add(EWSUtils.createComponentFilter(Importance.Normal));
                    break;
                }
                case 2: {
                    filterCollection.add(EWSUtils.createComponentFilter(Importance.High));
                    break;
                }
            }
        }
        if (null != (fromLastModifiedDate = filter.getFromLastModifiedDate())) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(fromLastModifiedDate, (PropertyDefinitionBase)TaskSchema.LastModifiedTime));
        }
        if (null != (toLastModifiedDate = filter.getToLastModifiedDate())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(toLastModifiedDate, (PropertyDefinitionBase)TaskSchema.LastModifiedTime));
        }
        if (null != (categories = filter.getCategories())) {
            filterCollection.add(EWSUtils.createCategoryFilter(categories));
        }
        return filterCollection;
    }

    private static SearchFilter createCompaniesFilter(String companies) {
        String[] splits;
        SearchFilter.SearchFilterCollection collection = new SearchFilter.SearchFilterCollection();
        for (String category : splits = Utils.splitString(companies)) {
            if (category.trim().length() <= 0) continue;
            SearchFilter.IsEqualTo filter = new SearchFilter.IsEqualTo();
            filter.setPropertyDefinition((PropertyDefinitionBase)TaskSchema.Companies);
            filter.setValue((Object)category.trim());
            collection.add((SearchFilter)filter);
        }
        return collection;
    }

    private static SearchFilter createCategoryFilter(String categories) {
        String[] splits;
        SearchFilter.SearchFilterCollection collection = new SearchFilter.SearchFilterCollection();
        for (String category : splits = Utils.splitString(categories)) {
            if (category.trim().length() <= 0) continue;
            SearchFilter.IsEqualTo filter = new SearchFilter.IsEqualTo();
            filter.setPropertyDefinition((PropertyDefinitionBase)ItemSchema.Categories);
            filter.setValue((Object)category.trim());
            collection.add((SearchFilter)filter);
        }
        return collection;
    }

    private static SearchFilter createListFilter(PropertyDefinitionBase propDef, String commaSeparatedValues) {
        String[] splits;
        SearchFilter.SearchFilterCollection collection = new SearchFilter.SearchFilterCollection();
        for (String split : splits = Utils.splitString(commaSeparatedValues)) {
            if (split.trim().length() <= 0) continue;
            SearchFilter.ContainsSubstring filter = new SearchFilter.ContainsSubstring();
            filter.setPropertyDefinition(propDef);
            filter.setValue(split.trim());
            filter.setComparisonMode(ComparisonMode.IgnoreCase);
            filter.setContainmentMode(ContainmentMode.Substring);
            collection.add((SearchFilter)filter);
        }
        return collection;
    }

    private static SearchFilter createComponentFilter(short value) {
        ExtendedPropertyDefinition pidLidTaskStatus = new ExtendedPropertyDefinition(DefaultExtendedPropertySet.Task, 33025, MapiPropertyType.Integer);
        SearchFilter.IsEqualTo componentFilter = new SearchFilter.IsEqualTo((PropertyDefinitionBase)pidLidTaskStatus, (Object)value);
        return componentFilter;
    }

    private static SearchFilter createComponentFilter(Integer value, PropertyDefinitionBase propertyDef) {
        SearchFilter.IsEqualTo componentFilter = new SearchFilter.IsEqualTo();
        componentFilter.setPropertyDefinition(propertyDef);
        componentFilter.setValue((Object)value);
        return componentFilter;
    }

    private static SearchFilter createComponentFilter(boolean value, PropertyDefinitionBase propDefinition) {
        SearchFilter.IsEqualTo componentFilter = new SearchFilter.IsEqualTo();
        componentFilter.setPropertyDefinition(propDefinition);
        componentFilter.setValue((Object)value);
        return componentFilter;
    }

    private static SearchFilter createLessThanEqFilter(Date date, PropertyDefinitionBase propDefinition) {
        SearchFilter.IsLessThanOrEqualTo lessThanEqFilter = new SearchFilter.IsLessThanOrEqualTo();
        lessThanEqFilter.setPropertyDefinition(propDefinition);
        lessThanEqFilter.setValue((Object)date);
        return lessThanEqFilter;
    }

    private static SearchFilter createGreaterThanEqFilter(Date date, PropertyDefinitionBase propDefinition) {
        SearchFilter.IsGreaterThanOrEqualTo greaterThanEqFilter = new SearchFilter.IsGreaterThanOrEqualTo();
        greaterThanEqFilter.setPropertyDefinition(propDefinition);
        greaterThanEqFilter.setValue((Object)date);
        return greaterThanEqFilter;
    }

    private static SearchFilter createLessThanEqFilter(int intValue, PropertyDefinition propDefinition) {
        SearchFilter.IsLessThanOrEqualTo lessThanEqFilter = new SearchFilter.IsLessThanOrEqualTo();
        lessThanEqFilter.setPropertyDefinition((PropertyDefinitionBase)propDefinition);
        lessThanEqFilter.setValue((Object)intValue);
        return lessThanEqFilter;
    }

    private static SearchFilter createGreaterThanEqFilter(int intValue, PropertyDefinition propDefinition) {
        SearchFilter.IsGreaterThanOrEqualTo greaterThanEqFilter = new SearchFilter.IsGreaterThanOrEqualTo();
        greaterThanEqFilter.setPropertyDefinition((PropertyDefinitionBase)propDefinition);
        greaterThanEqFilter.setValue((Object)intValue);
        return greaterThanEqFilter;
    }

    public static EmailMessage createServerMessage(ExchangeService service, ExchangeMessage msg) throws Exception {
        EmailMessage message = new EmailMessage(service);
        EWSUtils.setNonNullValues(message, msg);
        return message;
    }

    public static void setNonNullValues(EmailMessage serverMessage, ExchangeMessage cfMessage) throws Exception {
        String[] splits;
        String value = cfMessage.getFromId();
        if (null != value) {
            serverMessage.setFrom(new microsoft.exchange.webservices.data.property.complex.EmailAddress(value));
        }
        if (null != (value = cfMessage.getCc())) {
            EmailAddressCollection ccRecipients = serverMessage.getCcRecipients();
            for (String split : splits = value.split(",")) {
                ccRecipients.add(new microsoft.exchange.webservices.data.property.complex.EmailAddress(split));
            }
        }
        if (null != (value = cfMessage.getBcc())) {
            EmailAddressCollection bccRecipients = serverMessage.getBccRecipients();
            for (String split : splits = value.split(",")) {
                bccRecipients.add(new microsoft.exchange.webservices.data.property.complex.EmailAddress(split));
            }
        }
        if (null != (value = cfMessage.getToId())) {
            EmailAddressCollection toRecipients = serverMessage.getToRecipients();
            for (String split : splits = value.split(",")) {
                toRecipients.add(new microsoft.exchange.webservices.data.property.complex.EmailAddress(split));
            }
        }
        if (null != (value = cfMessage.getMessage())) {
            serverMessage.setBody(MessageBody.getMessageBodyFromText((String)value));
        }
        if (null != (value = cfMessage.getSubject())) {
            serverMessage.setSubject(value);
        }
        if (null != (value = cfMessage.getSensitivity())) {
            EWSUtils.setSensitivity((Item)serverMessage, value);
        }
        if (null != cfMessage.isRead()) {
            serverMessage.setIsRead(cfMessage.isRead());
        }
        if (null != (value = cfMessage.getImportance())) {
            EWSUtils.setImportance((Item)serverMessage, value);
        }
    }

    private static void setImportance(Item item, String value) throws Exception {
        if (value.equalsIgnoreCase("High")) {
            item.setImportance(Importance.High);
        } else if (value.equalsIgnoreCase("Normal")) {
            item.setImportance(Importance.Normal);
        } else if (value.equalsIgnoreCase("Low")) {
            item.setImportance(Importance.Low);
        } else {
            item.setImportance(Importance.Normal);
        }
    }

    private static void setSensitivity(Item item, String value) throws Exception {
        if (value.equalsIgnoreCase("Confidential") || value.equalsIgnoreCase("company-Confidential")) {
            item.setSensitivity(Sensitivity.Confidential);
        } else if (value.equalsIgnoreCase("Normal")) {
            item.setSensitivity(Sensitivity.Normal);
        } else if (value.equalsIgnoreCase("Personal")) {
            item.setSensitivity(Sensitivity.Personal);
        } else if (value.equalsIgnoreCase("Private")) {
            item.setSensitivity(Sensitivity.Private);
        }
    }

    public static ExchangeMessage createCFMessage(EmailMessage message) {
        OutParam outParam2;
        ExchangeMessage cfMessage;
        block60: {
            MessageBody body2;
            String addressStr;
            cfMessage = new ExchangeMessage();
            try {
                ItemId id = message.getId();
                if (null != id) {
                    cfMessage.setId(id.getUniqueId());
                }
            }
            catch (ServiceLocalException id) {
                // empty catch block
            }
            try {
                microsoft.exchange.webservices.data.property.complex.EmailAddress from = message.getFrom();
                if (null != from) {
                    cfMessage.setFromId(EWSUtils.getMailAddress(from));
                }
            }
            catch (ServiceLocalException from) {
                // empty catch block
            }
            try {
                Date timeReceived = message.getDateTimeReceived();
                if (null != timeReceived) {
                    cfMessage.setTimeReceived(timeReceived);
                }
            }
            catch (ServiceLocalException timeReceived) {
                // empty catch block
            }
            try {
                Date timeSent = message.getDateTimeSent();
                if (null != timeSent) {
                    cfMessage.setTimeSent(timeSent);
                }
            }
            catch (ServiceLocalException timeSent) {
                // empty catch block
            }
            try {
                EmailAddressCollection toRecipients = message.getToRecipients();
                addressStr = EWSUtils.getEmailAddressCollectionString(toRecipients);
                cfMessage.setToId(addressStr);
            }
            catch (ServiceLocalException toRecipients) {
                // empty catch block
            }
            try {
                EmailAddressCollection ccRecipients = message.getCcRecipients();
                addressStr = EWSUtils.getEmailAddressCollectionString(ccRecipients);
                cfMessage.setCc(addressStr);
            }
            catch (ServiceLocalException ccRecipients) {
                // empty catch block
            }
            try {
                EmailAddressCollection bccRecipients = message.getBccRecipients();
                addressStr = EWSUtils.getEmailAddressCollectionString(bccRecipients);
                cfMessage.setBcc(addressStr);
            }
            catch (ServiceLocalException bccRecipients) {
                // empty catch block
            }
            try {
                String subject = message.getSubject();
                cfMessage.setSubject(subject);
            }
            catch (ServiceLocalException subject) {
                // empty catch block
            }
            try {
                body2 = message.getBody();
                if (null != body2) {
                    cfMessage.setMessage(MessageBody.getStringFromMessageBody((MessageBody)body2));
                }
            }
            catch (Exception body2) {
                // empty catch block
            }
            try {
                body2 = message.getUniqueBody();
                if (null != body2) {
                    cfMessage.setHtmlMessage(message.getUniqueBody().toString());
                }
            }
            catch (Exception body3) {
                // empty catch block
            }
            try {
                Importance importance = message.getImportance();
                if (null != importance) {
                    cfMessage.setImportance(String.valueOf(importance));
                }
            }
            catch (ServiceLocalException importance) {
                // empty catch block
            }
            try {
                Sensitivity sensitivity = message.getSensitivity();
                if (null != sensitivity) {
                    cfMessage.setSensitivity(EWSUtils.getSensitivityString(sensitivity));
                }
            }
            catch (ServiceLocalException sensitivity) {
                // empty catch block
            }
            try {
                Boolean isRead = message.getIsRead();
                if (null != isRead) {
                    cfMessage.setRead(isRead);
                }
            }
            catch (ServiceLocalException isRead) {
                // empty catch block
            }
            try {
                Boolean hasAttachments = message.getHasAttachments();
                if (null != hasAttachments) {
                    cfMessage.setHasAttachment(hasAttachments);
                }
            }
            catch (ServiceLocalException hasAttachments) {
                // empty catch block
            }
            try {
                ExtendedProperty internetHeaders;
                ExtendedPropertyCollection extendedProperties = message.getExtendedProperties();
                if (extendedProperties.getCount() <= 0 || null == (internetHeaders = (ExtendedProperty)extendedProperties.getPropertyAtIndex(0))) break block60;
                InternetHeaders messageHeader = new InternetHeaders();
                cfMessage.setHeaders(messageHeader);
                String internetHeaderString = internetHeaders.getValue().toString();
                try {
                    javax.mail.internet.InternetHeaders headers = new javax.mail.internet.InternetHeaders(IOUtils.toInputStream((String)internetHeaderString));
                    Enumeration allHeaders = headers.getAllHeaders();
                    while (allHeaders.hasMoreElements()) {
                        String header = ((Header)allHeaders.nextElement()).getName();
                        String[] headerValue = headers.getHeader(header);
                        messageHeader.addHeader(header, headerValue);
                    }
                }
                catch (MessagingException e) {
                    cfMessage.setHeaders(null);
                }
            }
            catch (ServiceLocalException extendedProperties) {
                // empty catch block
            }
        }
        try {
            boolean gotValue;
            if (message instanceof MeetingMessage && (gotValue = message.tryGetProperty((PropertyDefinitionBase)MeetingMessageSchema.AssociatedAppointmentId, outParam2 = new OutParam())) && null != outParam2.getParam()) {
                cfMessage.setMeetingUID(String.valueOf(outParam2.getParam()));
            }
        }
        catch (Exception outParam2) {
            // empty catch block
        }
        if (message instanceof MeetingRequest) {
            cfMessage.setMessageType(3);
        } else if (message instanceof MeetingResponse) {
            cfMessage.setMessageType(4);
            outParam2 = new OutParam();
            try {
                boolean gotValue = message.tryGetProperty((PropertyDefinitionBase)MeetingMessageSchema.ResponseType, outParam2);
                if (gotValue) {
                    MeetingResponseType responseType = (MeetingResponseType)outParam2.getParam();
                    switch (responseType) {
                        case Accept: {
                            cfMessage.setMeetingResponseType("Accept");
                            break;
                        }
                        case Decline: {
                            cfMessage.setMeetingResponseType("Decline");
                            break;
                        }
                        case Tentative: {
                            cfMessage.setMeetingResponseType("Tentative");
                        }
                    }
                }
            }
            catch (Exception exception) {}
        } else if (message instanceof MeetingCancellation) {
            cfMessage.setMessageType(5);
            cfMessage.setMeetingResponseType("Cancel");
        } else {
            cfMessage.setMessageType(0);
        }
        return cfMessage;
    }

    private static String getMailAddress(microsoft.exchange.webservices.data.property.complex.EmailAddress address) {
        return "\"" + address.getName() + "\" <" + address.getAddress() + ">";
    }

    private static String getSensitivityString(Sensitivity sensitivity) {
        switch (sensitivity) {
            case Confidential: {
                return "company-Confidential";
            }
            case Normal: {
                return "Normal";
            }
            case Personal: {
                return "Personal";
            }
            case Private: {
                return "Private";
            }
        }
        return "Normal";
    }

    private static String getEmailAddressCollectionString(EmailAddressCollection collection) {
        StringBuilder builder = new StringBuilder();
        boolean firstElementAdded = false;
        if (null != collection) {
            for (microsoft.exchange.webservices.data.property.complex.EmailAddress emailAddress : collection) {
                String address;
                if (null == emailAddress || null == (address = EWSUtils.getMailAddress(emailAddress)) || address.length() == 0) continue;
                if (firstElementAdded) {
                    builder.append(",");
                } else {
                    firstElementAdded = true;
                }
                builder.append(address);
            }
        }
        String addressStr = builder.toString();
        return addressStr;
    }

    public static SearchFilter.SearchFilterCollection createSearchFilter(MessageFilterInfo filter) {
        String value;
        SearchFilter.SearchFilterCollection filterCollection = new SearchFilter.SearchFilterCollection();
        int messageType = filter.getMessageType();
        switch (messageType) {
            case 2: {
                SearchFilter.SearchFilterCollection collection = new SearchFilter.SearchFilterCollection();
                collection.setLogicalOperator(LogicalOperator.Or);
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Canceled", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Request", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Neg", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Pos", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Tent", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                filterCollection.add((SearchFilter)collection);
                break;
            }
            case 1: {
                SearchFilter.SearchFilterCollection collection = new SearchFilter.SearchFilterCollection();
                collection.setLogicalOperator(LogicalOperator.Or);
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Canceled", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Request", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Neg", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Pos", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Tent", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                SearchFilter.Not notFilter = new SearchFilter.Not((SearchFilter)collection);
                filterCollection.add((SearchFilter)notFilter);
                break;
            }
            case 3: {
                filterCollection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Request", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                break;
            }
            case 4: {
                SearchFilter.SearchFilterCollection collection = new SearchFilter.SearchFilterCollection();
                collection.setLogicalOperator(LogicalOperator.Or);
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Neg", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Pos", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                collection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Resp.Tent", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
                filterCollection.add((SearchFilter)collection);
                break;
            }
            case 5: {
                filterCollection.add(EWSUtils.createComponentFilter("IPM.Schedule.Meeting.Canceled", (PropertyDefinitionBase)EmailMessageSchema.ItemClass));
            }
        }
        Date tmpDate = filter.getFromTimeReceived();
        if (null != tmpDate) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(tmpDate, (PropertyDefinitionBase)EmailMessageSchema.DateTimeReceived));
        }
        if (null != (tmpDate = filter.getToTimeReceived())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(tmpDate, (PropertyDefinitionBase)EmailMessageSchema.DateTimeReceived));
        }
        if (null != (tmpDate = filter.getFromTimeSent())) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(tmpDate, (PropertyDefinitionBase)EmailMessageSchema.DateTimeSent));
        }
        if (null != (tmpDate = filter.getToTimeSent())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(tmpDate, (PropertyDefinitionBase)EmailMessageSchema.DateTimeSent));
        }
        if (null != (value = filter.getCc())) {
            filterCollection.add(EWSUtils.createListFilter((PropertyDefinitionBase)EmailMessageSchema.CcRecipients, value));
        }
        if (null != (value = filter.getBcc())) {
            filterCollection.add(EWSUtils.createListFilter((PropertyDefinitionBase)EmailMessageSchema.BccRecipients, value));
        }
        if (null != (value = filter.getFromId())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)EmailMessageSchema.From));
        }
        if (null != (tmpDate = filter.getFromLastModifiedDate())) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(tmpDate, (PropertyDefinitionBase)EmailMessageSchema.LastModifiedTime));
        }
        if (null != (tmpDate = filter.getToLastModifiedDate())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(tmpDate, (PropertyDefinitionBase)EmailMessageSchema.LastModifiedTime));
        }
        if (null != (value = filter.getImportance())) {
            if (value.equalsIgnoreCase("high")) {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.High));
            } else if (value.equalsIgnoreCase("Normal")) {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.Normal));
            } else if (value.equalsIgnoreCase("Low")) {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.Low));
            } else {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.Normal));
            }
        }
        if (null != (value = filter.getSensitivity())) {
            if (value.equalsIgnoreCase("Confidential") || value.equalsIgnoreCase("company-Confidential")) {
                filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Confidential));
            } else if (value.equalsIgnoreCase("Normal")) {
                filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Normal));
            } else if (value.equalsIgnoreCase("Personal")) {
                filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Personal));
            } else if (value.equalsIgnoreCase("Private")) {
                filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Private));
            }
        }
        if (null != (value = filter.getMessage())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)EmailMessageSchema.Body));
        }
        if (null != (value = filter.getSubject())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)EmailMessageSchema.Subject));
        }
        if (null != (value = filter.getToId())) {
            filterCollection.add(EWSUtils.createListFilter((PropertyDefinitionBase)EmailMessageSchema.ToRecipients, value));
        }
        if (null != filter.getHasAttachment()) {
            filterCollection.add(EWSUtils.createComponentFilter(filter.getHasAttachment(), (PropertyDefinitionBase)EmailMessageSchema.HasAttachments));
        }
        if (null != filter.isRead()) {
            filterCollection.add(EWSUtils.createComponentFilter(filter.isRead(), (PropertyDefinitionBase)EmailMessageSchema.IsRead));
        }
        return filterCollection;
    }

    private static SearchFilter createComponentFilter(Sensitivity sensitivity) {
        SearchFilter.IsEqualTo componentFilter = new SearchFilter.IsEqualTo();
        componentFilter.setPropertyDefinition((PropertyDefinitionBase)ItemSchema.Sensitivity);
        componentFilter.setValue((Object)sensitivity);
        return componentFilter;
    }

    private static SearchFilter createComponentFilter(Importance importance) {
        SearchFilter.IsEqualTo componentFilter = new SearchFilter.IsEqualTo();
        componentFilter.setPropertyDefinition((PropertyDefinitionBase)ItemSchema.Importance);
        componentFilter.setValue((Object)importance);
        return componentFilter;
    }

    public static Appointment createServerAppointment(ExchangeService service, ExchangeAppointment apt) throws Exception {
        Appointment serverAppointment = new Appointment(service);
        String timeZone = apt.getTimeZone();
        if (timeZone != null) {
            TimeZoneDefinition timezone = EWSUtils.getTimeZone(service, timeZone);
            if (timezone != null) {
                serverAppointment.setStartTimeZone(timezone);
                serverAppointment.setEndTimeZone(timezone);
            } else {
                throw new InvalidTimezoneException(timeZone);
            }
        }
        EWSUtils.setNonNullValues(serverAppointment, apt);
        return serverAppointment;
    }

    public static void setNonNullValues(Appointment serverAppointment, ExchangeAppointment apt) throws Exception {
        Integer intValue;
        String[] splits;
        String value;
        RecurrenceInfo recurrenceInfo;
        Date startTime = apt.getStartTime();
        Date endTime = apt.getEndTime();
        Boolean allDay = apt.isAllDay();
        if (null != allDay && allDay.booleanValue() && startTime != null) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(startTime);
            cal1.set(11, 0);
            cal1.set(12, 0);
            cal1.set(13, 0);
            cal1.set(14, 0);
            startTime = cal1.getTime();
            if (endTime != null) {
                Calendar cal2 = Calendar.getInstance();
                cal2.setTime(endTime);
                cal2.set(11, 24);
                cal2.set(12, 0);
                cal2.set(13, 0);
                cal2.set(14, 0);
                endTime = cal2.getTime();
            } else {
                cal1.set(11, 24);
                endTime = cal1.getTime();
            }
            serverAppointment.setIsAllDayEvent(Boolean.valueOf(true));
        }
        if (null != (recurrenceInfo = apt.getRecurrenceInfo())) {
            Date tmpDate;
            Object[] results = EWSUtils.getRecurrence(startTime, recurrenceInfo);
            Recurrence pattern = (Recurrence)results[0];
            serverAppointment.setRecurrence(pattern);
            if (results[1] != null && !(tmpDate = (Date)results[1]).equals(startTime)) {
                long timeDiff = endTime.getTime() - startTime.getTime();
                startTime = tmpDate;
                endTime.setTime(startTime.getTime() + timeDiff);
            }
        }
        if (null != (value = apt.getLocation())) {
            serverAppointment.setLocation(value);
        }
        String timeZone = apt.getTimeZone();
        if (null != startTime) {
            if (timeZone == null) {
                startTime = EWSUtils.normalizeDate("local2utc", startTime);
            }
            serverAppointment.setStart(startTime);
        }
        if (null != endTime) {
            if (timeZone == null) {
                endTime = EWSUtils.normalizeDate("local2utc", endTime);
            }
            serverAppointment.setEnd(endTime);
        }
        if (startTime != null && endTime != null && startTime.compareTo(endTime) > 0) {
            throw new EWSException(RB.getString(EWSUtils.class, (String)"EWSUtils.invalidStartDate"));
        }
        value = apt.getBusyStatus();
        if (null != value) {
            if (value.equalsIgnoreCase(LegacyFreeBusyStatus.Busy.toString())) {
                serverAppointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.Busy);
            } else if (value.equalsIgnoreCase(LegacyFreeBusyStatus.Free.toString())) {
                serverAppointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.Free);
            } else if (value.equalsIgnoreCase(LegacyFreeBusyStatus.NoData.toString())) {
                serverAppointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.NoData);
            } else if (value.equalsIgnoreCase(LegacyFreeBusyStatus.OOF.toString())) {
                serverAppointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.OOF);
            } else if (value.equalsIgnoreCase(LegacyFreeBusyStatus.Tentative.toString())) {
                serverAppointment.setLegacyFreeBusyStatus(LegacyFreeBusyStatus.Tentative);
            }
        }
        value = apt.getOrganizer();
        serverAppointment.setIsResponseRequested(Boolean.valueOf(true));
        value = apt.getRequiredAttendees();
        if (null != value) {
            AttendeeCollection requiredAttendees = serverAppointment.getRequiredAttendees();
            for (String split : splits = Utils.splitString(value)) {
                requiredAttendees.add(split);
            }
        }
        if (null != (value = apt.getResources())) {
            AttendeeCollection resources = serverAppointment.getResources();
            for (String split : splits = Utils.splitString(value)) {
                resources.add(split);
            }
        }
        if (null != (value = apt.getOptionalAttendees())) {
            AttendeeCollection optionalAttendees = serverAppointment.getOptionalAttendees();
            for (String split : splits = Utils.splitString(value)) {
                optionalAttendees.add(split);
            }
        }
        value = apt.getFromId();
        value = apt.getSensitivity();
        if (null != value) {
            EWSUtils.setSensitivity((Item)serverAppointment, value);
        }
        if (null != (value = apt.getImportance())) {
            EWSUtils.setImportance((Item)serverAppointment, value);
        }
        if (null != (intValue = apt.getReminderPeriod())) {
            serverAppointment.setReminderMinutesBeforeStart(intValue.intValue());
        }
        if (null != (value = apt.getSubject())) {
            serverAppointment.setSubject(value);
        }
        if (null != (value = apt.getMessage())) {
            serverAppointment.setBody(new MessageBody(BodyType.Text, value));
        }
        if (null != (value = apt.getCategories())) {
            EWSUtils.setCategories((Item)serverAppointment, value);
        }
    }

    private static TimeZoneDefinition getTimeZone(ExchangeService service, String name) throws Exception {
        Collection timeZoneDefinitions = service.getServerTimeZones();
        for (TimeZoneDefinition timeZone : timeZoneDefinitions) {
            if (timeZone.getName().indexOf(name) < 0 && timeZone.getId().indexOf(name) < 0) continue;
            return timeZone;
        }
        return null;
    }

    private static Object[] getRecurrence(Date startTime, RecurrenceInfo recurrenceInfo) throws ArgumentOutOfRangeException, ArgumentException {
        Date aNewStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(startTime);
        int recurrencePattern = recurrenceInfo.getRecurrencePatternType();
        Recurrence.DailyPattern pattern = null;
        switch (recurrencePattern) {
            case 1: {
                if (recurrenceInfo.isEveryWeekday()) {
                    pattern = new Recurrence.WeeklyPattern(startTime, 1, new DayOfTheWeek[]{DayOfTheWeek.Monday, DayOfTheWeek.Tuesday, DayOfTheWeek.Wednesday, DayOfTheWeek.Thursday, DayOfTheWeek.Friday});
                    break;
                }
                pattern = new Recurrence.DailyPattern(startTime, recurrenceInfo.getEveryNumDays());
                break;
            }
            case 2: {
                int everyNumWeeks = recurrenceInfo.getEveryNumWeeks();
                String recurrenceWeekDays = recurrenceInfo.getRecurrenceWeekDays();
                ArrayList<DayOfTheWeek> daysOfTheWeek = new ArrayList<DayOfTheWeek>();
                if (null != recurrenceWeekDays) {
                    String[] splits;
                    for (String split : splits = Utils.splitString(recurrenceWeekDays)) {
                        if ("MO".equals(split)) {
                            daysOfTheWeek.add(DayOfTheWeek.Monday);
                            continue;
                        }
                        if ("TU".equals(split)) {
                            daysOfTheWeek.add(DayOfTheWeek.Tuesday);
                            continue;
                        }
                        if ("WE".equals(split)) {
                            daysOfTheWeek.add(DayOfTheWeek.Wednesday);
                            continue;
                        }
                        if ("TH".equals(split)) {
                            daysOfTheWeek.add(DayOfTheWeek.Thursday);
                            continue;
                        }
                        if ("FR".equals(split)) {
                            daysOfTheWeek.add(DayOfTheWeek.Friday);
                            continue;
                        }
                        if ("SA".equals(split)) {
                            daysOfTheWeek.add(DayOfTheWeek.Saturday);
                            continue;
                        }
                        if (!"SU".equals(split)) continue;
                        daysOfTheWeek.add(DayOfTheWeek.Sunday);
                    }
                }
                if (daysOfTheWeek.size() > 0) {
                    DayOfTheWeek[] daysOfTheWeekArray = new DayOfTheWeek[daysOfTheWeek.size()];
                    int count = 0;
                    Iterator iterator = daysOfTheWeek.iterator();
                    while (iterator.hasNext()) {
                        DayOfTheWeek dayOfTheWeek;
                        daysOfTheWeekArray[count] = dayOfTheWeek = (DayOfTheWeek)iterator.next();
                        ++count;
                    }
                    pattern = new Recurrence.WeeklyPattern(startTime, everyNumWeeks, daysOfTheWeekArray);
                    break;
                }
                pattern = new Recurrence.WeeklyPattern(startTime, everyNumWeeks, new DayOfTheWeek[0]);
                break;
            }
            case 3: {
                String recurrenceWeek = recurrenceInfo.getRecurrenceWeek();
                if (null == recurrenceWeek) {
                    pattern = new Recurrence.MonthlyPattern(startTime, recurrenceInfo.getEveryNumMonths(), cal.get(5));
                    break;
                }
                String strWeekNum = recurrenceInfo.getRecurrenceWeek();
                String weekDay = recurrenceInfo.getRecurrenceWeekDays();
                DayOfTheWeek dayOfTheWeek = EWSUtils.getDayOfTheWeek(cal, weekDay);
                DayOfTheWeekIndex dayOfTheWeekIndex = EWSUtils.getDayOfTheWeekIndex(strWeekNum);
                pattern = new Recurrence.RelativeMonthlyPattern(startTime, recurrenceInfo.getEveryNumMonths(), dayOfTheWeek, dayOfTheWeekIndex);
                aNewStartDate = RecurrenceInfo.validateRecurrenceStartDate(startTime, strWeekNum, weekDay);
                break;
            }
            case 4: {
                String recurrenceWeek = recurrenceInfo.getRecurrenceWeek();
                if (null == recurrenceWeek) {
                    int calendarMonth = cal.get(2);
                    Month month = EWSUtils.getMonth(calendarMonth);
                    pattern = new Recurrence.YearlyPattern(startTime, month, cal.get(5));
                    break;
                }
                String strWeekNum = recurrenceInfo.getRecurrenceWeek();
                int recurrMonth = recurrenceInfo.getRecurranceMonth();
                String weekDay = recurrenceInfo.getRecurrenceWeekDays();
                Month month = EWSUtils.getMonth(recurrMonth - 1);
                DayOfTheWeek dayOfTheWeek = EWSUtils.getDayOfTheWeek(cal, weekDay);
                DayOfTheWeekIndex dayOfTheWeekIndex = EWSUtils.getDayOfTheWeekIndex(strWeekNum);
                pattern = new Recurrence.RelativeYearlyPattern(startTime, month, dayOfTheWeek, dayOfTheWeekIndex);
                aNewStartDate = RecurrenceInfo.validateRecurrenceStartDate(startTime, strWeekNum, weekDay, recurrMonth);
                break;
            }
        }
        int recurrenceRangeType = recurrenceInfo.getRecurrenceRangeType();
        switch (recurrenceRangeType) {
            case 1: {
                break;
            }
            case 3: {
                Date recurEndDate = recurrenceInfo.getEndRecurrenceByDate();
                if (recurEndDate.getHours() != 23) {
                    recurEndDate.setHours(23);
                    recurEndDate.setMinutes(59);
                    recurEndDate.setSeconds(59);
                }
                pattern.setEndDate(recurEndDate);
                break;
            }
            case 2: {
                pattern.setNumberOfOccurrences(Integer.valueOf(recurrenceInfo.getEndRecurrenceAfterCount()));
                break;
            }
        }
        return new Object[]{pattern, aNewStartDate};
    }

    private static Month getMonth(int calendarMonth) {
        Month month = Month.January;
        switch (calendarMonth) {
            case 0: {
                month = Month.January;
                break;
            }
            case 1: {
                month = Month.February;
                break;
            }
            case 2: {
                month = Month.March;
                break;
            }
            case 3: {
                month = Month.April;
                break;
            }
            case 4: {
                month = Month.May;
                break;
            }
            case 5: {
                month = Month.June;
                break;
            }
            case 6: {
                month = Month.July;
                break;
            }
            case 7: {
                month = Month.August;
                break;
            }
            case 8: {
                month = Month.September;
                break;
            }
            case 9: {
                month = Month.October;
                break;
            }
            case 10: {
                month = Month.November;
                break;
            }
            case 11: {
                month = Month.December;
            }
        }
        return month;
    }

    private static DayOfTheWeek getDayOfTheWeek(Calendar cal, String weekDay) {
        DayOfTheWeek dayOfTheWeek = DayOfTheWeek.Monday;
        if (weekDay == null) {
            int i = cal.get(7);
            switch (i) {
                case 2: {
                    dayOfTheWeek = DayOfTheWeek.Monday;
                    break;
                }
                case 3: {
                    dayOfTheWeek = DayOfTheWeek.Tuesday;
                    break;
                }
                case 4: {
                    dayOfTheWeek = DayOfTheWeek.Wednesday;
                    break;
                }
                case 5: {
                    dayOfTheWeek = DayOfTheWeek.Thursday;
                    break;
                }
                case 6: {
                    dayOfTheWeek = DayOfTheWeek.Friday;
                    break;
                }
                case 7: {
                    dayOfTheWeek = DayOfTheWeek.Saturday;
                    break;
                }
                case 1: {
                    dayOfTheWeek = DayOfTheWeek.Sunday;
                    break;
                }
            }
        } else if ("MO".equals(weekDay)) {
            dayOfTheWeek = DayOfTheWeek.Monday;
        } else if ("TU".equals(weekDay)) {
            dayOfTheWeek = DayOfTheWeek.Tuesday;
        } else if ("WE".equals(weekDay)) {
            dayOfTheWeek = DayOfTheWeek.Wednesday;
        } else if ("TH".equals(weekDay)) {
            dayOfTheWeek = DayOfTheWeek.Thursday;
        } else if ("FR".equals(weekDay)) {
            dayOfTheWeek = DayOfTheWeek.Friday;
        } else if ("SA".equals(weekDay)) {
            dayOfTheWeek = DayOfTheWeek.Saturday;
        } else if ("SU".equals(weekDay)) {
            dayOfTheWeek = DayOfTheWeek.Sunday;
        }
        return dayOfTheWeek;
    }

    private static DayOfTheWeekIndex getDayOfTheWeekIndex(String strWeekNum) {
        DayOfTheWeekIndex dayOfTheWeekIndex = DayOfTheWeekIndex.First;
        if (strWeekNum.equalsIgnoreCase("second")) {
            dayOfTheWeekIndex = DayOfTheWeekIndex.Second;
        } else if (strWeekNum.equalsIgnoreCase("third")) {
            dayOfTheWeekIndex = DayOfTheWeekIndex.Third;
        } else if (strWeekNum.equalsIgnoreCase("fourth")) {
            dayOfTheWeekIndex = DayOfTheWeekIndex.Fourth;
        } else if (strWeekNum.equalsIgnoreCase("last")) {
            dayOfTheWeekIndex = DayOfTheWeekIndex.Last;
        }
        return dayOfTheWeekIndex;
    }

    public static ExchangeAppointment createCFAppointment(Appointment appointment) {
        ExchangeAppointment apt = new ExchangeAppointment();
        return EWSUtils.setAppointmentFields(appointment, apt);
    }

    private static ExchangeAppointment setAppointmentFields(Appointment appointment, ExchangeAppointment apt) {
        boolean first;
        StringBuilder buffer;
        try {
            microsoft.exchange.webservices.data.property.complex.EmailAddress organizer = appointment.getOrganizer();
            if (null != organizer) {
                apt.setFromId(organizer.getAddress());
                apt.setOrganizer(organizer.getName());
            }
        }
        catch (ServiceLocalException organizer) {
            // empty catch block
        }
        try {
            OutParam propertyValue = new OutParam();
            if (appointment.tryGetProperty((PropertyDefinitionBase)ContactSchema.Body, propertyValue)) {
                MessageBody body = (MessageBody)propertyValue.getParam();
                apt.setHtmlMessage(MessageBody.getStringFromMessageBody((MessageBody)body));
                apt.setMessage(MessageBody.getStringFromMessageBody((MessageBody)body));
            }
        }
        catch (Exception propertyValue) {
            // empty catch block
        }
        try {
            AttendeeCollection requiredAttendees = appointment.getRequiredAttendees();
            buffer = new StringBuilder();
            first = true;
            if (null != requiredAttendees && requiredAttendees.getCount() > 0) {
                for (Attendee attendee : requiredAttendees) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",");
                    }
                    buffer.append(attendee.getAddress());
                }
                apt.setRequiredAttendees(buffer.toString());
                apt.setToId(buffer.toString());
            }
        }
        catch (ServiceLocalException requiredAttendees) {
            // empty catch block
        }
        try {
            AttendeeCollection optionalAttendees = appointment.getOptionalAttendees();
            buffer = new StringBuilder();
            first = true;
            if (null != optionalAttendees && optionalAttendees.getCount() > 0) {
                for (Attendee attendee : optionalAttendees) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",");
                    }
                    buffer.append(attendee.getAddress());
                }
                apt.setOptionalAttendees(buffer.toString());
            }
        }
        catch (ServiceLocalException optionalAttendees) {
            // empty catch block
        }
        try {
            apt.setSubject(appointment.getSubject());
        }
        catch (ServiceLocalException optionalAttendees) {
            // empty catch block
        }
        try {
            apt.setLocation(appointment.getLocation());
        }
        catch (ServiceLocalException optionalAttendees) {
            // empty catch block
        }
        try {
            apt.setId(appointment.getId().getUniqueId());
        }
        catch (ServiceLocalException optionalAttendees) {
            // empty catch block
        }
        try {
            AttendeeCollection resources = appointment.getResources();
            buffer = new StringBuilder();
            first = true;
            if (null != resources && resources.getCount() > 0) {
                for (Attendee attendee : resources) {
                    if (first) {
                        first = false;
                    } else {
                        buffer.append(",");
                    }
                    buffer.append(attendee.getAddress());
                }
                apt.setResources(buffer.toString());
            }
        }
        catch (ServiceLocalException resources) {
            // empty catch block
        }
        try {
            Date start = appointment.getStart();
            if (null != start) {
                start = EWSUtils.normalizeDate("utc2local", start);
                apt.setStartTime(start);
            }
        }
        catch (ServiceLocalException start) {
            // empty catch block
        }
        try {
            Date end = appointment.getEnd();
            if (null != end) {
                end = EWSUtils.normalizeDate("utc2local", end);
                apt.setEndTime(end);
            }
        }
        catch (ServiceLocalException end) {
            // empty catch block
        }
        try {
            apt.setTimeReceived(appointment.getDateTimeReceived());
        }
        catch (ServiceLocalException end) {
            // empty catch block
        }
        try {
            TimeSpan duration = appointment.getDuration();
            if (null != duration) {
                long minutes = duration.getMinutes();
                long hours = duration.getHours();
                long totalTime = 0L;
                if (0L != hours) {
                    totalTime += hours * 60L;
                }
                apt.setDuration(totalTime += minutes);
            }
        }
        catch (ServiceLocalException duration) {
            // empty catch block
        }
        try {
            apt.setImportance(String.valueOf(appointment.getImportance()));
        }
        catch (ServiceLocalException duration) {
            // empty catch block
        }
        try {
            apt.setSensitivity(EWSUtils.getSensitivityString(appointment.getSensitivity()));
        }
        catch (ServiceLocalException duration) {
            // empty catch block
        }
        try {
            apt.setHasAttachment(appointment.getHasAttachments());
        }
        catch (ServiceLocalException duration) {
            // empty catch block
        }
        try {
            int count = appointment.getExtendedProperties().getCount();
            if (0 != count) {
                ExtendedProperty property = (ExtendedProperty)appointment.getExtendedProperties().getPropertyAtIndex(0);
                Boolean isRecurring = (Boolean)property.getValue();
                apt.setRecurring(isRecurring);
                apt.setRecurringSeries(isRecurring);
            } else {
                apt.setRecurring(false);
                apt.setRecurringSeries(false);
            }
        }
        catch (ServiceLocalException count) {
            // empty catch block
        }
        try {
            Date iCalRecurrenceId = appointment.getICalRecurrenceId();
            if (null != iCalRecurrenceId) {
                iCalRecurrenceId = EWSUtils.normalizeDate("utc2local", iCalRecurrenceId);
                apt.setRecurrenceId(iCalRecurrenceId.toString());
            }
        }
        catch (ServiceLocalException iCalRecurrenceId) {
            // empty catch block
        }
        try {
            AppointmentType appointmentType = appointment.getAppointmentType();
            if (null != appointmentType) {
                apt.setAppointmentType(String.valueOf(appointmentType));
            }
        }
        catch (ServiceLocalException appointmentType) {
            // empty catch block
        }
        try {
            Boolean isAllDayEvent = appointment.getIsAllDayEvent();
            if (null != isAllDayEvent) {
                apt.setAllDay(isAllDayEvent);
            }
        }
        catch (ServiceLocalException isAllDayEvent) {
            // empty catch block
        }
        try {
            apt.setLastModified(appointment.getLastModifiedTime());
        }
        catch (ServiceLocalException isAllDayEvent) {
            // empty catch block
        }
        try {
            apt.setLastModified(appointment.getLastModifiedTime());
        }
        catch (ServiceLocalException isAllDayEvent) {
            // empty catch block
        }
        try {
            apt.setIsOrganizer(appointment.getIsFromMe());
        }
        catch (ServiceLocalException isAllDayEvent) {
            // empty catch block
        }
        try {
            apt.setReminderPeriod(appointment.getReminderMinutesBeforeStart());
        }
        catch (ServiceLocalException isAllDayEvent) {
            // empty catch block
        }
        try {
            StringList categories = appointment.getCategories();
            if (null != categories && categories.getSize() > 0) {
                Iterator iterator = categories.iterator();
                StringBuilder builder = new StringBuilder();
                while (iterator.hasNext()) {
                    String category = (String)iterator.next();
                    builder.append(category);
                    if (!iterator.hasNext()) continue;
                    builder.append(",");
                }
                apt.setCategories(builder.toString());
            }
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        try {
            apt.setTimeReceived(appointment.getDateTimeReceived());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        return apt;
    }

    public static SearchFilter.SearchFilterCollection createSearchFilter(AppointmentFilterInfo filter) {
        Integer intValue;
        SearchFilter.ContainsSubstring compfilter;
        String[] splits;
        SearchFilter.SearchFilterCollection collection;
        String value;
        Boolean booleanValue;
        SearchFilter.SearchFilterCollection filterCollection = new SearchFilter.SearchFilterCollection();
        Date date = filter.getFromStartTime();
        if (null != date) {
            date = EWSUtils.normalizeDate("local2utc", date);
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(date, (PropertyDefinitionBase)AppointmentSchema.Start));
        }
        if (null != (date = filter.getToStartTime())) {
            date = EWSUtils.normalizeDate("local2utc", date);
            filterCollection.add(EWSUtils.createLessThanEqFilter(date, (PropertyDefinitionBase)AppointmentSchema.Start));
        }
        if (null != (date = filter.getFromEndTime())) {
            date = EWSUtils.normalizeDate("local2utc", date);
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(date, (PropertyDefinitionBase)AppointmentSchema.End));
        }
        if (null != (date = filter.getToEndTime())) {
            date = EWSUtils.normalizeDate("local2utc", date);
            filterCollection.add(EWSUtils.createLessThanEqFilter(date, (PropertyDefinitionBase)AppointmentSchema.End));
        }
        if (null != (booleanValue = filter.getHasAttachment())) {
            filterCollection.add(EWSUtils.createComponentFilter(booleanValue, (PropertyDefinitionBase)AppointmentSchema.HasAttachments));
        }
        if (null != (booleanValue = filter.getIsAllDay())) {
            filterCollection.add(EWSUtils.createComponentFilter(booleanValue, (PropertyDefinitionBase)AppointmentSchema.IsAllDayEvent));
        }
        if (null != (value = filter.getLocation())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)AppointmentSchema.Location));
        }
        if (null != (value = filter.getMessage())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)AppointmentSchema.Body));
        }
        if (null != (value = filter.getSubject())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)AppointmentSchema.Subject));
        }
        if (null != (value = filter.getImportance())) {
            if (value.equalsIgnoreCase("high")) {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.High));
            } else if (value.equalsIgnoreCase("Normal")) {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.Normal));
            } else if (value.equalsIgnoreCase("Low")) {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.Low));
            } else {
                filterCollection.add(EWSUtils.createComponentFilter(Importance.Normal));
            }
        }
        if (null != (value = filter.getRequiredAttendees())) {
            collection = new SearchFilter.SearchFilterCollection();
            for (String requiredAttendee : splits = Utils.splitString(value)) {
                if (requiredAttendee.trim().length() <= 0) continue;
                compfilter = new SearchFilter.ContainsSubstring();
                compfilter.setPropertyDefinition((PropertyDefinitionBase)AppointmentSchema.RequiredAttendees);
                compfilter.setValue(requiredAttendee.trim());
                compfilter.setComparisonMode(ComparisonMode.IgnoreCase);
                compfilter.setContainmentMode(ContainmentMode.Substring);
                collection.add((SearchFilter)compfilter);
            }
            if (collection.getCount() > 0) {
                filterCollection.add((SearchFilter)collection);
            }
        }
        if (null != (value = filter.getOptionalAttendees())) {
            collection = new SearchFilter.SearchFilterCollection();
            for (String optionalAttendee : splits = Utils.splitString(value)) {
                if (optionalAttendee.trim().length() <= 0) continue;
                compfilter = new SearchFilter.ContainsSubstring();
                compfilter.setPropertyDefinition((PropertyDefinitionBase)AppointmentSchema.OptionalAttendees);
                compfilter.setValue(optionalAttendee.trim());
                compfilter.setComparisonMode(ComparisonMode.IgnoreCase);
                compfilter.setContainmentMode(ContainmentMode.Substring);
                collection.add((SearchFilter)compfilter);
            }
            if (collection.getCount() > 0) {
                filterCollection.add((SearchFilter)collection);
            }
        }
        if (null != (value = filter.getResources())) {
            collection = new SearchFilter.SearchFilterCollection();
            for (String resource : splits = Utils.splitString(value)) {
                if (resource.trim().length() <= 0) continue;
                compfilter = new SearchFilter.ContainsSubstring();
                compfilter.setPropertyDefinition((PropertyDefinitionBase)AppointmentSchema.Resources);
                compfilter.setValue(resource.trim());
                compfilter.setComparisonMode(ComparisonMode.IgnoreCase);
                compfilter.setContainmentMode(ContainmentMode.Substring);
                collection.add((SearchFilter)compfilter);
            }
            if (collection.getCount() > 0) {
                filterCollection.add((SearchFilter)collection);
            }
        }
        if (null != (value = filter.getOrganizer())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)AppointmentSchema.Organizer));
        }
        if (null != (value = filter.getSensitivity())) {
            if (!value.equalsIgnoreCase("normal")) {
                if (value.equalsIgnoreCase("Confidential") || value.equalsIgnoreCase("company-Confidential")) {
                    filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Confidential));
                } else if (value.equalsIgnoreCase("Normal")) {
                    filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Normal));
                } else if (value.equalsIgnoreCase("Personal")) {
                    filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Personal));
                } else if (value.equalsIgnoreCase("Private")) {
                    filterCollection.add(EWSUtils.createComponentFilter(Sensitivity.Private));
                }
            } else {
                collection = new SearchFilter.SearchFilterCollection();
                collection.add((SearchFilter)new SearchFilter.IsNotEqualTo((PropertyDefinitionBase)ItemSchema.Sensitivity, (Object)Sensitivity.Private));
                collection.add((SearchFilter)new SearchFilter.IsNotEqualTo((PropertyDefinitionBase)ItemSchema.Sensitivity, (Object)Sensitivity.Personal));
                collection.add((SearchFilter)new SearchFilter.IsNotEqualTo((PropertyDefinitionBase)ItemSchema.Sensitivity, (Object)Sensitivity.Confidential));
            }
        }
        if (null != (value = filter.getFromId())) {
            filterCollection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)AppointmentSchema.Organizer));
        }
        if (null != (intValue = filter.getDuration())) {
            filterCollection.add(EWSUtils.createComponentFilter(intValue, (PropertyDefinitionBase)durationProperty));
        }
        if (null != (intValue = filter.getRecurringSeries())) {
            if (intValue == 1) {
                filterCollection.add(EWSUtils.createComponentFilter(true, (PropertyDefinitionBase)isRecurringProperty));
            } else {
                filterCollection.add(EWSUtils.createComponentFilter(false, (PropertyDefinitionBase)isRecurringProperty));
            }
        }
        if (null != (value = filter.getCategories())) {
            filterCollection.add(EWSUtils.createCategoryFilter(value));
        }
        if (null != (date = filter.getFromLastModifiedDate())) {
            filterCollection.add(EWSUtils.createGreaterThanEqFilter(date, (PropertyDefinitionBase)AppointmentSchema.LastModifiedTime));
        }
        if (null != (date = filter.getToLastModifiedDate())) {
            filterCollection.add(EWSUtils.createLessThanEqFilter(date, (PropertyDefinitionBase)AppointmentSchema.LastModifiedTime));
        }
        return filterCollection;
    }

    public static ExchangeFolder createCFFolderInfo(ExchangeService service, Folder folder) {
        ExchangeFolder cfFolderInfo = new ExchangeFolder();
        EWSUtils.setBasicFolderFields(service, folder, cfFolderInfo);
        return cfFolderInfo;
    }

    private static void setBasicFolderFields(ExchangeService service, Folder folder, ExchangeFolder cfFolderInfo) {
        try {
            int childFolderCount = folder.getChildFolderCount();
            cfFolderInfo.setChildFolderCount(childFolderCount);
        }
        catch (Exception childFolderCount) {
            // empty catch block
        }
        try {
            String displayName = folder.getDisplayName();
            cfFolderInfo.setDisplayName(displayName);
        }
        catch (ServiceLocalException displayName) {
            // empty catch block
        }
        try {
            String folderClass = folder.getFolderClass();
            cfFolderInfo.setFolderClass(folderClass);
        }
        catch (ServiceLocalException folderClass) {
            // empty catch block
        }
        try {
            FolderId id = folder.getId();
            if (null != id) {
                cfFolderInfo.setId(id.getUniqueId());
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        try {
            FolderId parentFolderId = folder.getParentFolderId();
            if (null != parentFolderId) {
                cfFolderInfo.setParentFolderId(parentFolderId.getUniqueId());
            }
        }
        catch (ServiceLocalException parentFolderId) {
            // empty catch block
        }
        try {
            int totalCount = folder.getTotalCount();
            cfFolderInfo.setTotalCount(totalCount);
        }
        catch (Exception totalCount) {
            // empty catch block
        }
        try {
            int unreadCount = folder.getUnreadCount();
            cfFolderInfo.setUnreadCount(unreadCount);
        }
        catch (Exception unreadCount) {
            // empty catch block
        }
        try {
            String folderName;
            Folder msgRootFolder = Folder.bind((ExchangeService)service, (WellKnownFolderName)WellKnownFolderName.MsgFolderRoot);
            FolderId rootFolderId = msgRootFolder.getId();
            Folder tempFolder = folder;
            FolderId cParentFolderId = null;
            Object folderPath = "";
            while (!tempFolder.getId().equals((Object)rootFolderId) && (folderName = tempFolder.getDisplayName()) != null) {
                folderPath = folderName + "/" + (String)folderPath;
                FolderId parentFolderId = tempFolder.getParentFolderId();
                if (cParentFolderId != null && parentFolderId != null && parentFolderId.equals((Object)cParentFolderId)) break;
                cParentFolderId = parentFolderId;
                tempFolder = Folder.bind((ExchangeService)service, (FolderId)parentFolderId);
            }
            if (((String)folderPath).length() > 0) {
                folderPath = ((String)folderPath).substring(0, ((String)folderPath).length() - 1);
            }
            cfFolderInfo.setFolderPath((String)folderPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ExchangeFolderExtendedInfo createCFExtendedFolderInfo(ExchangeService service, Folder folder) {
        ExchangeFolderExtendedInfo cfFolder = new ExchangeFolderExtendedInfo();
        EWSUtils.setBasicFolderFields(service, folder, cfFolder);
        try {
            ManagedFolderInformation managedFolderInformation = folder.getManagedFolderInformation();
            if (null != managedFolderInformation) {
                ManagedFolderInfo info = EWSUtils.createCFManagedFolderinfo(managedFolderInformation);
                cfFolder.setManagedFolderInformation(info);
            }
        }
        catch (ServiceLocalException managedFolderInformation) {
            // empty catch block
        }
        try {
            FolderPermissionCollection permissions = folder.getPermissions();
            if (null != permissions) {
                List<FolderPermissionInfo> folderPermissions = EWSUtils.createFolderPermissions(permissions);
                cfFolder.setPermissions(folderPermissions);
            }
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        return cfFolder;
    }

    private static List<FolderPermissionInfo> createFolderPermissions(FolderPermissionCollection permissions) {
        ArrayList<FolderPermissionInfo> permissionList = new ArrayList<FolderPermissionInfo>();
        for (FolderPermission folderPermission : permissions) {
            UserId userId;
            microsoft.exchange.webservices.data.core.enumeration.permission.folder.FolderPermissionReadAccess readItems;
            microsoft.exchange.webservices.data.core.enumeration.permission.folder.FolderPermissionLevel permissionLevel;
            microsoft.exchange.webservices.data.core.enumeration.permission.PermissionScope editItems;
            microsoft.exchange.webservices.data.core.enumeration.permission.folder.FolderPermissionLevel displayPermissionLevel;
            FolderPermissionInfo info = new FolderPermissionInfo();
            info.setCanCreateItems(folderPermission.getCanCreateItems());
            info.setCanCreateSubFolders(folderPermission.getCanCreateSubFolders());
            info.setIsFolderContact(folderPermission.getIsFolderContact());
            info.setIsFolderOwner(folderPermission.getIsFolderOwner());
            info.setIsFolderVisible(folderPermission.getIsFolderVisible());
            microsoft.exchange.webservices.data.core.enumeration.permission.PermissionScope deleteItems = folderPermission.getDeleteItems();
            if (null != deleteItems) {
                switch (deleteItems) {
                    case All: {
                        info.setDeleteItems(PermissionScope.All);
                        break;
                    }
                    case None: {
                        info.setDeleteItems(PermissionScope.None);
                        break;
                    }
                    case Owned: {
                        info.setDeleteItems(PermissionScope.Owned);
                    }
                }
            }
            if (null != (displayPermissionLevel = folderPermission.getDisplayPermissionLevel())) {
                switch (displayPermissionLevel) {
                    case Author: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.Author);
                        break;
                    }
                    case Contributor: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.Contributor);
                        break;
                    }
                    case Custom: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.Custom);
                        break;
                    }
                    case Editor: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.Editor);
                        break;
                    }
                    case FreeBusyTimeAndSubjectAndLocation: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.FreeBusyTimeAndSubjectAndLocation);
                        break;
                    }
                    case FreeBusyTimeOnly: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.FreeBusyTimeOnly);
                        break;
                    }
                    case None: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.None);
                        break;
                    }
                    case NoneditingAuthor: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.NoneditingAuthor);
                        break;
                    }
                    case Owner: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.Owner);
                        break;
                    }
                    case PublishingAuthor: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.PublishingAuthor);
                        break;
                    }
                    case PublishingEditor: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.PublishingEditor);
                        break;
                    }
                    case Reviewer: {
                        info.setDisplayPermissionLevel(FolderPermissionLevel.Reviewer);
                    }
                }
            }
            if (null != (editItems = folderPermission.getEditItems())) {
                switch (editItems) {
                    case All: {
                        info.setEditItems(PermissionScope.All);
                        break;
                    }
                    case None: {
                        info.setEditItems(PermissionScope.None);
                        break;
                    }
                    case Owned: {
                        info.setEditItems(PermissionScope.Owned);
                    }
                }
            }
            if (null != (permissionLevel = folderPermission.getPermissionLevel())) {
                switch (permissionLevel) {
                    case Author: {
                        info.setPermissionLevel(FolderPermissionLevel.Author);
                        break;
                    }
                    case Contributor: {
                        info.setPermissionLevel(FolderPermissionLevel.Contributor);
                        break;
                    }
                    case Custom: {
                        info.setPermissionLevel(FolderPermissionLevel.Custom);
                        break;
                    }
                    case Editor: {
                        info.setPermissionLevel(FolderPermissionLevel.Editor);
                        break;
                    }
                    case FreeBusyTimeAndSubjectAndLocation: {
                        info.setPermissionLevel(FolderPermissionLevel.FreeBusyTimeAndSubjectAndLocation);
                        break;
                    }
                    case FreeBusyTimeOnly: {
                        info.setPermissionLevel(FolderPermissionLevel.FreeBusyTimeOnly);
                        break;
                    }
                    case None: {
                        info.setPermissionLevel(FolderPermissionLevel.None);
                        break;
                    }
                    case NoneditingAuthor: {
                        info.setPermissionLevel(FolderPermissionLevel.NoneditingAuthor);
                        break;
                    }
                    case Owner: {
                        info.setPermissionLevel(FolderPermissionLevel.Owner);
                        break;
                    }
                    case PublishingAuthor: {
                        info.setPermissionLevel(FolderPermissionLevel.PublishingAuthor);
                        break;
                    }
                    case PublishingEditor: {
                        info.setPermissionLevel(FolderPermissionLevel.PublishingEditor);
                        break;
                    }
                    case Reviewer: {
                        info.setPermissionLevel(FolderPermissionLevel.Reviewer);
                    }
                }
            }
            if (null != (readItems = folderPermission.getReadItems())) {
                switch (readItems) {
                    case FullDetails: {
                        info.setReadItems(FolderPermissionReadAccess.FullDetails);
                        break;
                    }
                    case None: {
                        info.setReadItems(FolderPermissionReadAccess.None);
                        break;
                    }
                    case TimeAndSubjectAndLocation: {
                        info.setReadItems(FolderPermissionReadAccess.TimeAndSubjectAndLocation);
                        break;
                    }
                    case TimeOnly: {
                        info.setReadItems(FolderPermissionReadAccess.TimeOnly);
                    }
                }
            }
            if (null != (userId = folderPermission.getUserId())) {
                UserIdInfo userIdInfo = new UserIdInfo();
                userIdInfo.setDisplayName(userId.getDisplayName());
                userIdInfo.setPrimarySmtpAddress(userId.getPrimarySmtpAddress());
                userIdInfo.setSID(userId.getSID());
                microsoft.exchange.webservices.data.core.enumeration.property.StandardUser standardUser = userId.getstandardUser();
                if (null != standardUser) {
                    switch (standardUser) {
                        case Anonymous: {
                            userIdInfo.setStandardUser(StandardUser.Anonymous);
                            break;
                        }
                        case Default: {
                            userIdInfo.setStandardUser(StandardUser.Default);
                        }
                    }
                }
                info.setUserId(userIdInfo);
            }
            permissionList.add(info);
        }
        return permissionList;
    }

    private static ManagedFolderInfo createCFManagedFolderinfo(ManagedFolderInformation managedFolderInformation) {
        ManagedFolderInfo info = new ManagedFolderInfo();
        info.setCanDelete(managedFolderInformation.getCanDelete());
        info.setCanRenameOrMove(managedFolderInformation.getCanRenameOrMove());
        info.setHasQuota(managedFolderInformation.getHasQuota());
        info.setIsManagedFoldersRoot(managedFolderInformation.getIsManagedFoldersRoot());
        info.setMustDisplayComment(managedFolderInformation.getMustDisplayComment());
        info.setComment(managedFolderInformation.getComment());
        info.setFolderSize(managedFolderInformation.getFolderSize());
        info.setManagedFolderId(managedFolderInformation.getManagedFolderId());
        info.setHomePage(managedFolderInformation.getHomePage());
        info.setStorageQuota(managedFolderInformation.getStorageQuota());
        return info;
    }

    public static void setNonNullValues(Folder serverFolder, ExchangeFolderExtendedInfo folder) throws Exception {
        String value = folder.getDisplayName();
        if (null != value) {
            serverFolder.setDisplayName(value);
        }
        if (null != (value = folder.getFolderClass())) {
            serverFolder.setFolderClass(value);
        }
    }

    public static SearchFilter.SearchFilterCollection createSearchFilter(FolderFilterInfo filter) {
        int toUnreadCount;
        int fromUnreadCount;
        int toTotalCount;
        int fromTotalCount;
        EffectiveRights effectiveRights;
        String value;
        int toChildFolderCount;
        SearchFilter.SearchFilterCollection collection = new SearchFilter.SearchFilterCollection();
        int fromChildFolderCount = filter.getFromChildFolderCount();
        if (-1 != fromChildFolderCount) {
            collection.add(EWSUtils.createGreaterThanEqFilter(fromChildFolderCount, FolderSchema.ChildFolderCount));
        }
        if (-1 != (toChildFolderCount = filter.getToChildFolderCount())) {
            collection.add(EWSUtils.createLessThanEqFilter(toChildFolderCount, FolderSchema.ChildFolderCount));
        }
        if (null != (value = filter.getDisplayName())) {
            collection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)FolderSchema.DisplayName));
        }
        if (null != (value = filter.getFolderClass())) {
            collection.add(EWSUtils.createComponentFilter(value, (PropertyDefinitionBase)FolderSchema.FolderClass));
        }
        if (null != (effectiveRights = filter.getEffectiveRights())) {
            collection.add(EWSUtils.createEffectiveRightsFilter(effectiveRights));
        }
        if (-1 != (fromTotalCount = filter.getFromTotalCount())) {
            collection.add(EWSUtils.createGreaterThanEqFilter(fromTotalCount, FolderSchema.TotalCount));
        }
        if (-1 != (toTotalCount = filter.getToTotalCount())) {
            collection.add(EWSUtils.createLessThanEqFilter(toTotalCount, FolderSchema.TotalCount));
        }
        if (-1 != (fromUnreadCount = filter.getFromUnreadCount())) {
            collection.add(EWSUtils.createGreaterThanEqFilter(fromUnreadCount, FolderSchema.UnreadCount));
        }
        if (-1 != (toUnreadCount = filter.getToUnreadCount())) {
            collection.add(EWSUtils.createLessThanEqFilter(toUnreadCount, FolderSchema.UnreadCount));
        }
        return collection;
    }

    private static SearchFilter createEffectiveRightsFilter(EffectiveRights effectiveRights) {
        SearchFilter.IsEqualTo filter = new SearchFilter.IsEqualTo();
        filter.setPropertyDefinition((PropertyDefinitionBase)FolderSchema.EffectiveRights);
        switch (effectiveRights) {
            case CreateAssociated: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.CreateAssociated);
                break;
            }
            case CreateContents: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.CreateContents);
                break;
            }
            case CreateHierarchy: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.CreateHierarchy);
                break;
            }
            case Delete: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.Delete);
                break;
            }
            case Modify: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.Modify);
                break;
            }
            case None: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.None);
                break;
            }
            case Read: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.Read);
                break;
            }
            case ViewPrivateItems: {
                filter.setValue((Object)microsoft.exchange.webservices.data.core.enumeration.service.EffectiveRights.ViewPrivateItems);
                break;
            }
        }
        return filter;
    }

    public static Folder createServerFolder(ExchangeService service, ExchangeFolderExtendedInfo folder) throws Exception {
        Folder serverFolder = new Folder(service);
        EWSUtils.setNonNullValues(serverFolder, folder);
        return serverFolder;
    }

    public static EmailAddress createCFEmailAddress(microsoft.exchange.webservices.data.property.complex.EmailAddress emailAddress) {
        String routingType;
        String name;
        MailboxType mailboxType;
        ItemId id;
        EmailAddress cfAddress = new EmailAddress();
        String address = emailAddress.getAddress();
        if (null != address) {
            cfAddress.setAddress(address);
        }
        if (null != (id = emailAddress.getId())) {
            cfAddress.setId(id.getUniqueId());
        }
        if (null != (mailboxType = emailAddress.getMailboxType())) {
            switch (mailboxType) {
                case Contact: {
                    cfAddress.setMailboxType(MailBoxType.Contact);
                    break;
                }
                case ContactGroup: {
                    cfAddress.setMailboxType(MailBoxType.ContactGroup);
                    break;
                }
                case Mailbox: {
                    cfAddress.setMailboxType(MailBoxType.Mailbox);
                    break;
                }
                case OneOff: {
                    cfAddress.setMailboxType(MailBoxType.OneOff);
                    break;
                }
                case PublicFolder: {
                    cfAddress.setMailboxType(MailBoxType.PublicFolder);
                    break;
                }
                case PublicGroup: {
                    cfAddress.setMailboxType(MailBoxType.PublicGroup);
                    break;
                }
                case Unknown: {
                    cfAddress.setMailboxType(MailBoxType.Unknown);
                    break;
                }
            }
        }
        if (null != (name = emailAddress.getName())) {
            cfAddress.setName(name);
        }
        if (null != (routingType = emailAddress.getRoutingType())) {
            cfAddress.setRoutingType(routingType);
        }
        return cfAddress;
    }

    public static microsoft.exchange.webservices.data.property.complex.EmailAddress createServerEmailAddress(EmailAddress emailAddress) throws Exception {
        String routingType;
        String name;
        MailBoxType mailboxType;
        String id;
        microsoft.exchange.webservices.data.property.complex.EmailAddress serverAddress = new microsoft.exchange.webservices.data.property.complex.EmailAddress();
        String address = emailAddress.getAddress();
        if (null != address) {
            serverAddress.setAddress(address);
        }
        if (null != (id = emailAddress.getId())) {
            serverAddress.setId(new ItemId(id));
        }
        if (null != (mailboxType = emailAddress.getMailboxType())) {
            switch (mailboxType) {
                case Contact: {
                    serverAddress.setMailboxType(MailboxType.Contact);
                    break;
                }
                case ContactGroup: {
                    serverAddress.setMailboxType(MailboxType.ContactGroup);
                    break;
                }
                case Mailbox: {
                    serverAddress.setMailboxType(MailboxType.Mailbox);
                    break;
                }
                case OneOff: {
                    serverAddress.setMailboxType(MailboxType.OneOff);
                    break;
                }
                case PublicFolder: {
                    serverAddress.setMailboxType(MailboxType.PublicFolder);
                    break;
                }
                case PublicGroup: {
                    serverAddress.setMailboxType(MailboxType.PublicGroup);
                    break;
                }
                case Unknown: {
                    serverAddress.setMailboxType(MailboxType.Unknown);
                    break;
                }
            }
        }
        if (null != (name = emailAddress.getName())) {
            serverAddress.setName(name);
        }
        if (null != (routingType = emailAddress.getRoutingType())) {
            serverAddress.setRoutingType(routingType);
        }
        return serverAddress;
    }

    public static CFUserAvailability createCFUserAvailability(GetUserAvailabilityResults userAvailability) {
        CFUserAvailability cfAvailability = new CFUserAvailability();
        ServiceResponseCollection attendeesAvailability = userAvailability.getAttendeesAvailability();
        if (null != attendeesAvailability && attendeesAvailability.getCount() > 0) {
            for (microsoft.exchange.webservices.data.core.response.AttendeeAvailability attendeeAvailability : attendeesAvailability) {
                AttendeeAvailability availability = EWSUtils.createCFAttendeeAvailability(attendeeAvailability);
                cfAvailability.addAttendeeAvailability(availability);
            }
        }
        try {
            Collection suggestions = userAvailability.getSuggestions();
            if (null != suggestions && suggestions.size() > 0) {
                for (microsoft.exchange.webservices.data.property.complex.availability.Suggestion suggestion : suggestions) {
                    Suggestion cfSuggestion = EWSUtils.createCFSuggestion(suggestion);
                    cfAvailability.addSuggestion(cfSuggestion);
                }
            }
        }
        catch (ServiceResponseException serviceResponseException) {
            // empty catch block
        }
        return cfAvailability;
    }

    private static Suggestion createCFSuggestion(microsoft.exchange.webservices.data.property.complex.availability.Suggestion suggestion) {
        Collection timeSuggestions;
        SuggestionQuality quality;
        Suggestion cfSuggestion = new Suggestion();
        Date date = suggestion.getDate();
        if (null != date) {
            cfSuggestion.setDate(date);
        }
        if (null != (quality = suggestion.getQuality())) {
            cfSuggestion.setQuality(String.valueOf(quality));
        }
        if (null != (timeSuggestions = suggestion.getTimeSuggestions()) && timeSuggestions.size() > 0) {
            for (microsoft.exchange.webservices.data.property.complex.availability.TimeSuggestion timeSuggestion : timeSuggestions) {
                cfSuggestion.addTimeSuggestion(EWSUtils.createCFTimeSuggestion(timeSuggestion));
            }
        }
        return cfSuggestion;
    }

    private static TimeSuggestion createCFTimeSuggestion(microsoft.exchange.webservices.data.property.complex.availability.TimeSuggestion timeSuggestion) {
        Collection conflicts;
        SuggestionQuality quality;
        TimeSuggestion cfTimeSuggestion = new TimeSuggestion();
        Date meetingTime = timeSuggestion.getMeetingTime();
        if (null != meetingTime) {
            cfTimeSuggestion.setMeetingTime(meetingTime);
        }
        if (null != (quality = timeSuggestion.getQuality())) {
            cfTimeSuggestion.setQuality(String.valueOf(quality));
        }
        if (null != (conflicts = timeSuggestion.getConflicts()) && conflicts.size() > 0) {
            for (microsoft.exchange.webservices.data.property.complex.availability.Conflict conflict : conflicts) {
                cfTimeSuggestion.addConflict(EWSUtils.createCFConflict(conflict));
            }
        }
        cfTimeSuggestion.setWorkTime(timeSuggestion.isWorkTime());
        return cfTimeSuggestion;
    }

    private static Conflict createCFConflict(microsoft.exchange.webservices.data.property.complex.availability.Conflict conflict) {
        LegacyFreeBusyStatus freeBusyStatus;
        Conflict cfConflict = new Conflict();
        ConflictType conflictType = conflict.getConflictType();
        if (null != conflictType) {
            cfConflict.setConflictType(String.valueOf(conflictType));
        }
        if (null != (freeBusyStatus = conflict.getFreeBusyStatus())) {
            cfConflict.setFreeBusyStatus(String.valueOf(freeBusyStatus));
        }
        cfConflict.setNumberOfMembers(conflict.getNumberOfMembers());
        cfConflict.setNumberOfMembersAvailable(conflict.getNumberOfMembersAvailable());
        cfConflict.setNumberOfMembersWithConflict(conflict.getNumberOfMembersWithConflict());
        cfConflict.setNumberOfMembersWithNoData(conflict.getNumberOfMembersWithNoData());
        return cfConflict;
    }

    private static AttendeeAvailability createCFAttendeeAvailability(microsoft.exchange.webservices.data.core.response.AttendeeAvailability attendeeAvailability) {
        microsoft.exchange.webservices.data.property.complex.availability.WorkingHours workingHours;
        FreeBusyViewType viewType;
        Collection mergedFreeBusyStatus;
        AttendeeAvailability availability = new AttendeeAvailability();
        Collection calendarEvents = attendeeAvailability.getCalendarEvents();
        if (null != calendarEvents && calendarEvents.size() > 0) {
            for (microsoft.exchange.webservices.data.property.complex.availability.CalendarEvent calendarEvent : calendarEvents) {
                CalendarEvent event = EWSUtils.createCFCalendarEvent(calendarEvent);
                availability.addCalendarEvent(event);
            }
        }
        if (null != (mergedFreeBusyStatus = attendeeAvailability.getMergedFreeBusyStatus()) && mergedFreeBusyStatus.size() > 0) {
            for (LegacyFreeBusyStatus legacyFreeBusyStatus : mergedFreeBusyStatus) {
                availability.addFreeBusyStatus(String.valueOf(legacyFreeBusyStatus));
            }
        }
        if (null != (viewType = attendeeAvailability.getViewType())) {
            availability.setViewType(String.valueOf(viewType));
        }
        if (null != (workingHours = attendeeAvailability.getWorkingHours())) {
            availability.setWorkingHours(EWSUtils.createCFWorkingHours(workingHours));
        }
        return availability;
    }

    private static WorkingHours createCFWorkingHours(microsoft.exchange.webservices.data.property.complex.availability.WorkingHours workingHours) {
        WorkingHours cfWorkingHours = new WorkingHours();
        Collection daysOfTheWeek = workingHours.getDaysOfTheWeek();
        if (null != daysOfTheWeek && daysOfTheWeek.size() > 0) {
            for (DayOfTheWeek dayOfTheWeek : daysOfTheWeek) {
                cfWorkingHours.addDayOfTheWeek(String.valueOf(dayOfTheWeek));
            }
        }
        cfWorkingHours.setStartTime(workingHours.getStartTime());
        cfWorkingHours.setEndTime(workingHours.getEndTime());
        TimeZoneDefinition timeZone = workingHours.getTimeZone();
        cfWorkingHours.setTimeZone(EWSUtils.createCFTimeZone(timeZone));
        return cfWorkingHours;
    }

    private static CFTimeZone createCFTimeZone(TimeZoneDefinition timeZone) {
        CFTimeZone zone = null;
        if (null != timeZone) {
            zone = new CFTimeZone();
            zone.setId(timeZone.getId());
            zone.setName(timeZone.getName());
        }
        return zone;
    }

    private static CalendarEvent createCFCalendarEvent(microsoft.exchange.webservices.data.property.complex.availability.CalendarEvent calendarEvent) {
        microsoft.exchange.webservices.data.property.complex.availability.CalendarEventDetails details;
        LegacyFreeBusyStatus freeBusyStatus;
        Date endTime;
        CalendarEvent event = new CalendarEvent();
        Date startTime = calendarEvent.getStartTime();
        if (null != startTime) {
            event.setStartTime(startTime);
        }
        if (null != (endTime = calendarEvent.getEndTime())) {
            event.setEndTime(endTime);
        }
        if (null != (freeBusyStatus = calendarEvent.getFreeBusyStatus())) {
            event.setFreeBusyStatus(String.valueOf(freeBusyStatus));
        }
        if (null != (details = calendarEvent.getDetails())) {
            event.setDetails(EWSUtils.createCFCalanderEventDetails(details));
        }
        return event;
    }

    private static CalendarEventDetails createCFCalanderEventDetails(microsoft.exchange.webservices.data.property.complex.availability.CalendarEventDetails details) {
        String subject;
        String storeId;
        CalendarEventDetails cfDetails = new CalendarEventDetails();
        String location = details.getLocation();
        if (null != location) {
            cfDetails.setLocation(location);
        }
        if (null != (storeId = details.getStoreId())) {
            cfDetails.setStoreId(storeId);
        }
        if (null != (subject = details.getSubject())) {
            cfDetails.setSubject(subject);
        }
        cfDetails.setException(details.isException());
        cfDetails.setMeeting(details.isMeeting());
        cfDetails.setPrivate(details.isPrivate());
        cfDetails.setRecurring(details.isRecurring());
        cfDetails.setReminderSet(details.isReminderSet());
        return cfDetails;
    }

    public static CFConversation createCFConversation(Conversation conversation) {
        CFConversation cfConversation = new CFConversation();
        try {
            StringList categories = conversation.getCategories();
            if (null != categories && categories.getSize() > 0) {
                for (String category : categories) {
                    cfConversation.addCategory(category.trim());
                }
            }
        }
        catch (ArgumentException categories) {
            // empty catch block
        }
        try {
            ConversationFlagStatus flagStatus = conversation.getFlagStatus();
            if (null != flagStatus) {
                cfConversation.setFlagStatus(String.valueOf(flagStatus));
            }
        }
        catch (ArgumentException flagStatus) {
            // empty catch block
        }
        try {
            StringList globalCategories = conversation.getGlobalCategories();
            if (null != globalCategories && globalCategories.getSize() > 0) {
                for (String category : globalCategories) {
                    cfConversation.addGlobalCategory(category.trim());
                }
            }
        }
        catch (ArgumentException globalCategories) {
            // empty catch block
        }
        try {
            ConversationFlagStatus globalFlagStatus = conversation.getGlobalFlagStatus();
            if (null != globalFlagStatus) {
                cfConversation.setGlobalFlagStatus(String.valueOf(globalFlagStatus));
            }
        }
        catch (ArgumentException globalFlagStatus) {
            // empty catch block
        }
        try {
            boolean globalHasAttachments = conversation.getGlobalHasAttachments();
            cfConversation.setGlobalHasAttachments(globalHasAttachments);
        }
        catch (ServiceLocalException globalHasAttachments) {
            // empty catch block
        }
        try {
            Importance globalImportance = conversation.getGlobalImportance();
            if (null != globalImportance) {
                cfConversation.setGlobalImportance(String.valueOf(globalImportance));
            }
        }
        catch (Exception globalImportance) {
            // empty catch block
        }
        try {
            StringList globalItemClasses = conversation.getGlobalItemClasses();
            if (null != globalItemClasses && globalItemClasses.getSize() > 0) {
                for (String globalItemClass : globalItemClasses) {
                    cfConversation.addGlobalItemClass(globalItemClass.trim());
                }
            }
        }
        catch (Exception globalItemClasses) {
            // empty catch block
        }
        try {
            ItemIdCollection globalItemIds = conversation.getGlobalItemIds();
            if (null != globalItemIds && globalItemIds.getCount() > 0) {
                for (ItemId globalItemId : globalItemIds) {
                    cfConversation.addGlobalItemId(globalItemId.getUniqueId());
                }
            }
        }
        catch (Exception globalItemIds) {
            // empty catch block
        }
        try {
            cfConversation.setGlobalLastDeliveryTime(conversation.getGlobalLastDeliveryTime());
        }
        catch (Exception globalItemIds) {
            // empty catch block
        }
        try {
            cfConversation.setGlobalMessageCount(conversation.getGlobalMessageCount());
        }
        catch (ServiceLocalException globalItemIds) {
            // empty catch block
        }
        try {
            cfConversation.setGlobalSize(conversation.getGlobalSize());
        }
        catch (ServiceLocalException globalItemIds) {
            // empty catch block
        }
        try {
            StringList globalUniqueRecipients = conversation.getGlobalUniqueRecipients();
            if (null != globalUniqueRecipients && globalUniqueRecipients.getSize() > 0) {
                for (String globalUniqueRecipient : globalUniqueRecipients) {
                    cfConversation.addGlobalUniqueRecipient(globalUniqueRecipient.trim());
                }
            }
        }
        catch (Exception globalUniqueRecipients) {
            // empty catch block
        }
        try {
            StringList globalUniqueSenders = conversation.getGlobalUniqueSenders();
            if (null != globalUniqueSenders && globalUniqueSenders.getSize() > 0) {
                for (String globalUniqueSender : globalUniqueSenders) {
                    cfConversation.addGlobalUniqueSender(globalUniqueSender.trim());
                }
            }
        }
        catch (Exception globalUniqueSenders) {
            // empty catch block
        }
        try {
            StringList globalUniqueUnreadSenders = conversation.getGlobalUniqueUnreadSenders();
            if (null != globalUniqueUnreadSenders && globalUniqueUnreadSenders.getSize() > 0) {
                for (String globalUniqueUnreadSender : globalUniqueUnreadSenders) {
                    cfConversation.addGlobalUniqueUnreadSender(globalUniqueUnreadSender.trim());
                }
            }
        }
        catch (ArgumentException globalUniqueUnreadSenders) {
            // empty catch block
        }
        try {
            cfConversation.setGlobalUnreadCount(conversation.getGlobalUnreadCount());
        }
        catch (ArgumentException globalUniqueUnreadSenders) {
            // empty catch block
        }
        try {
            boolean hasAttachments = conversation.getHasAttachments();
            cfConversation.setHasAttachments(hasAttachments);
        }
        catch (ServiceLocalException hasAttachments) {
            // empty catch block
        }
        try {
            ConversationId id = conversation.getId();
            if (null != id) {
                cfConversation.setId(id.getUniqueId());
            }
        }
        catch (ServiceLocalException id) {
            // empty catch block
        }
        try {
            Importance importance = conversation.getImportance();
            if (null != importance) {
                cfConversation.setImportance(String.valueOf(importance));
            }
        }
        catch (Exception importance) {
            // empty catch block
        }
        try {
            StringList itemClasses = conversation.getItemClasses();
            if (null != itemClasses && itemClasses.getSize() > 0) {
                for (String itemClass : itemClasses) {
                    cfConversation.addItemClass(itemClass.trim());
                }
            }
        }
        catch (Exception itemClasses) {
            // empty catch block
        }
        try {
            ItemIdCollection itemIds = conversation.getItemIds();
            if (null != itemIds && itemIds.getCount() > 0) {
                for (ItemId itemId : itemIds) {
                    cfConversation.addItemId(itemId.getUniqueId());
                }
            }
        }
        catch (Exception itemIds) {
            // empty catch block
        }
        try {
            cfConversation.setLastDeliveryTime(conversation.getLastDeliveryTime());
        }
        catch (Exception itemIds) {
            // empty catch block
        }
        try {
            cfConversation.setMessageCount(conversation.getMessageCount());
        }
        catch (ServiceLocalException itemIds) {
            // empty catch block
        }
        try {
            cfConversation.setSize(conversation.getSize());
        }
        catch (ServiceLocalException itemIds) {
            // empty catch block
        }
        try {
            cfConversation.setTopic(conversation.getTopic());
        }
        catch (ArgumentException itemIds) {
            // empty catch block
        }
        try {
            StringList uniqueRecipients = conversation.getUniqueRecipients();
            if (null != uniqueRecipients && uniqueRecipients.getSize() > 0) {
                for (String uniqueRecipient : uniqueRecipients) {
                    cfConversation.addUniqueRecipient(uniqueRecipient.trim());
                }
            }
        }
        catch (Exception uniqueRecipients) {
            // empty catch block
        }
        try {
            StringList uniqueSenders = conversation.getUniqueSenders();
            if (null != uniqueSenders && uniqueSenders.getSize() > 0) {
                for (String uniqueSender : uniqueSenders) {
                    cfConversation.addUniqueSender(uniqueSender.trim());
                }
            }
        }
        catch (Exception uniqueSenders) {
            // empty catch block
        }
        try {
            StringList uniqueUnreadSenders = conversation.getUniqueUnreadSenders();
            if (null != uniqueUnreadSenders && uniqueUnreadSenders.getSize() > 0) {
                for (String uniqueUnreadSender : uniqueUnreadSenders) {
                    cfConversation.addUniqueUnreadSender(uniqueUnreadSender.trim());
                }
            }
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
        try {
            cfConversation.setUnreadCount(conversation.getUnreadCount());
        }
        catch (ArgumentException argumentException) {
            // empty catch block
        }
        cfConversation.setConversation(conversation);
        return cfConversation;
    }

    public static ArrayList<CFConversation> filterConversations(List<CFConversation> cfConversations, CFConversationFilter filter) {
        ArrayList<CFConversation> filteredConversations = new ArrayList<CFConversation>();
        for (CFConversation cfConversation : cfConversations) {
            if (cfConversation.matchFilter(filter)) {
                filteredConversations.add(cfConversation);
            }
            if (filter.getMaxRows() == -1 || filteredConversations.size() != filter.getMaxRows()) continue;
            break;
        }
        return filteredConversations;
    }

    public static ExchangeMailMeeting createCFExchangeMailMeeting(Appointment associatedAppointment) {
        ExchangeMailMeeting mailMeeting = new ExchangeMailMeeting();
        EWSUtils.setAppointmentFields(associatedAppointment, mailMeeting);
        try {
            mailMeeting.setMeetingUID(associatedAppointment.getId().getUniqueId());
        }
        catch (ServiceLocalException serviceLocalException) {
            // empty catch block
        }
        return mailMeeting;
    }

    public static Date normalizeDate(String conversionType, Date date) {
        Map timeZoneInfo = DateUtils.getTimeZoneInfo((Date)date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Integer utcHourOffset = (Integer)timeZoneInfo.get("utcHourOffset");
        Integer utcMinOffset = (Integer)timeZoneInfo.get("utcMinuteOffset");
        if (null != utcHourOffset) {
            if (conversionType.equals("local2utc")) {
                cal.add(11, utcHourOffset);
            } else {
                cal.add(11, utcHourOffset * -1);
            }
        }
        if (null != utcMinOffset) {
            if (conversionType.equals("local2utc")) {
                cal.add(12, utcMinOffset);
            } else {
                cal.add(12, utcMinOffset * -1);
            }
        }
        return cal.getTime();
    }
}

