/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.microsoft.graph;

public enum QueryType {
    EQ("eq", FilterType.COMPARISON),
    NEQ("ne", FilterType.COMPARISON),
    LE("le", FilterType.COMPARISON),
    GE("ge", FilterType.COMPARISON),
    AND("and", FilterType.COMPARISON),
    OR("or", FilterType.COMPARISON),
    COLON(":", FilterType.SEARCH_COMPARISION),
    CONTAINS("contains", FilterType.FUNCTION),
    ANY("any", FilterType.LAMBDA_EXPRESSION);

    private final String name;
    private final FilterType filterType;

    private QueryType(String name, FilterType filterType) {
        this.name = name;
        this.filterType = filterType;
    }

    public String getQuery(String key, String value) {
        return this.getQuery(key, value, false);
    }

    public String getQuery(String key, String value, boolean isQuoted) {
        Object quotedValue = isQuoted ? "'" + value + "'" : value;
        return this.buildQuery(key, (String)quotedValue);
    }

    public String getQuery(String[] keyPath, String value, boolean isQuoted) {
        Object quotedValue = isQuoted ? "'" + value + "'" : value;
        String key = this.buildKey(keyPath);
        return this.buildQuery(key, (String)quotedValue);
    }

    private String buildQuery(String key, String value) {
        return switch (this.filterType) {
            default -> throw new IncompatibleClassChangeError();
            case FilterType.FUNCTION -> this.name + "(" + key + "," + value + ")";
            case FilterType.SEARCH_COMPARISION -> key + this.name + value;
            case FilterType.COMPARISON -> key + " " + this.name + " " + value;
            case FilterType.LAMBDA_EXPRESSION -> key + "/" + this.name + "(" + value + ")";
        };
    }

    private String buildKey(String[] keyPath) {
        StringBuilder keyBuilder = new StringBuilder();
        for (String key : keyPath) {
            keyBuilder.append(key).append("/");
        }
        return keyBuilder.length() > 0 ? keyBuilder.deleteCharAt(keyBuilder.length() - 1).toString() : keyBuilder.toString();
    }

    public String getSpaced() {
        return " " + this.name + " ";
    }

    private static enum FilterType {
        COMPARISON,
        SEARCH_COMPARISION,
        FUNCTION,
        LAMBDA_EXPRESSION;

    }
}

