/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.exchange.microsoft.graph;

import coldfusion.exchange.DeleteType;
import coldfusion.exchange.ExchangeAttachment;
import coldfusion.exchange.ExchangeFolder;
import coldfusion.exchange.ExchangeFolderExtendedInfo;
import coldfusion.exchange.ExchangeFolderInfo;
import coldfusion.exchange.ExchangeMailMeeting;
import coldfusion.exchange.ExchangeMessage;
import coldfusion.exchange.FolderFilterInfo;
import coldfusion.exchange.MessageFilterInfo;
import coldfusion.exchange.microsoft.graph.AbstractServiceManager;
import coldfusion.exchange.microsoft.graph.CalendarManager;
import coldfusion.exchange.microsoft.graph.GraphException;
import coldfusion.exchange.microsoft.graph.QueryType;
import coldfusion.exchange.webservice.CFConversation;
import coldfusion.exchange.webservice.CFConversationFilter;
import coldfusion.exchange.webservice.InternetHeaders;
import coldfusion.tagext.net.exchange.ExchangeExceptions;
import coldfusion.util.RB;
import com.microsoft.graph.core.content.BatchRequestContent;
import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.AttachmentCollectionResponse;
import com.microsoft.graph.models.BodyType;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.EventMessage;
import com.microsoft.graph.models.FileAttachment;
import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.MailFolder;
import com.microsoft.graph.models.MailFolderCollectionResponse;
import com.microsoft.graph.models.Message;
import com.microsoft.graph.models.MessageCollectionResponse;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.graph.users.item.mailfolders.item.copy.CopyPostRequestBody;
import com.microsoft.graph.users.item.mailfolders.item.move.MovePostRequestBody;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class MailManager
extends AbstractServiceManager {
    private static volatile MailManager instance = null;
    private final String SENSITIVITY_EXTENDED_PROPERTY_ID = "String {79942bfa-eb6d-40df-b0cf-911c338fcd59} Name Sensitivity";
    private final String QUERY_EXPANDER = "($filter=id eq 'String {79942bfa-eb6d-40df-b0cf-911c338fcd59} Name Sensitivity')";
    private final String MSG_FOLDER_ROOT = "msgfolderroot";
    private final String RECOVERABLE_ITEMS_DELETIONS = "recoverableitemsdeletions";
    private final String DELETED_ITEMS = "deleteditems";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static MailManager getInstance(GraphServiceClient graphServiceClient) {
        if (instance == null) {
            Class<MailManager> clazz = MailManager.class;
            // MONITORENTER : coldfusion.exchange.microsoft.graph.MailManager.class
            if (instance == null) {
                instance = new MailManager(graphServiceClient);
            }
            // MONITOREXIT : clazz
        }
        MailManager.instance.graphServiceClient = graphServiceClient;
        return instance;
    }

    private MailManager(GraphServiceClient graphServiceClient) {
        super(graphServiceClient);
    }

    public ArrayList<ExchangeMessage> getMessage(MessageFilterInfo filter) throws ReflectiveOperationException {
        ArrayList<ExchangeMessage> exchangeMessages = new ArrayList<ExchangeMessage>();
        String id = filter.getId();
        if (!this.isNullOrEmpty(id)) {
            this.splitCommaSeperatedString(id).forEach(uid -> {
                Message message = this.graphServiceClient.me().messages().byMessageId(uid).get(requestConfig -> {
                    requestConfig.queryParameters.expand = new String[]{"singleValueExtendedProperties($filter=id eq 'String {79942bfa-eb6d-40df-b0cf-911c338fcd59} Name Sensitivity')", "microsoft.graph.eventMessage/event($select=id)"};
                });
                exchangeMessages.add(this.getMessage(message));
            });
        } else {
            String filterParameter = this.getFilter(filter);
            String searchParameter = this.getSearchFilter(filter);
            int maxRows = filter.getMaxRows();
            ArrayList messageList = new ArrayList();
            if (maxRows == -1) {
                messages = this.getCollectionByFolderId(filter.getFolderId(), filter.getFolder(), filterParameter, new String[]{"singleValueExtendedProperties($filter=id eq 'String {79942bfa-eb6d-40df-b0cf-911c338fcd59} Name Sensitivity')", "microsoft.graph.eventMessage/event($select=id)"}, searchParameter, null);
                MailManager.iterateCollection(messageList, this.graphServiceClient, requestInfo -> {
                    if (filterParameter.length() > 0) {
                        requestInfo.addQueryParameter("%24filter", (Object)filterParameter);
                    }
                    if (searchParameter.length() > 0) {
                        requestInfo.addQueryParameter("%24search", (Object)searchParameter);
                    }
                    requestInfo.addQueryParameter("%24expand", (Object)new String[]{"singleValueExtendedProperties($filter=id eq 'String {79942bfa-eb6d-40df-b0cf-911c338fcd59} Name Sensitivity')", "microsoft.graph.eventMessage/event($select=id)"});
                    return requestInfo;
                }, messages, MessageCollectionResponse::createFromDiscriminatorValue);
            } else {
                messages = this.getCollectionByFolderId(filter.getFolderId(), filter.getFolder(), filterParameter, new String[]{"singleValueExtendedProperties($filter=id eq 'String {79942bfa-eb6d-40df-b0cf-911c338fcd59} Name Sensitivity')", "microsoft.graph.eventMessage/event($select=id)"}, searchParameter, maxRows);
                messageList.addAll(messages.getValue());
            }
            for (Message message : messageList) {
                exchangeMessages.add(this.getMessage(message));
            }
        }
        return exchangeMessages;
    }

    public void deleteMessages(String[] uids, String messageFolder) throws IOException {
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (String uid : uids) {
            if (messageFolder != null) {
                batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().mailFolders().byMailFolderId(this.resolveFolderPath(messageFolder, "/")).messages().byMessageId(uid).toDeleteRequestInformation());
                continue;
            }
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().messages().byMessageId(uid).toDeleteRequestInformation());
        }
        this.graphServiceClient.getBatchRequestBuilder().post(batchRequestContent, null);
    }

    public void modifyMessage(ExchangeMessage msg, String[] attachedFileNames, Object[] attachedFileContents) throws IOException {
        Message message = this.getMessage(msg);
        String folderId = Optional.ofNullable(msg.getFolderId()).orElse(msg.getFolder() != null ? this.resolveFolderPath(msg.getFolder(), "/") : null);
        String uid = msg.getId();
        if (folderId != null) {
            this.graphServiceClient.me().mailFolders().byMailFolderId(folderId).messages().byMessageId(uid).patch(message);
        } else {
            this.graphServiceClient.me().messages().byMessageId(uid).patch(message);
        }
        if (attachedFileNames != null && attachedFileContents != null) {
            List<Attachment> attachments = this.getGraphAttachments(attachedFileNames, attachedFileContents);
            for (Attachment attachment : attachments) {
                if (folderId != null) {
                    this.graphServiceClient.me().mailFolders().byMailFolderId(folderId).messages().byMessageId(uid).attachments().post(attachment);
                    continue;
                }
                this.graphServiceClient.me().messages().byMessageId(uid).attachments().post(attachment);
            }
        }
    }

    public ArrayList<ExchangeAttachment> getMessageAttachments(String uid, boolean getContent, String messageFolder) throws IOException {
        AttachmentCollectionResponse attachmentCollectionResponse = messageFolder != null ? this.graphServiceClient.me().mailFolders().byMailFolderId(this.resolveFolderPath(messageFolder, "/")).messages().byMessageId(uid).attachments().get() : this.graphServiceClient.me().messages().byMessageId(uid).attachments().get();
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        HashSet<String> requestIdSet = new HashSet<String>();
        for (Attachment attachment : attachmentCollectionResponse.getValue()) {
            requestIdSet.add(batchRequestContent.addBatchRequestStep(messageFolder != null ? this.graphServiceClient.me().mailFolders().byMailFolderId(this.resolveFolderPath(messageFolder, "/")).messages().byMessageId(uid).attachments().byAttachmentId(attachment.getId()).toGetRequestInformation() : this.graphServiceClient.me().messages().byMessageId(uid).attachments().byAttachmentId(attachment.getId()).toGetRequestInformation()));
        }
        BatchResponseContent batchResponseContent = this.executeBatchOperation(batchRequestContent);
        ArrayList<ExchangeAttachment> attachments = new ArrayList<ExchangeAttachment>();
        for (String requestId : requestIdSet) {
            Attachment attachment = (Attachment)batchResponseContent.getResponseById(requestId, Attachment::createFromDiscriminatorValue);
            attachments.add(this.getExchangeAttachment(attachment.getId(), attachment.getSize(), attachment.getName(), attachment.getContentType(), ((FileAttachment)attachment).getContentBytes()));
        }
        return attachments;
    }

    public void deleteMessageAttachments(String uid, String[] fileNames, String messageFolder) throws IOException {
        AttachmentCollectionResponse attachmentCollectionResponse = messageFolder != null ? this.graphServiceClient.me().mailFolders().byMailFolderId(this.resolveFolderPath(messageFolder, "/")).messages().byMessageId(uid).attachments().get(requestConfig -> this.getFilterToDeleteAttachments(fileNames).ifPresent(filter -> {
            requestConfig.queryParameters.filter = filter;
        })) : this.graphServiceClient.me().messages().byMessageId(uid).attachments().get(requestConfig -> this.getFilterToDeleteAttachments(fileNames).ifPresent(filter -> {
            requestConfig.queryParameters.filter = filter;
        }));
        for (Attachment attachment : attachmentCollectionResponse.getValue()) {
            this.graphServiceClient.me().messages().byMessageId(uid).attachments().byAttachmentId(attachment.getId()).delete();
        }
    }

    public ArrayList<ExchangeMailMeeting> getMessageMeetingInfo(String meetingUID, String mailUID) {
        Event event;
        ArrayList<ExchangeMailMeeting> mailMeetingsList = new ArrayList<ExchangeMailMeeting>();
        try {
            if (this.isNullOrEmpty(meetingUID)) {
                throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.mailNotAssociatedWithMeetingUID", (Object)mailUID));
            }
            event = this.graphServiceClient.me().events().byEventId(meetingUID).get();
        }
        catch (Exception ex) {
            if (mailUID != null) {
                Message message = this.graphServiceClient.me().messages().byMessageId(mailUID).get(requestConfiguration -> {
                    requestConfiguration.queryParameters.expand = new String[]{"microsoft.graph.eventMessage/event"};
                });
                if (!(message instanceof EventMessage)) {
                    throw new GraphException(RB.getString((Object)this, (String)"GraphConnection.mailNotAMeetingMessage", (Object)mailUID));
                }
                event = ((EventMessage)message).getEvent();
                meetingUID = event.getId();
            }
            throw ex;
        }
        ExchangeMailMeeting mailMeeting = (ExchangeMailMeeting)CalendarManager.getInstance(this.graphServiceClient).createCFEvent(event);
        mailMeeting.setMeetingUID(meetingUID);
        mailMeeting.setId(mailUID);
        mailMeetingsList.add(mailMeeting);
        return mailMeetingsList;
    }

    public void moveMessages(MessageFilterInfo filter, String destinationFolder) throws ReflectiveOperationException, IOException {
        ArrayList messageList = new ArrayList();
        String id = filter.getId();
        if (id != null && !id.trim().isEmpty()) {
            this.splitCommaSeperatedString(id).forEach(uid -> {
                Message message = this.graphServiceClient.me().messages().byMessageId(uid).get();
                messageList.add(message);
            });
        } else {
            String filterParameter = this.getFilter(filter);
            String searchParameter = this.getSearchFilter(filter);
            int maxRows = filter.getMaxRows();
            if (maxRows == -1) {
                messages = this.getCollectionByFolderId(filter.getFolderId(), filter.getFolder(), filterParameter, new String[0], searchParameter, null);
                MailManager.iterateCollection(messageList, this.graphServiceClient, requestInfo -> {
                    if (filterParameter.length() > 0) {
                        requestInfo.addQueryParameter("%24filter", (Object)filterParameter);
                    }
                    if (searchParameter.length() > 0) {
                        requestInfo.addQueryParameter("%24search", (Object)searchParameter);
                    }
                    return requestInfo;
                }, messages, MessageCollectionResponse::createFromDiscriminatorValue);
            } else {
                messages = this.getCollectionByFolderId(filter.getFolderId(), filter.getFolder(), filterParameter, new String[0], searchParameter, maxRows);
                messageList.addAll(messages.getValue());
            }
        }
        com.microsoft.graph.users.item.messages.item.move.MovePostRequestBody movePostRequestBody = new com.microsoft.graph.users.item.messages.item.move.MovePostRequestBody();
        movePostRequestBody.setDestinationId(this.resolveFolderPath(destinationFolder, "/"));
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (Message message : messageList) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().messages().byMessageId(message.getId()).move().toPostRequestInformation(movePostRequestBody));
        }
        this.graphServiceClient.getBatchRequestBuilder().post(batchRequestContent, null);
    }

    public void createFolder(String parentFolderId, ExchangeFolderExtendedInfo folder) {
        MailFolder mailFolder = this.getFolder(folder);
        MailFolder postedMailFolder = parentFolderId != null ? this.graphServiceClient.me().mailFolders().byMailFolderId(parentFolderId).childFolders().post(mailFolder) : this.graphServiceClient.me().mailFolders().post(mailFolder);
        folder.setId(postedMailFolder.getId());
    }

    private String resolveFolderPath(String path, String seperator) {
        String[] folderNames = path.split(seperator);
        String folderId = "msgfolderroot";
        for (String folderName : folderNames) {
            MailFolderCollectionResponse mailFolderCollectionResponse = this.graphServiceClient.me().mailFolders().byMailFolderId(folderId).childFolders().get(requestConfigurator -> {
                requestConfigurator.queryParameters.filter = "displayName eq '" + folderName + "'";
                requestConfigurator.queryParameters.select = new String[]{"displayName"};
            });
            if (mailFolderCollectionResponse.getValue().size() == 0) {
                return folderName;
            }
            folderId = ((MailFolder)mailFolderCollectionResponse.getValue().get(0)).getId();
        }
        return folderId;
    }

    private MailFolder getMinimalMailFolderDetails(String folderId) {
        return this.graphServiceClient.me().mailFolders().byMailFolderId(folderId).get(requestConfigurator -> {
            requestConfigurator.queryParameters.select = new String[]{"parentFolderId", "displayName"};
        });
    }

    private String resolveFolderId(String id) {
        MailFolder mailFolder = this.getMinimalMailFolderDetails("msgfolderroot");
        String rootFolderId = mailFolder.getId();
        StringBuilder folderPath = new StringBuilder();
        while (!rootFolderId.equalsIgnoreCase(id) && !"msgfolderroot".equalsIgnoreCase(id)) {
            mailFolder = this.getMinimalMailFolderDetails(id);
            folderPath.insert(0, "/" + mailFolder.getDisplayName());
            id = mailFolder.getParentFolderId();
        }
        return folderPath.length() > 0 ? folderPath.substring(1) : "";
    }

    public ExchangeFolder getFolderInfo(String folderIdentifier, boolean needsResolution, String pathSeparatorRegex, Boolean withExtendedInfo) {
        if (needsResolution) {
            folderIdentifier = this.resolveFolderPath(folderIdentifier, pathSeparatorRegex);
        }
        return this.getFolder(this.graphServiceClient.me().mailFolders().byMailFolderId(folderIdentifier).get(), withExtendedInfo);
    }

    public ArrayList<ExchangeFolder> getChildFolders(String parentFolderId, FolderFilterInfo filter) throws ReflectiveOperationException {
        List<MailFolder> mailFolderList = this.getSubFolders(parentFolderId, filter);
        ArrayList<ExchangeFolder> exchangeFolders = new ArrayList<ExchangeFolder>();
        for (MailFolder mailFolder : mailFolderList) {
            exchangeFolders.add(this.getFolder(mailFolder));
        }
        return exchangeFolders;
    }

    private List<MailFolder> getSubFolders(String parentFolderId, FolderFilterInfo filter) throws ReflectiveOperationException {
        LinkedList<MailFolder> mailFolderList = new LinkedList<MailFolder>();
        String filterParameter = this.getFilter(filter);
        int maxRows = filter.getMaxRows();
        if (maxRows == -1) {
            MailFolderCollectionResponse mailFolders = this.graphServiceClient.me().mailFolders().byMailFolderId(parentFolderId).childFolders().get(requestConfiguration -> {
                requestConfiguration.queryParameters.filter = filterParameter;
            });
            MailManager.iterateCollection(mailFolderList, this.graphServiceClient, requestInfo -> {
                if (filterParameter.length() > 0) {
                    requestInfo.addQueryParameter("%24filter", (Object)filterParameter);
                }
                return requestInfo;
            }, mailFolders, MailFolderCollectionResponse::createFromDiscriminatorValue);
        } else {
            MailFolderCollectionResponse mailFolders = this.graphServiceClient.me().mailFolders().byMailFolderId(parentFolderId).childFolders().get(requestConfiguration -> {
                if (filterParameter.length() > 0) {
                    requestConfiguration.queryParameters.filter = filterParameter;
                }
                requestConfiguration.queryParameters.top = maxRows;
            });
            mailFolderList.addAll(mailFolders.getValue());
        }
        return mailFolderList;
    }

    public ArrayList<ExchangeFolderInfo> getChildFolders(String folderId, boolean recurse) throws ReflectiveOperationException {
        folderId = this.isNullOrEmpty(folderId) ? "msgfolderroot" : folderId;
        String folderName = this.resolveFolderId(folderId);
        return this.getChildFolders(folderId, folderName, recurse);
    }

    public ArrayList<ExchangeFolderInfo> getChildFolders(String folderId, String folderName, boolean recurse) throws ReflectiveOperationException {
        List<MailFolder> mailFolderList = this.getSubFolders(folderId, new FolderFilterInfo());
        ArrayList<ExchangeFolderInfo> exchangeFolders = new ArrayList<ExchangeFolderInfo>();
        for (MailFolder mailFolder : mailFolderList) {
            ExchangeFolderInfo folderInfo = new ExchangeFolderInfo();
            folderInfo.setFolderName(mailFolder.getDisplayName());
            String folderPath = folderName.trim().length() > 0 ? folderName + "/" + mailFolder.getDisplayName() : mailFolder.getDisplayName();
            folderInfo.setFolderPath(folderPath);
            if (recurse && mailFolder.getChildFolderCount() > 0) {
                folderInfo.setSubFolders(this.getChildFolders(mailFolder.getId(), folderPath, recurse));
            }
            exchangeFolders.add(folderInfo);
        }
        return exchangeFolders;
    }

    public String copyFolder(String sourceFolderId, String destinationFolderId) {
        CopyPostRequestBody copyPostRequestBody = new CopyPostRequestBody();
        copyPostRequestBody.setDestinationId(destinationFolderId);
        MailFolder copiedFolder = this.graphServiceClient.me().mailFolders().byMailFolderId(sourceFolderId).copy().post(copyPostRequestBody);
        return copiedFolder.getId();
    }

    public String moveFolder(String sourceFolderId, String destinationFolderId) {
        MovePostRequestBody movePostRequestBody = new MovePostRequestBody();
        movePostRequestBody.setDestinationId(destinationFolderId);
        MailFolder copiedFolder = this.graphServiceClient.me().mailFolders().byMailFolderId(sourceFolderId).move().post(movePostRequestBody);
        return copiedFolder.getId();
    }

    public void deleteFolder(String[] folderIds, DeleteType type) throws IOException {
        for (String folderId : folderIds) {
            if (type == DeleteType.MoveToDeletedItems) {
                this.moveFolder(folderId, "deleteditems");
                continue;
            }
            this.graphServiceClient.me().mailFolders().byMailFolderId(folderId).delete();
        }
    }

    public void updateFolder(String folderId, ExchangeFolderExtendedInfo folder) {
        MailFolder mailFolder = this.getFolder(folder);
        this.graphServiceClient.me().mailFolders().byMailFolderId(folderId).patch(mailFolder);
    }

    public ArrayList<CFConversation> getConversations(String folderId, CFConversationFilter filter) {
        ArrayList<CFConversation> conversationList = new ArrayList<CFConversation>();
        return conversationList;
    }

    private List<Message> getMessagesIdInAFolder(String conversationFolderId, String conversationId) throws ReflectiveOperationException {
        if (this.isNullOrEmpty(conversationId)) {
            ExchangeExceptions.throwInvalidAttributeValueException("UID");
        }
        ArrayList<Message> messageList = new ArrayList<Message>();
        MessageCollectionResponse messages = this.graphServiceClient.me().mailFolders().byMailFolderId(conversationFolderId).messages().get(requestConfig -> {
            requestConfig.queryParameters.filter = "conversationId eq '" + conversationId + "'";
            requestConfig.queryParameters.select = new String[]{"id"};
        });
        MailManager.iterateCollection(messageList, this.graphServiceClient, requestInfo -> {
            requestInfo.addQueryParameter("%24filter", (Object)("conversationId eq '" + conversationId + "'"));
            requestInfo.addQueryParameter("%24search", (Object)new String[]{"id"});
            return requestInfo;
        }, messages, MessageCollectionResponse::createFromDiscriminatorValue);
        return messageList;
    }

    public void setReadStateToConversations(String conversationFolderId, String conversationId, boolean read) throws IOException, ReflectiveOperationException {
        Message message = new Message();
        message.setIsRead(Boolean.valueOf(read));
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (Message conversationMessage : this.getMessagesIdInAFolder(conversationFolderId, conversationId)) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().mailFolders().byMailFolderId(conversationFolderId).messages().byMessageId(conversationMessage.getId()).toPatchRequestInformation(message));
        }
        this.executeBatchOperation(batchRequestContent);
    }

    public void copyConversations(String conversationFolderId, String destinationFolderId, String conversationId) throws ReflectiveOperationException, IOException {
        com.microsoft.graph.users.item.messages.item.copy.CopyPostRequestBody copyPostRequestBody = new com.microsoft.graph.users.item.messages.item.copy.CopyPostRequestBody();
        copyPostRequestBody.setDestinationId(destinationFolderId);
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (Message message : this.getMessagesIdInAFolder(conversationFolderId, conversationId)) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().messages().byMessageId(message.getId()).copy().toPostRequestInformation(copyPostRequestBody));
        }
        this.executeBatchOperation(batchRequestContent);
    }

    public void moveConversations(String conversationFolderId, String destinationFolderId, String conversationId) throws ReflectiveOperationException, IOException {
        com.microsoft.graph.users.item.messages.item.move.MovePostRequestBody movePostRequestBody = new com.microsoft.graph.users.item.messages.item.move.MovePostRequestBody();
        movePostRequestBody.setDestinationId(destinationFolderId);
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        for (Message message : this.getMessagesIdInAFolder(conversationFolderId, conversationId)) {
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().messages().byMessageId(message.getId()).move().toPostRequestInformation(movePostRequestBody));
        }
        this.executeBatchOperation(batchRequestContent);
    }

    public void deleteConversations(String conversationFolderId, String conversationId, DeleteType deleteType) throws ReflectiveOperationException, IOException {
        BatchRequestContent batchRequestContent = new BatchRequestContent((IBaseClient)this.graphServiceClient);
        block4: for (Message message : this.getMessagesIdInAFolder(conversationFolderId, conversationId)) {
            switch (deleteType) {
                case SoftDelete: {
                    com.microsoft.graph.users.item.messages.item.move.MovePostRequestBody movePostRequestBody = new com.microsoft.graph.users.item.messages.item.move.MovePostRequestBody();
                    movePostRequestBody.setDestinationId("recoverableitemsdeletions");
                    batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().messages().byMessageId(message.getId()).move().toPostRequestInformation(movePostRequestBody));
                    continue block4;
                }
                case HardDelete: {
                    batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().messages().byMessageId(message.getId()).toDeleteRequestInformation());
                }
            }
            batchRequestContent.addBatchRequestStep(this.graphServiceClient.me().messages().byMessageId(message.getId()).toDeleteRequestInformation());
        }
        this.executeBatchOperation(batchRequestContent);
    }

    private ExchangeFolder getFolder(MailFolder mailFolder) {
        return this.getFolder(mailFolder, false);
    }

    private ExchangeFolder getFolder(MailFolder mailFolder, Boolean withExtendedInfo) {
        ExchangeFolder exchangeFolder = withExtendedInfo != false ? new ExchangeFolderExtendedInfo() : new ExchangeFolder();
        exchangeFolder.setChildFolderCount(mailFolder.getChildFolderCount());
        exchangeFolder.setDisplayName(mailFolder.getDisplayName());
        exchangeFolder.setId(mailFolder.getId());
        exchangeFolder.setParentFolderId(mailFolder.getParentFolderId());
        exchangeFolder.setTotalCount(mailFolder.getTotalItemCount());
        exchangeFolder.setUnreadCount(mailFolder.getUnreadItemCount());
        exchangeFolder.setFolderPath(this.resolveFolderId(mailFolder.getId()));
        return exchangeFolder;
    }

    private String getFilter(FolderFilterInfo filter) {
        StringBuilder filterBuilder = new StringBuilder();
        if (filter.getFromChildFolderCount() != -1) {
            filterBuilder.append(QueryType.GE.getQuery("childFolderCount", String.valueOf(filter.getFromChildFolderCount())));
        }
        if (filter.getToChildFolderCount() != -1) {
            filterBuilder.append(QueryType.LE.getQuery("childFolderCount", String.valueOf(filter.getToChildFolderCount())));
        }
        this.setIfPresent(filter.getDisplayName(), value -> QueryType.CONTAINS.getQuery("displayName", (String)value, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        if (filter.getFromTotalCount() != -1) {
            filterBuilder.append(QueryType.GE.getQuery("totalItemCount", String.valueOf(filter.getFromTotalCount())));
        }
        if (filter.getToTotalCount() != -1) {
            filterBuilder.append(QueryType.LE.getQuery("totalItemCount", String.valueOf(filter.getToTotalCount())));
        }
        if (filter.getFromUnreadCount() != -1) {
            filterBuilder.append(QueryType.GE.getQuery("unreadItemCount", String.valueOf(filter.getFromUnreadCount())));
        }
        if (filter.getToUnreadCount() != -1) {
            filterBuilder.append(QueryType.LE.getQuery("unreadItemCount", String.valueOf(filter.getToUnreadCount())));
        }
        return filterBuilder.length() > 0 ? this.trimAnd(filterBuilder.toString()) : filterBuilder.toString();
    }

    private MailFolder getFolder(ExchangeFolderExtendedInfo folder) {
        MailFolder mailFolder = new MailFolder();
        mailFolder.setDisplayName(folder.getDisplayName());
        return mailFolder;
    }

    private MessageCollectionResponse getCollectionByFolderId(String folderId, String folderPath, String filter, String[] expand, String search, Integer top) {
        if ((folderId = (String)Optional.ofNullable(folderId).orElse(folderPath != null ? this.resolveFolderPath(folderPath, "/") : null)) != null) {
            return this.graphServiceClient.me().mailFolders().byMailFolderId(folderId).messages().get(requestConfiguration -> {
                if (filter.length() > 0) {
                    requestConfiguration.queryParameters.filter = filter;
                }
                if (expand.length > 0) {
                    requestConfiguration.queryParameters.expand = expand;
                }
                if (search.length() > 0) {
                    requestConfiguration.queryParameters.search = search;
                }
                if (top != null) {
                    requestConfiguration.queryParameters.top = top;
                }
            });
        }
        return this.graphServiceClient.me().messages().get(requestConfiguration -> {
            if (filter.length() > 0) {
                requestConfiguration.queryParameters.filter = filter;
            }
            if (expand.length > 0) {
                requestConfiguration.queryParameters.expand = expand;
            }
            if (search.length() > 0) {
                requestConfiguration.queryParameters.search = search;
            }
            if (top != null) {
                requestConfiguration.queryParameters.top = top;
            }
        });
    }

    private ExchangeMessage getMessage(Message message) {
        Importance importance;
        String recipients;
        ExchangeMessage exchangeMessage = new ExchangeMessage();
        exchangeMessage.setId(message.getId());
        exchangeMessage.setFolder(this.resolveFolderId(message.getParentFolderId()));
        if (message.getFrom() != null && message.getFrom().getEmailAddress() != null) {
            exchangeMessage.setFromId(message.getFrom().getEmailAddress().getAddress());
        }
        if (message.getReceivedDateTime() != null) {
            exchangeMessage.setTimeReceived(Date.from(message.getReceivedDateTime().atZoneSameInstant(ZoneId.systemDefault()).toInstant()));
        }
        if (message.getSentDateTime() != null) {
            exchangeMessage.setTimeSent(Date.from(message.getSentDateTime().atZoneSameInstant(ZoneId.systemDefault()).toInstant()));
        }
        List recipientsList = message.getToRecipients();
        StringBuilder recipientsBuilder = new StringBuilder();
        if (recipientsList != null) {
            for (Object recipient : recipientsList) {
                if (recipient == null || recipient.getEmailAddress() == null || recipient.getEmailAddress().getAddress() == null || recipient.getEmailAddress().getAddress().length() <= 0) continue;
                recipientsBuilder.append(recipient.getEmailAddress().getAddress()).append(",");
            }
        }
        if ((recipients = recipientsBuilder.toString()).length() > 0) {
            exchangeMessage.setToId(recipients.substring(0, recipients.length() - 1));
        }
        recipientsList = message.getCcRecipients();
        recipientsBuilder = new StringBuilder();
        if (recipientsList != null) {
            for (Recipient recipient : recipientsList) {
                if (recipient == null || recipient.getEmailAddress() == null || recipient.getEmailAddress().getAddress() == null || recipient.getEmailAddress().getAddress().length() <= 0) continue;
                recipientsBuilder.append(recipient.getEmailAddress().getAddress()).append(",");
            }
        }
        if ((recipients = recipientsBuilder.toString()).length() > 0) {
            exchangeMessage.setCc(recipients.substring(0, recipients.length() - 1));
        }
        recipientsList = message.getBccRecipients();
        recipientsBuilder = new StringBuilder();
        if (recipientsList != null) {
            for (Recipient recipient : recipientsList) {
                if (recipient == null || recipient.getEmailAddress() == null || recipient.getEmailAddress().getAddress() == null || recipient.getEmailAddress().getAddress().length() <= 0) continue;
                recipientsBuilder.append(recipient.getEmailAddress().getAddress()).append(",");
            }
        }
        if ((recipients = recipientsBuilder.toString()).length() > 0) {
            exchangeMessage.setBcc(recipients.substring(0, recipients.length() - 1));
        }
        exchangeMessage.setSubject(message.getSubject());
        ItemBody itemBody = message.getBody();
        if (itemBody != null) {
            switch (itemBody.getContentType()) {
                case Html: {
                    exchangeMessage.setHtmlMessage(itemBody.getContent());
                    break;
                }
                default: {
                    exchangeMessage.setMessage(itemBody.getContent());
                }
            }
        }
        if ((importance = message.getImportance()) != null) {
            exchangeMessage.setImportance(importance.getValue());
        }
        exchangeMessage.setRead(message.getIsRead());
        exchangeMessage.setHasAttachment(message.getHasAttachments());
        if (message.getInternetMessageHeaders() != null && message.getInternetMessageHeaders().size() > 0) {
            InternetHeaders internetHeaders = new InternetHeaders();
            List internetMessageHeaderList = message.getInternetMessageHeaders();
            internetMessageHeaderList.forEach(header -> internetHeaders.addHeader(header.getName(), new String[]{header.getValue()}));
            exchangeMessage.setHeaders(internetHeaders);
        }
        if (message instanceof EventMessage) {
            exchangeMessage.setMeetingUID(((EventMessage)message).getEvent().getId());
            switch (((EventMessage)message).getMeetingMessageType()) {
                case MeetingRequest: {
                    exchangeMessage.setMessageType(3);
                    break;
                }
                case MeetingAccepted: {
                    exchangeMessage.setMessageType(4);
                    exchangeMessage.setMeetingResponseType("Accept");
                    break;
                }
                case MeetingTenativelyAccepted: {
                    exchangeMessage.setMessageType(4);
                    exchangeMessage.setMeetingResponseType("Tentative");
                    break;
                }
                case MeetingDeclined: {
                    exchangeMessage.setMessageType(4);
                    exchangeMessage.setMeetingResponseType("Decline");
                    break;
                }
                case MeetingCancelled: {
                    exchangeMessage.setMessageType(5);
                    exchangeMessage.setMeetingResponseType("Cancel");
                    break;
                }
                case None: {
                    exchangeMessage.setMessageType(0);
                    break;
                }
                default: {
                    exchangeMessage.setMessageType(0);
                    break;
                }
            }
        } else {
            exchangeMessage.setMessageType(1);
        }
        return exchangeMessage;
    }

    private Message getMessage(ExchangeMessage exchangeMessage) {
        LinkedList<Recipient> recipientList;
        Message message = new Message();
        this.setIfPresent(exchangeMessage.getFromId(), id -> message.setFrom(this.getRecipient((String)id)));
        if (exchangeMessage.getCc() != null) {
            List<String> ccAddresses = this.splitCommaSeperatedString(exchangeMessage.getCc());
            recipientList = new LinkedList<Recipient>();
            for (String address : ccAddresses) {
                recipientList.add(this.getRecipient(address));
            }
            message.setCcRecipients(recipientList);
        }
        if (exchangeMessage.getBcc() != null) {
            List<String> bccAddresses = this.splitCommaSeperatedString(exchangeMessage.getBcc());
            recipientList = new LinkedList();
            for (String address : bccAddresses) {
                recipientList.add(this.getRecipient(address));
            }
            message.setBccRecipients(recipientList);
        }
        if (exchangeMessage.getToId() != null) {
            List<String> toAddresses = this.splitCommaSeperatedString(exchangeMessage.getToId());
            recipientList = new LinkedList();
            for (String address : toAddresses) {
                recipientList.add(this.getRecipient(address));
            }
            message.setToRecipients(recipientList);
        }
        this.setIfPresent(exchangeMessage.getMessage(), messageBody -> this.createItemBody(BodyType.Text, (String)messageBody), arg_0 -> ((Message)message).setBody(arg_0));
        this.setIfPresent(exchangeMessage.getHtmlMessage(), messageBody -> this.createItemBody(BodyType.Html, (String)messageBody), arg_0 -> ((Message)message).setBody(arg_0));
        this.setIfPresent(exchangeMessage.getSubject(), arg_0 -> ((Message)message).setSubject(arg_0));
        this.setIfPresent(exchangeMessage.isRead(), arg_0 -> ((Message)message).setIsRead(arg_0));
        this.setIfPresent(exchangeMessage.getImportance(), importanceValue -> Importance.forValue((String)importanceValue.toLowerCase()), arg_0 -> ((Message)message).setImportance(arg_0));
        this.setIfPresent(exchangeMessage.getSensitivity(), sensitivityValue -> this.createSingleValueExtendedProperty("String {79942bfa-eb6d-40df-b0cf-911c338fcd59} Name Sensitivity", (String)sensitivityValue), extendedProperty -> message.setSingleValueExtendedProperties(new ArrayList<SingleValueLegacyExtendedProperty>(Set.of(extendedProperty))));
        return message;
    }

    private String getSearchFilter(MessageFilterInfo filter) {
        StringBuilder filterBuilder = new StringBuilder();
        String EXTENDED_OR = " OR  ";
        this.setIfPresent(filter.getCc(), cc -> {
            StringBuilder ccBuilder = new StringBuilder();
            for (String value : this.splitCommaSeperatedString((String)cc)) {
                ccBuilder.append(QueryType.COLON.getQuery("cc", value)).append(QueryType.AND.getSpaced());
            }
            return ccBuilder.toString();
        }, filterBuilder::append);
        this.setIfPresent(filter.getBcc(), bcc -> {
            StringBuilder bccBuilder = new StringBuilder();
            for (String value : this.splitCommaSeperatedString((String)bcc)) {
                bccBuilder.append(QueryType.COLON.getQuery("bcc", value)).append(QueryType.AND.getSpaced());
            }
            return bccBuilder.toString();
        }, filterBuilder::append);
        this.setIfPresent(filter.getToId(), toId -> {
            StringBuilder toIdBuilder = new StringBuilder();
            for (String value : this.splitCommaSeperatedString((String)toId)) {
                toIdBuilder.append(QueryType.COLON.getQuery("to", value)).append(QueryType.AND.getSpaced());
            }
            return toIdBuilder.toString();
        }, filterBuilder::append);
        this.setIfPresent(filter.getFromId(), fromId -> {
            StringBuilder fromIdBuilder = new StringBuilder();
            for (String value : this.splitCommaSeperatedString((String)fromId)) {
                fromIdBuilder.append(QueryType.COLON.getQuery("from", value)).append(EXTENDED_OR);
            }
            return fromIdBuilder.length() > 0 ? this.trimAnd(fromIdBuilder.toString()) + QueryType.AND.getSpaced() : "";
        }, filterBuilder::append);
        this.setIfPresent(filter.getSubject(), subject -> QueryType.COLON.getQuery("subject", (String)subject), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getImportance(), importance -> QueryType.COLON.getQuery("importance", Importance.forValue((String)importance.toLowerCase()) != null ? filter.getImportance() : Importance.Normal.value), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        return filterBuilder.length() > 0 ? "\"" + this.trimAnd(filterBuilder.toString()) + "\"" : "";
    }

    private String getFilter(MessageFilterInfo filter) {
        StringBuilder filterBuilder = new StringBuilder();
        this.setIfPresent(filter.getMessageType(), messageType -> switch (messageType) {
            case 3 -> QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingRequest", true);
            case 4 -> {
                String queryA = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingAccepted", true);
                String queryB = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingTenativelyAccepted", true);
                String queryC = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingDeclined", true);
                yield QueryType.OR.getQuery(QueryType.OR.getQuery(queryA, queryB), queryC);
            }
            case 5 -> QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingCancelled", true);
            case 2 -> {
                String queryA = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingAccepted", true);
                String queryB = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingTenativelyAccepted", true);
                String queryC = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingDeclined", true);
                String queryD = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingRequest", true);
                String queryE = QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "meetingCancelled", true);
                yield QueryType.OR.getQuery(QueryType.OR.getQuery(QueryType.OR.getQuery(queryA, queryB), QueryType.OR.getQuery(queryC, queryD)), queryE);
            }
            case 1 -> QueryType.EQ.getQuery("microsoft.graph.eventMessage/meetingMessageType", "none", true);
            default -> null;
        }, value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getMessage() != null ? filter.getMessage() : filter.getHtmlMessage(), message -> QueryType.CONTAINS.getQuery(new String[]{"body", "content"}, (String)message, true), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromTimeReceived(), receivedDateTime -> QueryType.GE.getQuery("receivedDateTime", this.getDateStringISOWithOffset((Date)receivedDateTime)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToTimeReceived(), receivedDateTime -> QueryType.LE.getQuery("receivedDateTime", this.getDateStringISOWithOffset((Date)receivedDateTime)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromTimeSent(), sentDateTime -> QueryType.GE.getQuery("sentDateTime", this.getDateStringISOWithOffset((Date)sentDateTime)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToTimeSent(), sentDateTime -> QueryType.LE.getQuery("sentDateTime", this.getDateStringISOWithOffset((Date)sentDateTime)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getFromLastModifiedDate(), lastModifiedDate -> QueryType.GE.getQuery("lastModifiedDateTime", this.getDateStringISOWithOffset((Date)lastModifiedDate)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getToLastModifiedDate(), lastModifiedDate -> QueryType.LE.getQuery("lastModifiedDateTime", this.getDateStringISOWithOffset((Date)lastModifiedDate)), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.isRead(), isRead -> QueryType.EQ.getQuery("isRead", isRead.toString()), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        this.setIfPresent(filter.getHasAttachment(), hasAttachments -> QueryType.EQ.getQuery("hasAttachments", hasAttachments.toString()), value -> filterBuilder.append((String)value).append(QueryType.AND.getSpaced()));
        return filterBuilder.length() > 0 ? this.trimAnd(filterBuilder.toString()) : "";
    }
}

