/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.syndication;

import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Struct;
import coldfusion.sql.QueryTable;
import coldfusion.syndication.FeedGenerator;
import com.rometools.rome.feed.atom.Category;
import com.rometools.rome.feed.atom.Content;
import com.rometools.rome.feed.atom.Entry;
import com.rometools.rome.feed.atom.Feed;
import com.rometools.rome.feed.atom.Generator;
import com.rometools.rome.feed.atom.Link;
import com.rometools.rome.feed.atom.Person;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class AtomGenerator
extends Feed {
    public void createATOMFeed(Struct feedStruct, String feedType) {
        this.setFeedType(feedType);
        this.setFeedMetadata(feedStruct);
        Object entryObj = feedStruct.get((Object)"entry");
        if (entryObj != null) {
            if (!(entryObj instanceof Array)) {
                throw new FeedGenerator.InvalidAttributeTypeException("entry", "Array");
            }
            Array entriesArray = (Array)entryObj;
            if (entriesArray != null) {
                ArrayList<Entry> entries = new ArrayList<Entry>();
                Iterator it = entriesArray.iterator();
                while (it.hasNext()) {
                    Object contentsObj;
                    Object summaryObj;
                    Object linkObj;
                    Object contributorObj;
                    Object authorObj;
                    Entry entry = new Entry();
                    Object obj = it.next();
                    if (!(obj instanceof Struct)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("entry", "Struct");
                    }
                    Struct entryStruct = (Struct)obj;
                    entry.setXmlBase(FeedGenerator.getString(entryStruct, "xmlbase"));
                    entry.setId(FeedGenerator.getString(entryStruct, "id"));
                    entry.setRights(FeedGenerator.getString(entryStruct, "rights"));
                    Object titleObj = entryStruct.get((Object)"title");
                    if (titleObj != null) {
                        if (!(titleObj instanceof Struct)) {
                            throw new FeedGenerator.InvalidAttributeTypeException("title", "Struct");
                        }
                        Struct titleStruct = (Struct)titleObj;
                        Content title = new Content();
                        title.setSrc(FeedGenerator.getString(titleStruct, "src"));
                        title.setType(FeedGenerator.getString(titleStruct, "type"));
                        title.setValue(FeedGenerator.getString(titleStruct, "value"));
                        entry.setTitleEx(title);
                    }
                    entry.setUpdated(FeedGenerator.getDate(entryStruct, "updated"));
                    entry.setCreated(FeedGenerator.getDate(entryStruct, "created"));
                    entry.setPublished(FeedGenerator.getDate(entryStruct, "published"));
                    Object categoryObj = entryStruct.get((Object)"category");
                    if (categoryObj != null) {
                        if (!(categoryObj instanceof Array)) {
                            throw new FeedGenerator.InvalidAttributeTypeException("category", "Array");
                        }
                        Array categoriesArray = (Array)categoryObj;
                        if (categoriesArray != null) {
                            ArrayList<Category> categories = new ArrayList<Category>();
                            for (Object obj1 : categoriesArray) {
                                if (!(obj1 instanceof Struct)) {
                                    throw new FeedGenerator.InvalidAttributeTypeException("category", "Struct");
                                }
                                Struct categoryStruct = (Struct)obj1;
                                Category atomCategory = new Category();
                                atomCategory.setLabel(FeedGenerator.getString(categoryStruct, "label"));
                                atomCategory.setScheme(FeedGenerator.getString(categoryStruct, "scheme").trim());
                                atomCategory.setTerm(FeedGenerator.getString(categoryStruct, "term"));
                                categories.add(atomCategory);
                            }
                            if (categories.size() > 0) {
                                entry.setCategories(categories);
                            }
                        }
                    }
                    if ((authorObj = entryStruct.get((Object)"author")) != null) {
                        if (!(authorObj instanceof Array)) {
                            throw new FeedGenerator.InvalidAttributeTypeException("author", "Array");
                        }
                        Array authorsArray = (Array)entryStruct.get((Object)"author");
                        if (authorsArray != null) {
                            ArrayList<Person> authors = new ArrayList<Person>();
                            for (Object obj1 : authorsArray) {
                                if (!(obj1 instanceof Struct)) {
                                    throw new FeedGenerator.InvalidAttributeTypeException("author", "Struct");
                                }
                                Struct authorStruct = (Struct)obj1;
                                Person author = new Person();
                                author.setEmail(FeedGenerator.getString(authorStruct, "email"));
                                author.setName(FeedGenerator.getString(authorStruct, "name"));
                                author.setUri(FeedGenerator.getString(authorStruct, "uri"));
                                authors.add(author);
                            }
                            if (authors.size() > 0) {
                                entry.setAuthors(authors);
                            }
                        }
                    }
                    if ((contributorObj = entryStruct.get((Object)"contributor")) != null) {
                        if (!(contributorObj instanceof Array)) {
                            throw new FeedGenerator.InvalidAttributeTypeException("contributor", "Array");
                        }
                        Array contributorsArray = (Array)contributorObj;
                        if (contributorsArray != null) {
                            ArrayList<Person> contributors = new ArrayList<Person>();
                            for (Object obj1 : contributorsArray) {
                                if (!(obj1 instanceof Struct)) {
                                    throw new FeedGenerator.InvalidAttributeTypeException("contributor", "Struct");
                                }
                                Struct contributorStruct = (Struct)obj1;
                                Person contributor = new Person();
                                contributor.setEmail(FeedGenerator.getString(contributorStruct, "email"));
                                contributor.setName(FeedGenerator.getString(contributorStruct, "name"));
                                contributor.setUri(FeedGenerator.getString(contributorStruct, "uri"));
                                contributors.add(contributor);
                            }
                            if (contributors.size() > 0) {
                                entry.setContributors(contributors);
                            }
                        }
                    }
                    if ((linkObj = entryStruct.get((Object)"link")) != null) {
                        if (!(linkObj instanceof Array)) {
                            throw new FeedGenerator.InvalidLinkAttributeTypeException("link");
                        }
                        Array linkArray = (Array)linkObj;
                        if (linkArray != null) {
                            ArrayList<Link> links = new ArrayList<Link>();
                            for (Object obj1 : linkArray) {
                                if (!(obj1 instanceof Struct)) {
                                    throw new FeedGenerator.InvalidLinkAttributeTypeException("link");
                                }
                                Struct linkStruct = (Struct)obj1;
                                Link link = new Link();
                                link.setHref(FeedGenerator.getString(linkStruct, "href"));
                                link.setHreflang(FeedGenerator.getString(linkStruct, "hreflang"));
                                Object lengthObj = linkStruct.get((Object)"length");
                                if (lengthObj != null) {
                                    try {
                                        link.setLength(new Long(Cast._long((Object)lengthObj)));
                                    }
                                    catch (Cast.NumberConversionException e) {
                                        throw new FeedGenerator.InvalidAttributeTypeException("length", "number");
                                    }
                                }
                                link.setRel(FeedGenerator.getString(linkStruct, "rel"));
                                link.setTitle(FeedGenerator.getString(linkStruct, "title"));
                                link.setType(FeedGenerator.getString(linkStruct, "type"));
                                links.add(link);
                            }
                            if (links.size() > 0) {
                                entry.setOtherLinks(links);
                            }
                        }
                    }
                    if ((summaryObj = entryStruct.get((Object)"summary")) != null) {
                        Content summary = new Content();
                        if (!(summaryObj instanceof Struct)) {
                            throw new FeedGenerator.InvalidAttributeTypeException("summary", "Struct");
                        }
                        Struct summaryStruct = (Struct)summaryObj;
                        String src = FeedGenerator.getString(summaryStruct, "src");
                        String type = FeedGenerator.getString(summaryStruct, "type");
                        String value = FeedGenerator.getString(summaryStruct, "value");
                        summary.setSrc(src);
                        summary.setType(type);
                        summary.setValue(value);
                        if (src != null || type != null || value != null) {
                            entry.setSummary(summary);
                        }
                    }
                    if ((contentsObj = entryStruct.get((Object)"content")) != null) {
                        if (!(contentsObj instanceof Array)) {
                            throw new FeedGenerator.InvalidAttributeTypeException("content", "Array");
                        }
                        Array contentsArray = (Array)contentsObj;
                        if (contentsArray != null) {
                            ArrayList<Content> contents = new ArrayList<Content>();
                            Iterator it1 = contentsArray.iterator();
                            while (it1.hasNext()) {
                                Content content = new Content();
                                Object obj1 = it1.next();
                                if (!(obj1 instanceof Struct)) {
                                    throw new FeedGenerator.InvalidAttributeTypeException("content", "Struct");
                                }
                                Struct contentStruct = (Struct)obj1;
                                content.setSrc(FeedGenerator.getString(contentStruct, "src"));
                                content.setType(FeedGenerator.getString(contentStruct, "type"));
                                content.setValue(FeedGenerator.getString(contentStruct, "value"));
                                contents.add(content);
                            }
                            if (contents.size() > 0) {
                                entry.setContents(contents);
                            }
                        }
                    }
                    entries.add(entry);
                }
                this.setEntries(entries);
            }
        }
    }

    public void createATOMFeed(Struct feedMetadata, QueryTable feedQuery, Struct columnMap, String feedType) {
        this.setFeedType(feedType);
        this.setFeedMetadata(feedMetadata);
        int numEntries = feedQuery.getRowCount();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < numEntries; ++i) {
            String contentValue;
            String contentSrc;
            String contentType;
            List contents;
            String length;
            String title;
            String hreflang;
            String type;
            String rel;
            String href;
            List links;
            String curi;
            String cemail;
            String cname;
            List contributors;
            String uri;
            String email;
            String name;
            List authors;
            Entry currentEntry = new Entry();
            feedQuery.absolute(i + 1);
            currentEntry.setXmlBase(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "XMLBASE", columnMap)));
            currentEntry.setId(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "ID", columnMap)));
            currentEntry.setRights(FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "RIGHTS", columnMap)));
            String title_value = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "TITLE", columnMap));
            String title_type = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "TITLETYPE", columnMap));
            Content currentTitle = new Content();
            currentTitle.setValue(title_value);
            currentTitle.setType(title_type);
            currentEntry.setTitleEx(currentTitle);
            String publishedStr = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "PUBLISHEDDATE", columnMap, false), false);
            currentEntry.setPublished(FeedGenerator.getDate(publishedStr, "PublishedDate Column"));
            String updatedStr = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "UPDATEDDATE", columnMap, false), false);
            currentEntry.setUpdated(FeedGenerator.getDate(updatedStr, "UpdatedDate Column"));
            String createdStr = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "CREATEDDATE", columnMap, false), false);
            currentEntry.setCreated(FeedGenerator.getDate(createdStr, "CreatedDate Column"));
            String term = FeedGenerator.getColumnValue(feedQuery, "CATEGORYTERM", columnMap);
            String scheme = FeedGenerator.getColumnValue(feedQuery, "CATEGORYSCHEME", columnMap);
            String label = FeedGenerator.getColumnValue(feedQuery, "CATEGORYLABEL", columnMap);
            List categories = this.getCategoriesList(term, scheme, label);
            if (categories.size() > 0) {
                currentEntry.setCategories(categories);
            }
            if ((authors = this.getPersonsList(name = FeedGenerator.getColumnValue(feedQuery, "AUTHORNAME", columnMap), email = FeedGenerator.getColumnValue(feedQuery, "AUTHOREMAIL", columnMap), uri = FeedGenerator.getColumnValue(feedQuery, "AUTHORURI", columnMap))).size() > 0) {
                currentEntry.setAuthors(authors);
            }
            if ((contributors = this.getPersonsList(cname = FeedGenerator.getColumnValue(feedQuery, "CONTRIBUTORNAME", columnMap), cemail = FeedGenerator.getColumnValue(feedQuery, "CONTRIBUTOREMAIL", columnMap), curi = FeedGenerator.getColumnValue(feedQuery, "CONTRIBUTORURI", columnMap))).size() > 0) {
                currentEntry.setContributors(contributors);
            }
            if ((links = this.getLinksList(href = FeedGenerator.getColumnValue(feedQuery, "LINKHREF", columnMap), rel = FeedGenerator.getColumnValue(feedQuery, "LINKREL", columnMap), type = FeedGenerator.getColumnValue(feedQuery, "LINKTYPE", columnMap), hreflang = FeedGenerator.getColumnValue(feedQuery, "LINKHREFLANG", columnMap), title = FeedGenerator.getColumnValue(feedQuery, "LINKTITLE", columnMap), length = FeedGenerator.getColumnValue(feedQuery, "LINKLENGTH", columnMap))).size() > 0) {
                currentEntry.setOtherLinks(links);
            }
            Content summary = new Content();
            String summary_src = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "SUMMARYSRC", columnMap));
            String summary_type = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "SUMMARYTYPE", columnMap));
            String summary_value = FeedGenerator.checkBlankValue(FeedGenerator.getColumnValue(feedQuery, "SUMMARY", columnMap));
            if (summary_src != null || summary_type != null || summary_value != null) {
                summary.setSrc(summary_src);
                summary.setType(summary_type);
                summary.setValue(summary_value);
                currentEntry.setSummary(summary);
            }
            if ((contents = this.getContentsList(contentType = FeedGenerator.getColumnValue(feedQuery, "CONTENTTYPE", columnMap), contentSrc = FeedGenerator.getColumnValue(feedQuery, "CONTENTSRC", columnMap), contentValue = FeedGenerator.getColumnValue(feedQuery, "CONTENT", columnMap))).size() > 0) {
                currentEntry.setContents(contents);
            }
            entries.add(currentEntry);
        }
        if (numEntries > 0) {
            this.setEntries(entries);
        }
    }

    private void setFeedMetadata(Struct metadataStruct) {
        Object subtitleObj;
        Object linkObj;
        Object contributorObj;
        Object authorObj;
        Object titleObj;
        this.setXmlBase(FeedGenerator.getString(metadataStruct, "xmlbase"));
        this.setIcon(FeedGenerator.getString(metadataStruct, "icon"));
        this.setLogo(FeedGenerator.getString(metadataStruct, "logo"));
        this.setId(FeedGenerator.getString(metadataStruct, "id"));
        this.setRights(FeedGenerator.getString(metadataStruct, "rights"));
        Object metadataObj = metadataStruct.get((Object)"generator");
        if (metadataObj != null) {
            if (!(metadataObj instanceof Struct)) {
                throw new FeedGenerator.InvalidAttributeTypeException("generator", "Struct");
            }
            Struct generatorStruct = (Struct)metadataObj;
            Generator generator = new Generator();
            generator.setUrl(FeedGenerator.getString(generatorStruct, "uri"));
            generator.setValue(FeedGenerator.getString(generatorStruct, "value"));
            generator.setVersion(FeedGenerator.getString(generatorStruct, "version"));
            this.setGenerator(generator);
        }
        if ((titleObj = metadataStruct.get((Object)"title")) != null) {
            if (!(titleObj instanceof Struct)) {
                throw new FeedGenerator.InvalidAttributeTypeException("title", "Struct");
            }
            Struct titleStruct = (Struct)titleObj;
            Content title = new Content();
            title.setSrc(FeedGenerator.getString(titleStruct, "src"));
            title.setType(FeedGenerator.getString(titleStruct, "type"));
            title.setValue(FeedGenerator.getString(titleStruct, "value"));
            this.setTitleEx(title);
        }
        this.setUpdated(FeedGenerator.getDate(metadataStruct, "updated"));
        Object categoryObj = metadataStruct.get((Object)"category");
        if (categoryObj != null) {
            if (!(categoryObj instanceof Array)) {
                throw new FeedGenerator.InvalidAttributeTypeException("category", "Array");
            }
            Array categoriesArray = (Array)categoryObj;
            if (categoriesArray != null) {
                ArrayList<Category> categories = new ArrayList<Category>();
                for (Object obj : categoriesArray) {
                    if (!(obj instanceof Struct)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("category", "Struct");
                    }
                    Struct categoryStruct = (Struct)obj;
                    Category atomCategory = new Category();
                    atomCategory.setLabel(FeedGenerator.getString(categoryStruct, "label"));
                    atomCategory.setScheme(FeedGenerator.getString(categoryStruct, "scheme"));
                    atomCategory.setTerm(FeedGenerator.getString(categoryStruct, "term"));
                    categories.add(atomCategory);
                }
                if (categories.size() > 0) {
                    this.setCategories(categories);
                }
            }
        }
        if ((authorObj = metadataStruct.get((Object)"author")) != null) {
            if (!(authorObj instanceof Array)) {
                throw new FeedGenerator.InvalidAttributeTypeException("author", "Array");
            }
            Array authorsArray = (Array)authorObj;
            if (authorsArray != null) {
                ArrayList<Person> authors = new ArrayList<Person>();
                for (Object obj : authorsArray) {
                    if (!(obj instanceof Struct)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("author", "Struct");
                    }
                    Struct authorStruct = (Struct)obj;
                    Person author = new Person();
                    author.setEmail(FeedGenerator.getString(authorStruct, "email"));
                    author.setName(FeedGenerator.getString(authorStruct, "name"));
                    author.setUri(FeedGenerator.getString(authorStruct, "uri"));
                    authors.add(author);
                }
                if (authors.size() > 0) {
                    this.setAuthors(authors);
                }
            }
        }
        if ((contributorObj = metadataStruct.get((Object)"contributor")) != null) {
            if (!(contributorObj instanceof Array)) {
                throw new FeedGenerator.InvalidAttributeTypeException("contributor", "Array");
            }
            Array contributorsArray = (Array)contributorObj;
            if (contributorsArray != null) {
                ArrayList<Person> contributors = new ArrayList<Person>();
                for (Object obj : contributorsArray) {
                    if (!(obj instanceof Struct)) {
                        throw new FeedGenerator.InvalidAttributeTypeException("contributor", "Struct");
                    }
                    Struct contributorStruct = (Struct)obj;
                    Person contributor = new Person();
                    contributor.setEmail(FeedGenerator.getString(contributorStruct, "email"));
                    contributor.setName(FeedGenerator.getString(contributorStruct, "name"));
                    contributor.setUri(FeedGenerator.getString(contributorStruct, "uri"));
                    contributors.add(contributor);
                }
                if (contributors.size() > 0) {
                    this.setContributors(contributors);
                }
            }
        }
        if ((linkObj = metadataStruct.get((Object)"link")) != null) {
            if (!(linkObj instanceof Array)) {
                throw new FeedGenerator.InvalidLinkAttributeTypeException("link");
            }
            Array linkArray = (Array)linkObj;
            if (linkArray != null) {
                ArrayList<Link> links = new ArrayList<Link>();
                for (Object obj : linkArray) {
                    if (!(obj instanceof Struct)) {
                        throw new FeedGenerator.InvalidLinkAttributeTypeException("link");
                    }
                    Struct linkStruct = (Struct)obj;
                    Link link = new Link();
                    link.setHref(FeedGenerator.getString(linkStruct, "href"));
                    link.setHreflang(FeedGenerator.getString(linkStruct, "hreflang"));
                    Object lengthObj = linkStruct.get((Object)"length");
                    if (lengthObj != null) {
                        try {
                            link.setLength(new Long(Cast._long((Object)lengthObj)));
                        }
                        catch (Cast.NumberConversionException e) {
                            throw new FeedGenerator.InvalidAttributeTypeException("length", "number");
                        }
                    }
                    link.setRel(FeedGenerator.getString(linkStruct, "rel"));
                    link.setTitle(FeedGenerator.getString(linkStruct, "title"));
                    link.setType(FeedGenerator.getString(linkStruct, "type"));
                    links.add(link);
                }
                if (links.size() > 0) {
                    this.setOtherLinks(links);
                }
            }
        }
        if ((subtitleObj = metadataStruct.get((Object)"subtitle")) != null && !(subtitleObj instanceof Struct)) {
            throw new FeedGenerator.InvalidAttributeTypeException("subtitle", "Struct");
        }
        Struct subtitleStruct = (Struct)subtitleObj;
        if (subtitleStruct != null) {
            Content subtitle = new Content();
            String subtitle_src = FeedGenerator.getString(subtitleStruct, "src");
            String subtitle_type = FeedGenerator.getString(subtitleStruct, "type");
            String subtitle_value = FeedGenerator.getString(subtitleStruct, "value");
            subtitle.setSrc(subtitle_src);
            subtitle.setType(subtitle_type);
            subtitle.setValue(subtitle_value);
            if (subtitle_src != null || subtitle_type != null || subtitle_value != null) {
                this.setSubtitle(subtitle);
            }
        }
    }

    private List getContentsList(String contentType, String contentSrc, String contentValue) {
        ArrayList<Content> contents = new ArrayList<Content>();
        if (contentValue != null) {
            StringTokenizer contentValueSt = new StringTokenizer(contentValue, ",");
            StringTokenizer contentTypeSt = null;
            StringTokenizer contentSrcSt = null;
            if (contentType != null) {
                contentTypeSt = new StringTokenizer(contentType, ",");
            }
            if (contentSrc != null) {
                contentSrcSt = new StringTokenizer(contentSrc, ",");
            }
            while (contentValueSt.hasMoreTokens()) {
                Content content = new Content();
                if (contentSrcSt != null && contentSrcSt.hasMoreTokens()) {
                    content.setSrc(FeedGenerator.checkBlankValue(contentSrcSt.nextToken()));
                }
                if (contentTypeSt != null && contentTypeSt.hasMoreTokens()) {
                    content.setType(FeedGenerator.checkBlankValue(contentTypeSt.nextToken()));
                }
                content.setValue(FeedGenerator.checkBlankValue(contentValueSt.nextToken()));
                contents.add(content);
            }
        }
        return contents;
    }

    private List getCategoriesList(String term, String scheme, String label) {
        ArrayList<Category> categories = new ArrayList<Category>();
        if (term != null) {
            StringTokenizer termSt = new StringTokenizer(term, ",");
            StringTokenizer schemeSt = null;
            StringTokenizer labelSt = null;
            if (scheme != null) {
                schemeSt = new StringTokenizer(scheme, ",");
            }
            if (label != null) {
                labelSt = new StringTokenizer(label, ",");
            }
            while (termSt.hasMoreTokens()) {
                Category atomCategory = new Category();
                if (labelSt != null && labelSt.hasMoreTokens()) {
                    atomCategory.setLabel(FeedGenerator.checkBlankValue(labelSt.nextToken()));
                }
                if (schemeSt != null && schemeSt.hasMoreTokens()) {
                    atomCategory.setScheme(FeedGenerator.checkBlankValue(schemeSt.nextToken().trim()));
                }
                atomCategory.setTerm(FeedGenerator.checkBlankValue(termSt.nextToken()));
                categories.add(atomCategory);
            }
        }
        return categories;
    }

    private List getPersonsList(String name, String email, String uri) {
        ArrayList<Person> persons = new ArrayList<Person>();
        if (name != null) {
            StringTokenizer nameSt = new StringTokenizer(name, ",");
            StringTokenizer emailSt = null;
            StringTokenizer uriSt = null;
            if (email != null) {
                emailSt = new StringTokenizer(email, ",");
            }
            if (uri != null) {
                uriSt = new StringTokenizer(uri, ",");
            }
            while (nameSt.hasMoreTokens()) {
                Person person = new Person();
                if (emailSt != null && emailSt.hasMoreTokens()) {
                    person.setEmail(FeedGenerator.checkBlankValue(emailSt.nextToken()));
                }
                person.setName(FeedGenerator.checkBlankValue(nameSt.nextToken()));
                if (uriSt != null && uriSt.hasMoreTokens()) {
                    person.setUri(FeedGenerator.checkBlankValue(uriSt.nextToken()));
                }
                persons.add(person);
            }
        }
        return persons;
    }

    private List getLinksList(String href, String rel, String type, String hreflang, String title, String length) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (href != null) {
            StringTokenizer hrefSt = new StringTokenizer(href, ",");
            StringTokenizer relSt = null;
            StringTokenizer typeSt = null;
            StringTokenizer hreflangSt = null;
            StringTokenizer titleSt = null;
            StringTokenizer lengthSt = null;
            if (rel != null) {
                relSt = new StringTokenizer(rel, ",");
            }
            if (type != null) {
                typeSt = new StringTokenizer(type, ",");
            }
            if (hreflang != null) {
                hreflangSt = new StringTokenizer(hreflang, ",");
            }
            if (title != null) {
                titleSt = new StringTokenizer(title, ",");
            }
            if (length != null) {
                lengthSt = new StringTokenizer(length, ",");
            }
            while (hrefSt.hasMoreTokens()) {
                String lengthObj;
                Link link = new Link();
                link.setHref(FeedGenerator.checkBlankValue(hrefSt.nextToken()));
                if (hreflangSt != null && hreflangSt.hasMoreTokens()) {
                    link.setHreflang(FeedGenerator.checkBlankValue(hreflangSt.nextToken()));
                }
                if (lengthSt != null && lengthSt.hasMoreTokens() && (lengthObj = lengthSt.nextToken()) != null && lengthObj.trim().length() > 0) {
                    try {
                        link.setLength(new Long(Cast._long((String)lengthObj)));
                    }
                    catch (Cast.NumberConversionException e) {
                        throw new FeedGenerator.InvalidAttributeTypeException("length", "number");
                    }
                }
                if (relSt != null && relSt.hasMoreTokens()) {
                    link.setRel(FeedGenerator.checkBlankValue(relSt.nextToken()));
                }
                if (titleSt != null && titleSt.hasMoreTokens()) {
                    link.setTitle(FeedGenerator.checkBlankValue(titleSt.nextToken()));
                }
                if (typeSt != null && typeSt.hasMoreTokens()) {
                    link.setType(FeedGenerator.checkBlankValue(typeSt.nextToken()));
                }
                links.add(link);
            }
        }
        return links;
    }
}

