/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.codecs;

import coldfusion.nosql.mongo.SimpleReference;
import coldfusion.nosql.mongo.codecs.CFMongoCodec;
import coldfusion.runtime.Array;
import java.util.UUID;
import org.bson.BsonBinarySubType;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class CFDynamicObjectCodec
implements CFMongoCodec<SimpleReference> {
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;

    public CFDynamicObjectCodec(CodecRegistry registry) {
        this.registry = registry;
        this.bsonTypeCodecMap = new BsonTypeCodecMap(bsonTypeClassMap, registry);
    }

    public void encode(BsonWriter writer, SimpleReference value, EncoderContext encoderContext) {
        throw new UnsupportedOperationException();
    }

    public Class<SimpleReference> getEncoderClass() {
        return SimpleReference.class;
    }

    public SimpleReference decode(BsonReader reader, DecoderContext decoderContext) {
        return new SimpleReference(this.readValue(reader, decoderContext));
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType = reader.getCurrentBsonType();
        if (bsonType == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return decoderContext.decodeWithChildContext((Decoder)this.registry.get(Array.class), reader);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return decoderContext.decodeWithChildContext((Decoder)this.registry.get(UUID.class), reader);
        }
        return this.bsonTypeCodecMap.get(bsonType).decode(reader, decoderContext);
    }
}

