/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo.bson.types;

import coldfusion.nosql.mongo.bson.types.CFMongoObjectID;
import coldfusion.runtime.Scope;
import coldfusion.util.CFDumpable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bson.BsonRegularExpression;

public class CFMongoRegExp
extends Scope
implements CFDumpable,
Serializable {
    private static final long serialVersionUID = 1L;
    private BsonRegularExpression regEx;
    public static final String PATTERN = "pattern";
    public static final String OPTIONS = "options";
    private static final List<String> keysList = Collections.unmodifiableList(Arrays.asList("pattern", "options"));

    public CFMongoRegExp(BsonRegularExpression regEx) {
        this.regEx = regEx;
    }

    public CFMongoRegExp(String pattern) {
        this.regEx = new BsonRegularExpression(pattern);
    }

    public CFMongoRegExp(String pattern, String options) {
        this.regEx = options == null ? new BsonRegularExpression(pattern) : new BsonRegularExpression(pattern, options);
    }

    public String getPattern() {
        return this.regEx.getPattern();
    }

    public String getOptions() {
        return this.regEx.getOptions();
    }

    public BsonRegularExpression getRegEx() {
        return this.regEx;
    }

    public Object getMetadata() {
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put(PATTERN, this.regEx.getPattern());
        metaData.put(OPTIONS, this.regEx.getOptions());
        return metaData;
    }

    public String getLabel() {
        return "MongoDBRegExp";
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void bindName(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected void bindName_Final(String name, Object obj) {
        throw new UnsupportedOperationException();
    }

    protected void unbindName(String name) {
        throw new UnsupportedOperationException();
    }

    protected Object resolveName(String name) {
        if ((name = name.toLowerCase()).equals(PATTERN)) {
            return this.regEx.getPattern();
        }
        if (name.equals(OPTIONS)) {
            return new CFMongoObjectID(this.regEx.getOptions());
        }
        return null;
    }

    protected boolean containsName(String name) {
        return keysList.contains(name.toLowerCase());
    }

    protected Iterator getNames() {
        return keysList.iterator();
    }
}

