/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.nosql.mongo;

import coldfusion.log.Logger;
import coldfusion.monitor.beans.TagAttributeList;
import coldfusion.monitor.event.RequestMonitorEventProcessor;
import coldfusion.monitor.util.CloudMonitoringUtil;
import coldfusion.nosql.mongo.CFMongoDatabase;
import coldfusion.nosql.mongo.CFMongoServiceHandle;
import coldfusion.nosql.mongo.MongoException;
import coldfusion.nosql.mongo.MongoUtils;
import coldfusion.nosql.mongo.bson.types.CFBsonTimeStamp;
import coldfusion.nosql.mongo.cursor.CFMongoListDatabasesIterator;
import coldfusion.nosql.mongo.cursor.CFMongoListDatabasesIteratorImpl;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.GenerateCFInvoke;
import coldfusion.runtime.GenerateCFNamedInvoke;
import coldfusion.runtime.InvokeNamedMethodInvocationMap;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.NamedMethodInvoker;
import coldfusion.runtime.Scope;
import coldfusion.server.ServiceFactory;
import coldfusion.util.CFDumpable;
import com.mongodb.ReadConcern;
import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import jakarta.servlet.jsp.PageContext;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.bson.BsonTimestamp;

@GenerateCFInvoke
@GenerateCFNamedInvoke
public class CFMongoClientSession
extends Scope
implements CFDumpable,
NamedInvokable {
    private final ClientSession cs;
    private final CFMongoServiceHandle svc;
    private TagAttributeList tagAttributeList = new TagAttributeList("service", (Object)"MONGO_DB");
    private static final Map<String, Function<ClientSession, Object>> variableResolveMap = new HashMap<String, Function<ClientSession, Object>>();
    private Logger logger;
    private static InvokeNamedMethodInvocationMap<CFMongoClientSession> __InvokeNamedMethodInvocationMap = new InvokeNamedMethodInvocationMap();

    CFMongoClientSession(ClientSession cs2, CFMongoServiceHandle svc) {
        variableResolveMap.put("clustertime", cs -> cs.getClusterTime());
        variableResolveMap.put("operationtime", cs -> MongoUtils.toMap(cs.getOperationTime()));
        variableResolveMap.put("hasactivetransaction", cs -> cs.hasActiveTransaction());
        variableResolveMap.put("transactionnumber", cs -> cs.getServerSession().getTransactionNumber());
        variableResolveMap.put("identifier", cs -> cs.getServerSession().getIdentifier());
        variableResolveMap.put("readpreference", cs -> MongoUtils.toMap(cs.getTransactionOptions().getReadPreference()));
        variableResolveMap.put("writeconcern", cs -> MongoUtils.toMap(cs.getTransactionOptions().getWriteConcern()));
        variableResolveMap.put("readconcern", cs -> {
            ReadConcern readConcern = cs.getTransactionOptions().getReadConcern();
            if (readConcern != null) {
                return readConcern.getLevel().toString();
            }
            return null;
        });
        variableResolveMap.put("hasEnded", cs -> cs.getServerSession().isClosed());
        this.logger = ServiceFactory.getLoggingService().getLogger("coldfusion.mongo");
        this.cs = cs2;
        this.svc = svc;
    }

    ClientSession getClientSession() {
        return this.cs;
    }

    MongoClient getMongoClient() {
        return (MongoClient)this.cs.getOriginator();
    }

    public CFMongoDatabase getDatabase(String databaseName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"getDatabase", (boolean)true);
        MongoDatabase database = ((MongoClient)this.cs.getOriginator()).getDatabase(databaseName);
        CFMongoDatabase db = new CFMongoDatabase(database, this.svc, this);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getDatabase", (TagAttributeList)this.tagAttributeList);
        return db;
    }

    public CFMongoDatabase db(String databaseName) {
        RequestMonitorEventProcessor.onFunctionStart((String)"db", (boolean)true);
        MongoDatabase database = ((MongoClient)this.cs.getOriginator()).getDatabase(databaseName);
        CFMongoDatabase db = new CFMongoDatabase(database, this.svc, this);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"db", (TagAttributeList)this.tagAttributeList);
        return db;
    }

    public Array listDBNames() {
        RequestMonitorEventProcessor.onFunctionStart((String)"listDBNames", (boolean)true);
        MongoIterable dbNamesItr = this.getMongoClient().listDatabaseNames(this.cs);
        Array array = new Array();
        dbNamesItr.iterator().forEachRemaining(arg_0 -> ((Array)array).add(arg_0));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"listDBNames", (TagAttributeList)this.tagAttributeList);
        return array;
    }

    public CFMongoListDatabasesIterator<Map> listDatabaseNames() {
        RequestMonitorEventProcessor.onFunctionStart((String)"listDatabaseNames", (boolean)true);
        CFMongoListDatabasesIteratorImpl<Map> res = new CFMongoListDatabasesIteratorImpl<Map>(this.getMongoClient().listDatabases(this.cs, Map.class));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"listDatabaseNames", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public boolean hasActiveTransaction() {
        RequestMonitorEventProcessor.onFunctionStart((String)"hasActiveTransaction", (boolean)true);
        boolean res = this.cs.hasActiveTransaction();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"hasActiveTransaction", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Map getOperationTime() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getOperationTime", (boolean)true);
        Map res = MongoUtils.toMap(this.cs.getOperationTime());
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getOperationTime", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoClientSession advanceOperationTime(Date date) {
        RequestMonitorEventProcessor.onFunctionStart((String)"advanceOperationTime", (boolean)true);
        if (date instanceof CFBsonTimeStamp) {
            CFBsonTimeStamp cfBsonTimeStamp = (CFBsonTimeStamp)((Object)date);
            this.cs.advanceOperationTime(new BsonTimestamp((int)(date.getTime() / 1000L), cfBsonTimeStamp.getInc()));
        } else {
            this.cs.advanceOperationTime(new BsonTimestamp(date.getTime() / 1000L));
        }
        CloudMonitoringUtil.onCloudFunctionEnd((String)"advanceOperationTime", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public long getTransactionNumber() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getTransactionNumber", (boolean)true);
        long res = this.cs.getServerSession().getTransactionNumber();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getTransactionNumber", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoClientSession startTransaction() {
        RequestMonitorEventProcessor.onFunctionStart((String)"startTransaction", (boolean)true);
        CFMongoClientSession res = this.startTransaction(null);
        CloudMonitoringUtil.onCloudFunctionEnd((String)"startTransaction", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public CFMongoClientSession startTransaction(Map<?, ?> options) {
        RequestMonitorEventProcessor.onFunctionStart((String)"startTransaction", (boolean)true);
        String statusText = "";
        TransactionOptions transactionOptions = MongoUtils.getTransactionOptions(options);
        try {
            if (options == null) {
                this.cs.startTransaction();
            } else {
                this.cs.startTransaction(transactionOptions);
            }
        }
        catch (MongoException | IllegalStateException e) {
            statusText = "IllegalStartTransaction";
            throw new MongoException(statusText, ((Throwable)e).getMessage(), (Throwable)e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"startTransaction", null, (Object)statusText, (TagAttributeList)this.tagAttributeList);
        }
        return this;
    }

    public CFMongoClientSession commitTransaction() {
        RequestMonitorEventProcessor.onFunctionStart((String)"commitTransaction", (boolean)true);
        String statusText = "";
        try {
            this.cs.commitTransaction();
        }
        catch (MongoException | IllegalStateException e) {
            statusText = "IllegalCommitTransaction";
            throw new MongoException(statusText, ((Throwable)e).getMessage(), (Throwable)e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"commitTransaction", null, (Object)statusText, (TagAttributeList)this.tagAttributeList);
        }
        return this;
    }

    public CFMongoClientSession abortTransaction() {
        RequestMonitorEventProcessor.onFunctionStart((String)"abortTransaction", (boolean)true);
        String statusText = "";
        try {
            this.cs.abortTransaction();
        }
        catch (MongoException | IllegalStateException e) {
            statusText = "IllegalAbortTransaction";
            throw new MongoException(statusText, ((Throwable)e).getMessage(), (Throwable)e);
        }
        finally {
            CloudMonitoringUtil.onCloudFunctionEnd((String)"abortTransaction", null, (Object)statusText, (TagAttributeList)this.tagAttributeList);
        }
        return this;
    }

    public CFMongoClientSession endSession() {
        RequestMonitorEventProcessor.onFunctionStart((String)"endSession", (boolean)true);
        this.cs.close();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"endSession", (TagAttributeList)this.tagAttributeList);
        return this;
    }

    public boolean hasEnded() {
        RequestMonitorEventProcessor.onFunctionStart((String)"hasEnded", (boolean)true);
        boolean res = this.cs.getServerSession().isClosed();
        CloudMonitoringUtil.onCloudFunctionEnd((String)"hasEnded", (TagAttributeList)this.tagAttributeList);
        return res;
    }

    public Object getMetadata() {
        RequestMonitorEventProcessor.onFunctionStart((String)"getMetadata", (boolean)true);
        HashMap metadata = new HashMap();
        variableResolveMap.forEach((key, value) -> metadata.put(key, value.apply(this.cs)));
        CloudMonitoringUtil.onCloudFunctionEnd((String)"getMetadata", (TagAttributeList)this.tagAttributeList);
        return metadata;
    }

    public String getLabel() {
        return "MongoDBClientSession";
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void bindName(String name, Object obj) {
        throw new UnsupportedScopeException("Mongo Client Session Scope is not supported");
    }

    protected void bindName_Final(String name, Object obj) {
        throw new UnsupportedScopeException("Mongo Client Session Scope is not supported");
    }

    protected void unbindName(String name) {
        throw new UnsupportedScopeException("Mongo Client Session Scope is not supported");
    }

    protected Object resolveName(String name) {
        Function<ClientSession, Object> function = variableResolveMap.get(name = name.toLowerCase());
        if (function != null) {
            return function.apply(this.cs);
        }
        return null;
    }

    public void close() {
        this.cs.close();
    }

    protected boolean containsName(String name) {
        name = name.toLowerCase();
        return variableResolveMap.containsKey(name);
    }

    protected Iterator getNames() {
        return variableResolveMap.keySet().iterator();
    }

    public Object invoke(String methodName, Map args, PageContext pageContext) throws Throwable {
        NamedMethodInvoker NamedMethodInvoker2 = __InvokeNamedMethodInvocationMap.get((Object)methodName);
        if (NamedMethodInvoker2 == null) {
            throw new CfJspPage.UnsupportedBaseTypeException(methodName, (Object)this);
        }
        this.logger.info((Object)("mongo service method " + methodName + " invoked and started excecution... "));
        long startTime = System.currentTimeMillis();
        Object invokeObject = NamedMethodInvoker2.invoke((Object)this, args);
        long endTime = System.currentTimeMillis();
        long timeElapsed = endTime - startTime;
        this.logger.info((Object)("mongo service method " + methodName + " finished execution successfully. Turn around time : " + timeElapsed + " milli secs"));
        return invokeObject;
    }

    static {
        __InvokeNamedMethodInvocationMap.put((Object)"getDatabase", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"databaseName"}, args);
                    return obj.getDatabase(Cast._String((Object)argColl.get((Object)"databaseName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getDatabase", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"db", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"databaseName"}, args);
                    return obj.db(Cast._String((Object)argColl.get((Object)"databaseName")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("db", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listDBNames", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listDBNames();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listDBNames", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"listDatabaseNames", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.listDatabaseNames();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("listDatabaseNames", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"hasActiveTransaction", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.hasActiveTransaction();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("hasActiveTransaction", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getOperationTime", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getOperationTime();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getOperationTime", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"advanceOperationTime", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"date"}, args);
                    return obj.advanceOperationTime(Cast._Date((Object)argColl.get((Object)"date")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("advanceOperationTime", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getTransactionNumber", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getTransactionNumber();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getTransactionNumber", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"startTransaction", (obj, args) -> {
            ArgumentCollection argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.startTransaction();
                }
                case 1: {
                    argColl = new ArgumentCollection((Object[])new String[]{"options"}, args);
                    return obj.startTransaction(Cast._Map((Object)argColl.get((Object)"options")));
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("startTransaction", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"commitTransaction", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.commitTransaction();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("commitTransaction", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"abortTransaction", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.abortTransaction();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("abortTransaction", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"endSession", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.endSession();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("endSession", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"hasEnded", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.hasEnded();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("hasEnded", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getMetadata", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getMetadata();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getMetadata", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"getLabel", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.getLabel();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("getLabel", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"clone", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    return obj.clone();
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("clone", (Object)obj);
        });
        __InvokeNamedMethodInvocationMap.put((Object)"close", (obj, args) -> {
            Object argColl = null;
            int count = args != null ? args.size() : 0;
            switch (count) {
                case 0: {
                    obj.close();
                    return null;
                }
            }
            throw new CfJspPage.UnsupportedBaseTypeException("close", (Object)obj);
        });
    }

    public static class UnsupportedScopeException
    extends ApplicationException {
        public String message = "";

        UnsupportedScopeException(String message) {
            this.message = message;
        }
    }
}

