/*
 * Decompiled with CFR 0.152.
 */
package macromedia.swf.types;

import java.util.Arrays;
import macromedia.swf.tags.DefineTag;
import macromedia.swf.types.GradRecord;
import macromedia.swf.types.Matrix;
import macromedia.util.Assert;

public class FillStyle {
    public static final int FILL_SOLID = 0;
    public static final int FILL_GRADIENT = 16;
    public static final int FILL_LINEAR_GRADIENT = 16;
    public static final int FILL_RADIAL_GRADIENT = 18;
    public static final int FILL_VECTOR_PATTERN = 32;
    public static final int FILL_RAGGED_CROSSHATCH = 32;
    public static final int FILL_DIAGONAL_LINES = 33;
    public static final int FILL_CROSSHATCHED_LINES = 34;
    public static final int FILL_STIPPLE = 35;
    public static final int FILL_BITS = 64;
    public static final int FILL_BITS_CLIP = 1;
    public static final int FILL_BITS_NOSMOOTH = 2;
    public int type;
    public int color;
    public GradRecord[] gradient;
    public Matrix matrix;
    public DefineTag bitmap;

    public FillStyle() {
    }

    public FillStyle(int type, Matrix matrix, DefineTag bitmap) {
        this.setType(type);
        this.matrix = matrix;
        this.bitmap = bitmap;
    }

    public FillStyle(int color) {
        this.type = 0;
        this.color = color;
    }

    public int getType() {
        return this.type;
    }

    public boolean hasBitmapId() {
        return (this.type & 0x40) != 0;
    }

    public void setType(int type) {
        this.type = type;
        Assert.testAssertion((type == 0 || type == 16 || type == 16 || type == 18 || type == 32 || type == 32 || type == 35 || type == 64 || type == 65 || type == 66 ? 1 : 0) != 0);
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object instanceof FillStyle) {
            FillStyle fillStyle = (FillStyle)object;
            if (fillStyle.type == this.type && fillStyle.color == this.color && Arrays.equals(fillStyle.gradient, this.gradient) && (fillStyle.matrix == null && this.matrix == null || fillStyle.matrix != null && this.matrix != null && fillStyle.matrix.equals(this.matrix)) && (fillStyle.bitmap == null && this.bitmap == null || fillStyle.bitmap != null && this.bitmap != null && fillStyle.bitmap.equals(this.bitmap))) {
                isEqual = true;
            }
        }
        return isEqual;
    }
}

