/*
 * Decompiled with CFR 0.152.
 */
package macromedia.fonts;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import macromedia.fonts.FontFace;

public abstract class FontManager {
    protected Map languageRanges;
    protected FontManager parent;

    protected FontManager() {
    }

    public void setParent(FontManager parent) {
        this.parent = parent;
    }

    public void setLanguageRange(Map languageRanges) {
        this.languageRanges = languageRanges;
    }

    public String getLanguageRange(String lang) {
        Object range = null;
        if (this.languageRanges != null) {
            range = this.languageRanges.get(lang);
        }
        return range == null ? null : range.toString();
    }

    public abstract void initialize(Properties var1);

    public abstract FontFace getEntryFromLocation(URL var1, int var2);

    public abstract FontFace getEntryFromSystem(String var1, int var2);

    public static FontManager create(String[] managerClasses, Properties properties) {
        FontManager manager = null;
        if (managerClasses != null) {
            int i = 0;
            while (i < managerClasses.length) {
                try {
                    Class<?> clazz = Class.forName(managerClasses[i]);
                    Object obj = clazz.newInstance();
                    if (obj instanceof FontManager) {
                        FontManager fm = (FontManager)obj;
                        fm.initialize(properties);
                        if (manager != null) {
                            fm.setParent(manager);
                        }
                        manager = fm;
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ++i;
            }
        }
        return manager;
    }
}

