/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.SerializationWriterFactory;
import com.microsoft.kiota.serialization.TextSerializationWriter;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class TextSerializationWriterFactory
implements SerializationWriterFactory {
    private static final String validContentType = "text/plain";

    @Nonnull
    public String getValidContentType() {
        return validContentType;
    }

    @Nonnull
    public SerializationWriter getSerializationWriter(@Nonnull String contentType) {
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        if (!contentType.equals(validContentType)) {
            throw new IllegalArgumentException("expected a text/plain content type");
        }
        return new TextSerializationWriter();
    }
}

