/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sqs.producer;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.config.AWSServiceConfig;
import coldfusion.cloud.aws.sqs.SQSClient;
import coldfusion.cloud.aws.sqs.SQSClientImpl;
import coldfusion.cloud.aws.sqs.SQSServiceConfig;
import java.util.HashMap;
import java.util.Map;

public class SQSProducer
implements CloudServiceProducer<AWSCredential, AWSServiceConfig> {
    private static Map<String, SQSClient> aliasToSQSClient = new HashMap<String, SQSClient>();

    public CloudService getServiceHandle(AWSCredential credential, AWSServiceConfig serviceConfig) {
        SQSServiceConfig config = (SQSServiceConfig)serviceConfig;
        String id = credential.hashCode() + "-" + config.hashCode();
        SQSClient sqsClient = aliasToSQSClient.get(id);
        if (sqsClient == null) {
            sqsClient = new SQSClientImpl(credential, config);
            aliasToSQSClient.put(id, sqsClient);
        }
        return sqsClient;
    }
}

