/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds.handler;

import coldfusion.bootstrap.ClassloaderHelper;
import coldfusion.debugger.CFDebuggerLogger;
import coldfusion.debugger.rds.handler.DebuggerPortException;
import coldfusion.debugger.rds.handler.DebuggerStartFailedException;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DebuggerLaunchHelper {
    Process debuggerProcess = null;
    boolean shutdownHookAdded = false;
    int serverPort = 0;
    String rootPath;
    String cfHost;
    String ctxRoot;
    int debugPort;
    int cfPort;
    int maxSessions;
    private static final Object serverStartCheckMutex = new Object();
    static final String serverStartMsgMatch = "JETTY_SERVER_STARTED";
    static final long waitTimeForServerStart = 15000L;
    boolean serverStarted = false;
    boolean traceDebugger = false;
    static String pathSep = System.getProperty("path.separator");
    private static DebuggerLaunchHelper instance = new DebuggerLaunchHelper();
    Thread shutDownHandlerThread = new Thread(){

        @Override
        public void run() {
            DebuggerLaunchHelper.this.stopDebugger(true);
        }
    };

    private DebuggerLaunchHelper() {
    }

    public static DebuggerLaunchHelper getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkServerStarted(final InputStream inStream, final InputStream errStream, long timeout) {
        Thread th = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = serverStartCheckMutex;
                synchronized (object) {
                    try (BufferedReader rd = new BufferedReader(new InputStreamReader(inStream));){
                        String msgs = rd.readLine();
                        if (msgs != null && msgs.trim().equals(DebuggerLaunchHelper.serverStartMsgMatch)) {
                            DebuggerLaunchHelper.this.serverStarted = true;
                        }
                    }
                    catch (Exception e) {
                        CFDebuggerLogger.log(e);
                        DebuggerLaunchHelper.this.serverStarted = false;
                        throw new DebuggerStartFailedException(e.getMessage());
                    }
                    serverStartCheckMutex.notifyAll();
                }
                if (!DebuggerLaunchHelper.this.serverStarted) {
                    String message = DebuggerLaunchHelper.getErrorMessage(errStream);
                    CFDebuggerLogger.log(message);
                }
            }
        };
        Object object = serverStartCheckMutex;
        synchronized (object) {
            th.start();
            try {
                serverStartCheckMutex.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.serverStarted;
    }

    private static String getErrorMessage(InputStream errStream) {
        StringBuilder message = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(errStream));){
            if (reader.ready()) {
                String msgs;
                while ((msgs = reader.readLine()) != null) {
                    message.append(msgs);
                }
            }
        }
        catch (IOException e) {
            message.append(e.getMessage());
        }
        return message.toString();
    }

    private void readInputStream(final InputStream inStream) {
        Thread th = new Thread(){

            @Override
            public void run() {
                BufferedReader rd = new BufferedReader(new InputStreamReader(inStream));
                String msgs = null;
                try {
                    while ((msgs = rd.readLine()) != null) {
                        CFDebuggerLogger.log("New VM : " + msgs);
                    }
                }
                catch (Exception e) {
                    CFDebuggerLogger.log(e);
                }
            }
        };
        th.start();
    }

    public synchronized int launchDebugger(String rootPath, String ctxRoot, int debugPort, int cfPort, String cfHost, int maxSessions) throws Exception {
        this.rootPath = rootPath;
        this.debugPort = debugPort;
        this.cfPort = cfPort;
        this.cfHost = cfHost;
        this.maxSessions = maxSessions;
        this.ctxRoot = ctxRoot;
        return this.startDebugger();
    }

    public static synchronized int getFreeSocketPort() throws Throwable {
        return DebuggerLaunchHelper.getFreeSocketPort(0);
    }

    public static synchronized int getFreeSocketPort(final int portToTry) throws Throwable {
        if (System.getSecurityManager() == null) {
            ServerSocket soc = new ServerSocket(portToTry);
            int serverPort = soc.getLocalPort();
            soc.close();
            return serverPort;
        }
        try {
            return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    ServerSocket soc = new ServerSocket(portToTry);
                    int serverPort = soc.getLocalPort();
                    soc.close();
                    return new Integer(serverPort);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    private synchronized Process executeDebuggerStartCommand(final String[] startCommand) throws Throwable {
        if (System.getSecurityManager() == null) {
            return Runtime.getRuntime().exec(startCommand);
        }
        try {
            return (Process)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Runtime.getRuntime().exec(startCommand);
                }
            });
        }
        catch (PrivilegedActionException ex) {
            throw ex.getException();
        }
    }

    public synchronized int startDebugger() throws Exception {
        if (this.debuggerProcess != null) {
            try {
                this.debuggerProcess.exitValue();
            }
            catch (Throwable tse) {
                return this.serverPort;
            }
            this.debuggerProcess = null;
        }
        this.serverPort = -1;
        try {
            int userSpecifiedPort = 0;
            String userPortString = System.getProperty("DEBUGGER_SERVER_PORT");
            if (userPortString != null) {
                userSpecifiedPort = Integer.valueOf(userPortString);
            }
            this.serverPort = DebuggerLaunchHelper.getFreeSocketPort(userSpecifiedPort);
        }
        catch (Throwable t) {
            CFDebuggerLogger.log(t);
            throw new DebuggerPortException(t.getMessage());
        }
        String[] execPath = this.createArgs(this.rootPath, this.ctxRoot, this.debugPort, this.serverPort, this.cfPort, this.cfHost, this.maxSessions);
        try {
            this.serverStarted = false;
            try {
                this.debuggerProcess = this.executeDebuggerStartCommand(execPath);
            }
            catch (Throwable t) {
                CFDebuggerLogger.log(t);
                throw new DebuggerStartFailedException(t.getMessage());
            }
            InputStream errStream = this.debuggerProcess.getErrorStream();
            InputStream inStream = this.debuggerProcess.getInputStream();
            boolean serverStarted = false;
            ApplicationException startException = null;
            try {
                serverStarted = this.checkServerStarted(inStream, errStream, 15000L);
                if (serverStarted) {
                    CFLogs.SERVER_LOG.info((Object)("ColdFusion debugger is listening at port " + this.serverPort));
                } else {
                    CFLogs.SERVER_LOG.error((Object)("Failed to start ColdFusion debugger at port " + this.serverPort));
                }
            }
            catch (ApplicationException e) {
                CFLogs.SERVER_LOG.error((Object)e.getMessage());
                startException = e;
            }
            if (!serverStarted) {
                if (this.debuggerProcess != null) {
                    this.debuggerProcess.destroy();
                }
                this.debuggerProcess = null;
                CFDebuggerLogger.log("Failed to launch debugger using following command ...\n" + this.stringArrayToString(execPath));
                if (startException != null) {
                    throw startException;
                }
                return -1;
            }
            this.readInputStream(errStream);
            this.readInputStream(inStream);
            if (!this.shutdownHookAdded) {
                Runtime.getRuntime().addShutdownHook(this.shutDownHandlerThread);
                this.shutdownHookAdded = true;
            }
        }
        catch (Exception e) {
            CFDebuggerLogger.log(e);
            throw e;
        }
        return this.serverPort;
    }

    private String stringArrayToString(String[] strArray) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strArray.length; ++i) {
            buf.append(strArray[i]);
            buf.append(" ");
        }
        return buf.toString().trim();
    }

    public synchronized void stopDebugger() {
        this.stopDebugger(false);
    }

    public synchronized void stopDebugger(boolean cfShuttingDown) {
        if (this.debuggerProcess == null) {
            return;
        }
        try {
            String strUrl = "http://localhost:" + this.serverPort + "/CFIDE/main/ide.cfm?cmd=CLOSE&cfshutdown=" + (cfShuttingDown ? "true" : "false");
            URL url = new URL(strUrl);
            url.openStream();
        }
        catch (Exception e) {
            CFDebuggerLogger.log(e);
        }
        CFLogs.SERVER_LOG.info((Object)"ColdFusion debugger is stopped");
        this.debuggerProcess = null;
    }

    private String[] createArgs(String rootPath, String ctxRoot, int debugPort, int serverPort, int cfPort, String cfHost, int maxSessions) {
        String fileSep = System.getProperty("file.separator");
        String javaHome = System.getProperty("java.home");
        String javaPath = javaHome + fileSep + "bin" + fileSep + "java";
        ArrayList<Object> args = new ArrayList<Object>();
        String cfLibPath = rootPath + fileSep + "lib" + fileSep;
        String cfUpdatesFolderPath = cfLibPath + fileSep + "updates" + fileSep;
        String debuggerLibPath = cfLibPath + "etc" + fileSep;
        String pathSep = System.getProperty("path.separator");
        StringBuffer cpBuf = new StringBuffer(cfLibPath);
        cpBuf.append("tools.jar");
        cpBuf.append(pathSep);
        this.addUpdatesFolderToClassPath(cpBuf, cfUpdatesFolderPath, pathSep);
        cpBuf.append(cfLibPath);
        cpBuf.append("cfusion.jar");
        cpBuf.append(pathSep);
        try {
            cpBuf = this.appendJarsToCP(cfLibPath, cpBuf);
            cpBuf = this.appendJarsToCP(new File(cfLibPath + "../../bundles/repo/").getCanonicalPath() + File.separatorChar, cpBuf);
            cpBuf = this.appendJarsToCP(new File(cfLibPath + "../../bundles/").getCanonicalPath() + File.separatorChar, cpBuf);
        }
        catch (IOException e) {
            CFDebuggerLogger.log(e);
        }
        cpBuf.append(cfLibPath).append("xercesImpl.jar").append(pathSep);
        cpBuf.append(cfLibPath).append("xml-apis.jar").append(pathSep);
        cpBuf.append(cfLibPath).append("../wwwroot/WEB-INF/lib/cfmx_bootstrap.jar").append(pathSep);
        cpBuf.append(cfLibPath).append("../../lib/cfmx_bootstrap.jar").append(pathSep);
        cpBuf.append(cfLibPath).append("guava.jar").append(pathSep);
        cpBuf.append(cfLibPath).append("failureaccess.jar").append(pathSep);
        try {
            cpBuf.append(new File(debuggerLibPath + "jakarta.servlet-api-6.0.0.jar").getCanonicalPath()).append(pathSep);
            cpBuf.append(new File(cfLibPath + "slf4j-api.jar").getCanonicalPath()).append(pathSep);
            cpBuf.append(new File(cfLibPath + "slf4j-reload4j.jar").getCanonicalPath()).append(pathSep);
        }
        catch (Exception e) {
            CFDebuggerLogger.log(e);
        }
        String mainClass = "coldfusion.debugger.server.jetty.CFJettyDebugServer";
        String traceOption = " ";
        String traceValue = System.getProperty("DEBUGGER_TRACE");
        if (traceValue != null && traceValue.toLowerCase().equals("true")) {
            traceOption = "-DDEBUGGER_TRACE=true";
            this.traceDebugger = true;
        }
        CFDebuggerLogger.setEnabled(this.traceDebugger);
        args.add(javaPath);
        args.add("-cp");
        args.add(cpBuf.toString().trim());
        if (traceOption != null && traceOption.trim().length() > 0) {
            args.add(traceOption);
        }
        args.add(mainClass.trim());
        args.add(cfHost);
        args.add(String.valueOf(debugPort));
        args.add(String.valueOf(serverPort));
        args.add(String.valueOf(maxSessions));
        String canonicalCtxRoot = null;
        if (ctxRoot != null) {
            args.add(ctxRoot);
            File ctxRootFile = new File(ctxRoot);
            if (ctxRootFile.exists()) {
                try {
                    canonicalCtxRoot = ctxRootFile.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (canonicalCtxRoot != null) {
                args.add(canonicalCtxRoot);
            }
        }
        return args.toArray(new String[args.size()]);
    }

    private void addUpdatesFolderToClassPath(StringBuffer cpBuf, String folderPath, String pathSeperator) {
        File updatesDir = new File(folderPath);
        if (updatesDir.exists() && updatesDir.isDirectory()) {
            List filePathsCpList = ClassloaderHelper.getFilePathsInUpdates((File)updatesDir);
            Iterator it = filePathsCpList.iterator();
            while (it.hasNext()) {
                cpBuf.append(it.next());
                cpBuf.append(pathSeperator);
            }
        }
    }

    private StringBuffer appendJarsToCP(String cfJarsPath, StringBuffer cpBuf) {
        List<String> jarsToInclude = this.getAllJarsToInclude(cfJarsPath);
        if (jarsToInclude != null && !jarsToInclude.isEmpty()) {
            for (String jarToInclude : jarsToInclude) {
                cpBuf.append(cfJarsPath);
                cpBuf.append(jarToInclude);
                cpBuf.append(pathSep);
            }
        }
        return cpBuf;
    }

    private List<String> getAllJarsToInclude(String cfLibPath) {
        File libDir = new File(cfLibPath);
        String[] fileNames = libDir.list();
        if (fileNames == null) {
            return null;
        }
        ArrayList<String> jars = new ArrayList<String>();
        for (int i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].startsWith("log4j") && !fileNames[i].startsWith("jetty") && !fileNames[i].startsWith("debugger") || !fileNames[i].endsWith(".jar")) continue;
            jars.add(fileNames[i]);
        }
        return jars;
    }

    public boolean isDebugProcessRunning() {
        return this.debuggerProcess != null;
    }
}

