/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.debugger.rds;

import coldfusion.debugger.rds.RdsHttpRequestFormatter;
import coldfusion.rds.RdsRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Enumeration;

class RdsRequestImpl
implements RdsRequest {
    private final RdsHttpRequestFormatter _formatter = new RdsHttpRequestFormatter();
    private HttpServletRequest _request;

    RdsRequestImpl() {
    }

    final void init(HttpServletRequest req) throws IOException {
        this._request = req;
        this.loadMetaData();
    }

    final void reset() {
        this._request = null;
    }

    public final String getMetaString(int i) {
        return this._formatter.getMetaString(i);
    }

    public final byte[] getMetaBytes(int i) {
        return this._formatter.getMetaBytes(i);
    }

    public final Enumeration enumerateMetaData() {
        return this._formatter.enumerateMetaData();
    }

    public final int getMetaCount() {
        return this._formatter.getMetaCount();
    }

    public final String getUserName() {
        String up = this._formatter.getMetaString(this._formatter.getMetaCount() - 1);
        if (up.indexOf(";") == -1) {
            return this._formatter.getMetaString(this._formatter.getMetaCount() - 2);
        }
        String[] parsedUP = up.split(";");
        return parsedUP[0];
    }

    public final String getPassword() {
        String up = this._formatter.getMetaString(this._formatter.getMetaCount() - 1);
        if (up.indexOf(";") == -1) {
            return up;
        }
        String[] parsedUP = up.split(";");
        if (parsedUP.length != 2) {
            return "";
        }
        return parsedUP[1];
    }

    public final HttpSession getSession() {
        return this._request.getSession();
    }

    public final HttpSession getSession(boolean create) {
        return this._request.getSession(create);
    }

    public final HttpServletRequest getHttpServletRequest() {
        return this._request;
    }

    private void loadMetaData() throws IOException {
        this._formatter.parseRequest(this._request);
    }
}

