/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.InputStream;
import java.nio.ByteBuffer;
import macromedia.sequelink.net.NetCrypto;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.util.BufferManager;

public class NetInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public NetInputStream(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public NetInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void replaceBuffer(byte[] byArray, int n, int n2) {
        BufferManager.ReturnBuffer(this.buf);
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, this.buf.length);
    }

    public void close() {
        if (this.buf != null) {
            BufferManager.ReturnBuffer(this.buf);
            this.buf = null;
        }
    }

    public void decrypt(NetCrypto netCrypto) throws NetworkException {
        int n = this.count - this.pos;
        int n2 = netCrypto.getDecryptionOutputSize(n);
        if (this.buf.length < n2 + this.pos) {
            this.buf = BufferManager.GetBiggerBuffer(this.buf, n2 + this.pos);
        }
        int n3 = netCrypto.decrypt(this.buf, this.pos, n, this.buf, this.pos);
        this.count = n3 + this.pos;
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this.buf, this.pos, this.count);
    }
}

