/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore.config;

import coldfusion.cloud.Executor;
import coldfusion.cloud.gcp.config.AbstractGCPServiceConfig;
import coldfusion.cloud.gcp.config.ChannelProviderBuilder;
import coldfusion.cloud.gcp.config.RetrySettingsBuilder;
import coldfusion.cloud.gcp.firestore.config.ConfigUtil;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.firestore.FirestoreOptions;
import java.util.Map;
import java.util.Objects;

public class FirestoreConfig
extends AbstractGCPServiceConfig {
    private String databaseId;
    private String host;
    private String emulatorHost;
    private String quotaProjectId;
    private final FirestoreOptions.Builder firestoreOptions;

    public FirestoreConfig() {
        InstantiatingGrpcChannelProvider channelProvider = InstantiatingGrpcChannelProvider.newBuilder().setExecutor((java.util.concurrent.Executor)Executor.getInstance()).build();
        this.firestoreOptions = FirestoreOptions.newBuilder().setChannelProvider((TransportChannelProvider)channelProvider);
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public void setDatabaseId(String databaseId) {
        this.databaseId = databaseId;
        this.firestoreOptions.setDatabaseId(databaseId);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.firestoreOptions.setHost(host);
    }

    public String getEmulatorHost() {
        return this.emulatorHost;
    }

    public void setEmulatorHost(String emulatorHost) {
        this.emulatorHost = emulatorHost;
        this.firestoreOptions.setEmulatorHost(emulatorHost);
    }

    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    public void setQuotaProjectId(String quotaProjectId) {
        this.quotaProjectId = quotaProjectId;
        this.firestoreOptions.setQuotaProjectId(quotaProjectId);
    }

    public void setChannelProvider(ChannelProviderBuilder channelProvider) {
        super.setChannelProvider(channelProvider);
        this.firestoreOptions.setChannelProvider(ConfigUtil.buildChannelProvider(channelProvider));
    }

    public void setHeaders(Map<String, String> headers) {
        super.setHeaders(headers);
        this.firestoreOptions.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create(headers));
    }

    public void setRetrySettings(RetrySettingsBuilder retrySettings) {
        super.setRetrySettings(retrySettings);
        this.firestoreOptions.setRetrySettings(ConfigUtil.buildRetrySettings(retrySettings));
    }

    public FirestoreOptions.Builder getFirestoreOptions() {
        return this.firestoreOptions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FirestoreConfig that = (FirestoreConfig)((Object)obj);
        return super.equals(obj) && Objects.equals(this.getDatabaseId(), that.getDatabaseId()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getQuotaProjectId(), that.getQuotaProjectId()) && Objects.equals(this.getEmulatorHost(), that.getEmulatorHost());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDatabaseId(), this.getHost(), this.getQuotaProjectId(), this.getEmulatorHost());
    }
}

