/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore;

import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.firestore.exception.GCPFirestoreException;
import coldfusion.cloud.gcp.firestore.impl.FirestoreClientImpl;
import coldfusion.util.RB;
import coldfusion.vfs.VFSFileFactory;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.ServiceOptions;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class GCPCredentialValidator {
    private String projectId;
    private String credentialJSONFilePath;
    private GoogleCredentials gcpCredentials;

    public GCPCredentialValidator(GCPCredential credential) {
        this.populateCredentials(credential);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getCredentialJSONFilePath() {
        return this.credentialJSONFilePath;
    }

    public GoogleCredentials getGcpCredentials() {
        return this.gcpCredentials;
    }

    private void populateCredentials(final GCPCredential credential) {
        if (System.getSecurityManager() == null) {
            this._populateCredentials(credential);
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    GCPCredentialValidator.this._populateCredentials(credential);
                    return null;
                }
            });
        }
    }

    private void _populateCredentials(GCPCredential credential) {
        if (credential != null) {
            this.projectId = credential.getProjectId();
            this.credentialJSONFilePath = credential.getCredentialJSONFilePath();
            if (!this.isNullOrEmpty(this.credentialJSONFilePath)) {
                InputStream inputStream = null;
                if (this.credentialJSONFilePath instanceof String) {
                    if (VFSFileFactory.checkIfVFile((String)this.credentialJSONFilePath)) {
                        try {
                            inputStream = VFSFileFactory.getInputStream((String)this.credentialJSONFilePath);
                        }
                        catch (FileNotFoundException e) {
                            throw new GCPFirestoreException(e.getMessage(), e);
                        }
                    }
                    try {
                        inputStream = new FileInputStream(this.credentialJSONFilePath);
                    }
                    catch (FileNotFoundException e) {
                        throw new GCPFirestoreException(e.getMessage(), e);
                    }
                }
                if (inputStream != null) {
                    try {
                        this.gcpCredentials = GoogleCredentials.fromStream(inputStream);
                    }
                    catch (IOException ioe) {
                        throw new GCPFirestoreException(ioe.getMessage(), ioe);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            throw new GCPFirestoreException(e.getMessage(), e);
                        }
                    }
                }
            }
            if (this.gcpCredentials == null) {
                try {
                    this.gcpCredentials = GoogleCredentials.getApplicationDefault();
                }
                catch (IOException ioe) {
                    throw new GCPFirestoreException(ioe.getMessage(), ioe);
                }
            }
            this.projectId = this.extractProjectIDFromGoogleCredentials(this.gcpCredentials);
        }
    }

    private String extractProjectIDFromGoogleCredentials(GoogleCredentials googleCredentials) {
        String projectId = "";
        if (googleCredentials instanceof ServiceAccountCredentials) {
            projectId = ((ServiceAccountCredentials)googleCredentials).getProjectId();
        }
        if (this.isNullOrEmpty(projectId)) {
            projectId = this.projectId;
        }
        if (this.isNullOrEmpty(projectId)) {
            projectId = ServiceOptions.getDefaultProjectId();
        }
        if (this.isNullOrEmpty(projectId)) {
            throw new GCPFirestoreException(RB.getString(FirestoreClientImpl.class, (String)"PROJECT_ID_NULL"));
        }
        return projectId;
    }

    private boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

