/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.gcp.firestore;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.gcp.GCPCredential;
import coldfusion.cloud.gcp.config.AbstractGCPServiceConfig;
import coldfusion.cloud.gcp.firestore.FirestoreClient;
import coldfusion.cloud.gcp.firestore.config.FirestoreConfig;
import coldfusion.cloud.gcp.firestore.impl.FirestoreClientImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FirestoreProducer
implements CloudServiceProducer<GCPCredential, AbstractGCPServiceConfig> {
    private static final Map<Integer, FirestoreClient> handleMap = new HashMap<Integer, FirestoreClient>();

    public CloudService getServiceHandle(GCPCredential vendorCredential, AbstractGCPServiceConfig config) {
        FirestoreConfig firestoreConfig = (FirestoreConfig)config;
        int hashCode = Objects.hash(vendorCredential.hashCode(), firestoreConfig.hashCode());
        FirestoreClient firestoreHandle = handleMap.get(hashCode);
        if (firestoreHandle == null) {
            firestoreHandle = new FirestoreClientImpl(vendorCredential, firestoreConfig);
            handleMap.put(hashCode, firestoreHandle);
        }
        return firestoreHandle;
    }
}

