/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRCalculable;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

class JRLongSumIncrementer
extends JRAbstractExtendedIncrementer {
    private static JRLongSumIncrementer mainInstance = new JRLongSumIncrementer();

    private JRLongSumIncrementer() {
    }

    public static JRLongSumIncrementer getInstance() {
        return mainInstance;
    }

    @Override
    public Object increment(JRCalculable variable, Object expressionValue, AbstractValueProvider valueProvider) {
        Number value = (Number)variable.getIncrementedValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null) {
            value = variable.getValue() == null ? (Number)JRLongIncrementerFactory.ZERO : (Number)((Number)variable.getValue());
        }
        return new Long(value.longValue() + newValue.longValue());
    }

    @Override
    public Object initialValue(JRCalculable variable) {
        if (variable.getValue() == null) {
            return JRLongIncrementerFactory.ZERO;
        }
        return (Number)variable.getValue();
    }
}

