/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.runtime.report;

import coldfusion.compiler.ExprClassLoader;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.NeoException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.report.CFRptCompiler;
import coldfusion.runtime.report.ReportScope;
import coldfusion.util.FastHashtable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public class CFExprEvaluator
extends JREvaluator {
    private Map cfExprs = new Hashtable();
    private NeoPageContext pageContext;
    private FastHashtable parsm = null;
    private FastHashtable fldsm = null;
    private FastHashtable varsm = null;
    private byte evalType = (byte)3;

    public void resetPageContext(NeoPageContext npc) {
        this.pageContext = npc;
    }

    public CFExprEvaluator(JasperReport jasperReport, NeoPageContext pageContext) {
        Collection expressions;
        this.pageContext = pageContext;
        CFRptCompiler.CompileData cd = (CFRptCompiler.CompileData)jasperReport.getCompileData();
        if (cd != null && (expressions = cd.design.getExpressions()) != null && expressions.size() > 0) {
            JRExpression expression2 = null;
            for (JRExpression expression2 : expressions) {
                if (expression2.getExpressionLanguageType() != 1) continue;
                JasperExprInfo info = new JasperExprInfo();
                info.cfExpr = this.getExpressionText(expression2);
                info.resultType = expression2.getValueClass();
                this.cfExprs.put(new Integer(expression2.getId()), info);
            }
        }
    }

    String getExpressionText(JRExpression jexpr) {
        JRExpressionChunk[] chunks = jexpr.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        StringBuffer exprBuffer = new StringBuffer("");
        if (chunks != null && chunks.length > 0) {
            for (int i = 0; i < chunks.length; ++i) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                exprBuffer.append(chunkText);
            }
        }
        return exprBuffer.toString();
    }

    @Override
    protected void customizedInit(Map parsm, Map fldsm, Map varsm) throws JRException {
        Object calc;
        Object query;
        Object params;
        this.parsm = new FastHashtable(1);
        if (parsm != null) {
            this.parsm.putAll(parsm);
        }
        this.fldsm = new FastHashtable(1);
        if (fldsm != null) {
            this.fldsm.putAll(fldsm);
        }
        this.varsm = new FastHashtable(1);
        if (varsm != null) {
            this.varsm.putAll(varsm);
        }
        if ((params = this.pageContext.findAttribute("PARAM")) instanceof ReportScope && ((ReportScope)((Object)params)).getCalc() == null) {
            ((ReportScope)((Object)params)).setCalc(this);
        }
        if ((query = this.pageContext.findAttribute("QUERY")) instanceof ReportScope && ((ReportScope)((Object)query)).getCalc() == null) {
            ((ReportScope)((Object)query)).setCalc(this);
        }
        if ((calc = this.pageContext.findAttribute("CALC")) instanceof ReportScope && ((ReportScope)((Object)calc)).getCalc() == null) {
            ((ReportScope)((Object)calc)).setCalc(this);
        }
    }

    byte getEvaluationType() {
        return this.evalType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object evaluateOld(int id) throws Throwable {
        byte old = this.evalType;
        try {
            this.evalType = 1;
            JasperExprInfo x = (JasperExprInfo)this.cfExprs.get(new Integer(id));
            if (x == null) {
                throw new IllegalStateException("Should never be non CF expressions");
            }
            Object ret = this.doCfEval(x);
            Object object = ret;
            return object;
        }
        finally {
            this.evalType = old;
        }
    }

    private Object doCfEval(JasperExprInfo x) {
        Object result = null;
        try {
            result = ExprClassLoader.evaluate((String)x.cfExpr, (CFPage)((CFPage)this.pageContext.getPage()));
            Object ret = Cast._cast((Object)result, (Class)x.resultType);
            return ret;
        }
        catch (NeoException e) {
            if (x.cfExpr.startsWith("Report.GetChartData_") && x.cfExpr.endsWith("(query, calc, param)")) {
                throw new ReportChartException(e, e.getMessage());
            }
            throw new ReportInvalidCFExpressionException(e, x.cfExpr);
        }
        catch (ClassCastException c) {
            throw new ReportClassCastException(c, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object evaluateEstimated(int id) throws Throwable {
        byte old = this.evalType;
        try {
            this.evalType = (byte)2;
            JasperExprInfo x = (JasperExprInfo)this.cfExprs.get(new Integer(id));
            if (x == null) {
                throw new IllegalStateException("Should never be non CF expressions");
            }
            Object ret = this.doCfEval(x);
            Object object = ret;
            return object;
        }
        finally {
            this.evalType = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object evaluate(int id) throws Throwable {
        byte old = this.evalType;
        try {
            this.evalType = (byte)3;
            JasperExprInfo x = (JasperExprInfo)this.cfExprs.get(new Integer(id));
            if (x == null) {
                throw new IllegalStateException("Should never be non CF expressions");
            }
            Object ret = this.doCfEval(x);
            Object object = ret;
            return object;
        }
        finally {
            this.evalType = old;
        }
    }

    Object getParam(String paramName) {
        Object ret = null;
        JRFillParameter temp = (JRFillParameter)this.parsm.get((Object)"REPORT_PARAMETERS_MAP");
        if (temp != null) {
            Map value = (Map)temp.getValue();
            ret = value.get(paramName);
        }
        return ret;
    }

    Iterator getAllParamNames() {
        Iterator ret = null;
        JRFillParameter temp = (JRFillParameter)this.parsm.get((Object)"REPORT_PARAMETERS_MAP");
        if (temp != null) {
            ret = ((Map)temp.getValue()).keySet().iterator();
        }
        return ret;
    }

    JRFillField getQueryField(String name) {
        JRFillField x = (JRFillField)this.fldsm.get((Object)name);
        return x;
    }

    Iterator getAllQueryFieldNames() {
        Iterator x = this.fldsm.keySet().iterator();
        return x;
    }

    JRFillVariable getCalculatedField(String name) {
        JRFillVariable x = (JRFillVariable)this.varsm.get((Object)name);
        return x;
    }

    Iterator getAllCalculatedFieldNames() {
        Iterator x = this.varsm.keySet().iterator();
        return x;
    }

    class JasperExprInfo {
        String cfExpr;
        Class resultType;

        JasperExprInfo() {
        }
    }

    public static class ReportChartException
    extends NeoException {
        String expression;
        NeoException e;

        ReportChartException(NeoException e, String expression) {
            this.e = e;
            this.expression = expression;
        }

        public String getOriginalMessage() {
            return this.e.getMessage();
        }

        public Object getExpression() {
            return this.expression;
        }
    }

    public static class ReportInvalidCFExpressionException
    extends NeoException {
        String expression;
        NeoException e;

        ReportInvalidCFExpressionException(NeoException e, String expression) {
            this.e = e;
            this.expression = expression;
        }

        public String getOriginalMessage() {
            return this.e.getMessage();
        }

        public Object getExpression() {
            return this.expression;
        }
    }

    public static class ReportClassCastException
    extends NeoException {
        Object result;
        ClassCastException t;

        ReportClassCastException(ClassCastException t, Object object) {
            this.t = t;
            this.result = object;
        }

        public String getOriginalMessage() {
            return this.t.getMessage();
        }

        public Object getResult() {
            return this.result;
        }
    }
}

