/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.pdfg.jetty;

import coldfusion.document.JPedalFontRegistry;
import coldfusion.document.webkit.PDFgServiceManager;
import coldfusion.document.webkit.PDFgServiceManagerHelper;
import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.osgi.services.PDFService;
import coldfusion.pdfg.jetty.PDFGServer;
import coldfusion.runtime.ApplicationException;
import coldfusion.server.ConfigMap;
import coldfusion.server.ConfigMapListener;
import coldfusion.server.PDFGService;
import coldfusion.server.Service;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.SystemInfo;
import coldfusion.tagext.htmltopdf.HtmlToPdfTag;
import coldfusion.util.IPAddressUtils;
import coldfusion.util.RB;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PDFGServiceImpl
extends ServiceBase
implements PDFGService {
    private String serverIPAddress;
    private String hostName;
    private Logger logger = CFLogs.SERVER_LOG;
    private static final String JETTY_READ_ERROR = "jettyReadError";
    private static final String JETYXML_PATHPART = File.separator + "jetty" + File.separator + "etc" + File.separator + "jetty.xml";
    private File config_file = null;
    private File wmimagefile = null;
    private ConfigMap fontConfigMap = null;
    private ConfigMap userFontConfigMap = null;
    private ConfigMap localOpenOfficeConfig = null;
    private ConfigMap remoteOpenOfficeConfig = null;
    private ConfigMap pdfgServiceManagersConfig = null;
    private static Set systemFontDirs = new HashSet();
    private static Set<String> userFontDirs = new HashSet<String>();
    private boolean initialized = false;
    private PDFgServiceManagerHelper pdfgHelper = PDFgServiceManagerHelper.getInstance();
    private String officeLocation = "";
    private String hostname = "";
    private String port = "";
    private int expiryTime = 300;

    public PDFGServiceImpl() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.serverIPAddress = localHost.getHostAddress();
            this.hostName = localHost.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"PDFG Service: Unable to determine server IP address.", (Throwable)e);
            this.serverIPAddress = "";
        }
    }

    public PDFGServiceImpl(File config_file, File wmimagefile) {
        this.config_file = config_file;
        this.wmimagefile = wmimagefile;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.serverIPAddress = localHost.getHostAddress();
            this.hostName = localHost.getHostName();
        }
        catch (UnknownHostException e) {
            this.logger.warn((Object)"PDFG Service: Unable to determine server IP address.", (Throwable)e);
            this.serverIPAddress = "";
        }
        this.setEnableWatch(true);
        this.setWatchFile(config_file);
    }

    public void start() throws ServiceException {
        super.start();
        if (this.isFirstLoad() && SystemInfo.isMac()) {
            JPedalFontRegistry.init();
        }
        new Thread(){

            @Override
            public void run() {
                PDFGServiceImpl.this.initializePDFGService();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePDFGService() {
        try {
            PDFgServiceManager serviceManager;
            try {
                Object sCFFontDir = ServiceFactory.getRuntimeService().getRootDir() + File.separator + "lib" + File.separator + "fonts";
                if (System.getProperty("os.name").startsWith("Mac OS")) {
                    sCFFontDir = ((String)sCFFontDir).concat(File.separator + "_macos");
                }
                if (!Boolean.getBoolean("coldfusion.disableassemblerfonts")) {
                    this.callAssemblerInitFonts();
                }
            }
            catch (Throwable e) {
                CFLogs.SERVER_LOG.error(e);
            }
            this.pdfgHelper.generateKeyPair();
            if (!Boolean.getBoolean("coldfusion.pdfgskip")) {
                this.loadPDFgServiceManagers();
            }
            this.pdfgServiceManagersConfig.setConfigMapListener((ConfigMapListener)this);
            if (this.isFirstLoad()) {
                this.pdfgServiceManagersConfig.setChanged();
            }
            if ((serviceManager = this.pdfgHelper.getServiceManager("localhost")).getEngine().equalsIgnoreCase("webkit") && !SystemInfo.isWindows() && !SystemInfo.isLinux() && this.pdfgHelper.getServiceManager("localhost") != null) {
                this.removeSM("localhost");
                CFLogs.SERVER_LOG.error((Object)"Local service Manager found on unsupported platform.");
            }
            HtmlToPdfTag.setupWaterMarkImage();
        }
        catch (Throwable e) {
            CFLogs.SERVER_LOG.error(e);
        }
        PDFGServiceImpl pDFGServiceImpl = this;
        synchronized (pDFGServiceImpl) {
            this.initialized = true;
            ((Object)((Object)this)).notifyAll();
        }
    }

    private void registerUserFonts() {
        Enumeration keysEnum = this.userFontConfigMap.keys();
        while (keysEnum.hasMoreElements()) {
            Object key = keysEnum.nextElement();
            String path = (String)this.userFontConfigMap.get(key);
            File file = new File(path);
            try {
                if (file.isDirectory()) {
                    JPedalFontRegistry.registerDirectory((String)path);
                    userFontDirs.add(path);
                    continue;
                }
                JPedalFontRegistry.register((String)path);
                int index = path.indexOf(",");
                if (index > 0) {
                    userFontDirs.add(path.substring(0, index));
                    continue;
                }
                userFontDirs.add(path);
            }
            catch (RuntimeException e) {
                CFLogs.SERVER_LOG.applog("information", "DocumentService", "", (Throwable)e);
                this.userFontConfigMap.remove(key);
            }
        }
    }

    private void callAssemblerInitFonts() {
        Iterator<String> iter = userFontDirs.iterator();
        while (iter.hasNext()) {
            String path = iter.next();
            if (new File(path).exists()) continue;
            iter.remove();
        }
        PDFService pdfService = ServiceFactory.getPDFService();
        if (pdfService != null) {
            pdfService.initFonts(new LinkedList<String>(userFontDirs), null, new LinkedList(systemFontDirs));
        }
    }

    public void startJettyServer() throws ServiceException {
        try {
            if (!this.isPDFGServerRunning()) {
                PDFGServer.getInstance().startServer();
            }
        }
        catch (Exception e) {
            CFLogs.MONITOR_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public void stopJettyServer() throws ServiceException {
        try {
            PDFGServer.getInstance().stopServer();
        }
        catch (Exception e) {
            CFLogs.MONITOR_LOG.error((Throwable)e);
            throw new ServiceException((Throwable)e);
        }
    }

    public boolean isPDFGServerRunning() {
        return PDFGServer.getInstance().isRunning();
    }

    public int getJettyServerPort() {
        return PDFGServer.getInstance().getPort();
    }

    public String getJettyServerProtocol() {
        return PDFGServer.getInstance().getProtocol();
    }

    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public String getServerHostName() {
        return this.hostName;
    }

    public void load() throws ServiceException {
        this.fontConfigMap = new ConfigMap();
        this.fontConfigMap.init((Service)this, "neo_font");
        try {
            try {
                Object configObject = this.deserialize(this.config_file);
                if (configObject instanceof Vector) {
                    Vector configObject2 = (Vector)configObject;
                    this.userFontConfigMap = (ConfigMap)configObject2.get(0);
                    this.localOpenOfficeConfig = (ConfigMap)configObject2.get(1);
                    this.remoteOpenOfficeConfig = (ConfigMap)configObject2.get(2);
                    if (configObject2.size() > 3) {
                        this.pdfgServiceManagersConfig = (ConfigMap)configObject2.get(3);
                    }
                } else {
                    this.userFontConfigMap = (ConfigMap)configObject;
                }
                if (this.localOpenOfficeConfig != null) {
                    this.officeLocation = (String)this.localOpenOfficeConfig.get((Object)"path");
                    if (this.officeLocation == null) {
                        this.officeLocation = "";
                    }
                } else {
                    this.localOpenOfficeConfig = new ConfigMap();
                }
                if (this.remoteOpenOfficeConfig != null) {
                    this.hostname = (String)this.remoteOpenOfficeConfig.get((Object)"hostname");
                    this.port = (String)this.remoteOpenOfficeConfig.get((Object)"port");
                    if (this.hostname == null) {
                        this.hostname = "";
                        this.port = "";
                    }
                } else {
                    this.remoteOpenOfficeConfig = new ConfigMap();
                }
                if (this.pdfgServiceManagersConfig == null) {
                    this.pdfgServiceManagersConfig = new ConfigMap();
                }
            }
            catch (Exception ex) {
                CFLogs.SERVER_LOG.applog("information", "DocumentService", "Recovering from a corrupt neo-document.xml file", (Throwable)ex);
                this.userFontConfigMap = new ConfigMap();
                this.remoteOpenOfficeConfig = new ConfigMap();
                this.localOpenOfficeConfig = new ConfigMap();
                CFLogs.SERVER_LOG.applog("information", "DocumentService", "Recovered from a corrupt neo-document.xml file");
            }
            this.userFontConfigMap.init((Service)this, "neo_user_font");
            this.localOpenOfficeConfig.init((Service)this, "openoffice_local_config");
            this.remoteOpenOfficeConfig.init((Service)this, "openoffice_remote_config");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException((Throwable)ex);
        }
    }

    public void store() throws ServiceException {
        super.store();
        Vector<ConfigMap> settings = new Vector<ConfigMap>();
        settings.add(0, this.userFontConfigMap);
        settings.add(1, this.localOpenOfficeConfig);
        settings.add(2, this.remoteOpenOfficeConfig);
        settings.add(3, this.pdfgServiceManagersConfig);
        this.serialize(settings, this.config_file);
    }

    public void store(boolean broadcast) throws ServiceException {
        this.store(null, null, null, broadcast);
    }

    public void store(Object key, Object value, Object oldValue) throws ServiceException {
        this.store(key, value, oldValue, true);
    }

    public void store(Object key, Object value, Object oldValue, boolean broadCast) throws ServiceException {
        super.store();
        Vector<ConfigMap> settings = new Vector<ConfigMap>();
        settings.add(0, this.userFontConfigMap);
        settings.add(1, this.localOpenOfficeConfig);
        settings.add(2, this.remoteOpenOfficeConfig);
        settings.add(3, this.pdfgServiceManagersConfig);
        this.serialize(settings, this.config_file, broadCast, key, value, oldValue);
    }

    private void createLocalPDFgServiceManager() {
        PDFgServiceManager serviceManager = this.pdfgHelper.createLocalPDFgServiceManager();
        this.pdfgServiceManagersConfig.put((Object)serviceManager.getName(), (Object)this.pdfgHelper.serializeToMap(serviceManager));
    }

    private void loadPDFgServiceManagers() {
        if (this.pdfgServiceManagersConfig.isEmpty() && PDFgServiceManagerHelper.supportsLocalSM) {
            this.updateDefaultPDFGPort();
            this.createLocalPDFgServiceManager();
        } else {
            Enumeration keys = this.pdfgServiceManagersConfig.keys();
            while (keys.hasMoreElements()) {
                boolean updateConfig;
                String itemKey = (String)keys.nextElement();
                Object itemObj = this.pdfgServiceManagersConfig.get((Object)itemKey);
                if (!(itemObj instanceof ConfigMap)) continue;
                PDFgServiceManager manager = this.pdfgHelper.loadFromConfigMap((ConfigMap)itemObj);
                if (manager != null && !manager.isLocal() && manager.isEnabled()) {
                    try {
                        ServiceFactory.getPDFGService().startJettyServer();
                    }
                    catch (ServiceException serviceException) {
                        // empty catch block
                    }
                }
                if (!(updateConfig = this.pdfgHelper.addServiceManager(manager, false))) continue;
                this.pdfgServiceManagersConfig.put((Object)manager.getName(), (Object)this.pdfgHelper.serializeToMap(manager));
            }
        }
    }

    private void updateDefaultPDFGPort() {
        String jettyFilePath = ServiceFactory.getRuntimeService().getRootDir() + JETYXML_PATHPART;
        try {
            File jettyFile = new File(jettyFilePath);
            if (jettyFile != null && jettyFile.exists()) {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = builder.parse(jettyFile);
                NodeList list = doc.getElementsByTagName("*");
                block2: for (int i = 0; i < list.getLength(); ++i) {
                    NodeList childNodes;
                    String classValue;
                    Element element = (Element)list.item(i);
                    if (element == null || !element.getNodeName().equalsIgnoreCase("New") || (classValue = element.getAttribute("class")) == null || !classValue.toLowerCase().endsWith("connector") || (childNodes = element.getElementsByTagName("Set")) == null) continue;
                    int len = childNodes.getLength();
                    for (int j = 0; j < len; ++j) {
                        Node portValueNode;
                        Element childElement = (Element)childNodes.item(j);
                        if (childElement == null || !childElement.getAttribute("name").equalsIgnoreCase("port") || (portValueNode = childElement.getFirstChild()) == null) continue;
                        if (portValueNode.getNodeName().equalsIgnoreCase("SystemProperty")) {
                            Node portAttrNameAttr = portValueNode.getAttributes().getNamedItem("name");
                            if (portAttrNameAttr == null || !portAttrNameAttr.getNodeValue().equalsIgnoreCase("jetty.port")) continue;
                            Node portAttrDefaultAttr = portValueNode.getAttributes().getNamedItem("default");
                            String portAttrText = portAttrDefaultAttr.getNodeValue();
                            this.pdfgHelper.setDefaultPort(new Integer(portAttrText));
                            continue block2;
                        }
                        String portNodeText = portValueNode.getTextContent();
                        if (portNodeText == null || portNodeText.length() <= 0) continue;
                        this.pdfgHelper.setDefaultPort(new Integer(portNodeText));
                        continue block2;
                    }
                }
            }
        }
        catch (Exception e) {
            CFLogs.SERVER_LOG.error((Object)RB.getString(PDFGServiceImpl.class, (String)JETTY_READ_ERROR), (Throwable)e);
        }
    }

    private void serializeServiceManagers() {
        for (PDFgServiceManager manager : this.pdfgHelper.getServiceManagers()) {
            if (manager == null) continue;
            this.pdfgServiceManagersConfig.put((Object)manager.getName(), (Object)this.pdfgHelper.serializeToMap(manager));
        }
    }

    public void enableServiceManager(String name) {
        if (name != null && name.length() > 0) {
            if (ServiceFactory.getLicenseService().isStandard() && !this.isServiceManagerEnabled()) {
                throw new LicenseRestrictionServiceManagerException();
            }
            PDFgServiceManager serviceManager = this.pdfgHelper.getServiceManager(name);
            if (serviceManager == null) {
                throw new NoSuchServiceManagerException(name);
            }
            if (serviceManager != null && !serviceManager.isLocal()) {
                try {
                    ServiceFactory.getPDFGService().startJettyServer();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            if ((serviceManager = this.pdfgHelper.enableServiceManager(serviceManager)) != null) {
                this.pdfgServiceManagersConfig.put((Object)serviceManager.getName(), (Object)this.pdfgHelper.serializeToMap(serviceManager));
            }
        } else {
            throw new NoSuchServiceManagerException(name);
        }
    }

    private boolean isServiceManagerEnabled() throws LicenseRestrictionServiceManagerException {
        List<PDFgServiceManager> servicemgrs = this.pdfgHelper.getServiceManagers();
        for (int i = 0; i < servicemgrs.size(); ++i) {
            if (!servicemgrs.get(i).isEnabled()) continue;
            return false;
        }
        return true;
    }

    public void disableServiceManager(String name) {
        if (name != null && name.length() > 0) {
            PDFgServiceManager serviceManager = this.pdfgHelper.getServiceManager(name);
            if (serviceManager == null) {
                throw new NoSuchServiceManagerException(name);
            }
            if ((serviceManager = this.pdfgHelper.disableServiceManager(serviceManager)) != null) {
                this.pdfgServiceManagersConfig.put((Object)serviceManager.getName(), (Object)this.pdfgHelper.serializeToMap(serviceManager));
                Enumeration keys = this.pdfgServiceManagersConfig.keys();
                int nonOfRemoteServicesEnabled = 0;
                while (keys.hasMoreElements()) {
                    PDFgServiceManager manager;
                    String itemKey = (String)keys.nextElement();
                    Object itemObj = this.pdfgServiceManagersConfig.get((Object)itemKey);
                    if (!(itemObj instanceof ConfigMap) || (manager = this.pdfgHelper.loadFromConfigMap((ConfigMap)itemObj)) == null || manager.isLocal() || !manager.isEnabled()) continue;
                    ++nonOfRemoteServicesEnabled;
                    break;
                }
                if (nonOfRemoteServicesEnabled == 0) {
                    try {
                        ServiceFactory.getPDFGService().stopJettyServer();
                    }
                    catch (ServiceException serviceException) {}
                }
            }
        } else {
            throw new NoSuchServiceManagerException(name);
        }
    }

    public void removeServiceManager(String name) {
        if (name == null || IPAddressUtils.isLocalHost((String)name)) {
            throw new LocalServiceManagerException("remove");
        }
        this.removeSM(name);
    }

    private void removeSM(String name) {
        PDFgServiceManager serviceManager = this.pdfgHelper.getServiceManager(name);
        if (serviceManager == null) {
            throw new NoSuchServiceManagerException(name);
        }
        if (serviceManager.isEnabled()) {
            this.pdfgHelper.checkDisabledForStd();
        }
        this.pdfgHelper.unRegisterServiceManager(serviceManager, true);
        this.pdfgServiceManagersConfig.setConfigMapListener(null);
        Object oldValue = this.pdfgServiceManagersConfig.remove((Object)name);
        try {
            this.store(name, null, oldValue, true);
        }
        catch (ServiceException e1) {
            CFLogs.SERVER_LOG.error((Throwable)e1);
        }
        this.pdfgServiceManagersConfig.setConfigMapListener((ConfigMapListener)this);
        Enumeration keys = this.pdfgServiceManagersConfig.keys();
        int nonOfRemoteServicesEnabled = 0;
        while (keys.hasMoreElements()) {
            PDFgServiceManager manager;
            String itemKey = (String)keys.nextElement();
            Object itemObj = this.pdfgServiceManagersConfig.get((Object)itemKey);
            if (!(itemObj instanceof ConfigMap) || (manager = this.pdfgHelper.loadFromConfigMap((ConfigMap)itemObj)) == null || manager.isLocal() || !manager.isEnabled()) continue;
            ++nonOfRemoteServicesEnabled;
            break;
        }
        if (nonOfRemoteServicesEnabled == 0) {
            try {
                ServiceFactory.getPDFGService().stopJettyServer();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
    }

    public void editServiceManager(String name, String hostname, int port, int weight, boolean isHttps, String engine) {
        String host;
        String localSMName;
        PDFgServiceManager serviceManager;
        if (name != null && name.length() > 0) {
            serviceManager = this.pdfgHelper.getServiceManager(name);
            if (serviceManager == null) {
                throw new NoSuchServiceManagerException(name);
            }
            localSMName = name;
            host = hostname;
            if (serviceManager.isLocal()) {
                localSMName = serviceManager.getName();
                if (!IPAddressUtils.isLocalHost((String)hostname)) {
                    throw new InvalidLocalServiceManagerAddressException(hostname);
                }
            }
            if (serviceManager.isEnabled()) {
                this.pdfgHelper.checkDisabledForStd();
            }
        } else {
            throw new NoSuchServiceManagerException(name);
        }
        this.pdfgHelper.unRegisterServiceManager(serviceManager, true);
        this.pdfgServiceManagersConfig.remove((Object)localSMName);
        serviceManager.update(localSMName, host, port, weight, isHttps, engine);
        this.pdfgHelper.addServiceManager(serviceManager);
        this.pdfgServiceManagersConfig.put((Object)name, (Object)this.pdfgHelper.serializeToMap(serviceManager));
    }

    public void addServiceManager(String name, String hostname, int port, int weight, boolean isHttps, String engine) {
        if (name != null && !IPAddressUtils.isLocalHost((String)hostname)) {
            PDFgServiceManager serviceManager = this.pdfgHelper.getServiceManager(name);
            if (serviceManager != null) {
                throw new ServiceManagerExistsException();
            }
            serviceManager = this.pdfgHelper.createRegisterPDFgServiceManager(name, hostname, port, weight, isHttps, engine);
            this.pdfgServiceManagersConfig.put((Object)serviceManager.getName(), (Object)this.pdfgHelper.serializeToMap(serviceManager));
            if (serviceManager != null && !serviceManager.isLocal()) {
                try {
                    ServiceFactory.getPDFGService().startJettyServer();
                }
                catch (ServiceException serviceException) {}
            }
        } else {
            throw new LocalServiceManagerException("add");
        }
    }

    public ConfigMap getServiceManager(String name) {
        if (name != null && !name.isEmpty()) {
            ConfigMap serviceManager = (ConfigMap)this.pdfgServiceManagersConfig.get((Object)name);
            if (serviceManager == null || serviceManager != null && serviceManager.isEmpty()) {
                throw new NoSuchServiceManagerException(name);
            }
            return serviceManager;
        }
        throw new NoSuchServiceManagerException(name);
    }

    public ConfigMap getAllServiceManagers() {
        return this.pdfgServiceManagersConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyServiceManager(String name) {
        boolean verifyStatus = false;
        if (name != null && name.length() > 0) {
            PDFgServiceManager serviceManager = this.pdfgHelper.getServiceManager(name);
            if (serviceManager == null) {
                throw new NoSuchServiceManagerException(name);
            }
            boolean oldEnableStatus = serviceManager.isEnabled();
            try {
                verifyStatus = this.pdfgHelper.verifyServiceManager(serviceManager);
            }
            finally {
                if (serviceManager.isEnabled() != oldEnableStatus) {
                    this.pdfgServiceManagersConfig.put((Object)serviceManager.getName(), (Object)this.pdfgHelper.serializeToMap(serviceManager));
                }
            }
        } else {
            throw new NoSuchServiceManagerException(name);
        }
        return verifyStatus;
    }

    public boolean isInstanceOfPDFGService(Object obj) {
        return obj instanceof PDFGServiceImpl;
    }

    public String getOSName() {
        return System.getProperty("os.name");
    }

    public static class LicenseRestrictionServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
    }

    public static class NoSuchServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String name = "";

        public NoSuchServiceManagerException() {
        }

        public NoSuchServiceManagerException(String name) {
            this.name = name;
        }
    }

    public static class LocalServiceManagerException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String action = "remove";

        public LocalServiceManagerException() {
        }

        public LocalServiceManagerException(String action) {
            this.action = action;
        }
    }

    public static class InvalidLocalServiceManagerAddressException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String hostname;

        public InvalidLocalServiceManagerAddressException(String hostname) {
            this.hostname = hostname;
        }
    }

    public static class ServiceManagerExistsException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        public String host = "";
    }
}

