/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.annotations.Nullable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.internal.fuseable.ConditionalSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.BasicQueueSubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import org.reactivestreams.Subscriber;

public final class FlowableRange
extends Flowable<Integer> {
    final int start;
    final int end;

    public FlowableRange(int start2, int count) {
        this.start = start2;
        this.end = start2 + count;
    }

    @Override
    public void subscribeActual(Subscriber<? super Integer> s) {
        if (s instanceof ConditionalSubscriber) {
            s.onSubscribe(new RangeConditionalSubscription((ConditionalSubscriber)s, this.start, this.end));
        } else {
            s.onSubscribe(new RangeSubscription(s, this.start, this.end));
        }
    }

    static final class RangeConditionalSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final ConditionalSubscriber<? super Integer> downstream;

        RangeConditionalSubscription(ConditionalSubscriber<? super Integer> actual, int index, int end) {
            super(index, end);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            int f = this.end;
            ConditionalSubscriber<? super Integer> a = this.downstream;
            for (int i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                a.tryOnNext((Integer)i);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            int f = this.end;
            int i = this.index;
            ConditionalSubscriber<? super Integer> a = this.downstream;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    if (a.tryOnNext((Integer)i)) {
                        ++e;
                    }
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static final class RangeSubscription
    extends BaseRangeSubscription {
        private static final long serialVersionUID = 2587302975077663557L;
        final Subscriber<? super Integer> downstream;

        RangeSubscription(Subscriber<? super Integer> actual, int index, int end) {
            super(index, end);
            this.downstream = actual;
        }

        @Override
        void fastPath() {
            int f = this.end;
            Subscriber<? super Integer> a = this.downstream;
            for (int i = this.index; i != f; ++i) {
                if (this.cancelled) {
                    return;
                }
                a.onNext((Integer)i);
            }
            if (this.cancelled) {
                return;
            }
            a.onComplete();
        }

        @Override
        void slowPath(long r) {
            long e = 0L;
            int f = this.end;
            int i = this.index;
            Subscriber<? super Integer> a = this.downstream;
            while (true) {
                if (e != r && i != f) {
                    if (this.cancelled) {
                        return;
                    }
                    a.onNext((Integer)i);
                    ++e;
                    ++i;
                    continue;
                }
                if (i == f) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                r = this.get();
                if (e != r) continue;
                this.index = i;
                r = this.addAndGet(-e);
                if (r == 0L) {
                    return;
                }
                e = 0L;
            }
        }
    }

    static abstract class BaseRangeSubscription
    extends BasicQueueSubscription<Integer> {
        private static final long serialVersionUID = -2252972430506210021L;
        final int end;
        int index;
        volatile boolean cancelled;

        BaseRangeSubscription(int index, int end) {
            this.index = index;
            this.end = end;
        }

        @Override
        public final int requestFusion(int mode) {
            return mode & 1;
        }

        @Override
        @Nullable
        public final Integer poll() {
            int i = this.index;
            if (i == this.end) {
                return null;
            }
            this.index = i + 1;
            return i;
        }

        @Override
        public final boolean isEmpty() {
            return this.index == this.end;
        }

        @Override
        public final void clear() {
            this.index = this.end;
        }

        @Override
        public final void request(long n) {
            if (SubscriptionHelper.validate(n) && BackpressureHelper.add(this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastPath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        @Override
        public final void cancel() {
            this.cancelled = true;
        }

        abstract void fastPath();

        abstract void slowPath(long var1);
    }
}

