/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.request.RequestHeaders;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.Executor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public interface ApolloInterceptor {
    public void interceptAsync(@NotNull InterceptorRequest var1, @NotNull ApolloInterceptorChain var2, @NotNull Executor var3, @NotNull CallBack var4);

    public void dispose();

    public static final class InterceptorRequest {
        public final UUID uniqueId = UUID.randomUUID();
        public final Operation operation;
        public final CacheHeaders cacheHeaders;
        public final RequestHeaders requestHeaders;
        public final boolean fetchFromCache;
        public final Optional<Operation.Data> optimisticUpdates;
        public final boolean sendQueryDocument;
        public final boolean useHttpGetMethodForQueries;
        public final boolean autoPersistQueries;

        InterceptorRequest(Operation operation, CacheHeaders cacheHeaders, RequestHeaders requestHeaders, Optional<Operation.Data> optimisticUpdates, boolean fetchFromCache, boolean sendQueryDocument, boolean useHttpGetMethodForQueries, boolean autoPersistQueries) {
            this.operation = operation;
            this.cacheHeaders = cacheHeaders;
            this.requestHeaders = requestHeaders;
            this.optimisticUpdates = optimisticUpdates;
            this.fetchFromCache = fetchFromCache;
            this.sendQueryDocument = sendQueryDocument;
            this.useHttpGetMethodForQueries = useHttpGetMethodForQueries;
            this.autoPersistQueries = autoPersistQueries;
        }

        public Builder toBuilder() {
            return new Builder(this.operation).cacheHeaders(this.cacheHeaders).requestHeaders(this.requestHeaders).fetchFromCache(this.fetchFromCache).optimisticUpdates(this.optimisticUpdates.orNull()).sendQueryDocument(this.sendQueryDocument).useHttpGetMethodForQueries(this.useHttpGetMethodForQueries).autoPersistQueries(this.autoPersistQueries);
        }

        public static Builder builder(@NotNull Operation operation) {
            return new Builder(operation);
        }

        public static final class Builder {
            private final Operation operation;
            private CacheHeaders cacheHeaders = CacheHeaders.NONE;
            private RequestHeaders requestHeaders = RequestHeaders.NONE;
            private boolean fetchFromCache;
            private Optional<Operation.Data> optimisticUpdates = Optional.absent();
            private boolean sendQueryDocument = true;
            private boolean useHttpGetMethodForQueries;
            private boolean autoPersistQueries;

            Builder(@NotNull Operation operation) {
                this.operation = Utils.checkNotNull(operation, "operation == null");
            }

            public Builder cacheHeaders(@NotNull CacheHeaders cacheHeaders) {
                this.cacheHeaders = Utils.checkNotNull(cacheHeaders, "cacheHeaders == null");
                return this;
            }

            public Builder requestHeaders(@NotNull RequestHeaders requestHeaders) {
                this.requestHeaders = Utils.checkNotNull(requestHeaders, "requestHeaders == null");
                return this;
            }

            public Builder fetchFromCache(boolean fetchFromCache) {
                this.fetchFromCache = fetchFromCache;
                return this;
            }

            public Builder optimisticUpdates(Operation.Data optimisticUpdates) {
                this.optimisticUpdates = Optional.fromNullable(optimisticUpdates);
                return this;
            }

            public Builder optimisticUpdates(@NotNull Optional<Operation.Data> optimisticUpdates) {
                this.optimisticUpdates = Utils.checkNotNull(optimisticUpdates, "optimisticUpdates == null");
                return this;
            }

            public Builder sendQueryDocument(boolean sendQueryDocument) {
                this.sendQueryDocument = sendQueryDocument;
                return this;
            }

            public Builder useHttpGetMethodForQueries(boolean useHttpGetMethodForQueries) {
                this.useHttpGetMethodForQueries = useHttpGetMethodForQueries;
                return this;
            }

            public Builder autoPersistQueries(boolean autoPersistQueries) {
                this.autoPersistQueries = autoPersistQueries;
                return this;
            }

            public InterceptorRequest build() {
                return new InterceptorRequest(this.operation, this.cacheHeaders, this.requestHeaders, this.optimisticUpdates, this.fetchFromCache, this.sendQueryDocument, this.useHttpGetMethodForQueries, this.autoPersistQueries);
            }
        }
    }

    public static final class InterceptorResponse {
        public final Optional<Response> httpResponse;
        public final Optional<com.apollographql.apollo.api.Response> parsedResponse;
        public final Optional<Collection<Record>> cacheRecords;

        public InterceptorResponse(Response httpResponse) {
            this(httpResponse, null, null);
        }

        public InterceptorResponse(Response httpResponse, com.apollographql.apollo.api.Response parsedResponse, Collection<Record> cacheRecords) {
            this.httpResponse = Optional.fromNullable(httpResponse);
            this.parsedResponse = Optional.fromNullable(parsedResponse);
            this.cacheRecords = Optional.fromNullable(cacheRecords);
        }
    }

    public static enum FetchSourceType {
        CACHE,
        NETWORK;

    }

    public static interface CallBack {
        public void onResponse(@NotNull InterceptorResponse var1);

        public void onFetch(FetchSourceType var1);

        public void onFailure(@NotNull ApolloException var1);

        public void onCompleted();
    }
}

