/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.IpEvidence;
import com.microsoft.graph.models.security.ProtocolType;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class NetworkConnectionEvidence
extends AlertEvidence
implements Parsable {
    public NetworkConnectionEvidence() {
        this.setOdataType("#microsoft.graph.security.networkConnectionEvidence");
    }

    @Nonnull
    public static NetworkConnectionEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new NetworkConnectionEvidence();
    }

    @Nullable
    public IpEvidence getDestinationAddress() {
        return (IpEvidence)this.backingStore.get("destinationAddress");
    }

    @Nullable
    public Integer getDestinationPort() {
        return (Integer)this.backingStore.get("destinationPort");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("destinationAddress", n -> this.setDestinationAddress((IpEvidence)n.getObjectValue(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("destinationPort", n -> this.setDestinationPort(n.getIntegerValue()));
        deserializerMap.put("protocol", n -> this.setProtocol((ProtocolType)n.getEnumValue(ProtocolType::forValue)));
        deserializerMap.put("sourceAddress", n -> this.setSourceAddress((IpEvidence)n.getObjectValue(IpEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("sourcePort", n -> this.setSourcePort(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public ProtocolType getProtocol() {
        return (ProtocolType)((Object)this.backingStore.get("protocol"));
    }

    @Nullable
    public IpEvidence getSourceAddress() {
        return (IpEvidence)this.backingStore.get("sourceAddress");
    }

    @Nullable
    public Integer getSourcePort() {
        return (Integer)this.backingStore.get("sourcePort");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("destinationAddress", (Parsable)this.getDestinationAddress(), new Parsable[0]);
        writer.writeIntegerValue("destinationPort", this.getDestinationPort());
        writer.writeEnumValue("protocol", (Enum)this.getProtocol());
        writer.writeObjectValue("sourceAddress", (Parsable)this.getSourceAddress(), new Parsable[0]);
        writer.writeIntegerValue("sourcePort", this.getSourcePort());
    }

    public void setDestinationAddress(@Nullable IpEvidence value) {
        this.backingStore.set("destinationAddress", (Object)value);
    }

    public void setDestinationPort(@Nullable Integer value) {
        this.backingStore.set("destinationPort", (Object)value);
    }

    public void setProtocol(@Nullable ProtocolType value) {
        this.backingStore.set("protocol", (Object)value);
    }

    public void setSourceAddress(@Nullable IpEvidence value) {
        this.backingStore.set("sourceAddress", (Object)value);
    }

    public void setSourcePort(@Nullable Integer value) {
        this.backingStore.set("sourcePort", (Object)value);
    }
}

