/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.security.CaseEscaped;
import com.microsoft.graph.models.security.CaseOperation;
import com.microsoft.graph.models.security.EdiscoveryCaseSettings;
import com.microsoft.graph.models.security.EdiscoveryCustodian;
import com.microsoft.graph.models.security.EdiscoveryNoncustodialDataSource;
import com.microsoft.graph.models.security.EdiscoveryReviewSet;
import com.microsoft.graph.models.security.EdiscoveryReviewTag;
import com.microsoft.graph.models.security.EdiscoverySearch;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class EdiscoveryCase
extends CaseEscaped
implements Parsable {
    public EdiscoveryCase() {
        this.setOdataType("#microsoft.graph.security.ediscoveryCase");
    }

    @Nonnull
    public static EdiscoveryCase createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new EdiscoveryCase();
    }

    @Nullable
    public IdentitySet getClosedBy() {
        return (IdentitySet)this.backingStore.get("closedBy");
    }

    @Nullable
    public OffsetDateTime getClosedDateTime() {
        return (OffsetDateTime)this.backingStore.get("closedDateTime");
    }

    @Nullable
    public List<EdiscoveryCustodian> getCustodians() {
        return (List)this.backingStore.get("custodians");
    }

    @Nullable
    public String getExternalId() {
        return (String)this.backingStore.get("externalId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("closedBy", n -> this.setClosedBy((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        deserializerMap.put("closedDateTime", n -> this.setClosedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("custodians", n -> this.setCustodians(n.getCollectionOfObjectValues(EdiscoveryCustodian::createFromDiscriminatorValue)));
        deserializerMap.put("externalId", n -> this.setExternalId(n.getStringValue()));
        deserializerMap.put("noncustodialDataSources", n -> this.setNoncustodialDataSources(n.getCollectionOfObjectValues(EdiscoveryNoncustodialDataSource::createFromDiscriminatorValue)));
        deserializerMap.put("operations", n -> this.setOperations(n.getCollectionOfObjectValues(CaseOperation::createFromDiscriminatorValue)));
        deserializerMap.put("reviewSets", n -> this.setReviewSets(n.getCollectionOfObjectValues(EdiscoveryReviewSet::createFromDiscriminatorValue)));
        deserializerMap.put("searches", n -> this.setSearches(n.getCollectionOfObjectValues(EdiscoverySearch::createFromDiscriminatorValue)));
        deserializerMap.put("settings", n -> this.setSettings((EdiscoveryCaseSettings)n.getObjectValue(EdiscoveryCaseSettings::createFromDiscriminatorValue)));
        deserializerMap.put("tags", n -> this.setTags(n.getCollectionOfObjectValues(EdiscoveryReviewTag::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<EdiscoveryNoncustodialDataSource> getNoncustodialDataSources() {
        return (List)this.backingStore.get("noncustodialDataSources");
    }

    @Nullable
    public List<CaseOperation> getOperations() {
        return (List)this.backingStore.get("operations");
    }

    @Nullable
    public List<EdiscoveryReviewSet> getReviewSets() {
        return (List)this.backingStore.get("reviewSets");
    }

    @Nullable
    public List<EdiscoverySearch> getSearches() {
        return (List)this.backingStore.get("searches");
    }

    @Nullable
    public EdiscoveryCaseSettings getSettings() {
        return (EdiscoveryCaseSettings)this.backingStore.get("settings");
    }

    @Nullable
    public List<EdiscoveryReviewTag> getTags() {
        return (List)this.backingStore.get("tags");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("closedBy", (Parsable)this.getClosedBy(), new Parsable[0]);
        writer.writeOffsetDateTimeValue("closedDateTime", this.getClosedDateTime());
        writer.writeCollectionOfObjectValues("custodians", this.getCustodians());
        writer.writeStringValue("externalId", this.getExternalId());
        writer.writeCollectionOfObjectValues("noncustodialDataSources", this.getNoncustodialDataSources());
        writer.writeCollectionOfObjectValues("operations", this.getOperations());
        writer.writeCollectionOfObjectValues("reviewSets", this.getReviewSets());
        writer.writeCollectionOfObjectValues("searches", this.getSearches());
        writer.writeObjectValue("settings", (Parsable)this.getSettings(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("tags", this.getTags());
    }

    public void setClosedBy(@Nullable IdentitySet value) {
        this.backingStore.set("closedBy", (Object)value);
    }

    public void setClosedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("closedDateTime", (Object)value);
    }

    public void setCustodians(@Nullable List<EdiscoveryCustodian> value) {
        this.backingStore.set("custodians", value);
    }

    public void setExternalId(@Nullable String value) {
        this.backingStore.set("externalId", (Object)value);
    }

    public void setNoncustodialDataSources(@Nullable List<EdiscoveryNoncustodialDataSource> value) {
        this.backingStore.set("noncustodialDataSources", value);
    }

    public void setOperations(@Nullable List<CaseOperation> value) {
        this.backingStore.set("operations", value);
    }

    public void setReviewSets(@Nullable List<EdiscoveryReviewSet> value) {
        this.backingStore.set("reviewSets", value);
    }

    public void setSearches(@Nullable List<EdiscoverySearch> value) {
        this.backingStore.set("searches", value);
    }

    public void setSettings(@Nullable EdiscoveryCaseSettings value) {
        this.backingStore.set("settings", (Object)value);
    }

    public void setTags(@Nullable List<EdiscoveryReviewTag> value) {
        this.backingStore.set("tags", value);
    }
}

