/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.security;

import com.microsoft.graph.models.security.AlertEvidence;
import com.microsoft.graph.models.security.UserEvidence;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CloudLogonSessionEvidence
extends AlertEvidence
implements Parsable {
    public CloudLogonSessionEvidence() {
        this.setOdataType("#microsoft.graph.security.cloudLogonSessionEvidence");
    }

    @Nonnull
    public static CloudLogonSessionEvidence createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CloudLogonSessionEvidence();
    }

    @Nullable
    public UserEvidence getAccount() {
        return (UserEvidence)this.backingStore.get("account");
    }

    @Nullable
    public String getBrowser() {
        return (String)this.backingStore.get("browser");
    }

    @Nullable
    public String getDeviceName() {
        return (String)this.backingStore.get("deviceName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("account", n -> this.setAccount((UserEvidence)n.getObjectValue(UserEvidence::createFromDiscriminatorValue)));
        deserializerMap.put("browser", n -> this.setBrowser(n.getStringValue()));
        deserializerMap.put("deviceName", n -> this.setDeviceName(n.getStringValue()));
        deserializerMap.put("operatingSystem", n -> this.setOperatingSystem(n.getStringValue()));
        deserializerMap.put("previousLogonDateTime", n -> this.setPreviousLogonDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("protocol", n -> this.setProtocol(n.getStringValue()));
        deserializerMap.put("sessionId", n -> this.setSessionId(n.getStringValue()));
        deserializerMap.put("startUtcDateTime", n -> this.setStartUtcDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("userAgent", n -> this.setUserAgent(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOperatingSystem() {
        return (String)this.backingStore.get("operatingSystem");
    }

    @Nullable
    public OffsetDateTime getPreviousLogonDateTime() {
        return (OffsetDateTime)this.backingStore.get("previousLogonDateTime");
    }

    @Nullable
    public String getProtocol() {
        return (String)this.backingStore.get("protocol");
    }

    @Nullable
    public String getSessionId() {
        return (String)this.backingStore.get("sessionId");
    }

    @Nullable
    public OffsetDateTime getStartUtcDateTime() {
        return (OffsetDateTime)this.backingStore.get("startUtcDateTime");
    }

    @Nullable
    public String getUserAgent() {
        return (String)this.backingStore.get("userAgent");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("account", (Parsable)this.getAccount(), new Parsable[0]);
        writer.writeStringValue("browser", this.getBrowser());
        writer.writeStringValue("deviceName", this.getDeviceName());
        writer.writeStringValue("operatingSystem", this.getOperatingSystem());
        writer.writeOffsetDateTimeValue("previousLogonDateTime", this.getPreviousLogonDateTime());
        writer.writeStringValue("protocol", this.getProtocol());
        writer.writeStringValue("sessionId", this.getSessionId());
        writer.writeOffsetDateTimeValue("startUtcDateTime", this.getStartUtcDateTime());
        writer.writeStringValue("userAgent", this.getUserAgent());
    }

    public void setAccount(@Nullable UserEvidence value) {
        this.backingStore.set("account", (Object)value);
    }

    public void setBrowser(@Nullable String value) {
        this.backingStore.set("browser", (Object)value);
    }

    public void setDeviceName(@Nullable String value) {
        this.backingStore.set("deviceName", (Object)value);
    }

    public void setOperatingSystem(@Nullable String value) {
        this.backingStore.set("operatingSystem", (Object)value);
    }

    public void setPreviousLogonDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("previousLogonDateTime", (Object)value);
    }

    public void setProtocol(@Nullable String value) {
        this.backingStore.set("protocol", (Object)value);
    }

    public void setSessionId(@Nullable String value) {
        this.backingStore.set("sessionId", (Object)value);
    }

    public void setStartUtcDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("startUtcDateTime", (Object)value);
    }

    public void setUserAgent(@Nullable String value) {
        this.backingStore.set("userAgent", (Object)value);
    }
}

