/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.externalconnectors;

import com.microsoft.graph.models.BinaryOperator;
import com.microsoft.graph.models.externalconnectors.RuleOperation;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class PropertyRule
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public PropertyRule() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static PropertyRule createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new PropertyRule();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("operation", n -> this.setOperation((RuleOperation)n.getEnumValue(RuleOperation::forValue)));
        deserializerMap.put("property", n -> this.setProperty(n.getStringValue()));
        deserializerMap.put("values", n -> this.setValues(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("valuesJoinedBy", n -> this.setValuesJoinedBy((BinaryOperator)n.getEnumValue(BinaryOperator::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public RuleOperation getOperation() {
        return (RuleOperation)((Object)this.backingStore.get("operation"));
    }

    @Nullable
    public String getProperty() {
        return (String)this.backingStore.get("property");
    }

    @Nullable
    public List<String> getValues() {
        return (List)this.backingStore.get("values");
    }

    @Nullable
    public BinaryOperator getValuesJoinedBy() {
        return (BinaryOperator)((Object)this.backingStore.get("valuesJoinedBy"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("operation", (Enum)this.getOperation());
        writer.writeStringValue("property", this.getProperty());
        writer.writeCollectionOfPrimitiveValues("values", this.getValues());
        writer.writeEnumValue("valuesJoinedBy", (Enum)this.getValuesJoinedBy());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setOperation(@Nullable RuleOperation value) {
        this.backingStore.set("operation", (Object)value);
    }

    public void setProperty(@Nullable String value) {
        this.backingStore.set("property", (Object)value);
    }

    public void setValues(@Nullable List<String> value) {
        this.backingStore.set("values", value);
    }

    public void setValuesJoinedBy(@Nullable BinaryOperator value) {
        this.backingStore.set("valuesJoinedBy", (Object)value);
    }
}

