/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AverageComparativeScore;
import com.microsoft.graph.models.ControlScore;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.SecurityVendorInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class SecureScore
extends Entity
implements Parsable {
    @Nonnull
    public static SecureScore createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new SecureScore();
    }

    @Nullable
    public Integer getActiveUserCount() {
        return (Integer)this.backingStore.get("activeUserCount");
    }

    @Nullable
    public List<AverageComparativeScore> getAverageComparativeScores() {
        return (List)this.backingStore.get("averageComparativeScores");
    }

    @Nullable
    public String getAzureTenantId() {
        return (String)this.backingStore.get("azureTenantId");
    }

    @Nullable
    public List<ControlScore> getControlScores() {
        return (List)this.backingStore.get("controlScores");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public Double getCurrentScore() {
        return (Double)this.backingStore.get("currentScore");
    }

    @Nullable
    public List<String> getEnabledServices() {
        return (List)this.backingStore.get("enabledServices");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("activeUserCount", n -> this.setActiveUserCount(n.getIntegerValue()));
        deserializerMap.put("averageComparativeScores", n -> this.setAverageComparativeScores(n.getCollectionOfObjectValues(AverageComparativeScore::createFromDiscriminatorValue)));
        deserializerMap.put("azureTenantId", n -> this.setAzureTenantId(n.getStringValue()));
        deserializerMap.put("controlScores", n -> this.setControlScores(n.getCollectionOfObjectValues(ControlScore::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("currentScore", n -> this.setCurrentScore(n.getDoubleValue()));
        deserializerMap.put("enabledServices", n -> this.setEnabledServices(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("licensedUserCount", n -> this.setLicensedUserCount(n.getIntegerValue()));
        deserializerMap.put("maxScore", n -> this.setMaxScore(n.getDoubleValue()));
        deserializerMap.put("vendorInformation", n -> this.setVendorInformation((SecurityVendorInformation)n.getObjectValue(SecurityVendorInformation::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public Integer getLicensedUserCount() {
        return (Integer)this.backingStore.get("licensedUserCount");
    }

    @Nullable
    public Double getMaxScore() {
        return (Double)this.backingStore.get("maxScore");
    }

    @Nullable
    public SecurityVendorInformation getVendorInformation() {
        return (SecurityVendorInformation)this.backingStore.get("vendorInformation");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeIntegerValue("activeUserCount", this.getActiveUserCount());
        writer.writeCollectionOfObjectValues("averageComparativeScores", this.getAverageComparativeScores());
        writer.writeStringValue("azureTenantId", this.getAzureTenantId());
        writer.writeCollectionOfObjectValues("controlScores", this.getControlScores());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeDoubleValue("currentScore", this.getCurrentScore());
        writer.writeCollectionOfPrimitiveValues("enabledServices", this.getEnabledServices());
        writer.writeIntegerValue("licensedUserCount", this.getLicensedUserCount());
        writer.writeDoubleValue("maxScore", this.getMaxScore());
        writer.writeObjectValue("vendorInformation", (Parsable)this.getVendorInformation(), new Parsable[0]);
    }

    public void setActiveUserCount(@Nullable Integer value) {
        this.backingStore.set("activeUserCount", (Object)value);
    }

    public void setAverageComparativeScores(@Nullable List<AverageComparativeScore> value) {
        this.backingStore.set("averageComparativeScores", value);
    }

    public void setAzureTenantId(@Nullable String value) {
        this.backingStore.set("azureTenantId", (Object)value);
    }

    public void setControlScores(@Nullable List<ControlScore> value) {
        this.backingStore.set("controlScores", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCurrentScore(@Nullable Double value) {
        this.backingStore.set("currentScore", (Object)value);
    }

    public void setEnabledServices(@Nullable List<String> value) {
        this.backingStore.set("enabledServices", value);
    }

    public void setLicensedUserCount(@Nullable Integer value) {
        this.backingStore.set("licensedUserCount", (Object)value);
    }

    public void setMaxScore(@Nullable Double value) {
        this.backingStore.set("maxScore", (Object)value);
    }

    public void setVendorInformation(@Nullable SecurityVendorInformation value) {
        this.backingStore.set("vendorInformation", (Object)value);
    }
}

