/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.ItemInsights;
import com.microsoft.graph.models.SharedInsight;
import com.microsoft.graph.models.Trending;
import com.microsoft.graph.models.UsedInsight;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OfficeGraphInsights
extends Entity
implements Parsable {
    @Nonnull
    public static OfficeGraphInsights createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.itemInsights": {
                    return new ItemInsights();
                }
            }
        }
        return new OfficeGraphInsights();
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("shared", n -> this.setShared(n.getCollectionOfObjectValues(SharedInsight::createFromDiscriminatorValue)));
        deserializerMap.put("trending", n -> this.setTrending(n.getCollectionOfObjectValues(Trending::createFromDiscriminatorValue)));
        deserializerMap.put("used", n -> this.setUsed(n.getCollectionOfObjectValues(UsedInsight::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<SharedInsight> getShared() {
        return (List)this.backingStore.get("shared");
    }

    @Nullable
    public List<Trending> getTrending() {
        return (List)this.backingStore.get("trending");
    }

    @Nullable
    public List<UsedInsight> getUsed() {
        return (List)this.backingStore.get("used");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("shared", this.getShared());
        writer.writeCollectionOfObjectValues("trending", this.getTrending());
        writer.writeCollectionOfObjectValues("used", this.getUsed());
    }

    public void setShared(@Nullable List<SharedInsight> value) {
        this.backingStore.set("shared", value);
    }

    public void setTrending(@Nullable List<Trending> value) {
        this.backingStore.set("trending", value);
    }

    public void setUsed(@Nullable List<UsedInsight> value) {
        this.backingStore.set("used", value);
    }
}

