/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.AttestationLevel;
import com.microsoft.graph.models.AuthenticationMethod;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Fido2AuthenticationMethod
extends AuthenticationMethod
implements Parsable {
    public Fido2AuthenticationMethod() {
        this.setOdataType("#microsoft.graph.fido2AuthenticationMethod");
    }

    @Nonnull
    public static Fido2AuthenticationMethod createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new Fido2AuthenticationMethod();
    }

    @Nullable
    public String getAaGuid() {
        return (String)this.backingStore.get("aaGuid");
    }

    @Nullable
    public List<String> getAttestationCertificates() {
        return (List)this.backingStore.get("attestationCertificates");
    }

    @Nullable
    public AttestationLevel getAttestationLevel() {
        return (AttestationLevel)((Object)this.backingStore.get("attestationLevel"));
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("aaGuid", n -> this.setAaGuid(n.getStringValue()));
        deserializerMap.put("attestationCertificates", n -> this.setAttestationCertificates(n.getCollectionOfPrimitiveValues(String.class)));
        deserializerMap.put("attestationLevel", n -> this.setAttestationLevel((AttestationLevel)n.getEnumValue(AttestationLevel::forValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("model", n -> this.setModel(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getModel() {
        return (String)this.backingStore.get("model");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("aaGuid", this.getAaGuid());
        writer.writeCollectionOfPrimitiveValues("attestationCertificates", this.getAttestationCertificates());
        writer.writeEnumValue("attestationLevel", (Enum)this.getAttestationLevel());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("model", this.getModel());
    }

    public void setAaGuid(@Nullable String value) {
        this.backingStore.set("aaGuid", (Object)value);
    }

    public void setAttestationCertificates(@Nullable List<String> value) {
        this.backingStore.set("attestationCertificates", value);
    }

    public void setAttestationLevel(@Nullable AttestationLevel value) {
        this.backingStore.set("attestationLevel", (Object)value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setModel(@Nullable String value) {
        this.backingStore.set("model", (Object)value);
    }
}

