/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.BookingAppointment;
import com.microsoft.graph.models.BookingCustomQuestion;
import com.microsoft.graph.models.BookingCustomerBase;
import com.microsoft.graph.models.BookingPageSettings;
import com.microsoft.graph.models.BookingSchedulingPolicy;
import com.microsoft.graph.models.BookingService;
import com.microsoft.graph.models.BookingStaffMemberBase;
import com.microsoft.graph.models.BookingWorkHours;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.PhysicalAddress;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BookingBusiness
extends Entity
implements Parsable {
    @Nonnull
    public static BookingBusiness createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new BookingBusiness();
    }

    @Nullable
    public PhysicalAddress getAddress() {
        return (PhysicalAddress)this.backingStore.get("address");
    }

    @Nullable
    public List<BookingAppointment> getAppointments() {
        return (List)this.backingStore.get("appointments");
    }

    @Nullable
    public BookingPageSettings getBookingPageSettings() {
        return (BookingPageSettings)this.backingStore.get("bookingPageSettings");
    }

    @Nullable
    public List<BookingWorkHours> getBusinessHours() {
        return (List)this.backingStore.get("businessHours");
    }

    @Nullable
    public String getBusinessType() {
        return (String)this.backingStore.get("businessType");
    }

    @Nullable
    public List<BookingAppointment> getCalendarView() {
        return (List)this.backingStore.get("calendarView");
    }

    @Nullable
    public OffsetDateTime getCreatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("createdDateTime");
    }

    @Nullable
    public List<BookingCustomerBase> getCustomers() {
        return (List)this.backingStore.get("customers");
    }

    @Nullable
    public List<BookingCustomQuestion> getCustomQuestions() {
        return (List)this.backingStore.get("customQuestions");
    }

    @Nullable
    public String getDefaultCurrencyIso() {
        return (String)this.backingStore.get("defaultCurrencyIso");
    }

    @Nullable
    public String getDisplayName() {
        return (String)this.backingStore.get("displayName");
    }

    @Nullable
    public String getEmail() {
        return (String)this.backingStore.get("email");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("address", n -> this.setAddress((PhysicalAddress)n.getObjectValue(PhysicalAddress::createFromDiscriminatorValue)));
        deserializerMap.put("appointments", n -> this.setAppointments(n.getCollectionOfObjectValues(BookingAppointment::createFromDiscriminatorValue)));
        deserializerMap.put("bookingPageSettings", n -> this.setBookingPageSettings((BookingPageSettings)n.getObjectValue(BookingPageSettings::createFromDiscriminatorValue)));
        deserializerMap.put("businessHours", n -> this.setBusinessHours(n.getCollectionOfObjectValues(BookingWorkHours::createFromDiscriminatorValue)));
        deserializerMap.put("businessType", n -> this.setBusinessType(n.getStringValue()));
        deserializerMap.put("calendarView", n -> this.setCalendarView(n.getCollectionOfObjectValues(BookingAppointment::createFromDiscriminatorValue)));
        deserializerMap.put("createdDateTime", n -> this.setCreatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("customers", n -> this.setCustomers(n.getCollectionOfObjectValues(BookingCustomerBase::createFromDiscriminatorValue)));
        deserializerMap.put("customQuestions", n -> this.setCustomQuestions(n.getCollectionOfObjectValues(BookingCustomQuestion::createFromDiscriminatorValue)));
        deserializerMap.put("defaultCurrencyIso", n -> this.setDefaultCurrencyIso(n.getStringValue()));
        deserializerMap.put("displayName", n -> this.setDisplayName(n.getStringValue()));
        deserializerMap.put("email", n -> this.setEmail(n.getStringValue()));
        deserializerMap.put("isPublished", n -> this.setIsPublished(n.getBooleanValue()));
        deserializerMap.put("languageTag", n -> this.setLanguageTag(n.getStringValue()));
        deserializerMap.put("lastUpdatedDateTime", n -> this.setLastUpdatedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("phone", n -> this.setPhone(n.getStringValue()));
        deserializerMap.put("publicUrl", n -> this.setPublicUrl(n.getStringValue()));
        deserializerMap.put("schedulingPolicy", n -> this.setSchedulingPolicy((BookingSchedulingPolicy)n.getObjectValue(BookingSchedulingPolicy::createFromDiscriminatorValue)));
        deserializerMap.put("services", n -> this.setServices(n.getCollectionOfObjectValues(BookingService::createFromDiscriminatorValue)));
        deserializerMap.put("staffMembers", n -> this.setStaffMembers(n.getCollectionOfObjectValues(BookingStaffMemberBase::createFromDiscriminatorValue)));
        deserializerMap.put("webSiteUrl", n -> this.setWebSiteUrl(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getIsPublished() {
        return (Boolean)this.backingStore.get("isPublished");
    }

    @Nullable
    public String getLanguageTag() {
        return (String)this.backingStore.get("languageTag");
    }

    @Nullable
    public OffsetDateTime getLastUpdatedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastUpdatedDateTime");
    }

    @Nullable
    public String getPhone() {
        return (String)this.backingStore.get("phone");
    }

    @Nullable
    public String getPublicUrl() {
        return (String)this.backingStore.get("publicUrl");
    }

    @Nullable
    public BookingSchedulingPolicy getSchedulingPolicy() {
        return (BookingSchedulingPolicy)this.backingStore.get("schedulingPolicy");
    }

    @Nullable
    public List<BookingService> getServices() {
        return (List)this.backingStore.get("services");
    }

    @Nullable
    public List<BookingStaffMemberBase> getStaffMembers() {
        return (List)this.backingStore.get("staffMembers");
    }

    @Nullable
    public String getWebSiteUrl() {
        return (String)this.backingStore.get("webSiteUrl");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeObjectValue("address", (Parsable)this.getAddress(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("appointments", this.getAppointments());
        writer.writeObjectValue("bookingPageSettings", (Parsable)this.getBookingPageSettings(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("businessHours", this.getBusinessHours());
        writer.writeStringValue("businessType", this.getBusinessType());
        writer.writeCollectionOfObjectValues("calendarView", this.getCalendarView());
        writer.writeOffsetDateTimeValue("createdDateTime", this.getCreatedDateTime());
        writer.writeCollectionOfObjectValues("customers", this.getCustomers());
        writer.writeCollectionOfObjectValues("customQuestions", this.getCustomQuestions());
        writer.writeStringValue("defaultCurrencyIso", this.getDefaultCurrencyIso());
        writer.writeStringValue("displayName", this.getDisplayName());
        writer.writeStringValue("email", this.getEmail());
        writer.writeStringValue("languageTag", this.getLanguageTag());
        writer.writeOffsetDateTimeValue("lastUpdatedDateTime", this.getLastUpdatedDateTime());
        writer.writeStringValue("phone", this.getPhone());
        writer.writeObjectValue("schedulingPolicy", (Parsable)this.getSchedulingPolicy(), new Parsable[0]);
        writer.writeCollectionOfObjectValues("services", this.getServices());
        writer.writeCollectionOfObjectValues("staffMembers", this.getStaffMembers());
        writer.writeStringValue("webSiteUrl", this.getWebSiteUrl());
    }

    public void setAddress(@Nullable PhysicalAddress value) {
        this.backingStore.set("address", (Object)value);
    }

    public void setAppointments(@Nullable List<BookingAppointment> value) {
        this.backingStore.set("appointments", value);
    }

    public void setBookingPageSettings(@Nullable BookingPageSettings value) {
        this.backingStore.set("bookingPageSettings", (Object)value);
    }

    public void setBusinessHours(@Nullable List<BookingWorkHours> value) {
        this.backingStore.set("businessHours", value);
    }

    public void setBusinessType(@Nullable String value) {
        this.backingStore.set("businessType", (Object)value);
    }

    public void setCalendarView(@Nullable List<BookingAppointment> value) {
        this.backingStore.set("calendarView", value);
    }

    public void setCreatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("createdDateTime", (Object)value);
    }

    public void setCustomers(@Nullable List<BookingCustomerBase> value) {
        this.backingStore.set("customers", value);
    }

    public void setCustomQuestions(@Nullable List<BookingCustomQuestion> value) {
        this.backingStore.set("customQuestions", value);
    }

    public void setDefaultCurrencyIso(@Nullable String value) {
        this.backingStore.set("defaultCurrencyIso", (Object)value);
    }

    public void setDisplayName(@Nullable String value) {
        this.backingStore.set("displayName", (Object)value);
    }

    public void setEmail(@Nullable String value) {
        this.backingStore.set("email", (Object)value);
    }

    public void setIsPublished(@Nullable Boolean value) {
        this.backingStore.set("isPublished", (Object)value);
    }

    public void setLanguageTag(@Nullable String value) {
        this.backingStore.set("languageTag", (Object)value);
    }

    public void setLastUpdatedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastUpdatedDateTime", (Object)value);
    }

    public void setPhone(@Nullable String value) {
        this.backingStore.set("phone", (Object)value);
    }

    public void setPublicUrl(@Nullable String value) {
        this.backingStore.set("publicUrl", (Object)value);
    }

    public void setSchedulingPolicy(@Nullable BookingSchedulingPolicy value) {
        this.backingStore.set("schedulingPolicy", (Object)value);
    }

    public void setServices(@Nullable List<BookingService> value) {
        this.backingStore.set("services", value);
    }

    public void setStaffMembers(@Nullable List<BookingStaffMemberBase> value) {
        this.backingStore.set("staffMembers", value);
    }

    public void setWebSiteUrl(@Nullable String value) {
        this.backingStore.set("webSiteUrl", (Object)value);
    }
}

