/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.communications.calls.item.transfer;

import com.microsoft.graph.models.InvitationParticipantInfo;
import com.microsoft.graph.models.ParticipantInfo;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TransferPostRequestBody
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TransferPostRequestBody() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TransferPostRequestBody createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TransferPostRequestBody();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(2);
        deserializerMap.put("transferee", n -> this.setTransferee((ParticipantInfo)n.getObjectValue(ParticipantInfo::createFromDiscriminatorValue)));
        deserializerMap.put("transferTarget", n -> this.setTransferTarget((InvitationParticipantInfo)n.getObjectValue(InvitationParticipantInfo::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public ParticipantInfo getTransferee() {
        return (ParticipantInfo)this.backingStore.get("transferee");
    }

    @Nullable
    public InvitationParticipantInfo getTransferTarget() {
        return (InvitationParticipantInfo)this.backingStore.get("transferTarget");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("transferee", (Parsable)this.getTransferee(), new Parsable[0]);
        writer.writeObjectValue("transferTarget", (Parsable)this.getTransferTarget(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setTransferee(@Nullable ParticipantInfo value) {
        this.backingStore.set("transferee", (Object)value);
    }

    public void setTransferTarget(@Nullable InvitationParticipantInfo value) {
        this.backingStore.set("transferTarget", (Object)value);
    }
}

