/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.post;

import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.im.Im;
import com.lotus.sametime.im.ImAdapter;
import com.lotus.sametime.im.ImEvent;
import com.lotus.sametime.im.ImListener;
import com.lotus.sametime.im.ImServiceListener;
import com.lotus.sametime.im.InstantMessagingService;
import com.lotus.sametime.post.Post;
import com.lotus.sametime.post.PostEvent;
import com.lotus.sametime.post.PostService;
import com.lotus.sametime.post.PostServiceListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PostComp
extends STComp
implements PostService {
    private Vector m_postListeners = new Vector();
    private Vector m_postTypes = new Vector();
    private InstantMessagingService m_imService;
    private Vector m_incomingMessages = new Vector();
    private ImListener m_imListener;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.post");

    public PostComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.post.PostComp", sTSession);
        sTSession.registerComponent(this.getName(), this);
        this.m_imService = (InstantMessagingService)sTSession.getCompApi("com.lotus.sametime.im.ImComp");
        if (this.m_imService != null) {
            this.addImServiceListener();
        }
        this.createImListener();
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (this.m_imService == null && sTCompApi instanceof InstantMessagingService) {
            this.m_imService = (InstantMessagingService)sTCompApi;
            this.addImServiceListener();
        }
    }

    public synchronized void addPostServiceListener(PostServiceListener postServiceListener) {
        Vector vector = (Vector)this.m_postListeners.clone();
        vector.addElement(postServiceListener);
        this.m_postListeners = vector;
    }

    public synchronized void removePostServiceListener(PostServiceListener postServiceListener) {
        Vector vector = (Vector)this.m_postListeners.clone();
        vector.removeElement(postServiceListener);
        this.m_postListeners = vector;
    }

    public Post createPost(int n) {
        return this.createPost(n, "", "", -1, null, null, false);
    }

    public Post createPost(int n, String string, String string2, int n2, byte[] byArray, STUser[] sTUserArray, boolean bl) {
        if (!this.isTypeSupported(n)) {
            return null;
        }
        return new Post(n, string, string2, n2, byArray, sTUserArray, this.m_imService, bl);
    }

    public Post createPost(int n, String string, String string2, int n2, byte[] byArray, STUser[] sTUserArray) {
        return this.createPost(n, string, string2, n2, byArray, sTUserArray, false);
    }

    public int registerPostType(int n) {
        if (this.m_postTypes.contains(new Integer(n))) {
            return -2147471356;
        }
        int n2 = this.m_imService.registerImType(n);
        switch (n2) {
            case 0: {
                this.m_postTypes.addElement(new Integer(n));
                return n2;
            }
            case -2147475452: {
                return -2147471356;
            }
        }
        return Integer.MIN_VALUE;
    }

    public int unregisterPostType(int n) {
        if (!this.m_postTypes.removeElement(new Integer(n))) {
            return -2147471355;
        }
        int n2 = this.m_imService.unregisterImType(n);
        switch (n2) {
            case 0: {
                return n2;
            }
            case -2147475451: {
                return -2147471355;
            }
        }
        return Integer.MIN_VALUE;
    }

    private void imReceived(ImEvent imEvent) {
        Im im = imEvent.getIm();
        if (!this.isTypeSupported(im.getType())) {
            return;
        }
        im.addImListener(this.m_imListener);
        this.m_incomingMessages.addElement(im);
    }

    private void dataReceived(ImEvent imEvent) {
        if (imEvent.getDataType() != 10 || imEvent.getDataSubType() != 1) {
            return;
        }
        if (this.m_incomingMessages.removeElement(imEvent.getIm())) {
            this.handlePosted(imEvent.getIm(), imEvent.getData());
        }
    }

    private boolean isTypeSupported(int n) {
        return this.m_postTypes.contains(new Integer(n));
    }

    private void handlePosted(Im im, byte[] byArray) {
        NdrInputStream ndrInputStream = new NdrInputStream(byArray);
        try {
            ndrInputStream.loadMark();
            String string = ndrInputStream.readUTF();
            String string2 = ndrInputStream.readUTF();
            int n = ndrInputStream.readInt();
            byte[] byArray2 = ndrInputStream.readBytes();
            ndrInputStream.skipMarks();
            Post post = new Post(im, string, string2, n, byArray2);
            Vector vector = this.m_postListeners;
            Enumeration enumeration = vector.elements();
            PostEvent postEvent = new PostEvent(this, 3, post);
            while (enumeration.hasMoreElements()) {
                PostServiceListener postServiceListener = (PostServiceListener)enumeration.nextElement();
                postServiceListener.posted(postEvent);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    private void addImServiceListener() {
        this.m_imService.addImServiceListener(new ImServiceListener(){

            public void imReceived(ImEvent imEvent) {
                PostComp.this.imReceived(imEvent);
            }
        });
    }

    private void createImListener() {
        this.m_imListener = new ImAdapter(){

            public void dataReceived(ImEvent imEvent) {
                PostComp.this.dataReceived(imEvent);
            }
        };
    }
}

