/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.lookup;

import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.Login;
import com.lotus.sametime.core.comparch.DuplicateObjectException;
import com.lotus.sametime.core.comparch.STComp;
import com.lotus.sametime.core.comparch.STCompApi;
import com.lotus.sametime.core.comparch.STCompPart;
import com.lotus.sametime.core.comparch.STEvent;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STId;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.types.STUserInstance;
import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.lookup.GroupContentEvent;
import com.lotus.sametime.lookup.GroupContentGetter;
import com.lotus.sametime.lookup.LookupEvent;
import com.lotus.sametime.lookup.LookupImpl;
import com.lotus.sametime.lookup.LookupService;
import com.lotus.sametime.lookup.LookupServiceListener;
import com.lotus.sametime.lookup.ResolveImplEvent;
import com.lotus.sametime.lookup.ResolveResponse;
import com.lotus.sametime.lookup.Resolver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LookupComp
extends STComp
implements LookupService {
    private Vector m_lookupListeners = new Vector();
    private Hashtable m_groupGetterTable = new Hashtable();
    private Hashtable m_requestedGroups = new Hashtable();
    private Hashtable m_resolverTable = new Hashtable();
    private Hashtable m_resolveRequests = new Hashtable();
    private LookupImpl m_impl = null;
    private STSession m_session;
    private CommunityService m_comm;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.lookup");

    public LookupComp(STSession sTSession) throws DuplicateObjectException {
        super("com.lotus.sametime.lookup.LookupComp", sTSession);
        this.m_impl = new LookupImpl(sTSession);
        sTSession.registerComponent(this.getName(), this);
        this.m_session = sTSession;
        this.m_comm = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
    }

    protected void start() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "start", this + " Started");
        }
    }

    protected void stop() {
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "stop", this + " Stopped");
        }
    }

    public Resolver createResolver(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Resolver resolver = new Resolver(this, bl, bl2, bl3, bl4);
        return resolver;
    }

    public GroupContentGetter createGroupContentGetter() {
        return new GroupContentGetter(this);
    }

    public synchronized void addLookupServiceListener(LookupServiceListener lookupServiceListener) {
        Vector vector = (Vector)this.m_lookupListeners.clone();
        vector.addElement(lookupServiceListener);
        this.m_lookupListeners = vector;
    }

    public synchronized void removeLookupServiceListener(LookupServiceListener lookupServiceListener) {
        Vector vector = (Vector)this.m_lookupListeners.clone();
        vector.removeElement(lookupServiceListener);
        this.m_lookupListeners = vector;
    }

    protected void resolveNames(String[] stringArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, Resolver resolver) {
        Integer n = STCompPart.getUniqueId();
        this.m_resolverTable.put(n, resolver);
        this.m_resolveRequests.put(n, stringArray);
        ResolveImplEvent resolveImplEvent = new ResolveImplEvent(this, 1, n, stringArray, bl, bl2, bl3, bl4);
        this.sendEvent(resolveImplEvent);
    }

    void getGroupContent(STGroup sTGroup, GroupContentGetter groupContentGetter) {
        Integer n = STCompPart.getUniqueId();
        this.m_groupGetterTable.put(n, groupContentGetter);
        this.m_requestedGroups.put(n, sTGroup);
        GroupContentEvent groupContentEvent = new GroupContentEvent((Object)this, 1, n, sTGroup);
        this.sendEvent(groupContentEvent);
    }

    protected void processSTEvent(STEvent sTEvent) {
        if (sTEvent instanceof ResolveImplEvent) {
            this.processResolveImplEvent((ResolveImplEvent)sTEvent);
        } else if (sTEvent instanceof GroupContentEvent) {
            this.processGroupContentEvent((GroupContentEvent)sTEvent);
        } else if (sTEvent instanceof LookupEvent) {
            this.processLookupEvent((LookupEvent)sTEvent);
        } else {
            super.processSTEvent(sTEvent);
        }
    }

    protected void processLookupEvent(LookupEvent lookupEvent) {
        Vector vector = this.m_lookupListeners;
        Enumeration enumeration = vector.elements();
        lookupEvent.setSource(this);
        while (enumeration.hasMoreElements()) {
            LookupServiceListener lookupServiceListener = (LookupServiceListener)enumeration.nextElement();
            lookupServiceListener.serviceAvailable(lookupEvent);
        }
    }

    protected void processResolveImplEvent(ResolveImplEvent resolveImplEvent) {
        switch (resolveImplEvent.getId()) {
            case -2147483647: {
                this.namesResolved(resolveImplEvent);
                resolveImplEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.resolveNamesFailed(resolveImplEvent);
                resolveImplEvent.setConsumed(true);
            }
        }
    }

    protected void processGroupContentEvent(GroupContentEvent groupContentEvent) {
        switch (groupContentEvent.getId()) {
            case -2147483647: {
                this.gotGroupContent(groupContentEvent);
                groupContentEvent.setConsumed(true);
                break;
            }
            case -2147483646: {
                this.groupContentFailed(groupContentEvent);
                groupContentEvent.setConsumed(true);
            }
        }
    }

    void namesResolved(ResolveImplEvent resolveImplEvent) {
        Integer n = resolveImplEvent.getResolveId();
        ResolveResponse[] resolveResponseArray = resolveImplEvent.getMatches();
        Resolver resolver = (Resolver)this.m_resolverTable.remove(n);
        this.m_resolveRequests.remove(n);
        for (int i = 0; i < resolveResponseArray.length; ++i) {
            this.resolved(resolver, resolveResponseArray[i]);
        }
    }

    protected void resolved(Resolver resolver, ResolveResponse resolveResponse) {
        Login login = this.m_comm.getLogin();
        if (null == login) {
            return;
        }
        STUserInstance sTUserInstance = login.getMyUserInstance();
        if (sTUserInstance == null) {
            return;
        }
        String string = sTUserInstance.getCommunityName();
        String[] stringArray = new String[]{resolveResponse.m_resolveString};
        if (resolveResponse.m_statusCode != 0) {
            resolver.resolveFailed(stringArray, resolveResponse.m_statusCode);
        } else if (resolveResponse.m_matches.length == 0) {
            resolver.resolveFailed(stringArray, -2147287040);
        } else if (resolveResponse.m_matches.length > 1) {
            if (!string.equals("")) {
                for (int i = 0; i < resolveResponse.m_matches.length; ++i) {
                    if (!(resolveResponse.m_matches[i] instanceof STUser)) continue;
                    resolveResponse.m_matches[i] = this.createUserWithCommunityName((STUser)resolveResponse.m_matches[i], string);
                }
            }
            resolver.resolveConflict(resolveResponse.m_resolveString, resolveResponse.m_matches);
        } else if (resolveResponse.m_matches[0] instanceof STUser) {
            STUser sTUser = (STUser)resolveResponse.m_matches[0];
            if (!string.equals("") && resolveResponse.m_matches[0] instanceof STUser) {
                sTUser = this.createUserWithCommunityName((STUser)resolveResponse.m_matches[0], string);
            }
            resolver.resolved(resolveResponse.m_resolveString, sTUser);
        } else if (resolveResponse.m_matches[0] instanceof STGroup) {
            STGroup sTGroup = (STGroup)resolveResponse.m_matches[0];
            if (!string.equals("") && resolveResponse.m_matches[0] instanceof STUser) {
                sTGroup = this.createGroupWithCommunityName((STGroup)resolveResponse.m_matches[0], string);
            }
            resolver.resolved(resolveResponse.m_resolveString, sTGroup);
        }
    }

    void resolveNamesFailed(ResolveImplEvent resolveImplEvent) {
        Integer n = resolveImplEvent.getResolveId();
        Resolver resolver = (Resolver)this.m_resolverTable.remove(n);
        String[] stringArray = (String[])this.m_resolveRequests.remove(n);
        resolver.resolveFailed(stringArray, resolveImplEvent.getReason());
    }

    void gotGroupContent(GroupContentEvent groupContentEvent) {
        Integer n = groupContentEvent.getRequestId();
        GroupContentGetter groupContentGetter = (GroupContentGetter)this.m_groupGetterTable.remove(n);
        this.m_requestedGroups.remove(n);
        Debug.stAssert(groupContentGetter != null);
        groupContentGetter.groupContentQueried(groupContentEvent);
    }

    void groupContentFailed(GroupContentEvent groupContentEvent) {
        Integer n = groupContentEvent.getRequestId();
        GroupContentGetter groupContentGetter = (GroupContentGetter)this.m_groupGetterTable.remove(n);
        STGroup sTGroup = (STGroup)this.m_requestedGroups.remove(n);
        Debug.stAssert(groupContentGetter != null && sTGroup != null);
        groupContentGetter.queryGroupContentFailed(groupContentEvent);
    }

    private STUser createUserWithCommunityName(STUser sTUser, String string) {
        STId sTId = new STId(sTUser.getId().getId(), string);
        return new STUser(sTId, sTUser.getName(), sTUser.getDesc(), sTUser.getNickName());
    }

    private STGroup createGroupWithCommunityName(STGroup sTGroup, String string) {
        STId sTId = new STId(sTGroup.getId().getId(), string);
        return new STGroup(sTId, sTGroup.getName(), sTGroup.getDesc());
    }

    protected void componentLoaded(STCompApi sTCompApi) {
        if (null == this.m_comm && sTCompApi instanceof CommunityService) {
            this.m_comm = (CommunityService)sTCompApi;
        }
    }
}

