/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.guiutils.misc;

import com.lotus.sametime.gdk.tooltip.STToolTip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class ImageButton
extends Panel
implements MouseListener,
MouseMotionListener,
STToolTip {
    private Image enabledImg;
    private Image disabledImg;
    private Image pressedImg;
    private Image mouseImg;
    private short state = 1;
    private Vector listeners = new Vector();
    private String m_tip;
    private MediaTracker m_tracker;

    public ImageButton(Image image, Image image2, Image image3, Image image4, String string) {
        this.enabledImg = image;
        this.disabledImg = image2;
        this.pressedImg = image3;
        this.mouseImg = image4;
        this.m_tip = string;
        this.m_tracker = new MediaTracker(this);
        if (this.m_tracker.checkAll(true)) {
            this.m_tracker.addImage(image, 0);
            this.m_tracker.addImage(image2, 1);
            this.m_tracker.addImage(image3, 2);
            this.m_tracker.addImage(image4, 3);
        }
        try {
            this.m_tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.enabledImg.getWidth(null), this.enabledImg.getHeight(null));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void paint(Graphics graphics) {
        Image image = null;
        switch (this.state) {
            case 1: {
                image = this.enabledImg;
                break;
            }
            case 2: {
                image = this.disabledImg;
                break;
            }
            case 3: {
                image = this.mouseImg;
                break;
            }
            case 4: {
                image = this.pressedImg;
            }
        }
        if (null != image) {
            graphics.drawImage(image, 0, 0, this);
        }
    }

    public void setEnabled(boolean bl) {
        short s = this.state;
        if (bl) {
            if (this.state == 2) {
                this.state = 1;
            }
        } else {
            this.state = (short)2;
        }
        if (s != this.state) {
            this.repaint();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.state != 2) {
            this.state = (short)4;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.state != 2) {
            this.state = (short)3;
            this.repaint();
            Point point = mouseEvent.getPoint();
            if (this.contains(point.x, point.y)) {
                Enumeration enumeration = this.listeners.elements();
                ActionEvent actionEvent = new ActionEvent(this, 0, null);
                while (enumeration.hasMoreElements()) {
                    ActionListener actionListener = (ActionListener)enumeration.nextElement();
                    actionListener.actionPerformed(actionEvent);
                }
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.state != 2) {
            this.state = (short)3;
            this.repaint();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.state != 2) {
            this.state = 1;
            this.repaint();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public Vector getToolTipComponents() {
        Vector<ImageButton> vector = new Vector<ImageButton>();
        vector.addElement(this);
        return vector;
    }

    public String getToolTipText(Component component, Point point) {
        return this.m_tip;
    }

    public void setHoverBased(boolean bl) {
    }

    public boolean isHoverBased() {
        return true;
    }

    public void setToolTipText(Component component, String string) {
    }
}

