/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.directoryui;

import com.lotus.sametime.commui.GroupContentDialog;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STGroup;
import com.lotus.sametime.core.types.STObject;
import com.lotus.sametime.directoryui.DirectoryListViewAdapter;
import com.lotus.sametime.directoryui.DirectoryListViewEvent;
import com.lotus.sametime.directoryui.DirectoryListViewListener;
import com.lotus.sametime.directoryui.DirectoryPanel;
import com.lotus.sametime.guiutils.accessibility.AccessibilityHelpers;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.accessibility.KeyHandler;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;

public class DirectoryDialog
extends Dialog {
    private int INSETS_UNIT = 10;
    private static String BUNDLE_FILE_NAME = "properties/directoryui";
    private STGroup m_stGroup;
    private DirectoryPanel m_dirPanel;
    private ButtonsPanel m_btnPanel;
    private Button m_contentButton;
    private STSession m_session;
    private STBundle m_bundle;
    private ActionListener m_actionListener;

    public DirectoryDialog(Frame frame, STSession sTSession, ButtonsPanel buttonsPanel, String string) {
        super(frame);
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_bundle = resourceLoaderService.getBundle(string);
        this.m_btnPanel = buttonsPanel;
        this.m_session = sTSession;
        this.initLayout();
        KeyHandler keyHandler = this.createKeyHandler();
        AccessibilityHelpers.addKeyListenerToSubComponents(this, keyHandler);
    }

    public DirectoryDialog(Frame frame, STSession sTSession, ButtonsPanel buttonsPanel) {
        this(frame, sTSession, buttonsPanel, BUNDLE_FILE_NAME);
    }

    public DirectoryDialog(Frame frame, STSession sTSession) {
        super(frame);
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_bundle = resourceLoaderService.getBundle(BUNDLE_FILE_NAME);
        this.m_session = sTSession;
        this.m_actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryDialog.this.actionPerformed(actionEvent);
            }
        };
        this.m_btnPanel = new ButtonsPanel(new String[]{this.m_bundle.getString("CONTENTS")}, this.m_actionListener, 2);
        this.m_contentButton = this.m_btnPanel.getButton(this.m_bundle.getString("CONTENTS"));
        this.m_contentButton.setEnabled(false);
        this.initLayout();
    }

    private void initLayout() {
        this.m_dirPanel = new DirectoryPanel(this.m_session);
        this.m_dirPanel.addDirectoryListViewListener(new DirectoryListViewAdapter(){

            public void selectionChanged(DirectoryListViewEvent directoryListViewEvent) {
                DirectoryDialog.this.selectionChanged(directoryListViewEvent);
            }
        });
        this.setTitle(this.m_bundle.getString("DEFAULT_DIALOG_TITLE"));
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DirectoryDialog.this.setVisible(false);
                DirectoryDialog.this.dispose();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_dirPanel, "Center");
        this.add((Component)this.m_btnPanel, "South");
        this.pack();
        Rectangle rectangle = this.getParent().getBounds();
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (rectangle.x + rectangle.width + dimension.width < dimension2.width && rectangle.y < dimension2.height) {
            this.setBounds(rectangle.x + rectangle.width, rectangle.y, dimension.width, dimension.height);
        } else {
            this.setBounds((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2, dimension.width, dimension.height);
        }
    }

    public void addDirectoryListViewListener(DirectoryListViewListener directoryListViewListener) {
        this.m_dirPanel.addDirectoryListViewListener(directoryListViewListener);
    }

    public void removeDirectoryListViewListener(DirectoryListViewListener directoryListViewListener) {
        this.m_dirPanel.removeDirectoryListViewListener(directoryListViewListener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = Math.max(dimension.width, this.m_bundle.getInt("DIRECTORY_DIALOG_PREF_WIDTH"));
        dimension.height = Math.max(dimension.height, this.m_bundle.getInt("DIRECTORY_DIALOG_PREF_HEIGHT"));
        return dimension;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        return new Insets(insets.top + this.INSETS_UNIT, this.INSETS_UNIT, insets.bottom + this.INSETS_UNIT, this.INSETS_UNIT);
    }

    public Vector getSelectedEntries() {
        return this.m_dirPanel.getSelectedEntries();
    }

    protected void launchGroupContentDialog() {
        GroupContentDialog groupContentDialog = new GroupContentDialog((Frame)this.getParent(), this.m_session, this.m_stGroup);
        groupContentDialog.setVisible(true);
    }

    private KeyHandler createKeyHandler() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(10){

            public void executeKeyMethod() {
            }
        });
        vector.addElement(new KeyAction(27){

            public void executeKeyMethod() {
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_bundle.getString("MN_BTN_ADD"))){

            public void executeKeyMethod() {
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_bundle.getString("MN_BTN_CONTENTS"))){

            public void executeKeyMethod() {
                DirectoryDialog.this.launchGroupContentDialog();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_bundle.getString("MN_BTN_CLOSE"))){

            public void executeKeyMethod() {
            }
        });
        Enumeration enumeration = this.m_dirPanel.getActionKeys();
        while (enumeration.hasMoreElements()) {
            vector.addElement((KeyAction)enumeration.nextElement());
        }
        return new KeyHandler(vector);
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_contentButton) {
            this.launchGroupContentDialog();
        }
    }

    protected void selectionChanged(DirectoryListViewEvent directoryListViewEvent) {
        if (this.m_contentButton != null) {
            Vector vector = directoryListViewEvent.getSelectedNodes();
            boolean bl = false;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                STObject sTObject = (STObject)enumeration.nextElement();
                if (!(sTObject instanceof STGroup)) continue;
                if (bl) {
                    bl = false;
                    this.m_stGroup = null;
                    break;
                }
                this.m_stGroup = (STGroup)sTObject;
                bl = true;
            }
            this.m_contentButton.setEnabled(bl);
        }
    }

    public void dispose() {
        this.m_dirPanel.removeServiceListeners();
        super.dispose();
    }
}

