/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.core.util.connection.Sender;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

class SocketSender
extends Sender {
    private Socket m_socket = null;
    private OutputStream m_outStream = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    protected SocketSender(Socket socket) throws IOException {
        this.m_socket = socket;
        this.m_outStream = this.m_socket.getOutputStream();
    }

    protected void initialize() {
    }

    protected void cleanup() {
        try {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "cleanup", "SocketSender: Closing socket");
            }
            this.m_socket.close();
        }
        catch (IOException iOException) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "cleanup", "vpSender run: couldn't close socket:");
            }
            iOException.printStackTrace();
        }
    }

    protected void send(byte[] byArray) throws IOException {
        try {
            this.m_outStream.write(byArray);
            this.m_outStream.flush();
        }
        catch (Throwable throwable) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "send", "SocketSender.send: ", throwable);
            }
            throw new IOException("Socket closed");
        }
    }

    protected boolean sendKeepAlive() {
        if (StaticProps.m_bLinuxOS || StaticProps.m_bMacOS || StaticProps.m_bMacOSX) {
            try {
                Socket socket = new Socket(this.m_socket.getInetAddress(), this.m_socket.getPort());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return super.sendKeepAlive();
    }
}

