/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.connection;

import com.lotus.sametime.core.util.Debug;
import com.lotus.sametime.core.util.connection.Connection;
import com.lotus.sametime.core.util.connection.ConnectionInitializer;
import com.lotus.sametime.core.util.connection.ConnectionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionFactory
implements Runnable {
    private static final String THREAD_NAME = "Karl's connection factory thread, LTD. ";
    private static int c_threadCount = 0;
    private Connection[] m_connectionsToTry;
    private ConnectionListener m_listener;
    private String m_host;
    private boolean m_isConnecting = false;
    private ConnectionInitializer m_initializer = null;
    private boolean m_canceled = false;
    private byte[] m_initialMsg = null;
    private Logger m_logger = Logger.getLogger("com.lotus.sametime.core.util.connection");

    public void connect(Connection[] connectionArray, String string, byte[] byArray, ConnectionListener connectionListener) {
        Debug.stAssert(!this.m_isConnecting);
        this.m_host = string;
        this.m_listener = connectionListener;
        this.m_connectionsToTry = connectionArray;
        this.m_initialMsg = byArray;
        Thread thread = new Thread((Runnable)this, THREAD_NAME + ++c_threadCount);
        thread.start();
    }

    public synchronized void cancelConnect() {
        this.m_canceled = true;
        if (this.m_logger.isLoggable(Level.FINER)) {
            this.m_logger.logp(Level.FINER, this.getClass().getName(), "cancelConnect", "ConnectionFactory: canceling connect request");
        }
        try {
            this.m_initializer.stopInitializerThread();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.m_isConnecting = true;
        Debug.stAssert(this.m_connectionsToTry != null);
        Debug.stAssert(this.m_listener != null);
        Connection connection = null;
        ConnectionFactory connectionFactory = this;
        synchronized (connectionFactory) {
            this.m_canceled = false;
        }
        for (int i = 0; i < this.m_connectionsToTry.length && !this.m_canceled; ++i) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                this.m_logger.logp(Level.FINEST, this.getClass().getName(), "run", "ConnectionFactory: Trying connection " + this.m_connectionsToTry[i]);
            }
            try {
                this.m_initializer = new ConnectionInitializer(this.m_connectionsToTry[i], this.m_host, this.m_initialMsg);
                this.m_initializer.initialize();
            }
            catch (IOException iOException) {
                connection = null;
                continue;
            }
            connection = this.m_connectionsToTry[i];
            break;
        }
        this.m_initializer = null;
        if (connection != null) {
            if (this.m_logger.isLoggable(Level.FINER)) {
                this.m_logger.logp(Level.FINER, this.getClass().getName(), "run", "ConnectionFactory: Connection initialized:\n" + connection);
            }
            this.m_listener.onConnected(connection);
            connection.setClosedListener(this.m_listener);
            connection.setDataListener(this.m_listener);
        } else {
            this.m_listener.onConnectFailed();
        }
        this.m_isConnecting = false;
    }

    public void setConnectionsToTry(Connection[] connectionArray) {
        this.m_connectionsToTry = connectionArray;
    }

    public Connection[] getConnectionsToTry() {
        return this.m_connectionsToTry;
    }
}

