/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util;

import com.lotus.sametime.core.util.MarkableByteOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.EmptyStackException;
import java.util.Vector;

public class NdrOutputStream
extends DataOutputStream {
    private Vector m_markups;
    private MarkableByteOutputStream m_byteStream;

    public NdrOutputStream() {
        super(new MarkableByteOutputStream());
        this.m_byteStream = (MarkableByteOutputStream)this.out;
    }

    public void startMark() throws IOException {
        if (this.m_markups == null) {
            this.m_markups = new Vector();
        }
        this.m_markups.addElement(new Integer(this.m_byteStream.position()));
        this.writeInt(0);
    }

    public void dumpMarks() throws IOException {
        this.dumpMarks(1);
    }

    public void dumpMarks(int n) throws IOException {
        if (this.m_markups == null || n > this.m_markups.size()) {
            throw new EmptyStackException();
        }
        int n2 = this.m_byteStream.position();
        for (int i = 0; i < n; ++i) {
            int n3 = (Integer)this.m_markups.lastElement();
            this.m_markups.removeElementAt(this.m_markups.size() - 1);
            this.m_byteStream.writeMark(n3, n2);
        }
    }

    public int position() {
        return this.m_byteStream.position();
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (byArray != null) {
            this.writeInt(byArray.length);
            this.write(byArray, 0, byArray.length);
        } else {
            this.writeInt(0);
        }
    }

    public void writeInetAddress(InetAddress inetAddress) throws IOException {
        byte[] byArray = inetAddress.getAddress();
        this.write(byArray, 0, byArray.length);
    }

    public void writeMark(int n, int n2) throws IOException {
        this.m_byteStream.writeMark(n, n2);
    }

    public void reset() {
        this.m_byteStream.reset();
    }

    public byte[] toByteArray() {
        return this.m_byteStream.toByteArray();
    }
}

