/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.constants;

import com.lotus.sametime.core.util.NdrInputStream;
import com.lotus.sametime.core.util.NdrOutputStream;
import java.io.IOException;

public class EncLevel {
    public static final EncLevel ENC_LEVEL_NONE = new EncLevel(0);
    public static final EncLevel ENC_LEVEL_DONT_CARE = new EncLevel(1);
    public static final EncLevel ENC_LEVEL_ALL = new EncLevel(2);
    public static final EncLevel ENC_LEVEL_RC2_40 = new EncLevel(4096);
    public static final EncLevel ENC_LEVEL_RC2_128 = new EncLevel(8192);
    private short m_level;

    public EncLevel(short s) {
        this.m_level = s;
    }

    public EncLevel(NdrInputStream ndrInputStream) throws IOException {
        this.load(ndrInputStream);
    }

    public short getValue() {
        return this.m_level;
    }

    public boolean isEqual(EncLevel encLevel) {
        return this.getValue() == encLevel.getValue();
    }

    public boolean isLower(EncLevel encLevel) {
        return this.getValue() < encLevel.getValue();
    }

    public static EncLevel max(EncLevel encLevel, EncLevel encLevel2) {
        return encLevel.isLower(encLevel2) ? encLevel2 : encLevel;
    }

    public static EncLevel min(EncLevel encLevel, EncLevel encLevel2) {
        return encLevel.isLower(encLevel2) ? encLevel : encLevel2;
    }

    public void dump(NdrOutputStream ndrOutputStream) throws IOException {
        ndrOutputStream.writeShort(this.m_level);
    }

    private void load(NdrInputStream ndrInputStream) throws IOException {
        this.m_level = ndrInputStream.readShort();
    }

    public String toString() {
        return super.toString() + " Value = {" + this.getValue() + "}";
    }
}

