/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.commui;

import com.lotus.sametime.commui.AddDialog;
import com.lotus.sametime.commui.ResolveViewEvent;
import com.lotus.sametime.commui.ResolveViewListener;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.comparch.STSession;
import com.lotus.sametime.core.types.STPrivacyList;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.core.util.StaticProps;
import com.lotus.sametime.guiutils.accessibility.KeyAction;
import com.lotus.sametime.guiutils.misc.ButtonsPanel;
import com.lotus.sametime.guiutils.misc.UbqDialog;
import com.lotus.sametime.guiutils.misc.UbqDialogListener;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PrivacyPanel
extends Panel {
    private static final int MODE_ALL = 0;
    private static final int MODE_INCLUDING = 1;
    private static final int MODE_EXCLUDING = 2;
    private STSession m_session;
    private CommunityService m_commService;
    private Hashtable m_excludeUsers = new Hashtable();
    private Hashtable m_includeUsers = new Hashtable();
    private CheckboxGroup m_cgroup;
    private Checkbox[] m_cbMode = new Checkbox[3];
    private List m_list;
    private AddDialog m_addDialog;
    private Button m_add;
    private Button m_remove;
    private Frame m_container;
    private Color m_bgColor = new Color(192, 192, 192);
    private STBundle m_resource;
    private ResourceLoaderService m_resService;

    public PrivacyPanel(STSession sTSession) {
        this.m_session = sTSession;
        this.m_commService = (CommunityService)sTSession.getCompApi("com.lotus.sametime.community.STBase");
        this.m_resService = (ResourceLoaderService)((Object)sTSession.getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resource = this.m_resService.getBundle("properties/commui");
        this.m_list = new List(15);
        this.m_commService.addLoginListener(new LoginListener(){

            public void loggedIn(LoginEvent loginEvent) {
                PrivacyPanel.this.loggedIn(loginEvent);
            }

            public void loggedOut(LoginEvent loginEvent) {
                PrivacyPanel.this.loggedOut(loginEvent);
            }
        });
        this.initUI();
        if (this.m_commService.isLoggedIn()) {
            this.getCurrentPrivacyList();
        }
    }

    private void initUI() {
        String[] stringArray = new String[]{this.m_resource.getString("BTN_ADD_WITH_ELLIPSES"), this.m_resource.getString("BTN_LBL_REMOVE")};
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrivacyPanel.this.actionPerformed(actionEvent);
            }
        };
        ButtonsPanel buttonsPanel = new ButtonsPanel(stringArray, actionListener, 2);
        this.m_add = buttonsPanel.getButton(stringArray[0]);
        this.m_remove = buttonsPanel.getButton(stringArray[1]);
        this.m_cgroup = new CheckboxGroup();
        String[] stringArray2 = this.m_resource.formatStringArray("CHECK_BOX_TEXT");
        Panel panel = new Panel(new GridLayout(0, 1));
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PrivacyPanel.this.itemStateChanged(itemEvent);
            }
        };
        for (int i = 0; i < stringArray2.length; ++i) {
            this.m_cbMode[i] = new Checkbox(stringArray2[i], this.m_cgroup, false);
            panel.add(this.m_cbMode[i]);
            this.m_cbMode[i].addItemListener(itemListener);
        }
        this.setLayout(new BorderLayout(3, 5));
        this.add("North", panel);
        this.add("Center", this.m_list);
        this.add("South", buttonsPanel);
        this.validate();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_bgColor = color;
    }

    public Insets getInsets() {
        Insets insets = (Insets)super.getInsets().clone();
        insets.top += 5;
        insets.bottom += 8;
        insets.left += 8;
        insets.right += 8;
        return insets;
    }

    public boolean submit() {
        Checkbox checkbox = this.m_cgroup.getSelectedCheckbox();
        boolean bl = checkbox == this.m_cbMode[1];
        STPrivacyList sTPrivacyList = new STPrivacyList(!bl);
        if (checkbox != this.m_cbMode[0]) {
            Enumeration enumeration;
            Enumeration enumeration2 = enumeration = bl ? this.m_includeUsers.elements() : this.m_excludeUsers.elements();
            if (!enumeration.hasMoreElements()) {
                this.errorPopup();
                return false;
            }
            while (enumeration.hasMoreElements()) {
                sTPrivacyList.addUser((STUser)enumeration.nextElement());
            }
        }
        this.m_commService.getLogin().changeMyPrivacy(sTPrivacyList);
        return true;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.m_commService.isLoggedIn()) {
                this.getCurrentPrivacyList();
            }
        } else if (this.m_addDialog != null) {
            this.m_addDialog.dispose();
            this.m_addDialog = null;
        }
        super.setVisible(bl);
    }

    private void addPressed() {
        if (this.m_addDialog == null) {
            String string = this.m_resource.getString("ADD_DIALOG_TITLE");
            String string2 = this.m_resource.getString("DIRECTORY_DIALOG_TITLE_2");
            this.m_addDialog = new AddDialog(this.m_container, this.m_session, string, string2, true);
            this.m_addDialog.addResolveViewListener(new ResolveViewListener(){

                public void resolveFailed(ResolveViewEvent resolveViewEvent) {
                    PrivacyPanel.this.resolveFailed(resolveViewEvent);
                }

                public void resolved(ResolveViewEvent resolveViewEvent) {
                    PrivacyPanel.this.resolved(resolveViewEvent);
                }
            });
            this.m_addDialog.pack();
            this.m_addDialog.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent windowEvent) {
                    PrivacyPanel.this.windowClosed(windowEvent);
                }

                public void windowClosing(WindowEvent windowEvent) {
                    PrivacyPanel.this.windowClosing(windowEvent);
                }
            });
        }
        this.m_addDialog.setVisible(true);
        this.m_addDialog.toFront();
        this.m_addDialog.requestFocus();
    }

    private void removePressed() {
        String string = this.m_list.getSelectedItem();
        if (string == null || string.equals("")) {
            return;
        }
        this.m_list.remove(string);
        Checkbox checkbox = this.m_cgroup.getSelectedCheckbox();
        if (checkbox == this.m_cbMode[1]) {
            this.m_includeUsers.remove(string);
        } else {
            this.m_excludeUsers.remove(string);
        }
        if (this.m_list.getItemCount() == 0) {
            this.m_remove.setEnabled(false);
        } else {
            this.m_list.select(0);
        }
    }

    protected void resolved(ResolveViewEvent resolveViewEvent) {
        String string = resolveViewEvent.getUser().getName();
        Checkbox checkbox = this.m_cgroup.getSelectedCheckbox();
        if (checkbox == this.m_cbMode[1]) {
            if (this.m_includeUsers.get(string) != null) {
                return;
            }
            this.m_includeUsers.put(string, resolveViewEvent.getUser());
        } else if (checkbox == this.m_cbMode[2]) {
            if (this.m_excludeUsers.get(string) != null) {
                return;
            }
            this.m_excludeUsers.put(string, resolveViewEvent.getUser());
        }
        this.m_list.add(string);
        this.m_remove.setEnabled(true);
        int n = this.m_list.getItemCount();
        if (n != 0) {
            this.m_list.select(n - 1);
        }
        if (StaticProps.m_bAIXOS) {
            this.m_list.setBackground(this.m_bgColor);
        }
    }

    protected void resolveFailed(ResolveViewEvent resolveViewEvent) {
        Object[] objectArray = new Object[]{resolveViewEvent.getResolvedName()};
        UbqDialog ubqDialog = new UbqDialog(this.m_container, this.m_resource.getString("ERROR_POPUP_TITLE"), this.m_resource.formatStringArray("USER_NOT_FOUND", objectArray), this.m_resource.formatStringArray("BTN_LBL_OK"));
        Image image = this.m_resService.getImage("images/alert.gif");
        ubqDialog.setImage(image);
        ubqDialog.addListener(new UbqDialogListener(){

            public void ubqDialogClosed(UbqDialog ubqDialog, int n, boolean bl) {
                ubqDialog.removeListener(this);
                PrivacyPanel.this.m_addDialog.requestFocus();
            }
        });
        ubqDialog.setVisible(true);
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_add) {
            this.addPressed();
        }
        if (actionEvent.getSource() == this.m_remove) {
            this.removePressed();
        }
    }

    protected void itemStateChanged(ItemEvent itemEvent) {
        this.m_list.removeAll();
        this.m_remove.setEnabled(false);
        Checkbox checkbox = this.m_cgroup.getSelectedCheckbox();
        if (checkbox == this.m_cbMode[0]) {
            this.disableButtons(false);
            return;
        }
        Enumeration enumeration = checkbox == this.m_cbMode[1] ? this.m_includeUsers.keys() : this.m_excludeUsers.keys();
        while (enumeration.hasMoreElements()) {
            this.m_list.add((String)enumeration.nextElement());
            this.m_remove.setEnabled(true);
        }
        this.m_add.setEnabled(true);
        if (!StaticProps.m_bAIXOS) {
            this.m_list.setBackground(Color.white);
        }
    }

    protected void getCurrentPrivacyList() {
        STPrivacyList sTPrivacyList = this.m_commService.getLogin().getMyPrivacy();
        this.m_list.clear();
        Enumeration enumeration = sTPrivacyList.elements();
        if (sTPrivacyList.isExcluding()) {
            while (enumeration.hasMoreElements()) {
                STUser sTUser = (STUser)enumeration.nextElement();
                this.m_excludeUsers.put(sTUser.getName(), sTUser);
                this.m_list.add(sTUser.getName());
            }
            if (this.m_list.getItemCount() != 0) {
                this.m_list.select(0);
                this.m_cgroup.setSelectedCheckbox(this.m_cbMode[2]);
            } else {
                this.m_cgroup.setSelectedCheckbox(this.m_cbMode[0]);
                this.disableButtons(false);
            }
        } else {
            while (enumeration.hasMoreElements()) {
                STUser sTUser = (STUser)enumeration.nextElement();
                this.m_includeUsers.put(sTUser.getName(), sTUser);
                this.m_list.add(sTUser.getName());
            }
            if (this.m_list.getItemCount() != 0) {
                this.m_list.select(0);
            }
            this.m_cgroup.setSelectedCheckbox(this.m_cbMode[1]);
        }
    }

    protected void disableButtons(boolean bl) {
        this.m_list.removeAll();
        this.m_list.setBackground(bl ? Color.white : this.m_bgColor);
        this.m_add.setEnabled(bl);
        this.m_remove.setEnabled(bl);
    }

    protected void errorPopup() {
        UbqDialog ubqDialog = new UbqDialog(this.m_container, this.m_resource.getString("SAMETIME_TITLE"), this.m_resource.formatStringArray("LIST_EMPTY"), this.m_resource.formatStringArray("BTN_LBL_OK"));
        Image image = this.m_resService.getImage("images/alert.gif");
        ubqDialog.setImage(image);
        ubqDialog.setVisible(true);
    }

    protected void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.m_addDialog) {
            this.m_addDialog.dispose();
            this.m_addDialog = null;
        }
    }

    protected void windowClosed(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.m_addDialog) {
            this.m_addDialog = null;
        }
    }

    public void addNotify() {
        super.addNotify();
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            this.m_container = (Frame)container;
            break;
        }
    }

    protected void loggedOut(LoginEvent loginEvent) {
        this.disableButtons(false);
    }

    protected void loggedIn(LoginEvent loginEvent) {
        this.disableButtons(true);
        this.getCurrentPrivacyList();
    }

    Enumeration getActionKeys() {
        Vector<KeyAction> vector = new Vector<KeyAction>();
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resource.getString("MN_RADIO_EVERYBODY"))){

            public void executeKeyMethod() {
                PrivacyPanel.this.m_cbMode[0].requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resource.getString("MN_RADIO_ONLY"))){

            public void executeKeyMethod() {
                PrivacyPanel.this.m_cbMode[1].requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resource.getString("MN_RADIO_EXCEPT"))){

            public void executeKeyMethod() {
                PrivacyPanel.this.m_cbMode[2].requestFocus();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resource.getString("MN_BTN_ADD"))){

            public void executeKeyMethod() {
                PrivacyPanel.this.addPressed();
            }
        });
        vector.addElement(new KeyAction(KeyAction.getKeyCodeByString(this.m_resource.getString("MN_BTN_REMOVE"))){

            public void executeKeyMethod() {
                PrivacyPanel.this.removePressed();
            }
        });
        return vector.elements();
    }
}

