/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.awarenessui;

import com.lotus.sametime.awarenessui.AwarenessModel;
import com.lotus.sametime.awarenessui.AwarenessNode;
import com.lotus.sametime.awarenessui.AwarenessViewEvent;
import com.lotus.sametime.chatui.ChatUI;
import com.lotus.sametime.commui.CommUI;
import com.lotus.sametime.community.CommunityService;
import com.lotus.sametime.community.LoginEvent;
import com.lotus.sametime.community.LoginListener;
import com.lotus.sametime.core.types.STBoolean;
import com.lotus.sametime.core.types.STUser;
import com.lotus.sametime.guiutils.tree.TreeNode;
import com.lotus.sametime.guiutils.tree.ViewListener;
import com.lotus.sametime.resourceloader.ResourceLoaderService;
import com.lotus.sametime.resourceloader.STBundle;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public abstract class AwarenessViewController {
    protected AwarenessModel m_model;
    protected CommunityService m_commService;
    protected ChatUI m_chat;
    protected CommUI m_comm;
    protected STBundle m_resource;
    protected PopupMenu m_popup;
    protected MenuItem m_message;
    protected MenuItem m_announcement;
    protected MenuItem m_fileTransfer;
    protected MenuItem m_remove;
    protected MenuItem m_separator;
    protected MenuItem m_startPhoneCall;
    protected boolean m_deleteEnabled = false;
    protected boolean m_messageEnabled = true;
    protected boolean m_announcementEnabled = false;
    protected boolean m_fileTransferEnabled = false;
    protected boolean m_serviceUp = true;
    protected boolean m_loggedIn;
    protected boolean m_popupShowing;
    protected Vector m_selectedNodes;
    private KeyListener m_keyListener;
    private ViewListener m_viewListener;

    public AwarenessViewController(AwarenessModel awarenessModel) {
        this.m_model = awarenessModel;
        this.m_commService = (CommunityService)awarenessModel.getSession().getCompApi("com.lotus.sametime.community.STBase");
        ResourceLoaderService resourceLoaderService = (ResourceLoaderService)((Object)awarenessModel.getSession().getCompApi("com.lotus.sametime.resourceloader.ResourceLoaderComp"));
        this.m_resource = resourceLoaderService.getBundle("properties/awarenessui");
        this.m_commService.addLoginListener(new LoginListener(){

            public void loggedIn(LoginEvent loginEvent) {
                AwarenessViewController.this.loggedIn(loginEvent);
            }

            public void loggedOut(LoginEvent loginEvent) {
                AwarenessViewController.this.loggedOut(loginEvent);
            }
        });
        this.m_loggedIn = this.m_commService.isLoggedIn();
        this.m_chat = (ChatUI)awarenessModel.getSession().getCompApi("com.lotus.sametime.chatui.ChatUIComp");
        this.m_messageEnabled = this.m_chat != null;
        this.m_popup = new PopupMenu();
        this.m_popup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AwarenessViewController.this.actionPerformed(actionEvent);
            }
        });
        this.createInnerClassListeners();
        this.createMenuItems();
    }

    private void createInnerClassListeners() {
        this.m_keyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AwarenessViewController.this.keyPressed(keyEvent);
            }
        };
        this.m_viewListener = new ViewListener(){

            public void deletePressed(Vector vector) {
                AwarenessViewController.this.deletePressed(vector);
            }

            public void nodeDoubleClicked(TreeNode treeNode) {
                AwarenessViewController.this.nodeDoubleClicked(treeNode);
            }

            public void selectionChanged(Vector vector) {
                AwarenessViewController.this.selectionChanged(vector);
            }

            public void popupMenuRequest(MouseEvent mouseEvent, Vector vector) {
                AwarenessViewController.this.popupMenuRequest(mouseEvent, vector);
            }

            public void nodeCollapsed(TreeNode treeNode) {
                AwarenessViewController.this.nodeCollapsed(treeNode);
            }

            public void nodeExpanded(TreeNode treeNode) {
                AwarenessViewController.this.nodeExpanded(treeNode);
            }
        };
    }

    public void enableDelete(boolean bl) {
        this.m_deleteEnabled = bl;
    }

    protected void serviceDown() {
        this.m_serviceUp = false;
    }

    protected void serviceUp() {
        this.m_serviceUp = true;
    }

    protected abstract void createMessage(Vector var1);

    protected abstract void createAnnouncement(Vector var1);

    protected abstract void createFileTransfer(Vector var1);

    protected abstract void removeSelectedNodes(Vector var1);

    protected abstract void enablePopupItems(Vector var1);

    protected abstract void handleNodeExpanded(TreeNode var1);

    protected abstract void handleNodeCollapsed(TreeNode var1);

    protected abstract void startPhoneCall(Vector var1);

    protected void deletePressed(Vector vector) {
        if (this.m_deleteEnabled) {
            this.removeSelectedNodes(vector);
        }
    }

    protected void nodeDoubleClicked(TreeNode treeNode) {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        vector.addElement(treeNode);
        this.createMessage(vector);
    }

    protected void nodeExpanded(TreeNode treeNode) {
        this.handleNodeExpanded(treeNode);
    }

    protected void nodeCollapsed(TreeNode treeNode) {
        this.handleNodeCollapsed(treeNode);
    }

    protected void popupMenuRequest(MouseEvent mouseEvent, Vector vector) {
        this.enablePopupItems(vector);
        this.applyServiceStateToItems();
        this.m_popupShowing = true;
        Panel panel = (Panel)mouseEvent.getSource();
        if (!panel.equals(this.m_popup.getParent())) {
            panel.add(this.m_popup);
        }
        this.m_popup.show(panel, mouseEvent.getX(), mouseEvent.getY());
        this.m_popupShowing = false;
        this.m_selectedNodes = vector;
    }

    protected final void selectionChanged(Vector vector) {
        this.m_selectedNodes = vector;
        this.handleSelectionChanged(vector);
    }

    protected void handleSelectionChanged(Vector vector) {
        STUser[] sTUserArray = this.m_model.nodesToSTuser(vector);
        AwarenessViewEvent awarenessViewEvent = new AwarenessViewEvent(8, (Object)this, sTUserArray);
        this.m_model.sendEvent(awarenessViewEvent);
    }

    protected void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.createMessage(this.m_selectedNodes);
        }
    }

    protected void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_popup) {
            String string = actionEvent.getActionCommand();
            if (string == this.m_resource.getString("MENU_MESSAGE")) {
                this.createMessage(this.m_selectedNodes);
            }
            if (string == this.m_resource.getString("MENU_ANNOUNCEMENT")) {
                this.createAnnouncement(this.m_selectedNodes);
            } else if (string == this.m_resource.getString("MENU_FILE_TRANSFER")) {
                this.createFileTransfer(this.m_selectedNodes);
            } else if (string == this.m_resource.getString("MENU_REMOVE")) {
                this.removeSelectedNodes(this.m_selectedNodes);
            } else if (string == this.m_resource.getString("START_A_PHONE_CALL")) {
                this.startPhoneCall(this.m_selectedNodes);
            }
        }
    }

    protected void createMenuItems() {
        this.m_message = new MenuItem(this.m_resource.getString("MENU_MESSAGE"));
        this.m_announcement = new MenuItem(this.m_resource.getString("MENU_ANNOUNCEMENT"));
        this.m_fileTransfer = new MenuItem(this.m_resource.getString("MENU_FILE_TRANSFER"));
        this.m_remove = new MenuItem(this.m_resource.getString("MENU_REMOVE"));
        this.m_startPhoneCall = new MenuItem(this.m_resource.getString("START_A_PHONE_CALL"));
        this.m_separator = new MenuItem("-");
        this.m_popup.add(this.m_message);
        this.m_popup.add(this.m_announcement);
        this.m_popup.add(this.m_fileTransfer);
        this.m_popup.add(this.m_remove);
        this.m_popup.add(this.m_startPhoneCall);
        this.m_popup.add(this.m_separator);
    }

    protected boolean isPopupShowing() {
        return this.m_popupShowing;
    }

    protected void loggedIn(LoginEvent loginEvent) {
        this.m_loggedIn = true;
    }

    protected void loggedOut(LoginEvent loginEvent) {
        this.m_loggedIn = false;
    }

    protected Vector getOnlineUsers(Vector vector) {
        STBoolean sTBoolean = new STBoolean(false);
        return this.getOnlineUsers(vector, false, sTBoolean);
    }

    protected Vector getOnlineUsers(Vector vector, boolean bl, STBoolean sTBoolean) {
        Vector<AwarenessNode> vector2 = new Vector<AwarenessNode>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
            if (!this.m_model.isGroup(awarenessNode)) {
                if (!awarenessNode.isOnline()) continue;
                STUser sTUser = (STUser)awarenessNode.getKey();
                if (sTUser.isExternalUser()) {
                    sTBoolean.setValue(true);
                    if (bl) continue;
                    vector2.addElement(awarenessNode);
                    continue;
                }
                vector2.addElement(awarenessNode);
                continue;
            }
            STBoolean sTBoolean2 = new STBoolean(false);
            Vector vector3 = this.getOnlineUsers(awarenessNode.getChilds(), bl, sTBoolean2);
            sTBoolean.setValue(sTBoolean.getValue() || sTBoolean2.getValue());
            Object e = null;
            for (int i = 0; i < vector3.size(); ++i) {
                e = vector3.elementAt(i);
                vector2.addElement((AwarenessNode)e);
            }
        }
        return vector2;
    }

    private void applyServiceStateToItems() {
        for (int i = 0; i < this.m_popup.getItemCount(); ++i) {
            MenuItem menuItem;
            menuItem.setEnabled((menuItem = this.m_popup.getItem(i)).isEnabled() && this.m_serviceUp && this.m_loggedIn);
        }
    }

    protected KeyListener getKeyListener() {
        return this.m_keyListener;
    }

    protected ViewListener getViewListener() {
        return this.m_viewListener;
    }

    protected Frame getMainFrame() {
        Frame frame = (Frame)this.m_model.getSession().getSessionProperty("mainFrame");
        return frame == null ? new Frame() : frame;
    }

    protected Vector getAllUsers(Vector vector) {
        Vector<STUser> vector2 = new Vector<STUser>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AwarenessNode awarenessNode = (AwarenessNode)enumeration.nextElement();
            if (!this.m_model.isGroup(awarenessNode)) {
                STUser sTUser = (STUser)awarenessNode.getKey();
                vector2.addElement(sTUser);
                continue;
            }
            Vector vector3 = this.getAllUsers(awarenessNode.getChilds());
            Object e = null;
            for (int i = 0; i < vector3.size(); ++i) {
                e = vector3.elementAt(i);
                vector2.addElement((STUser)e);
            }
        }
        return vector2;
    }
}

