/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.definition;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.definition.ServiceObjectPropertyDefinition;

public final class GroupMemberPropertyDefinition
extends ServiceObjectPropertyDefinition {
    private static final String FIELDURI = "distributionlist:Members:Member";
    private String key;

    public GroupMemberPropertyDefinition(String key) {
        super(FIELDURI);
        this.key = key;
    }

    public GroupMemberPropertyDefinition() {
        super(FIELDURI);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    protected String getXmlElementName() {
        return "IndexedFieldURI";
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("FieldIndex", this.key);
    }

    @Override
    public String getPrintableName() {
        return String.format("%s:%s", FIELDURI, this.key);
    }

    public Class<String> getType() {
        return String.class;
    }
}

