/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.time;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public class TimeZonePeriod
extends ComplexProperty {
    protected static final String StandardPeriodId = "Std";
    protected static final String StandardPeriodName = "Standard";
    protected static final String DaylightPeriodId = "Dlt";
    protected static final String DaylightPeriodName = "Daylight";
    private TimeSpan bias;
    private String name;
    private String id;

    @Override
    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.id = reader.readAttributeValue("Id");
        this.name = reader.readAttributeValue("Name");
        this.bias = EwsUtilities.getXSDurationToTimeSpan(reader.readAttributeValue("Bias"));
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Bias", EwsUtilities.getTimeSpanToXSDuration(this.bias));
        writer.writeAttributeValue("Name", this.name);
        writer.writeAttributeValue("Id", this.id);
    }

    public void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        this.loadFromXml(reader, "Period");
    }

    public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writeToXml(writer, "Period");
    }

    protected boolean isStandardPeriod() {
        return this.name.equals(StandardPeriodName);
    }

    protected TimeSpan getBias() {
        return this.bias;
    }

    protected void setBias(TimeSpan bias) {
        this.bias = bias;
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }
}

